/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class AuthorizationIdentityResponseControl
implements Control {
    public static final String OID = "2.16.840.1.113730.3.4.15";
    private final String authorizationID;
    private final boolean isCritical;
    public static final ControlDecoder<AuthorizationIdentityResponseControl> DECODER = new ControlDecoder<AuthorizationIdentityResponseControl>(){

        @Override
        public AuthorizationIdentityResponseControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull((Object)control);
            if (control instanceof AuthorizationIdentityResponseControl) {
                return (AuthorizationIdentityResponseControl)control;
            }
            if (!control.getOID().equals(AuthorizationIdentityResponseControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_AUTHZIDRESP_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)AuthorizationIdentityResponseControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_AUTHZIDRESP_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            String authID = control.getValue().toString();
            return new AuthorizationIdentityResponseControl(control.isCritical(), authID);
        }

        @Override
        public String getOID() {
            return AuthorizationIdentityResponseControl.OID;
        }
    };

    public static AuthorizationIdentityResponseControl newControl(String authorizationID) {
        return new AuthorizationIdentityResponseControl(false, authorizationID);
    }

    private AuthorizationIdentityResponseControl(boolean isCritical, String authorizationID) {
        Reject.ifNull((Object)authorizationID);
        this.isCritical = isCritical;
        this.authorizationID = authorizationID;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return ByteString.valueOf(this.authorizationID);
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthorizationIdentityResponseControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", authzID=\"");
        builder.append(this.authorizationID);
        builder.append("\")");
        return builder.toString();
    }
}

