/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

public final class Option<T> {
    private final Class<T> type;
    private final T defaultValue;

    public static Option<Boolean> withDefault(boolean defaultValue) {
        return Option.of(Boolean.class, defaultValue);
    }

    public static <T> Option<T> of(Class<T> type, T defaultValue) {
        return new Option<T>(type, defaultValue);
    }

    private Option(Class<T> type, T defaultValue) {
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getValue(Object value) {
        return value != null ? this.type.cast(value) : this.defaultValue;
    }
}

