/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.forgerock.opendj.ldap.AbstractAttribute;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AttributeFactory;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.util.Reject;

public final class LinkedAttribute
extends AbstractAttribute {
    public static final AttributeFactory FACTORY = new AttributeFactory(){

        @Override
        public Attribute newAttribute(AttributeDescription attributeDescription) {
            return new LinkedAttribute(attributeDescription);
        }
    };
    private static final MultiValueImpl MULTI_VALUE_IMPL = new MultiValueImpl();
    private static final SingleValueImpl SINGLE_VALUE_IMPL = new SingleValueImpl();
    private static final ZeroValueImpl ZERO_VALUE_IMPL = new ZeroValueImpl();
    private final AttributeDescription attributeDescription;
    private Map<ByteString, ByteString> multipleValues;
    private ByteString normalizedSingleValue;
    private Impl pimpl = ZERO_VALUE_IMPL;
    private ByteString singleValue;

    public LinkedAttribute(Attribute attribute) {
        this.attributeDescription = attribute.getAttributeDescription();
        if (attribute instanceof LinkedAttribute) {
            LinkedAttribute other = (LinkedAttribute)attribute;
            this.pimpl = other.pimpl;
            this.singleValue = other.singleValue;
            this.normalizedSingleValue = other.normalizedSingleValue;
            if (other.multipleValues != null) {
                this.multipleValues = new LinkedHashMap<ByteString, ByteString>(other.multipleValues);
            }
        } else {
            this.addAll(attribute);
        }
    }

    public LinkedAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull((Object)attributeDescription);
        this.attributeDescription = attributeDescription;
    }

    public LinkedAttribute(AttributeDescription attributeDescription, Object value) {
        this(attributeDescription);
        this.add(new Object[]{value});
    }

    public LinkedAttribute(AttributeDescription attributeDescription, Object ... values) {
        this(attributeDescription);
        this.add(values);
    }

    public LinkedAttribute(AttributeDescription attributeDescription, Collection<?> values) {
        this(attributeDescription);
        this.addAll(values, null);
    }

    public LinkedAttribute(String attributeDescription) {
        this(AttributeDescription.valueOf(attributeDescription));
    }

    public LinkedAttribute(String attributeDescription, Collection<?> values) {
        this(attributeDescription);
        this.addAll(values, null);
    }

    public LinkedAttribute(String attributeDescription, Object value) {
        this(attributeDescription);
        this.add(ByteString.valueOf(value));
    }

    public LinkedAttribute(String attributeDescription, Object ... values) {
        this(attributeDescription);
        this.add(values);
    }

    @Override
    public boolean add(ByteString value) {
        Reject.ifNull((Object)value);
        return this.pimpl.add(this, value);
    }

    @Override
    public void clear() {
        this.pimpl.clear(this);
    }

    @Override
    public boolean contains(Object value) {
        Reject.ifNull((Object)value);
        return this.pimpl.contains(this, ByteString.valueOf(value));
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        Reject.ifNull(values);
        return this.pimpl.containsAll(this, values);
    }

    @Override
    public ByteString firstValue() {
        return this.pimpl.firstValue(this);
    }

    @Override
    public AttributeDescription getAttributeDescription() {
        return this.attributeDescription;
    }

    @Override
    public Iterator<ByteString> iterator() {
        return this.pimpl.iterator(this);
    }

    @Override
    public boolean remove(Object value) {
        Reject.ifNull((Object)value);
        return this.pimpl.remove(this, ByteString.valueOf(value));
    }

    @Override
    public <T> boolean retainAll(Collection<T> values, Collection<? super T> missingValues) {
        Reject.ifNull(values);
        return this.pimpl.retainAll(this, values, missingValues);
    }

    @Override
    public int size() {
        return this.pimpl.size(this);
    }

    private ByteString normalizedSingleValue() {
        if (this.normalizedSingleValue == null) {
            this.normalizedSingleValue = LinkedAttribute.normalizeValue(this, this.singleValue);
        }
        return this.normalizedSingleValue;
    }

    private static final class ZeroValueImpl
    extends Impl {
        private ZeroValueImpl() {
        }

        @Override
        boolean add(LinkedAttribute attribute, ByteString value) {
            attribute.singleValue = value;
            attribute.pimpl = SINGLE_VALUE_IMPL;
            return true;
        }

        @Override
        void clear(LinkedAttribute attribute) {
        }

        @Override
        boolean contains(LinkedAttribute attribute, ByteString value) {
            return false;
        }

        @Override
        boolean containsAll(LinkedAttribute attribute, Collection<?> values) {
            return values.isEmpty();
        }

        @Override
        ByteString firstValue(LinkedAttribute attribute) {
            throw new NoSuchElementException();
        }

        @Override
        Iterator<ByteString> iterator(final LinkedAttribute attribute) {
            return new Iterator<ByteString>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public ByteString next() {
                    if (attribute.pimpl != ZERO_VALUE_IMPL) {
                        throw new ConcurrentModificationException();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    if (attribute.pimpl != ZERO_VALUE_IMPL) {
                        throw new ConcurrentModificationException();
                    }
                    throw new IllegalStateException();
                }
            };
        }

        @Override
        boolean remove(LinkedAttribute attribute, ByteString value) {
            return false;
        }

        @Override
        <T> boolean retainAll(LinkedAttribute attribute, Collection<T> values, Collection<? super T> missingValues) {
            if (missingValues != null) {
                missingValues.addAll(values);
            }
            return false;
        }

        @Override
        int size(LinkedAttribute attribute) {
            return 0;
        }
    }

    private static final class SingleValueImpl
    extends Impl {
        private SingleValueImpl() {
        }

        @Override
        boolean add(LinkedAttribute attribute, ByteString value) {
            ByteString normalizedValue = AbstractAttribute.normalizeValue(attribute, value);
            if (attribute.normalizedSingleValue().equals(normalizedValue)) {
                return false;
            }
            attribute.multipleValues = new LinkedHashMap(2);
            attribute.multipleValues.put(attribute.normalizedSingleValue, attribute.singleValue);
            attribute.multipleValues.put(normalizedValue, value);
            attribute.singleValue = null;
            attribute.normalizedSingleValue = null;
            attribute.pimpl = MULTI_VALUE_IMPL;
            return true;
        }

        @Override
        void clear(LinkedAttribute attribute) {
            attribute.singleValue = null;
            attribute.normalizedSingleValue = null;
            attribute.pimpl = ZERO_VALUE_IMPL;
        }

        @Override
        boolean contains(LinkedAttribute attribute, ByteString value) {
            ByteString normalizedValue = AbstractAttribute.normalizeValue(attribute, value);
            return attribute.normalizedSingleValue().equals(normalizedValue);
        }

        @Override
        ByteString firstValue(LinkedAttribute attribute) {
            if (attribute.singleValue != null) {
                return attribute.singleValue;
            }
            throw new NoSuchElementException();
        }

        @Override
        Iterator<ByteString> iterator(final LinkedAttribute attribute) {
            return new Iterator<ByteString>(){
                private Impl expectedImpl = LinkedAttribute.access$800();
                private boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public ByteString next() {
                    if (attribute.pimpl != this.expectedImpl) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.hasNext) {
                        this.hasNext = false;
                        return attribute.singleValue;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    if (attribute.pimpl != this.expectedImpl) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.hasNext || attribute.singleValue == null) {
                        throw new IllegalStateException();
                    }
                    SingleValueImpl.this.clear(attribute);
                    this.expectedImpl = attribute.pimpl;
                }
            };
        }

        @Override
        boolean remove(LinkedAttribute attribute, ByteString value) {
            if (this.contains(attribute, value)) {
                this.clear(attribute);
                return true;
            }
            return false;
        }

        @Override
        <T> boolean retainAll(LinkedAttribute attribute, Collection<T> values, Collection<? super T> missingValues) {
            if (values.isEmpty()) {
                this.clear(attribute);
                return true;
            }
            ByteString normalizedSingleValue = attribute.normalizedSingleValue();
            boolean retained = false;
            for (T value : values) {
                ByteString normalizedValue = AbstractAttribute.normalizeValue(attribute, ByteString.valueOf(value));
                if (normalizedSingleValue.equals(normalizedValue)) {
                    if (missingValues == null) {
                        return false;
                    }
                    retained = true;
                    continue;
                }
                if (missingValues == null) continue;
                missingValues.add(value);
            }
            if (!retained) {
                this.clear(attribute);
                return true;
            }
            return false;
        }

        @Override
        int size(LinkedAttribute attribute) {
            return 1;
        }
    }

    private static final class MultiValueImpl
    extends Impl {
        private MultiValueImpl() {
        }

        @Override
        boolean add(LinkedAttribute attribute, ByteString value) {
            ByteString normalizedValue = AbstractAttribute.normalizeValue(attribute, value);
            return attribute.multipleValues.put(normalizedValue, value) == null;
        }

        @Override
        void clear(LinkedAttribute attribute) {
            attribute.multipleValues = null;
            attribute.pimpl = ZERO_VALUE_IMPL;
        }

        @Override
        boolean contains(LinkedAttribute attribute, ByteString value) {
            return attribute.multipleValues.containsKey(AbstractAttribute.normalizeValue(attribute, value));
        }

        @Override
        ByteString firstValue(LinkedAttribute attribute) {
            return (ByteString)attribute.multipleValues.values().iterator().next();
        }

        @Override
        Iterator<ByteString> iterator(final LinkedAttribute attribute) {
            return new Iterator<ByteString>(){
                private Impl expectedImpl = LinkedAttribute.access$400();
                private Iterator<ByteString> iterator = LinkedAttribute.access$100(attribute).values().iterator();

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public ByteString next() {
                    if (attribute.pimpl != this.expectedImpl) {
                        throw new ConcurrentModificationException();
                    }
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    if (attribute.pimpl != this.expectedImpl) {
                        throw new ConcurrentModificationException();
                    }
                    this.iterator.remove();
                    if (attribute.multipleValues != null && attribute.multipleValues.size() == 1) {
                        MultiValueImpl.this.resize(attribute);
                        this.iterator = attribute.pimpl.iterator(attribute);
                    }
                    this.expectedImpl = attribute.pimpl;
                }
            };
        }

        @Override
        boolean remove(LinkedAttribute attribute, ByteString value) {
            ByteString normalizedValue = AbstractAttribute.normalizeValue(attribute, value);
            if (attribute.multipleValues.remove(normalizedValue) != null) {
                this.resize(attribute);
                return true;
            }
            return false;
        }

        @Override
        <T> boolean retainAll(LinkedAttribute attribute, Collection<T> values, Collection<? super T> missingValues) {
            if (values.isEmpty()) {
                this.clear(attribute);
                return true;
            }
            HashMap<ByteString, T> valuesToRetain = new HashMap<ByteString, T>(values.size());
            for (T value : values) {
                valuesToRetain.put(AbstractAttribute.normalizeValue(attribute, ByteString.valueOf(value)), value);
            }
            boolean modified = false;
            Iterator iterator = attribute.multipleValues.keySet().iterator();
            while (iterator.hasNext()) {
                ByteString normalizedValue = (ByteString)iterator.next();
                if (valuesToRetain.remove(normalizedValue) != null) continue;
                modified = true;
                iterator.remove();
            }
            if (missingValues != null) {
                missingValues.addAll(valuesToRetain.values());
            }
            this.resize(attribute);
            return modified;
        }

        @Override
        int size(LinkedAttribute attribute) {
            return attribute.multipleValues.size();
        }

        private void resize(LinkedAttribute attribute) {
            switch (attribute.multipleValues.size()) {
                case 0: {
                    attribute.multipleValues = null;
                    attribute.pimpl = ZERO_VALUE_IMPL;
                    break;
                }
                case 1: {
                    Map.Entry e = attribute.multipleValues.entrySet().iterator().next();
                    attribute.singleValue = (ByteString)e.getValue();
                    attribute.normalizedSingleValue = (ByteString)e.getKey();
                    attribute.multipleValues = null;
                    attribute.pimpl = SINGLE_VALUE_IMPL;
                    break;
                }
            }
        }
    }

    private static abstract class Impl {
        private Impl() {
        }

        abstract boolean add(LinkedAttribute var1, ByteString var2);

        abstract void clear(LinkedAttribute var1);

        abstract boolean contains(LinkedAttribute var1, ByteString var2);

        boolean containsAll(LinkedAttribute attribute, Collection<?> values) {
            for (Object value : values) {
                if (this.contains(attribute, ByteString.valueOf(value))) continue;
                return false;
            }
            return true;
        }

        abstract ByteString firstValue(LinkedAttribute var1);

        abstract Iterator<ByteString> iterator(LinkedAttribute var1);

        abstract boolean remove(LinkedAttribute var1, ByteString var2);

        abstract <T> boolean retainAll(LinkedAttribute var1, Collection<T> var2, Collection<? super T> var3);

        abstract int size(LinkedAttribute var1);
    }
}

