/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.forgerock.opendj.ldap.CommonLDAPOptions;
import org.forgerock.util.Reject;

public final class LDAPOptions
extends CommonLDAPOptions<LDAPOptions> {
    private static final long DEFAULT_TIMEOUT = LDAPOptions.getIntProperty("org.forgerock.opendj.io.timeout", 0);
    private static final long DEFAULT_CONNECT_TIMEOUT = LDAPOptions.getIntProperty("org.forgerock.opendj.io.connectTimeout", 5000);
    private SSLContext sslContext;
    private boolean useStartTLS;
    private long timeoutInMillis = DEFAULT_TIMEOUT;
    private long connectTimeoutInMillis = DEFAULT_CONNECT_TIMEOUT;
    private final List<String> enabledCipherSuites = new LinkedList<String>();
    private final List<String> enabledProtocols = new LinkedList<String>();

    public LDAPOptions() {
    }

    public LDAPOptions(LDAPOptions options) {
        super(options);
        this.sslContext = options.sslContext;
        this.timeoutInMillis = options.timeoutInMillis;
        this.useStartTLS = options.useStartTLS;
        this.enabledCipherSuites.addAll(options.getEnabledCipherSuites());
        this.enabledProtocols.addAll(options.getEnabledProtocols());
        this.connectTimeoutInMillis = options.connectTimeoutInMillis;
    }

    public LDAPOptions addEnabledCipherSuite(String ... suites) {
        for (String suite : suites) {
            this.enabledCipherSuites.add((String)Reject.checkNotNull((Object)suite));
        }
        return this;
    }

    public LDAPOptions addEnabledProtocol(String ... protocols) {
        for (String protocol : protocols) {
            this.enabledProtocols.add((String)Reject.checkNotNull((Object)protocol));
        }
        return this;
    }

    public long getConnectTimeout(TimeUnit unit) {
        return unit.convert(this.connectTimeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public List<String> getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public long getTimeout(TimeUnit unit) {
        return unit.convert(this.timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public LDAPOptions setConnectTimeout(long timeout, TimeUnit unit) {
        this.connectTimeoutInMillis = unit.toMillis(timeout);
        return this;
    }

    public LDAPOptions setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public LDAPOptions setTimeout(long timeout, TimeUnit unit) {
        this.timeoutInMillis = unit.toMillis(timeout);
        return this;
    }

    public LDAPOptions setUseStartTLS(boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
        return this;
    }

    public boolean useStartTLS() {
        return this.useStartTLS;
    }

    @Override
    LDAPOptions getThis() {
        return this;
    }
}

