/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.StaticUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPListenerOptions;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.spi.LDAPListenerImpl;
import org.forgerock.opendj.ldap.spi.TransportProvider;
import org.forgerock.util.Reject;

public final class LDAPListener
implements Closeable {
    private final LDAPListenerImpl impl;
    private TransportProvider provider;

    public LDAPListener(int port, ServerConnectionFactory<LDAPClientContext, Integer> factory) throws IOException {
        this(port, factory, new LDAPListenerOptions());
    }

    public LDAPListener(int port, ServerConnectionFactory<LDAPClientContext, Integer> factory, LDAPListenerOptions options) throws IOException {
        Reject.ifNull((Object[])new Object[]{factory, options});
        InetSocketAddress address = new InetSocketAddress(port);
        this.provider = StaticUtils.getProvider(TransportProvider.class, options.getTransportProvider(), options.getProviderClassLoader());
        this.impl = this.provider.getLDAPListener(address, factory, options);
    }

    public LDAPListener(InetSocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory) throws IOException {
        this(address, factory, new LDAPListenerOptions());
    }

    public LDAPListener(InetSocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory, LDAPListenerOptions options) throws IOException {
        Reject.ifNull((Object[])new Object[]{address, factory, options});
        this.provider = StaticUtils.getProvider(TransportProvider.class, options.getTransportProvider(), options.getProviderClassLoader());
        this.impl = this.provider.getLDAPListener(address, factory, options);
    }

    public LDAPListener(String host, int port, ServerConnectionFactory<LDAPClientContext, Integer> factory) throws IOException {
        this(host, port, factory, new LDAPListenerOptions());
    }

    public LDAPListener(String host, int port, ServerConnectionFactory<LDAPClientContext, Integer> factory, LDAPListenerOptions options) throws IOException {
        Reject.ifNull((Object[])new Object[]{host, factory, options});
        InetSocketAddress address = new InetSocketAddress(host, port);
        this.provider = StaticUtils.getProvider(TransportProvider.class, options.getTransportProvider(), options.getProviderClassLoader());
        this.impl = this.provider.getLDAPListener(address, factory, options);
    }

    @Override
    public void close() {
        this.impl.close();
    }

    public InetAddress getAddress() {
        return this.getSocketAddress().getAddress();
    }

    public String getHostName() {
        return Connections.getHostString(this.getSocketAddress());
    }

    public int getPort() {
        return this.getSocketAddress().getPort();
    }

    public InetSocketAddress getSocketAddress() {
        return this.impl.getSocketAddress();
    }

    public String getProviderName() {
        return this.provider.getName();
    }

    public String toString() {
        return this.impl.toString();
    }
}

