/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.spi.LDAPConnectionFactoryImpl;
import org.forgerock.opendj.ldap.spi.TransportProvider;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

public final class LDAPConnectionFactory
implements ConnectionFactory {
    private final LDAPConnectionFactoryImpl impl;
    private final TransportProvider provider;

    public LDAPConnectionFactory(String host, int port) {
        this(host, port, new LDAPOptions());
    }

    public LDAPConnectionFactory(String host, int port, LDAPOptions options) {
        Reject.ifNull((Object[])new Object[]{host, options});
        this.provider = StaticUtils.getProvider(TransportProvider.class, options.getTransportProvider(), options.getProviderClassLoader());
        this.impl = this.provider.getLDAPConnectionFactory(host, port, options);
    }

    @Override
    public void close() {
        this.impl.close();
    }

    @Override
    public Promise<Connection, LdapException> getConnectionAsync() {
        return this.impl.getConnectionAsync();
    }

    @Override
    public Connection getConnection() throws LdapException {
        return this.impl.getConnection();
    }

    public String getHostName() {
        return this.impl.getHostName();
    }

    public int getPort() {
        return this.impl.getPort();
    }

    public String getProviderName() {
        return this.provider.getName();
    }

    public String toString() {
        return this.impl.toString();
    }
}

