/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.CancelledResultException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TimeoutResultException;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.spi.ConnectionState;
import org.forgerock.opendj.ldap.spi.LdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.time.TimeService;

final class HeartBeatConnectionFactory
implements ConnectionFactory {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final SearchRequest DEFAULT_SEARCH = Requests.newSearchRequest("", SearchScope.BASE_OBJECT, "(objectClass=*)", "1.1");
    TimeService timeService = TimeService.SYSTEM;
    private final Runnable checkHeartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            for (ConnectionImpl connection : HeartBeatConnectionFactory.this.getValidConnections()) {
                connection.checkForHeartBeat();
            }
        }
    };
    private final ConnectionFactory factory;
    private ScheduledFuture<?> heartBeatFuture;
    private final SearchRequest heartBeatRequest;
    private final long interval;
    private final TimeUnit intervalUnit;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final long minDelayMS;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private final ReferenceCountedObject.Reference scheduler;
    private final Runnable sendHeartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            boolean heartBeatSent = false;
            for (ConnectionImpl connection : HeartBeatConnectionFactory.this.getValidConnections()) {
                heartBeatSent |= connection.sendHeartBeat();
            }
            if (heartBeatSent) {
                ((ScheduledExecutorService)HeartBeatConnectionFactory.this.scheduler.get()).schedule(HeartBeatConnectionFactory.this.checkHeartBeatRunnable, HeartBeatConnectionFactory.this.timeoutMS, TimeUnit.MILLISECONDS);
            }
        }
    };
    private final long timeoutMS;
    private final List<ConnectionImpl> validConnections = new LinkedList<ConnectionImpl>();

    HeartBeatConnectionFactory(ConnectionFactory factory, long interval, long timeout, TimeUnit unit, SearchRequest heartBeat, ScheduledExecutorService scheduler) {
        Reject.ifNull((Object[])new Object[]{factory, unit});
        Reject.ifFalse((interval >= 0L ? 1 : 0) != 0, (String)"negative interval");
        Reject.ifFalse((timeout >= 0L ? 1 : 0) != 0, (String)"negative timeout");
        this.heartBeatRequest = heartBeat != null ? heartBeat : DEFAULT_SEARCH;
        this.interval = interval;
        this.intervalUnit = unit;
        this.factory = factory;
        this.scheduler = StaticUtils.DEFAULT_SCHEDULER.acquireIfNull(scheduler);
        this.timeoutMS = unit.toMillis(timeout);
        this.minDelayMS = unit.toMillis(interval) / 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            List<ConnectionImpl> list = this.validConnections;
            synchronized (list) {
                if (!this.validConnections.isEmpty()) {
                    logger.debug(LocalizableMessage.raw((CharSequence)"HeartbeatConnectionFactory '%s' is closing while %d active connections remain", (Object[])new Object[]{this, this.validConnections.size()}));
                }
            }
            this.releaseScheduler();
            this.factory.close();
        }
    }

    private void releaseScheduler() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.scheduler.release();
        }
    }

    private void acquireScheduler() {
        this.referenceCount.incrementAndGet();
        if (this.isClosed.get()) {
            this.releaseScheduler();
            throw new IllegalStateException("Attempted to get a connection after factory close");
        }
    }

    @Override
    public Connection getConnection() throws LdapException {
        this.acquireScheduler();
        Connection connection = null;
        try {
            connection = this.factory.getConnection();
            connection.searchAsync(this.heartBeatRequest, null).getOrThrow(this.timeoutMS, TimeUnit.MILLISECONDS);
            return this.registerConnection(new ConnectionImpl(connection));
        }
        catch (Exception e) {
            Utils.closeSilently((Closeable[])new Closeable[]{connection});
            this.releaseScheduler();
            throw this.adaptHeartBeatError(e);
        }
    }

    @Override
    public Promise<Connection, LdapException> getConnectionAsync() {
        this.acquireScheduler();
        final AtomicReference connectionHolder = new AtomicReference();
        final PromiseImpl promise = PromiseImpl.create();
        this.factory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, Result, LdapException>(){

            public Promise<Result, LdapException> apply(Connection connection) {
                connectionHolder.set(connection);
                ((ScheduledExecutorService)HeartBeatConnectionFactory.this.scheduler.get()).schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (promise.tryHandleException((Exception)HeartBeatConnectionFactory.this.newHeartBeatTimeoutError())) {
                            Utils.closeSilently((Closeable[])new Closeable[]{(Closeable)connectionHolder.get()});
                            HeartBeatConnectionFactory.this.releaseScheduler();
                        }
                    }
                }, HeartBeatConnectionFactory.this.timeoutMS, TimeUnit.MILLISECONDS);
                return connection.searchAsync(HeartBeatConnectionFactory.this.heartBeatRequest, null);
            }
        }).thenOnResult((ResultHandler)new ResultHandler<Result>(){

            public void handleResult(Result result) {
                Connection connection = (Connection)connectionHolder.get();
                ConnectionImpl connectionImpl = new ConnectionImpl(connection);
                if (!promise.tryHandleResult((Object)HeartBeatConnectionFactory.this.registerConnection(connectionImpl))) {
                    connectionImpl.close();
                }
            }
        }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

            public void handleException(LdapException exception) {
                if (promise.tryHandleException((Exception)HeartBeatConnectionFactory.this.adaptHeartBeatError(exception))) {
                    Utils.closeSilently((Closeable[])new Closeable[]{(Closeable)connectionHolder.get()});
                    HeartBeatConnectionFactory.this.releaseScheduler();
                }
            }
        });
        return promise;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HeartBeatConnectionFactory(");
        builder.append(this.factory);
        builder.append(')');
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection registerConnection(ConnectionImpl heartBeatConnection) {
        List<ConnectionImpl> list = this.validConnections;
        synchronized (list) {
            if (this.validConnections.isEmpty()) {
                this.heartBeatFuture = ((ScheduledExecutorService)this.scheduler.get()).scheduleWithFixedDelay(this.sendHeartBeatRunnable, 0L, this.interval, this.intervalUnit);
            }
            this.validConnections.add(heartBeatConnection);
            return heartBeatConnection;
        }
    }

    private LdapException adaptHeartBeatError(Exception error) {
        if (error instanceof ConnectionException) {
            return (LdapException)error;
        }
        if (error instanceof TimeoutResultException || error instanceof TimeoutException) {
            return this.newHeartBeatTimeoutError();
        }
        if (error instanceof InterruptedException) {
            return LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED, error);
        }
        return LdapException.newLdapException(ResultCode.CLIENT_SIDE_SERVER_DOWN, (CharSequence)CoreMessages.HBCF_HEARTBEAT_FAILED.get(), error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionImpl[] getValidConnections() {
        ConnectionImpl[] tmp;
        List<ConnectionImpl> list = this.validConnections;
        synchronized (list) {
            tmp = this.validConnections.toArray(new ConnectionImpl[0]);
        }
        return tmp;
    }

    private LdapException newHeartBeatTimeoutError() {
        return LdapException.newLdapException(ResultCode.CLIENT_SIDE_SERVER_DOWN, (CharSequence)CoreMessages.HBCF_HEARTBEAT_TIMEOUT.get((Object)this.timeoutMS));
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int LOCKED_EXCLUSIVELY = -1;
        private static final long serialVersionUID = -3590428415442668336L;
        private static final int UNLOCKED = 0;

        private Sync() {
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() == -1;
        }

        boolean isHeld() {
            return this.getState() != 0;
        }

        @Override
        protected boolean tryAcquire(int ignored) {
            if (this.compareAndSetState(0, -1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected int tryAcquireShared(int readers) {
            int newState;
            int state;
            do {
                if ((state = this.getState()) != -1) continue;
                return -1;
            } while (!this.compareAndSetState(state, newState = state + readers));
            return newState;
        }

        @Override
        protected boolean tryRelease(int ignored) {
            if (this.getState() != -1) {
                throw new IllegalMonitorStateException();
            }
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        protected boolean tryReleaseShared(int ignored) {
            int newState;
            int state;
            do {
                if ((state = this.getState()) != 0 && state != -1) continue;
                throw new IllegalMonitorStateException();
            } while (!this.compareAndSetState(state, newState = state - 1));
            return newState == 0;
        }

        void lockShared() {
            this.acquireShared(1);
        }

        boolean tryLockExclusively() {
            return this.tryAcquire(0);
        }

        boolean tryLockShared() {
            return this.tryAcquireShared(1) > 0;
        }

        void unlockExclusively() {
            this.release(0);
        }

        void unlockShared() {
            this.releaseShared(0);
        }
    }

    private final class ConnectionImpl
    extends AbstractAsynchronousConnection
    implements ConnectionEventListener {
        private final Connection connection;
        private final Queue<Runnable> pendingBindOrStartTLSRequests = new ConcurrentLinkedQueue<Runnable>();
        private final Queue<LdapResultHandler<?>> pendingResults = new ConcurrentLinkedQueue();
        private final ConnectionState state = new ConnectionState();
        private final Sync sync = new Sync();
        private volatile long lastResponseTimestamp;

        private ConnectionImpl(Connection connection) {
            this.lastResponseTimestamp = HeartBeatConnectionFactory.this.timeService.now();
            this.connection = connection;
            connection.addConnectionEventListener(this);
        }

        @Override
        public LdapPromise<Void> abandonAsync(AbandonRequest request) {
            return this.connection.abandonAsync(request);
        }

        @Override
        public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.checkState()) {
                return this.timestampPromise(this.connection.addAsync(request, intermediateResponseHandler));
            }
            return this.newConnectionErrorPromise();
        }

        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            this.state.addConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<BindResult> bindAsync(final BindRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            if (this.checkState()) {
                if (this.sync.tryLockShared()) {
                    return this.timestampBindOrStartTLSPromise(this.connection.bindAsync(request, intermediateResponseHandler));
                }
                return this.enqueueBindOrStartTLSPromise(new AsyncFunction<Void, BindResult, LdapException>(){

                    public Promise<BindResult, LdapException> apply(Void value) throws LdapException {
                        return ConnectionImpl.this.timestampBindOrStartTLSPromise(ConnectionImpl.this.connection.bindAsync(request, intermediateResponseHandler));
                    }
                });
            }
            return this.newConnectionErrorPromise();
        }

        @Override
        public void close() {
            this.handleConnectionClosed();
            this.connection.close();
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.handleConnectionClosed();
            this.connection.close(request, reason);
        }

        @Override
        public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.checkState()) {
                return this.timestampPromise(this.connection.compareAsync(request, intermediateResponseHandler));
            }
            return this.newConnectionErrorPromise();
        }

        @Override
        public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.checkState()) {
                return this.timestampPromise(this.connection.deleteAsync(request, intermediateResponseHandler));
            }
            return this.newConnectionErrorPromise();
        }

        @Override
        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(final ExtendedRequest<R> request, final IntermediateResponseHandler intermediateResponseHandler) {
            if (this.checkState()) {
                if (this.isStartTLSRequest(request)) {
                    if (this.sync.tryLockShared()) {
                        return this.timestampBindOrStartTLSPromise(this.connection.extendedRequestAsync(request, intermediateResponseHandler));
                    }
                    return this.enqueueBindOrStartTLSPromise(new AsyncFunction<Void, R, LdapException>(){

                        public Promise<R, LdapException> apply(Void value) throws LdapException {
                            return ConnectionImpl.this.timestampBindOrStartTLSPromise(ConnectionImpl.this.connection.extendedRequestAsync(request, intermediateResponseHandler));
                        }
                    });
                }
                return this.timestampPromise(this.connection.extendedRequestAsync(request, intermediateResponseHandler));
            }
            return this.newConnectionErrorPromise();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleConnectionClosed() {
            if (this.state.notifyConnectionClosed()) {
                this.failPendingResults(LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED, (CharSequence)CoreMessages.HBCF_CONNECTION_CLOSED_BY_CLIENT.get()));
                List list = HeartBeatConnectionFactory.this.validConnections;
                synchronized (list) {
                    this.connection.removeConnectionEventListener(this);
                    HeartBeatConnectionFactory.this.validConnections.remove(this);
                    if (HeartBeatConnectionFactory.this.validConnections.isEmpty()) {
                        HeartBeatConnectionFactory.this.heartBeatFuture.cancel(false);
                    }
                }
                HeartBeatConnectionFactory.this.releaseScheduler();
            }
        }

        @Override
        public void handleConnectionError(boolean isDisconnectNotification, LdapException error) {
            if (this.state.notifyConnectionError(isDisconnectNotification, error)) {
                this.failPendingResults(error);
            }
        }

        @Override
        public void handleUnsolicitedNotification(ExtendedResult notification) {
            this.timestamp(notification);
            this.state.notifyUnsolicitedNotification(notification);
        }

        @Override
        public boolean isClosed() {
            return this.state.isClosed();
        }

        @Override
        public boolean isValid() {
            return this.state.isValid() && this.connection.isValid();
        }

        @Override
        public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.checkState()) {
                return this.timestampPromise(this.connection.modifyAsync(request, intermediateResponseHandler));
            }
            return this.newConnectionErrorPromise();
        }

        @Override
        public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.checkState()) {
                return this.timestampPromise(this.connection.modifyDNAsync(request, intermediateResponseHandler));
            }
            return this.newConnectionErrorPromise();
        }

        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            this.state.removeConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, final SearchResultHandler searchHandler) {
            if (this.checkState()) {
                final AtomicBoolean searchDone = new AtomicBoolean();
                SearchResultHandler entryHandler = new SearchResultHandler(){

                    @Override
                    public synchronized boolean handleEntry(SearchResultEntry entry) {
                        if (!searchDone.get()) {
                            ConnectionImpl.this.timestamp(entry);
                            if (searchHandler != null) {
                                searchHandler.handleEntry(entry);
                            }
                        }
                        return true;
                    }

                    @Override
                    public synchronized boolean handleReference(SearchResultReference reference) {
                        if (!searchDone.get()) {
                            ConnectionImpl.this.timestamp(reference);
                            if (searchHandler != null) {
                                searchHandler.handleReference(reference);
                            }
                        }
                        return true;
                    }
                };
                return this.timestampPromise(this.connection.searchAsync(request, intermediateResponseHandler, entryHandler).thenOnResultOrException(new Runnable(){

                    @Override
                    public void run() {
                        searchDone.getAndSet(true);
                    }
                }));
            }
            return this.newConnectionErrorPromise();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("HeartBeatConnection(");
            builder.append(this.connection);
            builder.append(')');
            return builder.toString();
        }

        private void checkForHeartBeat() {
            long currentTimeMillis;
            if (this.sync.isHeld() && this.lastResponseTimestamp < (currentTimeMillis = HeartBeatConnectionFactory.this.timeService.now()) - HeartBeatConnectionFactory.this.timeoutMS) {
                logger.warn(LocalizableMessage.raw((CharSequence)"No heartbeat detected for connection '%s'", (Object[])new Object[]{this.connection}));
                this.handleConnectionError(false, HeartBeatConnectionFactory.this.newHeartBeatTimeoutError());
            }
        }

        private boolean checkState() {
            return this.state.getConnectionError() == null;
        }

        private void failPendingResults(LdapException error) {
            LdapResultHandler<?> pendingResult;
            while ((pendingResult = this.pendingResults.peek()) != null) {
                pendingResult.handleException(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushPendingBindOrStartTLSRequests() {
            if (!this.pendingBindOrStartTLSRequests.isEmpty() && this.sync.tryLockShared()) {
                try {
                    Runnable pendingRequest;
                    while ((pendingRequest = this.pendingBindOrStartTLSRequests.poll()) != null) {
                        pendingRequest.run();
                    }
                }
                finally {
                    this.sync.unlockShared();
                }
            }
        }

        private boolean isStartTLSRequest(ExtendedRequest<?> request) {
            return request.getOID().equals("1.3.6.1.4.1.1466.20037");
        }

        private <R> LdapPromise<R> newConnectionErrorPromise() {
            return LdapPromises.newFailedLdapPromise(this.state.getConnectionError());
        }

        private void releaseBindOrStartTLSLock() {
            this.sync.unlockShared();
        }

        private void releaseHeartBeatLock() {
            this.sync.unlockExclusively();
            this.flushPendingBindOrStartTLSRequests();
        }

        private boolean sendHeartBeat() {
            if (!this.state.isValid()) {
                return false;
            }
            long currentTimeMillis = HeartBeatConnectionFactory.this.timeService.now();
            if (currentTimeMillis < this.lastResponseTimestamp + HeartBeatConnectionFactory.this.minDelayMS) {
                return false;
            }
            if (this.sync.tryLockExclusively()) {
                try {
                    this.connection.searchAsync(HeartBeatConnectionFactory.this.heartBeatRequest, new SearchResultHandler(){

                        @Override
                        public boolean handleEntry(SearchResultEntry entry) {
                            ConnectionImpl.this.timestamp(entry);
                            return true;
                        }

                        @Override
                        public boolean handleReference(SearchResultReference reference) {
                            ConnectionImpl.this.timestamp(reference);
                            return true;
                        }
                    }).thenOnResult(new ResultHandler<Result>(){

                        public void handleResult(Result result) {
                            ConnectionImpl.this.timestamp(result);
                            ConnectionImpl.this.releaseHeartBeatLock();
                        }
                    }).thenOnException(new ExceptionHandler<LdapException>(){

                        public void handleException(LdapException exception) {
                            if (!(exception instanceof CancelledResultException)) {
                                logger.debug(LocalizableMessage.raw((CharSequence)"Heartbeat failed for connection factory '%s'", (Object[])new Object[]{HeartBeatConnectionFactory.this.factory, exception}));
                                ConnectionImpl.this.timestamp(exception);
                            }
                            ConnectionImpl.this.releaseHeartBeatLock();
                        }
                    });
                }
                catch (IllegalStateException e) {
                    this.releaseHeartBeatLock();
                }
            }
            return true;
        }

        private <R> R timestamp(R response) {
            if (!(response instanceof ConnectionException)) {
                this.lastResponseTimestamp = HeartBeatConnectionFactory.this.timeService.now();
            }
            return response;
        }

        private <R extends Result> LdapPromise<R> enqueueBindOrStartTLSPromise(AsyncFunction<Void, R, LdapException> doRequest) {
            final LdapPromiseImpl promise = LdapPromiseImpl.newLdapPromiseImpl();
            final LdapPromise result = promise.thenAsync((AsyncFunction)doRequest);
            this.pendingBindOrStartTLSRequests.offer(new Runnable(){

                @Override
                public void run() {
                    if (!result.isCancelled()) {
                        ConnectionImpl.this.sync.lockShared();
                        promise.handleResult(null);
                    }
                }
            });
            this.flushPendingBindOrStartTLSRequests();
            return result;
        }

        private <R extends Result> LdapPromise<R> timestampPromise(LdapPromise<R> wrappedPromise) {
            final LdapPromiseImplWrapper<R> outerPromise = new LdapPromiseImplWrapper<R>(wrappedPromise);
            this.pendingResults.add(outerPromise);
            wrappedPromise.thenOnResult(new ResultHandler<R>(){

                public void handleResult(R result) {
                    outerPromise.handleResult(result);
                    ConnectionImpl.this.timestamp(result);
                }
            }).thenOnException(new ExceptionHandler<LdapException>(){

                public void handleException(LdapException exception) {
                    outerPromise.handleException(exception);
                    ConnectionImpl.this.timestamp(exception);
                }
            });
            outerPromise.thenOnResultOrException(new Runnable(){

                @Override
                public void run() {
                    ConnectionImpl.this.pendingResults.remove(outerPromise);
                }
            });
            if (!this.checkState()) {
                outerPromise.handleException(this.state.getConnectionError());
            }
            return outerPromise;
        }

        private <R extends Result> LdapPromise<R> timestampBindOrStartTLSPromise(LdapPromise<R> wrappedPromise) {
            return this.timestampPromise(wrappedPromise).thenOnResultOrException(new Runnable(){

                @Override
                public void run() {
                    ConnectionImpl.this.releaseBindOrStartTLSLock();
                }
            });
        }

        private class LdapPromiseImplWrapper<R>
        extends LdapPromiseImpl<R> {
            protected LdapPromiseImplWrapper(final LdapPromise<R> wrappedPromise) {
                super(new PromiseImpl<R, LdapException>(){

                    protected LdapException tryCancel(boolean mayInterruptIfRunning) {
                        wrappedPromise.cancel(mayInterruptIfRunning);
                        return null;
                    }
                }, wrappedPromise.getRequestID());
            }
        }
    }
}

