/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;

public final class Functions {
    private static final Function<ByteString, String, NeverThrowsException> BYTESTRING_TO_STRING = new Function<ByteString, String, NeverThrowsException>(){

        public String apply(ByteString value) {
            return value.toString();
        }
    };
    private static final Function<Object, Object, NeverThrowsException> IDENTITY = new Function<Object, Object, NeverThrowsException>(){

        public Object apply(Object value) {
            return value;
        }
    };
    private static final Function<String, String, NeverThrowsException> NORMALIZE_STRING = new Function<String, String, NeverThrowsException>(){

        public String apply(String value) {
            return StaticUtils.toLowerCase(value).trim();
        }
    };
    private static final Function<Object, ByteString, NeverThrowsException> OBJECT_TO_BYTESTRING = new Function<Object, ByteString, NeverThrowsException>(){

        public ByteString apply(Object value) {
            return ByteString.valueOf(value);
        }
    };
    private static final Function<String, Boolean, NeverThrowsException> STRING_TO_BOOLEAN = new Function<String, Boolean, NeverThrowsException>(){

        public Boolean apply(String value) {
            String valueString = StaticUtils.toLowerCase(value);
            if ("true".equals(valueString) || "yes".equals(valueString) || "on".equals(valueString) || "1".equals(valueString)) {
                return Boolean.TRUE;
            }
            if ("false".equals(valueString) || "no".equals(valueString) || "off".equals(valueString) || "0".equals(valueString)) {
                return Boolean.FALSE;
            }
            throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN.get((Object)valueString));
        }
    };
    private static final Function<String, GeneralizedTime, NeverThrowsException> STRING_TO_GENERALIZED_TIME = new Function<String, GeneralizedTime, NeverThrowsException>(){

        public GeneralizedTime apply(String value) {
            return GeneralizedTime.valueOf(value);
        }
    };
    private static final Function<String, Integer, NeverThrowsException> STRING_TO_INTEGER = new Function<String, Integer, NeverThrowsException>(){

        public Integer apply(String value) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                LocalizableMessage message = CoreMessages.FUNCTIONS_TO_INTEGER_FAIL.get((Object)value);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
    };
    private static final Function<String, Long, NeverThrowsException> STRING_TO_LONG = new Function<String, Long, NeverThrowsException>(){

        public Long apply(String value) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                LocalizableMessage message = CoreMessages.FUNCTIONS_TO_LONG_FAIL.get((Object)value);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
    };
    private static final Function<ByteString, Boolean, NeverThrowsException> BYTESTRING_TO_BOOLEAN = Functions.compose(Functions.byteStringToString(), STRING_TO_BOOLEAN);
    private static final Function<ByteString, GeneralizedTime, NeverThrowsException> BYTESTRING_TO_GENERALIZED_TIME = Functions.compose(Functions.byteStringToString(), STRING_TO_GENERALIZED_TIME);
    private static final Function<ByteString, Integer, NeverThrowsException> BYTESTRING_TO_INTEGER = Functions.compose(Functions.byteStringToString(), STRING_TO_INTEGER);
    private static final Function<ByteString, Long, NeverThrowsException> BYTESTRING_TO_LONG = Functions.compose(Functions.byteStringToString(), STRING_TO_LONG);

    public static <M, X, N> Function<M, N, NeverThrowsException> compose(final Function<M, X, NeverThrowsException> first, final Function<X, N, NeverThrowsException> second) {
        return new Function<M, N, NeverThrowsException>(){

            public N apply(M value) {
                return second.apply(first.apply(value));
            }
        };
    }

    public static <M> Function<M, M, NeverThrowsException> identityFunction() {
        return IDENTITY;
    }

    public static Function<String, String, NeverThrowsException> normalizeString() {
        return NORMALIZE_STRING;
    }

    public static Function<Object, ByteString, NeverThrowsException> objectToByteString() {
        return OBJECT_TO_BYTESTRING;
    }

    public static Function<String, AttributeDescription, NeverThrowsException> stringToAttributeDescription() {
        return Functions.stringToAttributeDescription(Schema.getDefaultSchema());
    }

    public static Function<String, AttributeDescription, NeverThrowsException> stringToAttributeDescription(final Schema schema) {
        return new Function<String, AttributeDescription, NeverThrowsException>(){

            public AttributeDescription apply(String value) {
                return AttributeDescription.valueOf(value, schema);
            }
        };
    }

    public static Function<String, Boolean, NeverThrowsException> stringToBoolean() {
        return STRING_TO_BOOLEAN;
    }

    public static Function<String, DN, NeverThrowsException> stringToDN() {
        return Functions.stringToDN(Schema.getDefaultSchema());
    }

    public static Function<String, DN, NeverThrowsException> stringToDN(final Schema schema) {
        return new Function<String, DN, NeverThrowsException>(){

            public DN apply(String value) {
                return DN.valueOf(value, schema);
            }
        };
    }

    public static Function<String, GeneralizedTime, NeverThrowsException> stringToGeneralizedTime() {
        return STRING_TO_GENERALIZED_TIME;
    }

    public static Function<String, Integer, NeverThrowsException> stringToInteger() {
        return STRING_TO_INTEGER;
    }

    public static Function<String, Long, NeverThrowsException> stringToLong() {
        return STRING_TO_LONG;
    }

    public static Function<ByteString, AttributeDescription, NeverThrowsException> byteStringToAttributeDescription() {
        return Functions.byteStringToAttributeDescription(Schema.getDefaultSchema());
    }

    public static Function<ByteString, AttributeDescription, NeverThrowsException> byteStringToAttributeDescription(final Schema schema) {
        return Functions.compose(Functions.byteStringToString(), new Function<String, AttributeDescription, NeverThrowsException>(){

            public AttributeDescription apply(String value) {
                return AttributeDescription.valueOf(value, schema);
            }
        });
    }

    public static Function<ByteString, Boolean, NeverThrowsException> byteStringToBoolean() {
        return BYTESTRING_TO_BOOLEAN;
    }

    public static Function<ByteString, DN, NeverThrowsException> byteStringToDN() {
        return Functions.byteStringToDN(Schema.getDefaultSchema());
    }

    public static Function<ByteString, DN, NeverThrowsException> byteStringToDN(final Schema schema) {
        return Functions.compose(Functions.byteStringToString(), new Function<String, DN, NeverThrowsException>(){

            public DN apply(String value) {
                return DN.valueOf(value, schema);
            }
        });
    }

    public static Function<ByteString, GeneralizedTime, NeverThrowsException> byteStringToGeneralizedTime() {
        return BYTESTRING_TO_GENERALIZED_TIME;
    }

    public static Function<ByteString, Integer, NeverThrowsException> byteStringToInteger() {
        return BYTESTRING_TO_INTEGER;
    }

    public static Function<ByteString, Long, NeverThrowsException> byteStringToLong() {
        return BYTESTRING_TO_LONG;
    }

    public static Function<ByteString, String, NeverThrowsException> byteStringToString() {
        return BYTESTRING_TO_STRING;
    }

    private Functions() {
    }
}

