/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.FilterVisitor;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Reject;

public final class Filter {
    private static final byte ASTERISK = 42;
    private static final byte BACKSLASH = 92;
    private static final Filter FALSE = new Filter(new OrImpl(Collections.emptyList()));
    private static final Filter OBJECT_CLASS_PRESENT = new Filter(new PresentImpl("objectClass"));
    private static final FilterVisitor<StringBuilder, StringBuilder> TO_STRING_VISITOR = new FilterVisitor<StringBuilder, StringBuilder>(){

        @Override
        public StringBuilder visitAndFilter(StringBuilder builder, List<Filter> subFilters) {
            builder.append("(&");
            for (Filter subFilter : subFilters) {
                subFilter.accept(this, builder);
            }
            builder.append(')');
            return builder;
        }

        @Override
        public StringBuilder visitApproxMatchFilter(StringBuilder builder, String attributeDescription, ByteString assertionValue) {
            builder.append('(');
            builder.append(attributeDescription);
            builder.append("~=");
            Filter.valueToFilterString(builder, assertionValue);
            builder.append(')');
            return builder;
        }

        @Override
        public StringBuilder visitEqualityMatchFilter(StringBuilder builder, String attributeDescription, ByteString assertionValue) {
            builder.append('(');
            builder.append(attributeDescription);
            builder.append("=");
            Filter.valueToFilterString(builder, assertionValue);
            builder.append(')');
            return builder;
        }

        @Override
        public StringBuilder visitExtensibleMatchFilter(StringBuilder builder, String matchingRule, String attributeDescription, ByteString assertionValue, boolean dnAttributes) {
            builder.append('(');
            if (attributeDescription != null) {
                builder.append(attributeDescription);
            }
            if (dnAttributes) {
                builder.append(":dn");
            }
            if (matchingRule != null) {
                builder.append(':');
                builder.append(matchingRule);
            }
            builder.append(":=");
            Filter.valueToFilterString(builder, assertionValue);
            builder.append(')');
            return builder;
        }

        @Override
        public StringBuilder visitGreaterOrEqualFilter(StringBuilder builder, String attributeDescription, ByteString assertionValue) {
            builder.append('(');
            builder.append(attributeDescription);
            builder.append(">=");
            Filter.valueToFilterString(builder, assertionValue);
            builder.append(')');
            return builder;
        }

        @Override
        public StringBuilder visitLessOrEqualFilter(StringBuilder builder, String attributeDescription, ByteString assertionValue) {
            builder.append('(');
            builder.append(attributeDescription);
            builder.append("<=");
            Filter.valueToFilterString(builder, assertionValue);
            builder.append(')');
            return builder;
        }

        @Override
        public StringBuilder visitNotFilter(StringBuilder builder, Filter subFilter) {
            builder.append("(!");
            subFilter.accept(this, builder);
            builder.append(')');
            return builder;
        }

        @Override
        public StringBuilder visitOrFilter(StringBuilder builder, List<Filter> subFilters) {
            builder.append("(|");
            for (Filter subFilter : subFilters) {
                subFilter.accept(this, builder);
            }
            builder.append(')');
            return builder;
        }

        @Override
        public StringBuilder visitPresentFilter(StringBuilder builder, String attributeDescription) {
            builder.append('(');
            builder.append(attributeDescription);
            builder.append("=*)");
            return builder;
        }

        @Override
        public StringBuilder visitSubstringsFilter(StringBuilder builder, String attributeDescription, ByteString initialSubstring, List<ByteString> anySubstrings, ByteString finalSubstring) {
            builder.append('(');
            builder.append(attributeDescription);
            builder.append("=");
            if (initialSubstring != null) {
                Filter.valueToFilterString(builder, initialSubstring);
            }
            for (ByteString anySubstring : anySubstrings) {
                builder.append('*');
                Filter.valueToFilterString(builder, anySubstring);
            }
            builder.append('*');
            if (finalSubstring != null) {
                Filter.valueToFilterString(builder, finalSubstring);
            }
            builder.append(')');
            return builder;
        }

        @Override
        public StringBuilder visitUnrecognizedFilter(StringBuilder builder, byte filterTag, ByteString filterBytes) {
            builder.append('(');
            builder.append(StaticUtils.byteToHex(filterTag));
            builder.append(':');
            builder.append(filterBytes.toHexString());
            builder.append(')');
            return builder;
        }
    };
    private static final Filter TRUE = new Filter(new AndImpl(Collections.emptyList()));
    private final Impl pimpl;

    public static Filter alwaysFalse() {
        return FALSE;
    }

    public static Filter alwaysTrue() {
        return TRUE;
    }

    public static Filter and(Collection<Filter> subFilters) {
        if (subFilters == null || subFilters.isEmpty()) {
            return Filter.alwaysTrue();
        }
        if (subFilters.size() == 1) {
            Filter subFilter = subFilters.iterator().next();
            Reject.ifNull((Object)subFilter);
            return new Filter(new AndImpl(Collections.singletonList(subFilter)));
        }
        ArrayList<Filter> subFiltersList = new ArrayList<Filter>(subFilters.size());
        for (Filter subFilter : subFilters) {
            Reject.ifNull((Object)subFilter);
            subFiltersList.add(subFilter);
        }
        return new Filter(new AndImpl(Collections.unmodifiableList(subFiltersList)));
    }

    public static Filter and(Filter ... subFilters) {
        if (subFilters == null || subFilters.length == 0) {
            return Filter.alwaysTrue();
        }
        if (subFilters.length == 1) {
            Reject.ifNull((Object)subFilters[0]);
            return new Filter(new AndImpl(Collections.singletonList(subFilters[0])));
        }
        ArrayList<Filter> subFiltersList = new ArrayList<Filter>(subFilters.length);
        for (Filter subFilter : subFilters) {
            Reject.ifNull((Object)subFilter);
            subFiltersList.add(subFilter);
        }
        return new Filter(new AndImpl(Collections.unmodifiableList(subFiltersList)));
    }

    public static Filter approx(String attributeDescription, Object assertionValue) {
        Reject.ifNull((Object[])new Object[]{attributeDescription, assertionValue});
        return new Filter(new ApproxMatchImpl(attributeDescription, ByteString.valueOf(assertionValue)));
    }

    public static Filter equality(String attributeDescription, Object assertionValue) {
        Reject.ifNull((Object[])new Object[]{attributeDescription, assertionValue});
        return new Filter(new EqualityMatchImpl(attributeDescription, ByteString.valueOf(assertionValue)));
    }

    public static String escapeAssertionValue(Object assertionValue) {
        Reject.ifNull((Object)assertionValue);
        ByteString bytes = ByteString.valueOf(assertionValue);
        StringBuilder builder = new StringBuilder(bytes.length());
        Filter.valueToFilterString(builder, bytes);
        return builder.toString();
    }

    public static Filter extensible(String matchingRule, String attributeDescription, Object assertionValue, boolean dnAttributes) {
        Reject.ifFalse((matchingRule != null || attributeDescription != null ? 1 : 0) != 0, (String)"matchingRule and/or attributeDescription must not be null");
        Reject.ifNull((Object)assertionValue);
        return new Filter(new ExtensibleMatchImpl(matchingRule, attributeDescription, ByteString.valueOf(assertionValue), dnAttributes));
    }

    public static Filter greaterOrEqual(String attributeDescription, Object assertionValue) {
        Reject.ifNull((Object[])new Object[]{attributeDescription, assertionValue});
        return new Filter(new GreaterOrEqualImpl(attributeDescription, ByteString.valueOf(assertionValue)));
    }

    public static Filter greaterThan(String attributeDescription, Object assertionValue) {
        return Filter.and(Filter.greaterOrEqual(attributeDescription, assertionValue), Filter.not(Filter.equality(attributeDescription, assertionValue)));
    }

    public static Filter lessOrEqual(String attributeDescription, Object assertionValue) {
        Reject.ifNull((Object[])new Object[]{attributeDescription, assertionValue});
        return new Filter(new LessOrEqualImpl(attributeDescription, ByteString.valueOf(assertionValue)));
    }

    public static Filter lessThan(String attributeDescription, Object assertionValue) {
        return Filter.and(Filter.lessOrEqual(attributeDescription, assertionValue), Filter.not(Filter.equality(attributeDescription, assertionValue)));
    }

    public static Filter not(Filter subFilter) {
        Reject.ifNull((Object)subFilter);
        return new Filter(new NotImpl(subFilter));
    }

    public static Filter objectClassPresent() {
        return OBJECT_CLASS_PRESENT;
    }

    public static Filter or(Collection<Filter> subFilters) {
        if (subFilters == null || subFilters.isEmpty()) {
            return Filter.alwaysFalse();
        }
        if (subFilters.size() == 1) {
            Filter subFilter = subFilters.iterator().next();
            Reject.ifNull((Object)subFilter);
            return new Filter(new OrImpl(Collections.singletonList(subFilter)));
        }
        ArrayList<Filter> subFiltersList = new ArrayList<Filter>(subFilters.size());
        for (Filter subFilter : subFilters) {
            Reject.ifNull((Object)subFilter);
            subFiltersList.add(subFilter);
        }
        return new Filter(new OrImpl(Collections.unmodifiableList(subFiltersList)));
    }

    public static Filter or(Filter ... subFilters) {
        if (subFilters == null || subFilters.length == 0) {
            return Filter.alwaysFalse();
        }
        if (subFilters.length == 1) {
            Reject.ifNull((Object)subFilters[0]);
            return new Filter(new OrImpl(Collections.singletonList(subFilters[0])));
        }
        ArrayList<Filter> subFiltersList = new ArrayList<Filter>(subFilters.length);
        for (Filter subFilter : subFilters) {
            Reject.ifNull((Object)subFilter);
            subFiltersList.add(subFilter);
        }
        return new Filter(new OrImpl(Collections.unmodifiableList(subFiltersList)));
    }

    public static Filter present(String attributeDescription) {
        Reject.ifNull((Object)attributeDescription);
        if ("objectclass".equals(StaticUtils.toLowerCase(attributeDescription))) {
            return OBJECT_CLASS_PRESENT;
        }
        return new Filter(new PresentImpl(attributeDescription));
    }

    public static Filter substrings(String attributeDescription, Object initialSubstring, Collection<?> anySubstrings, Object finalSubstring) {
        List<ByteString> anySubstringList;
        Reject.ifNull((Object)attributeDescription);
        Reject.ifFalse((initialSubstring != null || finalSubstring != null || anySubstrings != null && anySubstrings.size() > 0 ? 1 : 0) != 0, (String)"at least one substring (initial, any or final) must be specified");
        if (anySubstrings == null || anySubstrings.size() == 0) {
            anySubstringList = Collections.emptyList();
        } else if (anySubstrings.size() == 1) {
            Object anySubstring = anySubstrings.iterator().next();
            Reject.ifNull(anySubstring);
            anySubstringList = Collections.singletonList(ByteString.valueOf(anySubstring));
        } else {
            anySubstringList = new ArrayList(anySubstrings.size());
            for (Object anySubstring : anySubstrings) {
                Reject.ifNull(anySubstring);
                anySubstringList.add(ByteString.valueOf(anySubstring));
            }
            anySubstringList = Collections.unmodifiableList(anySubstringList);
        }
        return new Filter(new SubstringsImpl(attributeDescription, initialSubstring != null ? ByteString.valueOf(initialSubstring) : null, anySubstringList, finalSubstring != null ? ByteString.valueOf(finalSubstring) : null));
    }

    public static Filter unrecognized(byte filterTag, ByteString filterBytes) {
        Reject.ifNull((Object)filterBytes);
        return new Filter(new UnrecognizedImpl(filterTag, filterBytes));
    }

    public static Filter valueOf(String string) {
        Reject.ifNull((Object)string);
        if (string.length() > 1 && string.startsWith("'") && string.endsWith("'")) {
            LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_ENCLOSED_IN_APOSTROPHES.get((Object)string);
            throw new LocalizedIllegalArgumentException(message);
        }
        try {
            if (string.startsWith("(")) {
                if (string.endsWith(")")) {
                    return Filter.valueOf0(string, 1, string.length() - 1);
                }
                LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_MISMATCHED_PARENTHESES.get((Object)string, (Object)1, (Object)string.length());
                throw new LocalizedIllegalArgumentException(message);
            }
            return Filter.valueOf0(string, 0, string.length());
        }
        catch (LocalizedIllegalArgumentException liae) {
            throw liae;
        }
        catch (Exception e) {
            LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_UNCAUGHT_EXCEPTION.get((Object)string, (Object)String.valueOf(e));
            throw new LocalizedIllegalArgumentException(message);
        }
    }

    public static Filter format(String template, Object ... assertionValues) {
        String[] assertionValueStrings = new String[assertionValues.length];
        for (int i = 0; i < assertionValues.length; ++i) {
            assertionValueStrings[i] = Filter.escapeAssertionValue(assertionValues[i]);
        }
        String filterString = String.format(template, assertionValueStrings);
        return Filter.valueOf(filterString);
    }

    private static Filter assertionValue2SubstringFilter(String filterString, String attrType, int equalPos, int endPos) {
        ByteString subFinal;
        ByteString subInitial;
        byte[] valueBytes = StaticUtils.getBytes(filterString.substring(equalPos, endPos));
        boolean hasEscape = false;
        LinkedList<Integer> asteriskPositions = new LinkedList<Integer>();
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] == 42) {
                asteriskPositions.add(i);
                continue;
            }
            if (valueBytes[i] != 92) continue;
            hasEscape = true;
        }
        if (asteriskPositions.isEmpty()) {
            LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_SUBSTRING_NO_ASTERISKS.get((Object)filterString, (Object)(equalPos + 1), (Object)endPos);
            throw new LocalizedIllegalArgumentException(message);
        }
        int firstPos = (Integer)asteriskPositions.removeFirst();
        if (firstPos == 0) {
            subInitial = null;
        } else if (hasEscape) {
            ByteStringBuilder buffer = new ByteStringBuilder(firstPos);
            Filter.escapeHexChars(buffer, attrType, valueBytes, 0, firstPos, equalPos);
            subInitial = buffer.toByteString();
        } else {
            subInitial = ByteString.wrap(valueBytes, 0, firstPos);
        }
        ArrayList<ByteString> subAny = new ArrayList<ByteString>();
        Iterator i$ = asteriskPositions.iterator();
        while (i$.hasNext()) {
            int asteriskPos = (Integer)i$.next();
            int length = asteriskPos - firstPos - 1;
            if (hasEscape) {
                ByteStringBuilder buffer = new ByteStringBuilder(length);
                Filter.escapeHexChars(buffer, attrType, valueBytes, firstPos + 1, asteriskPos, equalPos);
                subAny.add(buffer.toByteString());
                buffer.clear();
            } else {
                subAny.add(ByteString.wrap(valueBytes, firstPos + 1, length));
            }
            firstPos = asteriskPos;
        }
        if (firstPos == valueBytes.length - 1) {
            subFinal = null;
        } else {
            int length = valueBytes.length - firstPos - 1;
            if (hasEscape) {
                ByteStringBuilder buffer = new ByteStringBuilder(length);
                Filter.escapeHexChars(buffer, attrType, valueBytes, firstPos + 1, valueBytes.length, equalPos);
                subFinal = buffer.toByteString();
            } else {
                subFinal = ByteString.wrap(valueBytes, firstPos + 1, length);
            }
        }
        return new Filter(new SubstringsImpl(attrType, subInitial, subAny, subFinal));
    }

    private static void escapeHexChars(ByteStringBuilder valueBuffer, String string, byte[] valueBytes, int fromIndex, int len, int errorIndex) {
        for (int i = fromIndex; i < len; ++i) {
            if (valueBytes[i] == 92) {
                if (i + 2 >= valueBytes.length) {
                    LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get((Object)string, (Object)(errorIndex + i + 1));
                    throw new LocalizedIllegalArgumentException(message);
                }
                byte byteValue = 0;
                switch (valueBytes[++i]) {
                    case 48: {
                        break;
                    }
                    case 49: {
                        byteValue = 16;
                        break;
                    }
                    case 50: {
                        byteValue = 32;
                        break;
                    }
                    case 51: {
                        byteValue = 48;
                        break;
                    }
                    case 52: {
                        byteValue = 64;
                        break;
                    }
                    case 53: {
                        byteValue = 80;
                        break;
                    }
                    case 54: {
                        byteValue = 96;
                        break;
                    }
                    case 55: {
                        byteValue = 112;
                        break;
                    }
                    case 56: {
                        byteValue = -128;
                        break;
                    }
                    case 57: {
                        byteValue = -112;
                        break;
                    }
                    case 65: 
                    case 97: {
                        byteValue = -96;
                        break;
                    }
                    case 66: 
                    case 98: {
                        byteValue = -80;
                        break;
                    }
                    case 67: 
                    case 99: {
                        byteValue = -64;
                        break;
                    }
                    case 68: 
                    case 100: {
                        byteValue = -48;
                        break;
                    }
                    case 69: 
                    case 101: {
                        byteValue = -32;
                        break;
                    }
                    case 70: 
                    case 102: {
                        byteValue = -16;
                        break;
                    }
                    default: {
                        LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get((Object)string, (Object)(errorIndex + i + 1));
                        throw new LocalizedIllegalArgumentException(message);
                    }
                }
                switch (valueBytes[++i]) {
                    case 48: {
                        break;
                    }
                    case 49: {
                        byteValue = (byte)(byteValue | 1);
                        break;
                    }
                    case 50: {
                        byteValue = (byte)(byteValue | 2);
                        break;
                    }
                    case 51: {
                        byteValue = (byte)(byteValue | 3);
                        break;
                    }
                    case 52: {
                        byteValue = (byte)(byteValue | 4);
                        break;
                    }
                    case 53: {
                        byteValue = (byte)(byteValue | 5);
                        break;
                    }
                    case 54: {
                        byteValue = (byte)(byteValue | 6);
                        break;
                    }
                    case 55: {
                        byteValue = (byte)(byteValue | 7);
                        break;
                    }
                    case 56: {
                        byteValue = (byte)(byteValue | 8);
                        break;
                    }
                    case 57: {
                        byteValue = (byte)(byteValue | 9);
                        break;
                    }
                    case 65: 
                    case 97: {
                        byteValue = (byte)(byteValue | 0xA);
                        break;
                    }
                    case 66: 
                    case 98: {
                        byteValue = (byte)(byteValue | 0xB);
                        break;
                    }
                    case 67: 
                    case 99: {
                        byteValue = (byte)(byteValue | 0xC);
                        break;
                    }
                    case 68: 
                    case 100: {
                        byteValue = (byte)(byteValue | 0xD);
                        break;
                    }
                    case 69: 
                    case 101: {
                        byteValue = (byte)(byteValue | 0xE);
                        break;
                    }
                    case 70: 
                    case 102: {
                        byteValue = (byte)(byteValue | 0xF);
                        break;
                    }
                    default: {
                        LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_INVALID_ESCAPED_BYTE.get((Object)string, (Object)(errorIndex + i + 1));
                        throw new LocalizedIllegalArgumentException(message);
                    }
                }
                valueBuffer.append(byteValue);
                continue;
            }
            valueBuffer.append(valueBytes[i]);
        }
    }

    private static Filter valueOf0(String string, int beginIndex, int endIndex) {
        if (beginIndex >= endIndex) {
            LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_STRING_NULL.get();
            throw new LocalizedIllegalArgumentException(message);
        }
        int index = beginIndex;
        char c = string.charAt(index);
        if (c == '&') {
            List<Filter> subFilters = Filter.valueOfFilterList(string, index + 1, endIndex);
            if (subFilters.isEmpty()) {
                return Filter.alwaysTrue();
            }
            return new Filter(new AndImpl(subFilters));
        }
        if (c == '|') {
            List<Filter> subFilters = Filter.valueOfFilterList(string, index + 1, endIndex);
            if (subFilters.isEmpty()) {
                return Filter.alwaysFalse();
            }
            return new Filter(new OrImpl(subFilters));
        }
        if (c == '!') {
            if (string.charAt(index + 1) != '(' || string.charAt(endIndex - 1) != ')') {
                LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_COMPOUND_MISSING_PARENTHESES.get((Object)string, (Object)index, (Object)(endIndex - 1));
                throw new LocalizedIllegalArgumentException(message);
            }
            List<Filter> subFilters = Filter.valueOfFilterList(string, index + 1, endIndex);
            if (subFilters.size() != 1) {
                LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_NOT_EXACTLY_ONE.get((Object)string, (Object)index, (Object)endIndex);
                throw new LocalizedIllegalArgumentException(message);
            }
            return new Filter(new NotImpl(subFilters.get(0)));
        }
        int equalPos = Filter.indexOf(string, index, endIndex);
        if (equalPos <= index) {
            LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_NO_EQUAL_SIGN.get((Object)string, (Object)index, (Object)endIndex);
            throw new LocalizedIllegalArgumentException(message);
        }
        switch (string.charAt(equalPos - 1)) {
            case '~': {
                String attributeDescription = Filter.valueOfAttributeDescription(string, index, equalPos - 1);
                ByteString assertionValue = Filter.valueOfAssertionValue(string, equalPos + 1, endIndex);
                return new Filter(new ApproxMatchImpl(attributeDescription, assertionValue));
            }
            case '>': {
                String attributeDescription = Filter.valueOfAttributeDescription(string, index, equalPos - 1);
                ByteString assertionValue = Filter.valueOfAssertionValue(string, equalPos + 1, endIndex);
                return new Filter(new GreaterOrEqualImpl(attributeDescription, assertionValue));
            }
            case '<': {
                String attributeDescription = Filter.valueOfAttributeDescription(string, index, equalPos - 1);
                ByteString assertionValue = Filter.valueOfAssertionValue(string, equalPos + 1, endIndex);
                return new Filter(new LessOrEqualImpl(attributeDescription, assertionValue));
            }
            case ':': {
                return Filter.valueOfExtensibleFilter(string, index, equalPos, endIndex);
            }
        }
        String attributeDescription = Filter.valueOfAttributeDescription(string, index, equalPos);
        return Filter.valueOfGenericFilter(string, attributeDescription, equalPos + 1, endIndex);
    }

    private static int indexOf(String string, int index, int endIndex) {
        for (int i = index; i < endIndex; ++i) {
            if (string.charAt(i) != '=') continue;
            return i;
        }
        return -1;
    }

    private static ByteString valueOfAssertionValue(String string, int startIndex, int endIndex) {
        byte[] valueBytes = StaticUtils.getBytes(string.substring(startIndex, endIndex));
        if (Filter.hasEscape(valueBytes)) {
            ByteStringBuilder valueBuffer = new ByteStringBuilder(valueBytes.length);
            Filter.escapeHexChars(valueBuffer, string, valueBytes, 0, valueBytes.length, startIndex);
            return valueBuffer.toByteString();
        }
        return ByteString.wrap(valueBytes);
    }

    private static boolean hasEscape(byte[] valueBytes) {
        for (byte valueByte : valueBytes) {
            if (valueByte != 92) continue;
            return true;
        }
        return false;
    }

    private static String valueOfAttributeDescription(String string, int startIndex, int endIndex) {
        String attrType = string.substring(startIndex, endIndex);
        block3: for (int i = 0; i < attrType.length(); ++i) {
            switch (attrType.charAt(i)) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ';': 
                case '=': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
                default: {
                    LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_INVALID_CHAR_IN_ATTR_TYPE.get((Object)attrType, (Object)String.valueOf(attrType.charAt(i)), (Object)i);
                    throw new LocalizedIllegalArgumentException(message);
                }
            }
        }
        return attrType;
    }

    private static Filter valueOfExtensibleFilter(String string, int startIndex, int equalIndex, int endIndex) {
        String attributeDescription = null;
        boolean dnAttributes = false;
        String matchingRule = null;
        String lowerLeftStr = StaticUtils.toLowerCase(string.substring(startIndex, equalIndex));
        if (string.charAt(startIndex) == ':') {
            if (lowerLeftStr.startsWith(":dn:")) {
                dnAttributes = true;
                if (startIndex + 4 < equalIndex - 1) {
                    matchingRule = string.substring(startIndex + 4, equalIndex - 1);
                }
            } else {
                matchingRule = string.substring(startIndex + 1, equalIndex - 1);
            }
        } else {
            int colonPos = string.indexOf(58, startIndex);
            if (colonPos < 0) {
                LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_EXTENSIBLE_MATCH_NO_COLON.get((Object)string, (Object)startIndex);
                throw new LocalizedIllegalArgumentException(message);
            }
            attributeDescription = string.substring(startIndex, colonPos);
            if (colonPos < equalIndex - 1) {
                if (lowerLeftStr.startsWith(":dn:", colonPos - startIndex)) {
                    dnAttributes = true;
                    if (colonPos + 4 < equalIndex - 1) {
                        matchingRule = string.substring(colonPos + 4, equalIndex - 1);
                    }
                } else {
                    matchingRule = string.substring(colonPos + 1, equalIndex - 1);
                }
            }
        }
        ByteString matchValue = Filter.valueOfAssertionValue(string, equalIndex + 1, endIndex);
        if (attributeDescription == null && matchingRule == null) {
            LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_EXTENSIBLE_MATCH_NO_AD_OR_MR.get((Object)string, (Object)startIndex);
            throw new LocalizedIllegalArgumentException(message);
        }
        return new Filter(new ExtensibleMatchImpl(matchingRule, attributeDescription, matchValue, dnAttributes));
    }

    private static List<Filter> valueOfFilterList(String string, int startIndex, int endIndex) {
        if (startIndex >= endIndex) {
            return Collections.emptyList();
        }
        Filter firstFilter = null;
        LinkedList<Filter> subFilters = null;
        if (string.charAt(startIndex) != '(' || string.charAt(endIndex - 1) != ')') {
            LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_COMPOUND_MISSING_PARENTHESES.get((Object)string, (Object)startIndex, (Object)endIndex);
            throw new LocalizedIllegalArgumentException(message);
        }
        int pendingOpens = 0;
        int openIndex = -1;
        for (int i = startIndex; i < endIndex; ++i) {
            LocalizableMessage message;
            char c = string.charAt(i);
            if (c == '(') {
                if (openIndex < 0) {
                    openIndex = i;
                }
                ++pendingOpens;
                continue;
            }
            if (c == ')') {
                if (--pendingOpens == 0) {
                    Filter subFilter = Filter.valueOf0(string, openIndex + 1, i);
                    if (subFilters != null) {
                        subFilters.add(subFilter);
                    } else if (firstFilter != null) {
                        subFilters = new LinkedList<Filter>();
                        subFilters.add(firstFilter);
                        subFilters.add(subFilter);
                        firstFilter = null;
                    } else {
                        firstFilter = subFilter;
                    }
                    openIndex = -1;
                    continue;
                }
                if (pendingOpens >= 0) continue;
                message = CoreMessages.ERR_LDAP_FILTER_NO_CORRESPONDING_OPEN_PARENTHESIS.get((Object)string, (Object)i);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (pendingOpens > 0) continue;
            message = CoreMessages.ERR_LDAP_FILTER_COMPOUND_MISSING_PARENTHESES.get((Object)string, (Object)startIndex, (Object)endIndex);
            throw new LocalizedIllegalArgumentException(message);
        }
        if (pendingOpens != 0) {
            LocalizableMessage message = CoreMessages.ERR_LDAP_FILTER_NO_CORRESPONDING_CLOSE_PARENTHESIS.get((Object)string, (Object)openIndex);
            throw new LocalizedIllegalArgumentException(message);
        }
        if (subFilters != null) {
            return Collections.unmodifiableList(subFilters);
        }
        return Collections.singletonList(firstFilter);
    }

    private static Filter valueOfGenericFilter(String string, String attributeDescription, int startIndex, int endIndex) {
        int asteriskIdx = string.indexOf(42, startIndex);
        if (startIndex >= endIndex) {
            return new Filter(new EqualityMatchImpl(attributeDescription, ByteString.empty()));
        }
        if (endIndex - startIndex == 1 && string.charAt(startIndex) == '*') {
            return Filter.present(attributeDescription);
        }
        if (asteriskIdx > 0 && asteriskIdx <= endIndex) {
            return Filter.assertionValue2SubstringFilter(string, attributeDescription, startIndex, endIndex);
        }
        ByteString assertionValue = Filter.valueOfAssertionValue(string, startIndex, endIndex);
        return new Filter(new EqualityMatchImpl(attributeDescription, assertionValue));
    }

    private static void valueToFilterString(StringBuilder builder, ByteString value) {
        builder.ensureCapacity(builder.length() + value.length());
        for (int i = 0; i < value.length(); ++i) {
            byte b = value.byteAt(i);
            if ((b & 0x7F) != b || b <= 31 || b == 40 || b == 41 || b == 42 || b == 92 || b == 127) {
                builder.append('\\');
                builder.append(StaticUtils.byteToHex(b));
                continue;
            }
            builder.append((char)b);
        }
    }

    private Filter(Impl pimpl) {
        this.pimpl = pimpl;
    }

    public <R, P> R accept(FilterVisitor<R, P> v, P p) {
        return this.pimpl.accept(v, p);
    }

    public Matcher matcher() {
        return new Matcher(this, Schema.getDefaultSchema());
    }

    public Matcher matcher(Schema schema) {
        return new Matcher(this, schema);
    }

    public ConditionResult matches(Entry entry) {
        return this.matcher(Schema.getDefaultSchema()).matches(entry);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return this.pimpl.accept(TO_STRING_VISITOR, builder).toString();
    }

    private static final class UnrecognizedImpl
    extends Impl {
        private final ByteString filterBytes;
        private final byte filterTag;

        public UnrecognizedImpl(byte filterTag, ByteString filterBytes) {
            this.filterTag = filterTag;
            this.filterBytes = filterBytes;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitUnrecognizedFilter(p, this.filterTag, this.filterBytes);
        }
    }

    private static final class SubstringsImpl
    extends Impl {
        private final List<ByteString> anyStrings;
        private final String attributeDescription;
        private final ByteString finalString;
        private final ByteString initialString;

        public SubstringsImpl(String attributeDescription, ByteString initialString, List<ByteString> anyStrings, ByteString finalString) {
            this.attributeDescription = attributeDescription;
            this.initialString = initialString;
            this.anyStrings = anyStrings;
            this.finalString = finalString;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitSubstringsFilter(p, this.attributeDescription, this.initialString, this.anyStrings, this.finalString);
        }
    }

    private static final class PresentImpl
    extends Impl {
        private final String attributeDescription;

        public PresentImpl(String attributeDescription) {
            this.attributeDescription = attributeDescription;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitPresentFilter(p, this.attributeDescription);
        }
    }

    private static final class OrImpl
    extends Impl {
        private final List<Filter> subFilters;

        public OrImpl(List<Filter> subFilters) {
            this.subFilters = subFilters;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitOrFilter(p, this.subFilters);
        }
    }

    private static final class NotImpl
    extends Impl {
        private final Filter subFilter;

        public NotImpl(Filter subFilter) {
            this.subFilter = subFilter;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitNotFilter(p, this.subFilter);
        }
    }

    private static final class LessOrEqualImpl
    extends Impl {
        private final ByteString assertionValue;
        private final String attributeDescription;

        public LessOrEqualImpl(String attributeDescription, ByteString assertionValue) {
            this.attributeDescription = attributeDescription;
            this.assertionValue = assertionValue;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitLessOrEqualFilter(p, this.attributeDescription, this.assertionValue);
        }
    }

    private static abstract class Impl {
        protected Impl() {
        }

        public abstract <R, P> R accept(FilterVisitor<R, P> var1, P var2);
    }

    private static final class GreaterOrEqualImpl
    extends Impl {
        private final ByteString assertionValue;
        private final String attributeDescription;

        public GreaterOrEqualImpl(String attributeDescription, ByteString assertionValue) {
            this.attributeDescription = attributeDescription;
            this.assertionValue = assertionValue;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitGreaterOrEqualFilter(p, this.attributeDescription, this.assertionValue);
        }
    }

    private static final class ExtensibleMatchImpl
    extends Impl {
        private final String attributeDescription;
        private final boolean dnAttributes;
        private final String matchingRule;
        private final ByteString matchValue;

        public ExtensibleMatchImpl(String matchingRule, String attributeDescription, ByteString matchValue, boolean dnAttributes) {
            this.matchingRule = matchingRule;
            this.attributeDescription = attributeDescription;
            this.matchValue = matchValue;
            this.dnAttributes = dnAttributes;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitExtensibleMatchFilter(p, this.matchingRule, this.attributeDescription, this.matchValue, this.dnAttributes);
        }
    }

    private static final class EqualityMatchImpl
    extends Impl {
        private final ByteString assertionValue;
        private final String attributeDescription;

        public EqualityMatchImpl(String attributeDescription, ByteString assertionValue) {
            this.attributeDescription = attributeDescription;
            this.assertionValue = assertionValue;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitEqualityMatchFilter(p, this.attributeDescription, this.assertionValue);
        }
    }

    private static final class ApproxMatchImpl
    extends Impl {
        private final ByteString assertionValue;
        private final String attributeDescription;

        public ApproxMatchImpl(String attributeDescription, ByteString assertionValue) {
            this.attributeDescription = attributeDescription;
            this.assertionValue = assertionValue;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitApproxMatchFilter(p, this.attributeDescription, this.assertionValue);
        }
    }

    private static final class AndImpl
    extends Impl {
        private final List<Filter> subFilters;

        public AndImpl(List<Filter> subFilters) {
            this.subFilters = subFilters;
        }

        @Override
        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return v.visitAndFilter(p, this.subFilters);
        }
    }
}

