/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.forgerock.opendj.ldap.Base64;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.util.Reject;

public final class ByteStringBuilder
implements ByteSequence {
    public static final long COMPACTED_MAX_VALUE = 0xFFFFFFFFFFFFFFL;
    byte[] buffer;
    int length;
    private OutputStreamImpl os;

    public ByteStringBuilder() {
        this(32);
    }

    public ByteStringBuilder(int capacity) {
        Reject.ifFalse((capacity >= 0 ? 1 : 0) != 0, (String)"capacity must be >= 0");
        this.buffer = new byte[capacity];
        this.length = 0;
    }

    public ByteStringBuilder(ByteSequence bs) {
        this(bs.length());
        bs.copyTo(this);
    }

    public ByteStringBuilder append(byte b) {
        this.ensureAdditionalCapacity(1);
        this.buffer[this.length++] = b;
        return this;
    }

    public ByteStringBuilder append(byte[] bytes) {
        return this.append(bytes, 0, bytes.length);
    }

    public ByteStringBuilder append(byte[] bytes, int offset, int length) {
        ByteString.checkArrayBounds(bytes, offset, length);
        if (length != 0) {
            this.ensureAdditionalCapacity(length);
            System.arraycopy(bytes, offset, this.buffer, this.length, length);
            this.length += length;
        }
        return this;
    }

    public ByteStringBuilder append(ByteBuffer buffer, int length) {
        if (length < 0 || length > buffer.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        if (length != 0) {
            this.ensureAdditionalCapacity(length);
            buffer.get(this.buffer, this.length, length);
            this.length += length;
        }
        return this;
    }

    public ByteStringBuilder append(ByteSequence bytes) {
        return bytes.copyTo(this);
    }

    public ByteStringBuilder append(ByteSequenceReader reader, int length) {
        if (length < 0 || length > reader.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        if (length != 0) {
            this.ensureAdditionalCapacity(length);
            reader.get(this.buffer, this.length, length);
            this.length += length;
        }
        return this;
    }

    public ByteStringBuilder append(char[] chars) {
        if (chars == null) {
            return this;
        }
        int len = chars.length;
        this.ensureAdditionalCapacity(len);
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            byte b = (byte)(c & 0x7F);
            if (c != b) {
                Charset utf8 = Charset.forName("UTF-8");
                ByteBuffer byteBuffer = utf8.encode(CharBuffer.wrap(chars));
                int remaining = byteBuffer.remaining();
                this.ensureAdditionalCapacity(remaining - len);
                byteBuffer.get(this.buffer, this.length, remaining);
                this.length += remaining;
                return this;
            }
            this.buffer[this.length + i] = b;
        }
        this.length += len;
        return this;
    }

    public void append(DataInput stream, int length) throws EOFException, IOException {
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureAdditionalCapacity(length);
        stream.readFully(this.buffer, this.length, length);
        this.length += length;
    }

    public int append(InputStream stream, int length) throws IOException {
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureAdditionalCapacity(length);
        int bytesRead = stream.read(this.buffer, this.length, length);
        if (bytesRead > 0) {
            this.length += bytesRead;
        }
        return bytesRead;
    }

    public ByteStringBuilder append(int i) {
        this.ensureAdditionalCapacity(4);
        for (int j = this.length + 3; j >= this.length; --j) {
            this.buffer[j] = (byte)(i & 0xFF);
            i >>>= 8;
        }
        this.length += 4;
        return this;
    }

    public ByteStringBuilder append(long l) {
        this.ensureAdditionalCapacity(8);
        for (int i = this.length + 7; i >= this.length; --i) {
            this.buffer[i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        this.length += 8;
        return this;
    }

    public ByteStringBuilder appendCompactUnsigned(long value) {
        Reject.ifFalse((value >= 0L ? 1 : 0) != 0, (String)"value must be >= 0");
        int size = ByteStringBuilder.getEncodedSize(value);
        this.ensureAdditionalCapacity(size);
        switch (size) {
            case 1: {
                this.buffer[this.length++] = (byte)value;
                break;
            }
            case 2: {
                this.buffer[this.length++] = (byte)(value >>> 8 | 0x80L);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value);
                break;
            }
            case 3: {
                this.buffer[this.length++] = (byte)(value >>> 16 | 0xC0L);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 8);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value);
                break;
            }
            case 4: {
                this.buffer[this.length++] = (byte)(value >>> 24 | 0xE0L);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 16);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 8);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value);
                break;
            }
            case 5: {
                this.buffer[this.length++] = (byte)(value >>> 32 | 0xF0L);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 24);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 16);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 8);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value);
                break;
            }
            case 6: {
                this.buffer[this.length++] = (byte)(value >>> 40 | 0xF8L);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 32);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 24);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 16);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 8);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value);
                break;
            }
            case 7: {
                this.buffer[this.length++] = (byte)(value >>> 48 | 0xFCL);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 40);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 32);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 24);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 16);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 8);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value);
                break;
            }
            default: {
                this.buffer[this.length++] = -2;
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 48);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 40);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 32);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 24);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 16);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value >>> 8);
                this.buffer[this.length++] = ByteStringBuilder.l2b(value);
            }
        }
        return this;
    }

    private static int getEncodedSize(long value) {
        if (value < 128L) {
            return 1;
        }
        if (value < 16384L) {
            return 2;
        }
        if (value < 0x200000L) {
            return 3;
        }
        if (value < 0x10000000L) {
            return 4;
        }
        if (value < 0x800000000L) {
            return 5;
        }
        if (value < 0x40000000000L) {
            return 6;
        }
        if (value < 0x2000000000000L) {
            return 7;
        }
        if (value < 0x100000000000000L) {
            return 8;
        }
        throw new IllegalArgumentException("value out of range: " + value);
    }

    private static byte l2b(long value) {
        return (byte)(value & 0xFFL);
    }

    public ByteStringBuilder append(Object o) {
        if (o == null) {
            return this;
        }
        if (o instanceof ByteSequence) {
            return this.append((ByteSequence)o);
        }
        if (o instanceof byte[]) {
            return this.append((byte[])o);
        }
        if (o instanceof char[]) {
            return this.append((char[])o);
        }
        return this.append(o.toString());
    }

    public ByteStringBuilder append(short i) {
        this.ensureAdditionalCapacity(2);
        for (int j = this.length + 1; j >= this.length; --j) {
            this.buffer[j] = (byte)(i & 0xFF);
            i = (short)(i >>> 8);
        }
        this.length += 2;
        return this;
    }

    public ByteStringBuilder append(String s) {
        if (s == null) {
            return this;
        }
        int len = s.length();
        this.ensureAdditionalCapacity(len);
        for (int i = 0; i < len; ++i) {
            byte b;
            char c = s.charAt(i);
            if (c != (b = (byte)(c & 0x7F))) {
                try {
                    return this.append(s.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Unable to encode String '" + s + "' to UTF-8 bytes", e);
                }
            }
            this.buffer[this.length + i] = b;
        }
        this.length += len;
        return this;
    }

    public ByteStringBuilder appendBERLength(int length) {
        if ((length & 0x7F) == length) {
            this.ensureAdditionalCapacity(1);
            this.buffer[this.length++] = (byte)(length & 0xFF);
        } else if ((length & 0xFF) == length) {
            this.ensureAdditionalCapacity(2);
            this.buffer[this.length++] = -127;
            this.buffer[this.length++] = (byte)(length & 0xFF);
        } else if ((length & 0xFFFF) == length) {
            this.ensureAdditionalCapacity(3);
            this.buffer[this.length++] = -126;
            this.buffer[this.length++] = (byte)(length >> 8 & 0xFF);
            this.buffer[this.length++] = (byte)(length & 0xFF);
        } else if ((length & 0xFFFFFF) == length) {
            this.ensureAdditionalCapacity(4);
            this.buffer[this.length++] = -125;
            this.buffer[this.length++] = (byte)(length >> 16 & 0xFF);
            this.buffer[this.length++] = (byte)(length >> 8 & 0xFF);
            this.buffer[this.length++] = (byte)(length & 0xFF);
        } else {
            this.ensureAdditionalCapacity(5);
            this.buffer[this.length++] = -124;
            this.buffer[this.length++] = (byte)(length >> 24 & 0xFF);
            this.buffer[this.length++] = (byte)(length >> 16 & 0xFF);
            this.buffer[this.length++] = (byte)(length >> 8 & 0xFF);
            this.buffer[this.length++] = (byte)(length & 0xFF);
        }
        return this;
    }

    public OutputStream asOutputStream() {
        if (this.os == null) {
            this.os = new OutputStreamImpl();
        }
        return this.os;
    }

    @Override
    public ByteSequenceReader asReader() {
        return new ByteSequenceReader(this);
    }

    @Override
    public byte byteAt(int index) {
        if (index >= this.length || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[index];
    }

    public int capacity() {
        return this.buffer.length;
    }

    public ByteStringBuilder clear() {
        this.length = 0;
        return this;
    }

    public ByteStringBuilder clearAndTruncate(int thresholdCapacity, int newCapacity) {
        if (newCapacity > thresholdCapacity) {
            throw new IllegalArgumentException("new capacity '" + newCapacity + "' cannot be bigger than threshold capacity '" + thresholdCapacity + "'");
        }
        if (newCapacity < 0) {
            throw new IllegalArgumentException("new capacity '" + newCapacity + "' cannot be negative.");
        }
        if (this.buffer.length > thresholdCapacity) {
            this.buffer = new byte[newCapacity];
        }
        this.length = 0;
        return this;
    }

    @Override
    public int compareTo(byte[] bytes, int offset, int length) {
        ByteString.checkArrayBounds(bytes, offset, length);
        return ByteString.compareTo(this.buffer, 0, this.length, bytes, offset, length);
    }

    @Override
    public int compareTo(ByteSequence o) {
        if (this == o) {
            return 0;
        }
        return -o.compareTo(this.buffer, 0, this.length);
    }

    @Override
    public byte[] copyTo(byte[] bytes) {
        this.copyTo(bytes, 0);
        return bytes;
    }

    @Override
    public byte[] copyTo(byte[] bytes, int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, 0, bytes, offset, Math.min(this.length, bytes.length - offset));
        return bytes;
    }

    @Override
    public ByteBuffer copyTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.buffer, 0, this.length);
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public ByteStringBuilder copyTo(ByteStringBuilder builder) {
        builder.append(this.buffer, 0, this.length);
        return builder;
    }

    @Override
    public boolean copyTo(CharBuffer charBuffer, CharsetDecoder decoder) {
        return ByteString.copyTo(ByteBuffer.wrap(this.buffer, 0, this.length), charBuffer, decoder);
    }

    @Override
    public OutputStream copyTo(OutputStream stream) throws IOException {
        stream.write(this.buffer, 0, this.length);
        return stream;
    }

    public int copyTo(WritableByteChannel channel) throws IOException {
        return channel.write(ByteBuffer.wrap(this.buffer, 0, this.length));
    }

    public ByteStringBuilder ensureAdditionalCapacity(int size) {
        int newCount = this.length + size;
        if (newCount > this.buffer.length) {
            byte[] newbuffer = new byte[Math.max(this.buffer.length << 1, newCount)];
            System.arraycopy(this.buffer, 0, newbuffer, 0, this.buffer.length);
            this.buffer = newbuffer;
        }
        return this;
    }

    @Override
    public boolean equals(byte[] bytes, int offset, int length) {
        ByteString.checkArrayBounds(bytes, offset, length);
        return ByteString.equals(this.buffer, 0, this.length, bytes, offset, length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)o;
            return other.equals(this.buffer, 0, this.length);
        }
        return false;
    }

    public byte[] getBackingArray() {
        return this.buffer;
    }

    @Override
    public int hashCode() {
        return ByteString.hashCode(this.buffer, 0, this.length);
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public void setByte(int index, byte b) {
        if (index >= this.length || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer[index] = b;
    }

    public ByteStringBuilder setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException("Negative newLength: " + newLength);
        }
        if (newLength > this.length) {
            this.ensureAdditionalCapacity(newLength - this.length);
            for (int i = this.length; i < newLength; ++i) {
                this.buffer[i] = 0;
            }
        }
        this.length = newLength;
        return this;
    }

    @Override
    public ByteSequence subSequence(int start, int end) {
        if (start < 0 || start > end || end > this.length) {
            throw new IndexOutOfBoundsException();
        }
        return new SubSequence(start, end - start);
    }

    @Override
    public boolean startsWith(ByteSequence prefix) {
        if (prefix == null || prefix.length() > this.length) {
            return false;
        }
        return prefix.equals(this.buffer, 0, prefix.length());
    }

    @Override
    public String toBase64String() {
        return Base64.encode(this);
    }

    @Override
    public byte[] toByteArray() {
        return this.copyTo(new byte[this.length]);
    }

    @Override
    public ByteString toByteString() {
        byte[] b = new byte[this.length];
        System.arraycopy(this.buffer, 0, b, 0, this.length);
        return ByteString.wrap(b);
    }

    @Override
    public String toString() {
        return ByteString.toString(this.buffer, 0, this.length);
    }

    public ByteStringBuilder trimToSize() {
        if (this.buffer.length > this.length) {
            byte[] newBuffer = new byte[this.length];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.length);
            this.buffer = newBuffer;
        }
        return this;
    }

    private final class SubSequence
    implements ByteSequence {
        private final int subLength;
        private final int subOffset;

        private SubSequence(int offset, int length) {
            this.subOffset = offset;
            this.subLength = length;
        }

        @Override
        public ByteSequenceReader asReader() {
            return new ByteSequenceReader(this);
        }

        @Override
        public byte byteAt(int index) {
            if (index >= this.subLength || index < 0) {
                throw new IndexOutOfBoundsException();
            }
            return ByteStringBuilder.this.buffer[this.subOffset + index];
        }

        @Override
        public int compareTo(byte[] b, int offset, int length) {
            ByteString.checkArrayBounds(b, offset, length);
            return ByteString.compareTo(ByteStringBuilder.this.buffer, this.subOffset, this.subLength, b, offset, length);
        }

        @Override
        public int compareTo(ByteSequence o) {
            if (this == o) {
                return 0;
            }
            return -o.compareTo(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
        }

        @Override
        public byte[] copyTo(byte[] b) {
            this.copyTo(b, 0);
            return b;
        }

        @Override
        public byte[] copyTo(byte[] b, int offset) {
            if (offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(ByteStringBuilder.this.buffer, this.subOffset, b, offset, Math.min(this.subLength, b.length - offset));
            return b;
        }

        @Override
        public ByteBuffer copyTo(ByteBuffer byteBuffer) {
            byteBuffer.put(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
            byteBuffer.flip();
            return byteBuffer;
        }

        @Override
        public ByteStringBuilder copyTo(ByteStringBuilder builder) {
            return builder.append(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
        }

        @Override
        public boolean copyTo(CharBuffer charBuffer, CharsetDecoder decoder) {
            return ByteString.copyTo(ByteBuffer.wrap(ByteStringBuilder.this.buffer, this.subOffset, this.subLength), charBuffer, decoder);
        }

        @Override
        public OutputStream copyTo(OutputStream stream) throws IOException {
            stream.write(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
            return stream;
        }

        @Override
        public boolean equals(byte[] b, int offset, int length) {
            ByteString.checkArrayBounds(b, offset, length);
            return ByteString.equals(ByteStringBuilder.this.buffer, this.subOffset, this.subLength, b, offset, length);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ByteSequence) {
                ByteSequence other = (ByteSequence)o;
                return other.equals(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ByteString.hashCode(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
        }

        @Override
        public boolean isEmpty() {
            return ByteStringBuilder.this.length == 0;
        }

        @Override
        public int length() {
            return this.subLength;
        }

        @Override
        public ByteSequence subSequence(int start, int end) {
            if (start < 0 || start > end || end > this.subLength) {
                throw new IndexOutOfBoundsException();
            }
            return new SubSequence(this.subOffset + start, end - start);
        }

        @Override
        public boolean startsWith(ByteSequence prefix) {
            if (prefix == null || prefix.length() > ByteStringBuilder.this.length) {
                return false;
            }
            return prefix.equals(ByteStringBuilder.this.buffer, 0, prefix.length());
        }

        @Override
        public String toBase64String() {
            return Base64.encode(this);
        }

        @Override
        public byte[] toByteArray() {
            return this.copyTo(new byte[this.subLength]);
        }

        @Override
        public ByteString toByteString() {
            byte[] b = new byte[this.subLength];
            System.arraycopy(ByteStringBuilder.this.buffer, this.subOffset, b, 0, this.subLength);
            return ByteString.wrap(b);
        }

        @Override
        public String toString() {
            return ByteString.toString(ByteStringBuilder.this.buffer, this.subOffset, this.subLength);
        }
    }

    private final class OutputStreamImpl
    extends OutputStream {
        private OutputStreamImpl() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write(byte[] bytes) {
            ByteStringBuilder.this.append(bytes);
        }

        @Override
        public void write(byte[] bytes, int i, int i1) {
            ByteStringBuilder.this.append(bytes, i, i1);
        }

        @Override
        public void write(int i) {
            ByteStringBuilder.this.append((byte)(i & 0xFF));
        }
    }
}

