/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;

public final class ByteSequenceReader {
    private static final int[] DECODE_SIZE = new int[256];
    private int pos;
    private final ByteSequence sequence;

    ByteSequenceReader(ByteSequence sequence) {
        this.sequence = sequence;
    }

    public byte get() {
        byte b = this.sequence.byteAt(this.pos);
        ++this.pos;
        return b;
    }

    public void get(byte[] b) {
        this.get(b, 0, b.length);
    }

    public void get(byte[] b, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > b.length || length > this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        this.sequence.subSequence(this.pos, this.pos + length).copyTo(b, offset);
        this.pos += length;
    }

    public int getBERLength() {
        int newPos = this.pos + 1;
        if (newPos > this.sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int length = this.sequence.byteAt(this.pos) & 0x7F;
        if (length != this.sequence.byteAt(this.pos)) {
            int numLengthBytes = length;
            newPos = this.pos + 1 + numLengthBytes;
            if (numLengthBytes > 4 || newPos > this.sequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            length = 0;
            for (int i = this.pos + 1; i < newPos; ++i) {
                length = length << 8 | this.sequence.byteAt(i) & 0xFF;
            }
        }
        this.pos = newPos;
        return length;
    }

    public ByteSequence getByteSequence(int length) {
        int newPos = this.pos + length;
        ByteSequence subSequence = this.sequence.subSequence(this.pos, newPos);
        this.pos = newPos;
        return subSequence;
    }

    public ByteString getByteString(int length) {
        return this.getByteSequence(length).toByteString();
    }

    public int getInt() {
        if (this.remaining() < 4) {
            throw new IndexOutOfBoundsException();
        }
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            v <<= 8;
            v |= this.sequence.byteAt(this.pos++) & 0xFF;
        }
        return v;
    }

    public long getLong() {
        if (this.remaining() < 8) {
            throw new IndexOutOfBoundsException();
        }
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            v <<= 8;
            v |= (long)(this.sequence.byteAt(this.pos++) & 0xFF);
        }
        return v;
    }

    public long getCompactUnsigned() {
        long value;
        byte b0 = this.get();
        int size = ByteSequenceReader.decodeSize(b0);
        switch (size) {
            case 1: {
                value = ByteSequenceReader.b2l(b0);
                break;
            }
            case 2: {
                value = ((long)b0 & 0x3FL) << 8;
                value |= ByteSequenceReader.b2l(this.get());
                break;
            }
            case 3: {
                value = ((long)b0 & 0x1FL) << 16;
                value |= ByteSequenceReader.b2l(this.get()) << 8;
                value |= ByteSequenceReader.b2l(this.get());
                break;
            }
            case 4: {
                value = ((long)b0 & 0xFL) << 24;
                value |= ByteSequenceReader.b2l(this.get()) << 16;
                value |= ByteSequenceReader.b2l(this.get()) << 8;
                value |= ByteSequenceReader.b2l(this.get());
                break;
            }
            case 5: {
                value = ((long)b0 & 7L) << 32;
                value |= ByteSequenceReader.b2l(this.get()) << 24;
                value |= ByteSequenceReader.b2l(this.get()) << 16;
                value |= ByteSequenceReader.b2l(this.get()) << 8;
                value |= ByteSequenceReader.b2l(this.get());
                break;
            }
            case 6: {
                value = ((long)b0 & 3L) << 40;
                value |= ByteSequenceReader.b2l(this.get()) << 32;
                value |= ByteSequenceReader.b2l(this.get()) << 24;
                value |= ByteSequenceReader.b2l(this.get()) << 16;
                value |= ByteSequenceReader.b2l(this.get()) << 8;
                value |= ByteSequenceReader.b2l(this.get());
                break;
            }
            case 7: {
                value = ((long)b0 & 1L) << 48;
                value |= ByteSequenceReader.b2l(this.get()) << 40;
                value |= ByteSequenceReader.b2l(this.get()) << 32;
                value |= ByteSequenceReader.b2l(this.get()) << 24;
                value |= ByteSequenceReader.b2l(this.get()) << 16;
                value |= ByteSequenceReader.b2l(this.get()) << 8;
                value |= ByteSequenceReader.b2l(this.get());
                break;
            }
            default: {
                value = ByteSequenceReader.b2l(this.get()) << 48;
                value |= ByteSequenceReader.b2l(this.get()) << 40;
                value |= ByteSequenceReader.b2l(this.get()) << 32;
                value |= ByteSequenceReader.b2l(this.get()) << 24;
                value |= ByteSequenceReader.b2l(this.get()) << 16;
                value |= ByteSequenceReader.b2l(this.get()) << 8;
                value |= ByteSequenceReader.b2l(this.get());
            }
        }
        return value;
    }

    private static long b2l(byte b) {
        return (long)b & 0xFFL;
    }

    private static int decodeSize(int b) {
        return DECODE_SIZE[b & 0xFF];
    }

    public short getShort() {
        if (this.remaining() < 2) {
            throw new IndexOutOfBoundsException();
        }
        short v = 0;
        for (int i = 0; i < 2; ++i) {
            v = (short)(v << 8);
            v = (short)(v | this.sequence.byteAt(this.pos++) & 0xFF);
        }
        return v;
    }

    public String getString(int length) {
        if (this.remaining() < length) {
            throw new IndexOutOfBoundsException();
        }
        int newPos = this.pos + length;
        String str = this.sequence.subSequence(this.pos, this.pos + length).toString();
        this.pos = newPos;
        return str;
    }

    public int position() {
        return this.pos;
    }

    public void position(int pos) {
        if (pos > this.sequence.length() || pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.pos = pos;
    }

    public int remaining() {
        return this.sequence.length() - this.pos;
    }

    public void rewind() {
        this.position(0);
    }

    public byte peek() {
        return this.sequence.byteAt(this.pos);
    }

    public byte peek(int offset) {
        return this.sequence.byteAt(this.pos + offset);
    }

    public void skip(int length) {
        this.position(this.pos + length);
    }

    public String toString() {
        return this.sequence.toString();
    }

    static {
        Arrays.fill(DECODE_SIZE, 0, 128, 1);
        Arrays.fill(DECODE_SIZE, 128, 192, 2);
        Arrays.fill(DECODE_SIZE, 192, 224, 3);
        Arrays.fill(DECODE_SIZE, 224, 240, 4);
        Arrays.fill(DECODE_SIZE, 240, 248, 5);
        Arrays.fill(DECODE_SIZE, 248, 252, 6);
        Arrays.fill(DECODE_SIZE, 252, 254, 7);
        Arrays.fill(DECODE_SIZE, 254, 256, 8);
    }
}

