/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.opendj.ldap.AbstractConnectionWrapper;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.Promise;

final class AuthenticatedConnectionFactory
implements ConnectionFactory {
    private final BindRequest request;
    private final ConnectionFactory parentFactory;

    AuthenticatedConnectionFactory(ConnectionFactory factory, BindRequest request) {
        this.parentFactory = factory;
        this.request = request;
    }

    @Override
    public void close() {
        this.parentFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws LdapException {
        Connection connection = this.parentFactory.getConnection();
        boolean bindSucceeded = false;
        try {
            connection.bind(this.request);
            bindSucceeded = true;
        }
        finally {
            if (!bindSucceeded) {
                connection.close();
            }
        }
        return new AuthenticatedConnection(connection);
    }

    @Override
    public Promise<Connection, LdapException> getConnectionAsync() {
        final AtomicReference connectionHolder = new AtomicReference();
        return this.parentFactory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, BindResult, LdapException>(){

            public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                connectionHolder.set(connection);
                return connection.bindAsync(AuthenticatedConnectionFactory.this.request);
            }
        }).then((Function)new Function<BindResult, Connection, LdapException>(){

            public Connection apply(BindResult result) throws LdapException {
                return new AuthenticatedConnection((Connection)connectionHolder.get());
            }
        }, (Function)new Function<LdapException, Connection, LdapException>(){

            public Connection apply(LdapException error) throws LdapException {
                Utils.closeSilently((Closeable[])new Closeable[]{(Closeable)connectionHolder.get()});
                throw error;
            }
        });
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticatedConnectionFactory(");
        builder.append(this.parentFactory);
        builder.append(", ");
        builder.append(this.request);
        builder.append(')');
        return builder.toString();
    }

    public static final class AuthenticatedConnection
    extends AbstractConnectionWrapper<Connection> {
        private AuthenticatedConnection(Connection connection) {
            super(connection);
        }

        public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<? super BindResult> resultHandler) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BindResult bind(BindRequest request) throws LdapException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BindResult bind(String name, char[] password) throws LdapException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AuthenticatedConnection(");
            builder.append(this.connection);
            builder.append(')');
            return builder.toString();
        }
    }
}

