/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Iterators;
import java.util.Collection;
import java.util.Iterator;
import org.forgerock.opendj.ldap.AbstractAttribute;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AttributeParser;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.util.Reject;

public final class Attributes {
    public static Attribute emptyAttribute(AttributeDescription attributeDescription) {
        return new EmptyAttribute(attributeDescription);
    }

    public static Attribute emptyAttribute(String attributeDescription) {
        return Attributes.emptyAttribute(AttributeDescription.valueOf(attributeDescription));
    }

    public static Attribute renameAttribute(Attribute attribute, AttributeDescription attributeDescription) {
        Reject.ifNull((Object[])new Object[]{attribute, attributeDescription});
        if (attribute.getAttributeDescription() == attributeDescription) {
            return attribute;
        }
        return new RenamedAttribute(attribute, attributeDescription);
    }

    public static Attribute renameAttribute(Attribute attribute, String attributeDescription) {
        Reject.ifNull((Object)attribute, (String)attributeDescription);
        return Attributes.renameAttribute(attribute, AttributeDescription.valueOf(attributeDescription));
    }

    public static Attribute singletonAttribute(AttributeDescription attributeDescription, Object value) {
        return new SingletonAttribute(attributeDescription, value);
    }

    public static Attribute singletonAttribute(String attributeDescription, Object value) {
        return Attributes.singletonAttribute(AttributeDescription.valueOf(attributeDescription), value);
    }

    public static Attribute unmodifiableAttribute(Attribute attribute) {
        if (attribute instanceof UnmodifiableAttribute) {
            return attribute;
        }
        return new UnmodifiableAttribute(attribute);
    }

    private Attributes() {
    }

    private static final class UnmodifiableAttribute
    implements Attribute {
        private final Attribute attribute;

        private UnmodifiableAttribute(Attribute attribute) {
            this.attribute = attribute;
        }

        @Override
        public boolean add(ByteString value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends ByteString> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> boolean addAll(Collection<T> values, Collection<? super T> duplicateValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object value) {
            return this.attribute.contains(value);
        }

        @Override
        public boolean containsAll(Collection<?> values) {
            return this.attribute.containsAll(values);
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.attribute.equals(object);
        }

        @Override
        public ByteString firstValue() {
            return this.attribute.firstValue();
        }

        @Override
        public String firstValueAsString() {
            return this.attribute.firstValueAsString();
        }

        @Override
        public AttributeDescription getAttributeDescription() {
            return this.attribute.getAttributeDescription();
        }

        @Override
        public String getAttributeDescriptionAsString() {
            return this.attribute.getAttributeDescriptionAsString();
        }

        @Override
        public int hashCode() {
            return this.attribute.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.attribute.isEmpty();
        }

        @Override
        public Iterator<ByteString> iterator() {
            return Iterators.unmodifiableIterator(this.attribute.iterator());
        }

        @Override
        public AttributeParser parse() {
            return this.attribute.parse();
        }

        @Override
        public boolean remove(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> boolean removeAll(Collection<T> values, Collection<? super T> missingValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> boolean retainAll(Collection<T> values, Collection<? super T> missingValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.attribute.size();
        }

        @Override
        public ByteString[] toArray() {
            return this.attribute.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.attribute.toArray(array);
        }

        @Override
        public String toString() {
            return this.attribute.toString();
        }
    }

    private static final class SingletonAttribute
    extends AbstractAttribute {
        private final AttributeDescription attributeDescription;
        private ByteString normalizedValue;
        private final ByteString value;

        private SingletonAttribute(AttributeDescription attributeDescription, Object value) {
            this.attributeDescription = attributeDescription;
            this.value = ByteString.valueOf(value);
        }

        @Override
        public boolean add(ByteString value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object value) {
            ByteString normalizedValue = SingletonAttribute.normalizeValue(this, ByteString.valueOf(value));
            return this.normalizedSingleValue().equals(normalizedValue);
        }

        @Override
        public AttributeDescription getAttributeDescription() {
            return this.attributeDescription;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<ByteString> iterator() {
            return Iterators.singletonIterator(this.value);
        }

        @Override
        public boolean remove(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 1;
        }

        private ByteString normalizedSingleValue() {
            if (this.normalizedValue == null) {
                this.normalizedValue = SingletonAttribute.normalizeValue(this, this.value);
            }
            return this.normalizedValue;
        }
    }

    private static final class RenamedAttribute
    implements Attribute {
        private final Attribute attribute;
        private final AttributeDescription attributeDescription;

        private RenamedAttribute(Attribute attribute, AttributeDescription attributeDescription) {
            this.attribute = attribute;
            this.attributeDescription = attributeDescription;
        }

        @Override
        public boolean add(ByteString value) {
            return this.attribute.add(value);
        }

        @Override
        public boolean add(Object ... values) {
            return this.attribute.add(values);
        }

        @Override
        public boolean addAll(Collection<? extends ByteString> values) {
            return this.attribute.addAll(values);
        }

        @Override
        public <T> boolean addAll(Collection<T> values, Collection<? super T> duplicateValues) {
            return this.attribute.addAll(values, duplicateValues);
        }

        @Override
        public void clear() {
            this.attribute.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.attribute.contains(value);
        }

        @Override
        public boolean containsAll(Collection<?> values) {
            return this.attribute.containsAll(values);
        }

        @Override
        public boolean equals(Object object) {
            return AbstractAttribute.equals(this, object);
        }

        @Override
        public ByteString firstValue() {
            return this.attribute.firstValue();
        }

        @Override
        public String firstValueAsString() {
            return this.attribute.firstValueAsString();
        }

        @Override
        public AttributeDescription getAttributeDescription() {
            return this.attributeDescription;
        }

        @Override
        public String getAttributeDescriptionAsString() {
            return this.attributeDescription.toString();
        }

        @Override
        public int hashCode() {
            return AbstractAttribute.hashCode(this);
        }

        @Override
        public boolean isEmpty() {
            return this.attribute.isEmpty();
        }

        @Override
        public Iterator<ByteString> iterator() {
            return this.attribute.iterator();
        }

        @Override
        public AttributeParser parse() {
            return this.attribute.parse();
        }

        @Override
        public boolean remove(Object value) {
            return this.attribute.remove(value);
        }

        @Override
        public boolean removeAll(Collection<?> values) {
            return this.attribute.removeAll(values);
        }

        @Override
        public <T> boolean removeAll(Collection<T> values, Collection<? super T> missingValues) {
            return this.attribute.removeAll(values, missingValues);
        }

        @Override
        public boolean retainAll(Collection<?> values) {
            return this.attribute.retainAll(values);
        }

        @Override
        public <T> boolean retainAll(Collection<T> values, Collection<? super T> missingValues) {
            return this.attribute.retainAll(values, missingValues);
        }

        @Override
        public int size() {
            return this.attribute.size();
        }

        @Override
        public ByteString[] toArray() {
            return this.attribute.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.attribute.toArray(array);
        }

        @Override
        public String toString() {
            return AbstractAttribute.toString(this);
        }
    }

    private static final class EmptyAttribute
    extends AbstractAttribute {
        private final AttributeDescription attributeDescription;

        private EmptyAttribute(AttributeDescription attributeDescription) {
            this.attributeDescription = attributeDescription;
        }

        @Override
        public boolean add(ByteString value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object value) {
            return false;
        }

        @Override
        public AttributeDescription getAttributeDescription() {
            return this.attributeDescription;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<ByteString> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public boolean remove(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

