/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.extensions;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.ldap.extensions.PasswordPolicyStateExtendedResult;
import com.forgerock.opendj.ldap.extensions.PasswordPolicyStateOperation;
import com.forgerock.opendj.ldap.extensions.PasswordPolicyStateOperationContainer;
import com.forgerock.opendj.ldap.extensions.PasswordPolicyStateOperationType;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.ExtendedResultDecoder;

public final class PasswordPolicyStateExtendedRequest
extends AbstractExtendedRequest<PasswordPolicyStateExtendedRequest, PasswordPolicyStateExtendedResult>
implements PasswordPolicyStateOperationContainer {
    public static final String OID = "1.3.6.1.4.1.26027.1.6.1";
    private String targetUser = "";
    private final List<PasswordPolicyStateOperation> operations = new ArrayList<PasswordPolicyStateOperation>();
    static final String PASSWORD_POLICY_DN_NAME = "Password Policy DN";
    static final String ACCOUNT_DISABLED_STATE_NAME = "Account Disabled State";
    static final String ACCOUNT_EXPIRATION_TIME_NAME = "Account Expiration Time";
    static final String SECONDS_UNTIL_ACCOUNT_EXPIRATION_NAME = "Seconds Until Account Expiration";
    static final String PASSWORD_CHANGED_TIME_NAME = "Password Changed Time";
    static final String PASSWORD_EXPIRATION_WARNED_TIME_NAME = "Password Expiration Warned Time";
    static final String SECONDS_UNTIL_PASSWORD_EXPIRATION_NAME = "Seconds Until Password Expiration";
    static final String SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING_NAME = "Seconds Until Password Expiration Warning";
    static final String AUTHENTICATION_FAILURE_TIMES_NAME = "Authentication Failure Times";
    static final String SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK_NAME = "Seconds Until Authentication Failure Unlock";
    static final String REMAINING_AUTHENTICATION_FAILURE_COUNT_NAME = "Remaining Authentication Failure Count";
    static final String LAST_LOGIN_TIME_NAME = "Last Login Time";
    static final String SECONDS_UNTIL_IDLE_LOCKOUT_NAME = "Seconds Until Idle Lockout";
    static final String PASSWORD_RESET_STATE_NAME = "Password Reset State";
    static final String SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT_NAME = "Seconds Until Password Reset Lockout";
    static final String GRACE_LOGIN_USE_TIMES_NAME = "Grace Login Use Times";
    static final String REMAINING_GRACE_LOGIN_COUNT_NAME = "Remaining Grace Login Count";
    static final String PASSWORD_CHANGED_BY_REQUIRED_TIME_NAME = "Password Changed By Required Time";
    static final String SECONDS_UNTIL_REQUIRED_CHANGE_TIME_NAME = "Seconds Until Required Change Time";
    static final String PASSWORD_HISTORY_NAME = "Password History";
    public static final RequestDecoder REQUEST_DECODER = new RequestDecoder();
    private static final ResultDecoder RESULT_DECODER = new ResultDecoder();

    static ByteString encode(String targetUser, List<PasswordPolicyStateOperation> operations) {
        ByteStringBuilder buffer = new ByteStringBuilder(6);
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeOctetString(targetUser);
            if (!operations.isEmpty()) {
                writer.writeStartSequence();
                for (PasswordPolicyStateOperation operation : operations) {
                    writer.writeStartSequence();
                    writer.writeEnumerated(operation.getOperationType().ordinal());
                    if (operation.getValues() != null) {
                        writer.writeStartSequence();
                        for (ByteString value : operation.getValues()) {
                            writer.writeOctetString(value);
                        }
                        writer.writeEndSequence();
                    }
                    writer.writeEndSequence();
                }
                writer.writeEndSequence();
            }
            writer.writeEndSequence();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buffer.toByteString();
    }

    private static void decodeOperations(ASN1Reader reader, PasswordPolicyStateOperationContainer container) throws IOException, DecodeException {
        if (reader.hasNextElement()) {
            reader.readStartSequence();
            while (reader.hasNextElement()) {
                PasswordPolicyStateOperationType type;
                reader.readStartSequence();
                int opType = reader.readEnumerated();
                try {
                    type = PasswordPolicyStateOperationType.values()[opType];
                }
                catch (IndexOutOfBoundsException iobe) {
                    throw DecodeException.error(CoreMessages.ERR_PWPSTATE_EXTOP_UNKNOWN_OP_TYPE.get((Object)String.valueOf(opType)), iobe);
                }
                if (reader.hasNextElement()) {
                    reader.readStartSequence();
                    ArrayList<ByteString> values = new ArrayList<ByteString>();
                    while (reader.hasNextElement()) {
                        values.add(reader.readOctetString());
                    }
                    reader.readEndSequence();
                    container.addOperation(new MultiValueOperation(type, values));
                } else {
                    container.addOperation(type);
                }
                reader.readEndSequence();
            }
            reader.readEndSequence();
        }
    }

    public void addAuthenticationFailureTime(Date date) {
        this.setDateProperty(PasswordPolicyStateOperationType.ADD_AUTHENTICATION_FAILURE_TIMES, date);
    }

    public void addGraceLoginUseTime(Date date) {
        this.setDateProperty(PasswordPolicyStateOperationType.ADD_GRACE_LOGIN_USE_TIME, date);
    }

    @Override
    public void addOperation(PasswordPolicyStateOperation operation) {
        this.operations.add(operation);
    }

    public void clearAccountDisabledState() {
        this.operations.add(PasswordPolicyStateOperationType.CLEAR_ACCOUNT_DISABLED_STATE);
    }

    public void clearAccountExpirationTime() {
        this.operations.add(PasswordPolicyStateOperationType.CLEAR_ACCOUNT_EXPIRATION_TIME);
    }

    public void clearAuthenticationFailureTimes() {
        this.operations.add(PasswordPolicyStateOperationType.CLEAR_AUTHENTICATION_FAILURE_TIMES);
    }

    public void clearGraceLoginUseTimes() {
        this.operations.add(PasswordPolicyStateOperationType.CLEAR_GRACE_LOGIN_USE_TIMES);
    }

    public void clearLastLoginTime() {
        this.operations.add(PasswordPolicyStateOperationType.CLEAR_LAST_LOGIN_TIME);
    }

    public void clearPasswordChangedByRequiredTime() {
        this.operations.add(PasswordPolicyStateOperationType.CLEAR_PASSWORD_CHANGED_BY_REQUIRED_TIME);
    }

    public void clearPasswordChangedTime() {
        this.operations.add(PasswordPolicyStateOperationType.CLEAR_PASSWORD_CHANGED_TIME);
    }

    public void clearPasswordExpirationWarnedTime() {
        this.operations.add(PasswordPolicyStateOperationType.CLEAR_PASSWORD_EXPIRATION_WARNED_TIME);
    }

    public void clearPasswordHistory() {
        this.operations.add(PasswordPolicyStateOperationType.CLEAR_PASSWORD_HISTORY);
    }

    public void clearPasswordResetState() {
        this.operations.add(PasswordPolicyStateOperationType.CLEAR_PASSWORD_RESET_STATE);
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public Iterable<PasswordPolicyStateOperation> getOperations() {
        return this.operations;
    }

    @Override
    public ExtendedResultDecoder<PasswordPolicyStateExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public String getTargetUser() {
        return this.targetUser;
    }

    @Override
    public ByteString getValue() {
        return PasswordPolicyStateExtendedRequest.encode(this.targetUser, this.operations);
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    public void requestAccountDisabledState() {
        this.operations.add(PasswordPolicyStateOperationType.GET_ACCOUNT_DISABLED_STATE);
    }

    public void requestAccountExpirationTime() {
        this.operations.add(PasswordPolicyStateOperationType.GET_ACCOUNT_EXPIRATION_TIME);
    }

    public void requestAuthenticationFailureTimes() {
        this.operations.add(PasswordPolicyStateOperationType.GET_AUTHENTICATION_FAILURE_TIMES);
    }

    public void requestGraceLoginUseTimes() {
        this.operations.add(PasswordPolicyStateOperationType.GET_GRACE_LOGIN_USE_TIMES);
    }

    public void requestLastLoginTime() {
        this.operations.add(PasswordPolicyStateOperationType.GET_LAST_LOGIN_TIME);
    }

    public void requestPasswordChangedByRequiredTime() {
        this.operations.add(PasswordPolicyStateOperationType.GET_PASSWORD_CHANGED_BY_REQUIRED_TIME);
    }

    public void requestPasswordChangedTime() {
        this.operations.add(PasswordPolicyStateOperationType.GET_PASSWORD_CHANGED_TIME);
    }

    public void requestPasswordExpirationWarnedTime() {
        this.operations.add(PasswordPolicyStateOperationType.GET_PASSWORD_EXPIRATION_WARNED_TIME);
    }

    public void requestPasswordHistory() {
        this.operations.add(PasswordPolicyStateOperationType.GET_PASSWORD_HISTORY);
    }

    public void requestPasswordPolicyDN() {
        this.operations.add(PasswordPolicyStateOperationType.GET_PASSWORD_POLICY_DN);
    }

    public void requestPasswordResetState() {
        this.operations.add(PasswordPolicyStateOperationType.GET_PASSWORD_RESET_STATE);
    }

    public void requestRemainingAuthenticationFailureCount() {
        this.operations.add(PasswordPolicyStateOperationType.GET_REMAINING_AUTHENTICATION_FAILURE_COUNT);
    }

    public void requestRemainingGraceLoginCount() {
        this.operations.add(PasswordPolicyStateOperationType.GET_REMAINING_GRACE_LOGIN_COUNT);
    }

    public void requestSecondsUntilAccountExpiration() {
        this.operations.add(PasswordPolicyStateOperationType.GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION);
    }

    public void requestSecondsUntilAuthenticationFailureUnlock() {
        this.operations.add(PasswordPolicyStateOperationType.GET_SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK);
    }

    public void requestSecondsUntilIdleLockout() {
        this.operations.add(PasswordPolicyStateOperationType.GET_SECONDS_UNTIL_IDLE_LOCKOUT);
    }

    public void requestSecondsUntilPasswordExpiration() {
        this.operations.add(PasswordPolicyStateOperationType.GET_SECONDS_UNTIL_PASSWORD_EXPIRATION);
    }

    public void requestSecondsUntilPasswordExpirationWarning() {
        this.operations.add(PasswordPolicyStateOperationType.GET_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING);
    }

    public void requestSecondsUntilPasswordResetLockout() {
        this.operations.add(PasswordPolicyStateOperationType.GET_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT);
    }

    public void requestSecondsUntilRequiredChangeTime() {
        this.operations.add(PasswordPolicyStateOperationType.GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME);
    }

    public void setAccountDisabledState(boolean state) {
        this.setBooleanProperty(PasswordPolicyStateOperationType.SET_ACCOUNT_DISABLED_STATE, state);
    }

    public void setAccountExpirationTime(Date date) {
        this.setDateProperty(PasswordPolicyStateOperationType.SET_ACCOUNT_EXPIRATION_TIME, date);
    }

    public void setAuthenticationFailureTimes(Date ... dates) {
        this.setDateProperties(PasswordPolicyStateOperationType.SET_AUTHENTICATION_FAILURE_TIMES, dates);
    }

    public void setGraceLoginUseTimes(Date ... dates) {
        this.setDateProperties(PasswordPolicyStateOperationType.SET_GRACE_LOGIN_USE_TIMES, dates);
    }

    public void setLastLoginTime(Date date) {
        this.setDateProperty(PasswordPolicyStateOperationType.SET_LAST_LOGIN_TIME, date);
    }

    public void setPasswordChangedByRequiredTime(boolean state) {
        this.setBooleanProperty(PasswordPolicyStateOperationType.SET_PASSWORD_CHANGED_BY_REQUIRED_TIME, state);
    }

    public void setPasswordChangedTime(Date date) {
        this.setDateProperty(PasswordPolicyStateOperationType.SET_PASSWORD_CHANGED_TIME, date);
    }

    public void setPasswordExpirationWarnedTime(Date date) {
        this.setDateProperty(PasswordPolicyStateOperationType.SET_PASSWORD_EXPIRATION_WARNED_TIME, date);
    }

    public void setPasswordResetState(boolean state) {
        this.setBooleanProperty(PasswordPolicyStateOperationType.SET_PASSWORD_RESET_STATE, state);
    }

    private void setBooleanProperty(PasswordPolicyStateOperationType property, boolean state) {
        this.operations.add(new MultiValueOperation(property, ByteString.valueOf(String.valueOf(state))));
    }

    private void setDateProperty(PasswordPolicyStateOperationType property, Date date) {
        if (date != null) {
            this.operations.add(new MultiValueOperation(property, this.toByteString(date)));
        } else {
            this.operations.add(property);
        }
    }

    private void setDateProperties(PasswordPolicyStateOperationType property, Date ... dates) {
        if (dates == null) {
            this.operations.add(property);
        } else {
            ArrayList<ByteString> times = new ArrayList<ByteString>(dates.length);
            for (Date date : dates) {
                times.add(this.toByteString(date));
            }
            this.operations.add(new MultiValueOperation(property, times));
        }
    }

    private ByteString toByteString(Date date) {
        return ByteString.valueOf(StaticUtils.formatAsGeneralizedTime(date));
    }

    @Override
    public void setTargetUser(String targetUser) {
        this.targetUser = targetUser != null ? targetUser : "";
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PasswordPolicyStateExtendedRequest(requestName=");
        builder.append(this.getOID());
        builder.append(", targetUser=");
        builder.append(this.targetUser);
        builder.append(", operations=");
        builder.append(this.operations);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<PasswordPolicyStateExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public PasswordPolicyStateExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, String diagnosticMessage) {
            if (!resultCode.isExceptional()) {
                throw new IllegalArgumentException("No response name and value for result code " + resultCode.intValue());
            }
            return (PasswordPolicyStateExtendedResult)((PasswordPolicyStateExtendedResult)new PasswordPolicyStateExtendedResult(resultCode).setMatchedDN(matchedDN)).setDiagnosticMessage(diagnosticMessage);
        }

        @Override
        public PasswordPolicyStateExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            ResultCode resultCode = result.getResultCode();
            PasswordPolicyStateExtendedResult newResult = (PasswordPolicyStateExtendedResult)((PasswordPolicyStateExtendedResult)new PasswordPolicyStateExtendedResult(resultCode).setMatchedDN(result.getMatchedDN())).setDiagnosticMessage(result.getDiagnosticMessage());
            ByteString responseValue = result.getValue();
            if (!resultCode.isExceptional() && responseValue == null) {
                throw DecodeException.error(CoreMessages.ERR_PWPSTATE_EXTOP_NO_REQUEST_VALUE.get());
            }
            if (responseValue != null) {
                try {
                    ASN1Reader reader = ASN1.getReader(responseValue);
                    reader.readStartSequence();
                    newResult.setTargetUser(reader.readOctetStringAsString());
                    PasswordPolicyStateExtendedRequest.decodeOperations(reader, newResult);
                    reader.readEndSequence();
                }
                catch (IOException ioe) {
                    LocalizableMessage message = CoreMessages.ERR_PWPSTATE_EXTOP_DECODE_FAILURE.get((Object)StaticUtils.getExceptionMessage(ioe));
                    throw DecodeException.error(message, ioe);
                }
            }
            for (Control control : result.getControls()) {
                newResult.addControl(control);
            }
            return newResult;
        }
    }

    private static final class RequestDecoder
    implements ExtendedRequestDecoder<PasswordPolicyStateExtendedRequest, PasswordPolicyStateExtendedResult> {
        private RequestDecoder() {
        }

        @Override
        public PasswordPolicyStateExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            ByteString requestValue = request.getValue();
            if (requestValue == null || requestValue.length() <= 0) {
                throw DecodeException.error(CoreMessages.ERR_PWPSTATE_EXTOP_NO_REQUEST_VALUE.get());
            }
            try {
                ASN1Reader reader = ASN1.getReader(requestValue);
                reader.readStartSequence();
                PasswordPolicyStateExtendedRequest newRequest = new PasswordPolicyStateExtendedRequest();
                newRequest.setTargetUser(reader.readOctetStringAsString());
                PasswordPolicyStateExtendedRequest.decodeOperations(reader, newRequest);
                reader.readEndSequence();
                for (Control control : request.getControls()) {
                    newRequest.addControl(control);
                }
                return newRequest;
            }
            catch (IOException ioe) {
                LocalizableMessage message = CoreMessages.ERR_PWPSTATE_EXTOP_DECODE_FAILURE.get((Object)StaticUtils.getExceptionMessage(ioe));
                throw DecodeException.error(message, ioe);
            }
        }
    }

    private static final class MultiValueOperation
    implements PasswordPolicyStateOperation {
        private final PasswordPolicyStateOperationType property;
        private final List<ByteString> values;

        private MultiValueOperation(PasswordPolicyStateOperationType property, ByteString value) {
            this.property = property;
            this.values = Collections.singletonList(value);
        }

        private MultiValueOperation(PasswordPolicyStateOperationType property, List<ByteString> values) {
            this.property = property;
            this.values = values;
        }

        @Override
        public PasswordPolicyStateOperationType getOperationType() {
            return this.property;
        }

        @Override
        public Iterable<ByteString> getValues() {
            return this.values;
        }

        public String toString() {
            return this.property + ": " + this.values;
        }
    }
}

