/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.DatatypeConverter;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Functions;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.rest2ldap.Context;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;

final class Utils {
    private static final Function<Object, ByteString, NeverThrowsException> BASE64_TO_BYTESTRING = new Function<Object, ByteString, NeverThrowsException>(){

        public ByteString apply(Object value) {
            return ByteString.valueOfBase64((String)String.valueOf(value));
        }
    };
    private static final Function<ByteString, String, NeverThrowsException> BYTESTRING_TO_BASE64 = new Function<ByteString, String, NeverThrowsException>(){

        public String apply(ByteString value) {
            return value.toBase64String();
        }
    };

    static <V> ResultHandler<V> accumulate(int size, ResultHandler<List<V>> handler) {
        return new AccumulatingResultHandler(size, handler);
    }

    static Object attributeToJson(Attribute a) {
        Function<ByteString, Object, NeverThrowsException> f = Utils.byteStringToJson(a.getAttributeDescription());
        boolean isSingleValued = a.getAttributeDescription().getAttributeType().isSingleValue();
        return isSingleValued ? a.parse().as(f) : Utils.asList(a.parse().asSetOf(f, new Object[0]));
    }

    static Function<Object, ByteString, NeverThrowsException> base64ToByteString() {
        return BASE64_TO_BYTESTRING;
    }

    static Function<ByteString, String, NeverThrowsException> byteStringToBase64() {
        return BYTESTRING_TO_BASE64;
    }

    static Function<ByteString, Object, NeverThrowsException> byteStringToJson(final AttributeDescription ad) {
        return new Function<ByteString, Object, NeverThrowsException>(){

            public Object apply(ByteString value) {
                Syntax syntax = ad.getAttributeType().getSyntax();
                if (syntax.equals((Object)CoreSchema.getBooleanSyntax())) {
                    return Functions.byteStringToBoolean().apply((Object)value);
                }
                if (syntax.equals((Object)CoreSchema.getIntegerSyntax())) {
                    return Functions.byteStringToLong().apply((Object)value);
                }
                if (syntax.equals((Object)CoreSchema.getGeneralizedTimeSyntax())) {
                    return DatatypeConverter.printDateTime((Calendar)((GeneralizedTime)Functions.byteStringToGeneralizedTime().apply((Object)value)).toCalendar());
                }
                return Functions.byteStringToString().apply((Object)value);
            }
        };
    }

    static <T> T ensureNotNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    static <T> T ensureNotNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    static String getAttributeName(Attribute a) {
        return a.getAttributeDescription().withoutOption("binary").toString();
    }

    static String i18n(String format, Object ... args) {
        return String.format(format, args);
    }

    static boolean isJSONPrimitive(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number;
    }

    static boolean isNullOrEmpty(JsonValue v) {
        return v == null || v.isNull() || v.isList() && v.size() == 0;
    }

    static Attribute jsonToAttribute(Object value, AttributeDescription ad) {
        return Utils.jsonToAttribute(value, ad, Utils.jsonToByteString(ad));
    }

    static Attribute jsonToAttribute(Object value, AttributeDescription ad, Function<Object, ByteString, NeverThrowsException> f) {
        if (Utils.isJSONPrimitive(value)) {
            return new LinkedAttribute(ad, f.apply(value));
        }
        if (value instanceof Collection) {
            LinkedAttribute a = new LinkedAttribute(ad);
            for (Object o : (Collection)value) {
                a.add((ByteString)f.apply(o));
            }
            return a;
        }
        throw new IllegalArgumentException("Unrecognized type of JSON value: " + value.getClass().getName());
    }

    static Function<Object, ByteString, NeverThrowsException> jsonToByteString(final AttributeDescription ad) {
        return new Function<Object, ByteString, NeverThrowsException>(){

            public ByteString apply(Object value) {
                if (Utils.isJSONPrimitive(value)) {
                    Syntax syntax = ad.getAttributeType().getSyntax();
                    if (syntax.equals((Object)CoreSchema.getGeneralizedTimeSyntax())) {
                        return ByteString.valueOf((Object)GeneralizedTime.valueOf((Calendar)DatatypeConverter.parseDateTime((String)value.toString())));
                    }
                    return ByteString.valueOf((Object)value);
                }
                throw new IllegalArgumentException("Unrecognized type of JSON value: " + value.getClass().getName());
            }
        };
    }

    static Filter toFilter(boolean value) {
        return value ? Filter.alwaysTrue() : Filter.alwaysFalse();
    }

    static Filter toFilter(Context c, FilterType type, String ldapAttribute, ByteString valueAssertion) {
        Filter filter;
        switch (type) {
            case CONTAINS: {
                filter = Filter.substrings((String)ldapAttribute, null, Collections.singleton(valueAssertion), null);
                break;
            }
            case STARTS_WITH: {
                filter = Filter.substrings((String)ldapAttribute, (Object)valueAssertion, null, null);
                break;
            }
            case EQUAL_TO: {
                filter = Filter.equality((String)ldapAttribute, (Object)valueAssertion);
                break;
            }
            case GREATER_THAN: {
                filter = Filter.greaterThan((String)ldapAttribute, (Object)valueAssertion);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                filter = Filter.greaterOrEqual((String)ldapAttribute, (Object)valueAssertion);
                break;
            }
            case LESS_THAN: {
                filter = Filter.lessThan((String)ldapAttribute, (Object)valueAssertion);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                filter = Filter.lessOrEqual((String)ldapAttribute, (Object)valueAssertion);
                break;
            }
            case PRESENT: {
                filter = Filter.present((String)ldapAttribute);
                break;
            }
            default: {
                filter = Filter.alwaysFalse();
            }
        }
        return filter;
    }

    static String toLowerCase(String s) {
        return s != null ? s.toLowerCase(Locale.ENGLISH) : null;
    }

    static <M, N> ResultHandler<M> transform(final Function<M, N, NeverThrowsException> f, final ResultHandler<N> handler) {
        return new ResultHandler<M>(){

            public void handleError(ResourceException error) {
                handler.handleError(error);
            }

            public void handleResult(M result) {
                try {
                    handler.handleResult(f.apply(result));
                }
                catch (Throwable t) {
                    handler.handleError(Rest2LDAP.asResourceException(t));
                }
            }
        };
    }

    private static <T> List<T> asList(Collection<T> c) {
        if (c instanceof List) {
            return (List)c;
        }
        return new ArrayList<T>(c);
    }

    private Utils() {
    }

    private static final class AccumulatingResultHandler<V>
    implements ResultHandler<V> {
        private ResourceException exception;
        private final ResultHandler<List<V>> handler;
        private final AtomicInteger latch;
        private final List<V> results;

        private AccumulatingResultHandler(int size, ResultHandler<List<V>> handler) {
            if (size < 0) {
                throw new IllegalStateException();
            }
            this.latch = new AtomicInteger(size);
            this.results = new ArrayList<V>(size);
            this.handler = handler;
            if (size == 0) {
                handler.handleResult(this.results);
            }
        }

        public void handleError(ResourceException e) {
            this.exception = e;
            this.latch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResult(V result) {
            if (result != null) {
                List<V> list = this.results;
                synchronized (list) {
                    this.results.add(result);
                }
            }
            this.latch();
        }

        private void latch() {
            if (this.latch.decrementAndGet() == 0) {
                if (this.exception != null) {
                    this.handler.handleError(this.exception);
                } else {
                    this.handler.handleResult(this.results);
                }
            }
        }
    }
}

