/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.TrustManager;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.fluent.JsonValueException;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.AssertionFailureException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AuthenticationException;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.ConstraintViolationException;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.FailoverLoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.LoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.RoundRobinLoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TimeoutResultException;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.AuthorizationPolicy;
import org.forgerock.opendj.rest2ldap.AuthzIdTemplate;
import org.forgerock.opendj.rest2ldap.Config;
import org.forgerock.opendj.rest2ldap.Context;
import org.forgerock.opendj.rest2ldap.JSONConstantAttributeMapper;
import org.forgerock.opendj.rest2ldap.LDAPCollectionResourceProvider;
import org.forgerock.opendj.rest2ldap.NameStrategy;
import org.forgerock.opendj.rest2ldap.ObjectAttributeMapper;
import org.forgerock.opendj.rest2ldap.ReadOnUpdatePolicy;
import org.forgerock.opendj.rest2ldap.ReferenceAttributeMapper;
import org.forgerock.opendj.rest2ldap.SimpleAttributeMapper;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.opendj.rest2ldap.WritabilityPolicy;

public final class Rest2LDAP {
    public static ResourceException asResourceException(Throwable t) {
        int resourceResultCode;
        try {
            throw t;
        }
        catch (ResourceException e) {
            return e;
        }
        catch (AssertionFailureException e) {
            resourceResultCode = 412;
        }
        catch (ConstraintViolationException e) {
            ResultCode rc = e.getResult().getResultCode();
            resourceResultCode = rc.equals((Object)ResultCode.ENTRY_ALREADY_EXISTS) ? 412 : 400;
        }
        catch (AuthenticationException e) {
            resourceResultCode = 401;
        }
        catch (AuthorizationException e) {
            resourceResultCode = 403;
        }
        catch (ConnectionException e) {
            resourceResultCode = 503;
        }
        catch (EntryNotFoundException e) {
            resourceResultCode = 404;
        }
        catch (MultipleEntriesFoundException e) {
            resourceResultCode = 500;
        }
        catch (TimeoutResultException e) {
            resourceResultCode = 408;
        }
        catch (LdapException e) {
            ResultCode rc = e.getResult().getResultCode();
            resourceResultCode = rc.equals((Object)ResultCode.ADMIN_LIMIT_EXCEEDED) ? 413 : (rc.equals((Object)ResultCode.SIZE_LIMIT_EXCEEDED) ? 413 : 500);
        }
        catch (Throwable tmp) {
            resourceResultCode = 500;
        }
        return ResourceException.getException((int)resourceResultCode, (String)t.getMessage(), (Throwable)t);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ConnectionFactory configureConnectionFactory(JsonValue configuration, String name, ClassLoader providerClassLoader) {
        JsonValue normalizedConfiguration = Rest2LDAP.normalizeConnectionFactory(configuration, name, 0);
        return Rest2LDAP.configureConnectionFactory(normalizedConfiguration, providerClassLoader);
    }

    public static ConnectionFactory configureConnectionFactory(JsonValue configuration, String name) {
        return Rest2LDAP.configureConnectionFactory(configuration, name, null);
    }

    public static AttributeMapper constant(Object value) {
        return new JSONConstantAttributeMapper(value);
    }

    public static ObjectAttributeMapper object() {
        return new ObjectAttributeMapper();
    }

    public static ReferenceAttributeMapper reference(AttributeDescription attribute, DN baseDN, AttributeDescription primaryKey, AttributeMapper mapper) {
        return new ReferenceAttributeMapper(attribute, baseDN, primaryKey, mapper);
    }

    public static ReferenceAttributeMapper reference(String attribute, String baseDN, String primaryKey, AttributeMapper mapper) {
        return Rest2LDAP.reference(AttributeDescription.valueOf((String)attribute), DN.valueOf((String)baseDN), AttributeDescription.valueOf((String)primaryKey), mapper);
    }

    public static SimpleAttributeMapper simple(AttributeDescription attribute) {
        return new SimpleAttributeMapper(attribute);
    }

    public static SimpleAttributeMapper simple(String attribute) {
        return Rest2LDAP.simple(AttributeDescription.valueOf((String)attribute));
    }

    private static ConnectionFactory configureConnectionFactory(JsonValue configuration) {
        return Rest2LDAP.configureConnectionFactory(configuration, (ClassLoader)null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConnectionFactory configureConnectionFactory(JsonValue configuration, ClassLoader providerClassLoader) {
        ConnectionFactory secondary;
        JsonValue primaryLDAPServers;
        SimpleBindRequest bindRequest;
        int connectionPoolSize = Math.max(configuration.get("connectionPoolSize").defaultTo((Object)10).asInteger(), 1);
        int heartBeatIntervalSeconds = Math.max(configuration.get("heartBeatIntervalSeconds").defaultTo((Object)30).asInteger(), 1);
        int heartBeatTimeoutMilliSeconds = Math.max(configuration.get("heartBeatTimeoutMilliSeconds").defaultTo((Object)500).asInteger(), 100);
        if (configuration.isDefined("authentication")) {
            JsonValue authn = configuration.get("authentication");
            if (!authn.isDefined("simple")) throw new IllegalArgumentException("Only simple authentication is supported");
            JsonValue simple = authn.get("simple");
            bindRequest = Requests.newSimpleBindRequest((String)simple.get("bindDN").required().asString(), (char[])simple.get("bindPassword").required().asString().toCharArray());
        } else {
            bindRequest = null;
        }
        ConnectionSecurity connectionSecurity = (ConnectionSecurity)configuration.get("connectionSecurity").defaultTo((Object)ConnectionSecurity.NONE).asEnum(ConnectionSecurity.class);
        LDAPOptions options = new LDAPOptions();
        options.setProviderClassLoader(providerClassLoader);
        if (connectionSecurity != ConnectionSecurity.NONE) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                TrustManagerType trustManagerType = (TrustManagerType)configuration.get("trustManager").defaultTo((Object)TrustManagerType.TRUSTALL).asEnum(TrustManagerType.class);
                switch (trustManagerType) {
                    case TRUSTALL: {
                        builder.setTrustManager((TrustManager)TrustManagers.trustAll());
                        break;
                    }
                    case JVM: {
                        break;
                    }
                    case FILE: {
                        String fileName = configuration.get("fileBasedTrustManagerFile").required().asString();
                        String password = configuration.get("fileBasedTrustManagerPassword").asString();
                        String type = configuration.get("fileBasedTrustManagerType").asString();
                        builder.setTrustManager((TrustManager)TrustManagers.checkUsingTrustStore((String)fileName, (char[])(password != null ? password.toCharArray() : null), (String)type));
                    }
                }
                options.setSSLContext(builder.getSSLContext());
                options.setUseStartTLS(connectionSecurity == ConnectionSecurity.STARTTLS);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (!(primaryLDAPServers = configuration.get("primaryLDAPServers")).isList() || primaryLDAPServers.size() == 0) {
            throw new IllegalArgumentException("No primaryLDAPServers");
        }
        ConnectionFactory primary = Rest2LDAP.parseLDAPServers(primaryLDAPServers, (BindRequest)bindRequest, connectionPoolSize, heartBeatIntervalSeconds, heartBeatTimeoutMilliSeconds, options);
        JsonValue secondaryLDAPServers = configuration.get("secondaryLDAPServers");
        if (secondaryLDAPServers.isList()) {
            secondary = secondaryLDAPServers.size() > 0 ? Rest2LDAP.parseLDAPServers(secondaryLDAPServers, (BindRequest)bindRequest, connectionPoolSize, heartBeatIntervalSeconds, heartBeatTimeoutMilliSeconds, options) : null;
        } else {
            if (!secondaryLDAPServers.isNull()) {
                throw new IllegalArgumentException("Invalid secondaryLDAPServers configuration");
            }
            secondary = null;
        }
        if (secondary == null) return primary;
        return Connections.newLoadBalancer((LoadBalancingAlgorithm)new FailoverLoadBalancingAlgorithm(Arrays.asList(primary, secondary), (long)heartBeatIntervalSeconds, TimeUnit.SECONDS));
    }

    private static JsonValue normalizeConnectionFactory(JsonValue configuration, String name, int depth) {
        if (depth > 100) {
            throw new IllegalArgumentException("The LDAP server configuration '" + name + "' could not be parsed because of potential circular inheritance dependencies");
        }
        JsonValue current = configuration.get(name).required();
        if (current.isDefined("inheritFrom")) {
            JsonValue parent = Rest2LDAP.normalizeConnectionFactory(configuration, current.get("inheritFrom").asString(), depth + 1);
            LinkedHashMap normalized = new LinkedHashMap(parent.asMap());
            normalized.putAll(current.asMap());
            normalized.remove("inheritFrom");
            return new JsonValue(normalized);
        }
        return current;
    }

    private static ConnectionFactory parseLDAPServers(JsonValue config, BindRequest bindRequest, int connectionPoolSize, int heartBeatIntervalSeconds, int heartBeatTimeoutMilliSeconds, LDAPOptions options) {
        ArrayList<LDAPConnectionFactory> servers = new ArrayList<LDAPConnectionFactory>(config.size());
        for (JsonValue server : config) {
            String host = server.get("hostname").required().asString();
            int port = server.get("port").required().asInteger();
            LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port, options);
            factory = Connections.newHeartBeatConnectionFactory((ConnectionFactory)factory, (long)(heartBeatIntervalSeconds * 1000), (long)heartBeatTimeoutMilliSeconds, (TimeUnit)TimeUnit.MILLISECONDS);
            if (bindRequest != null) {
                factory = Connections.newAuthenticatedConnectionFactory((ConnectionFactory)factory, (BindRequest)bindRequest);
            }
            if (connectionPoolSize > 1) {
                factory = Connections.newCachedConnectionPool((ConnectionFactory)factory, (int)0, (int)connectionPoolSize, (long)60L, (TimeUnit)TimeUnit.SECONDS);
            }
            servers.add(factory);
        }
        if (servers.size() > 1) {
            return Connections.newLoadBalancer((LoadBalancingAlgorithm)new RoundRobinLoadBalancingAlgorithm(servers, (long)heartBeatIntervalSeconds, TimeUnit.SECONDS));
        }
        return (ConnectionFactory)servers.get(0);
    }

    private Rest2LDAP() {
    }

    private static final class DNNameStrategy
    extends NameStrategy {
        private final AttributeDescription attribute;

        private DNNameStrategy(AttributeType attribute) {
            this.attribute = AttributeDescription.create((AttributeType)attribute);
        }

        @Override
        SearchRequest createSearchRequest(Context c, DN baseDN, String resourceId) {
            return Requests.newSearchRequest((DN)baseDN.child(this.rdn(resourceId)), (SearchScope)SearchScope.BASE_OBJECT, (Filter)Filter.objectClassPresent(), (String[])new String[0]);
        }

        @Override
        void getLDAPAttributes(Context c, Set<String> ldapAttributes) {
            ldapAttributes.add(this.attribute.toString());
        }

        @Override
        String getResourceId(Context c, Entry entry) {
            return entry.parseAttribute(this.attribute).asString();
        }

        @Override
        void setResourceId(Context c, DN baseDN, String resourceId, Entry entry) throws ResourceException {
            if (resourceId != null) {
                entry.setName(baseDN.child(this.rdn(resourceId)));
                entry.addAttribute((Attribute)new LinkedAttribute(this.attribute, (Object)ByteString.valueOf((CharSequence)resourceId)));
            } else if (entry.getAttribute(this.attribute) != null) {
                entry.setName(baseDN.child(this.rdn(entry.parseAttribute(this.attribute).asString())));
            } else {
                throw new BadRequestException("Resources cannot be created without a client provided resource ID");
            }
        }

        private RDN rdn(String resourceId) {
            return new RDN(this.attribute.getAttributeType(), (Object)resourceId);
        }
    }

    private static final class AttributeNameStrategy
    extends NameStrategy {
        private final AttributeDescription dnAttribute;
        private final AttributeDescription idAttribute;
        private final boolean isServerProvided;

        private AttributeNameStrategy(AttributeType dnAttribute, AttributeDescription idAttribute, boolean isServerProvided) {
            this.dnAttribute = AttributeDescription.create((AttributeType)dnAttribute);
            if (this.dnAttribute.equals((Object)idAttribute)) {
                throw new IllegalArgumentException("DN and ID attributes must be different");
            }
            this.idAttribute = Utils.ensureNotNull(idAttribute);
            this.isServerProvided = isServerProvided;
        }

        @Override
        SearchRequest createSearchRequest(Context c, DN baseDN, String resourceId) {
            return Requests.newSearchRequest((DN)baseDN, (SearchScope)SearchScope.SINGLE_LEVEL, (Filter)Filter.equality((String)this.idAttribute.toString(), (Object)resourceId), (String[])new String[0]);
        }

        @Override
        void getLDAPAttributes(Context c, Set<String> ldapAttributes) {
            ldapAttributes.add(this.idAttribute.toString());
        }

        @Override
        String getResourceId(Context c, Entry entry) {
            return entry.parseAttribute(this.idAttribute).asString();
        }

        @Override
        void setResourceId(Context c, DN baseDN, String resourceId, Entry entry) throws ResourceException {
            if (this.isServerProvided) {
                if (resourceId != null) {
                    throw new BadRequestException("Resources cannot be created with a client provided resource ID");
                }
            } else {
                entry.addAttribute((Attribute)new LinkedAttribute(this.idAttribute, (Object)ByteString.valueOf((CharSequence)resourceId)));
            }
            String rdnValue = entry.parseAttribute(this.dnAttribute).asString();
            RDN rdn = new RDN(this.dnAttribute.getAttributeType(), (Object)rdnValue);
            entry.setName(baseDN.child(rdn));
        }
    }

    public static final class Builder {
        private final List<Attribute> additionalLDAPAttributes = new LinkedList<Attribute>();
        private AuthorizationPolicy authzPolicy = AuthorizationPolicy.NONE;
        private DN baseDN;
        private AttributeDescription etagAttribute;
        private ConnectionFactory factory;
        private NameStrategy nameStrategy;
        private AuthzIdTemplate proxiedAuthzTemplate;
        private ReadOnUpdatePolicy readOnUpdatePolicy = ReadOnUpdatePolicy.CONTROLS;
        private AttributeMapper rootMapper;
        private Schema schema = Schema.getDefaultSchema();
        private boolean usePermissiveModify;
        private boolean useSubtreeDelete;

        private Builder() {
            this.useEtagAttribute();
            this.useClientDNNaming("uid");
        }

        public Builder additionalLDAPAttribute(Attribute attribute) {
            this.additionalLDAPAttributes.add(attribute);
            return this;
        }

        public Builder additionalLDAPAttribute(String attribute, Object ... values) {
            return this.additionalLDAPAttribute((Attribute)new LinkedAttribute(this.ad(attribute), values));
        }

        public Builder authorizationPolicy(AuthorizationPolicy policy) {
            this.authzPolicy = Utils.ensureNotNull(policy);
            return this;
        }

        public Builder baseDN(DN dn) {
            Utils.ensureNotNull(dn);
            this.baseDN = dn;
            return this;
        }

        public Builder baseDN(String dn) {
            return this.baseDN(DN.valueOf((String)dn, (Schema)this.schema));
        }

        public CollectionResourceProvider build() {
            Utils.ensureNotNull(this.baseDN);
            if (this.rootMapper == null) {
                throw new IllegalStateException("No mappings provided");
            }
            switch (this.authzPolicy) {
                case NONE: {
                    if (this.factory != null) break;
                    throw new IllegalStateException("A connection factory must be specified when the authorization policy is 'none'");
                }
                case PROXY: {
                    if (this.proxiedAuthzTemplate == null) {
                        throw new IllegalStateException("Proxied authorization enabled but no template defined");
                    }
                    if (this.factory != null) break;
                    throw new IllegalStateException("A connection factory must be specified when using proxied authorization");
                }
            }
            return new LDAPCollectionResourceProvider(this.baseDN, this.rootMapper, this.nameStrategy, this.etagAttribute, new Config(this.factory, this.readOnUpdatePolicy, this.authzPolicy, this.proxiedAuthzTemplate, this.useSubtreeDelete, this.usePermissiveModify, this.schema), this.additionalLDAPAttributes);
        }

        public Builder configureMapping(JsonValue configuration) {
            JsonValue etagAttribute;
            this.baseDN(configuration.get("baseDN").required().asString());
            JsonValue readOnUpdatePolicy = configuration.get("readOnUpdatePolicy");
            if (!readOnUpdatePolicy.isNull()) {
                this.readOnUpdatePolicy((ReadOnUpdatePolicy)readOnUpdatePolicy.asEnum(ReadOnUpdatePolicy.class));
            }
            for (JsonValue v : configuration.get("additionalLDAPAttributes")) {
                String type = v.get("type").required().asString();
                List values = v.get("values").required().asList();
                this.additionalLDAPAttribute((Attribute)new LinkedAttribute(type, (Collection)values));
            }
            JsonValue namingStrategy = configuration.get("namingStrategy");
            if (!namingStrategy.isNull()) {
                String name = namingStrategy.get("strategy").required().asString();
                if (name.equalsIgnoreCase("clientDNNaming")) {
                    this.useClientDNNaming(namingStrategy.get("dnAttribute").required().asString());
                } else if (name.equalsIgnoreCase("clientNaming")) {
                    this.useClientNaming(namingStrategy.get("dnAttribute").required().asString(), namingStrategy.get("idAttribute").required().asString());
                } else if (name.equalsIgnoreCase("serverNaming")) {
                    this.useServerNaming(namingStrategy.get("dnAttribute").required().asString(), namingStrategy.get("idAttribute").required().asString());
                } else {
                    throw new IllegalArgumentException("Illegal naming strategy. Must be one of: clientDNNaming, clientNaming, or serverNaming");
                }
            }
            if (!(etagAttribute = configuration.get("etagAttribute")).isNull()) {
                this.useEtagAttribute(etagAttribute.asString());
            }
            if (configuration.get("useSubtreeDelete").defaultTo((Object)false).asBoolean().booleanValue()) {
                this.useSubtreeDelete();
            }
            if (configuration.get("usePermissiveModify").defaultTo((Object)true).asBoolean().booleanValue()) {
                this.usePermissiveModify();
            }
            this.mapper(this.configureObjectMapper(configuration.get("attributes").required()));
            return this;
        }

        public Builder ldapConnectionFactory(ConnectionFactory factory) {
            this.factory = factory;
            return this;
        }

        public Builder mapper(AttributeMapper mapper) {
            this.rootMapper = mapper;
            return this;
        }

        public Builder proxyAuthzIdTemplate(String template) {
            this.proxiedAuthzTemplate = template != null ? new AuthzIdTemplate(template) : null;
            return this;
        }

        public Builder readOnUpdatePolicy(ReadOnUpdatePolicy policy) {
            this.readOnUpdatePolicy = Utils.ensureNotNull(policy);
            return this;
        }

        public Builder schema(Schema schema) {
            this.schema = Utils.ensureNotNull(schema);
            return this;
        }

        public Builder useClientDNNaming(AttributeType attribute) {
            this.nameStrategy = new DNNameStrategy(attribute);
            return this;
        }

        public Builder useClientDNNaming(String attribute) {
            return this.useClientDNNaming(this.at(attribute));
        }

        public Builder useClientNaming(AttributeType dnAttribute, AttributeDescription idAttribute) {
            this.nameStrategy = new AttributeNameStrategy(dnAttribute, idAttribute, false);
            return this;
        }

        public Builder useClientNaming(String dnAttribute, String idAttribute) {
            return this.useClientNaming(this.at(dnAttribute), this.ad(idAttribute));
        }

        public Builder useEtagAttribute() {
            return this.useEtagAttribute("etag");
        }

        public Builder useEtagAttribute(AttributeDescription attribute) {
            this.etagAttribute = attribute;
            return this;
        }

        public Builder useEtagAttribute(String attribute) {
            return this.useEtagAttribute(attribute != null ? this.ad(attribute) : null);
        }

        public Builder usePermissiveModify() {
            this.usePermissiveModify = true;
            return this;
        }

        public Builder useServerEntryUUIDNaming(AttributeType dnAttribute) {
            return this.useServerNaming(dnAttribute, AttributeDescription.create((AttributeType)CoreSchema.getEntryUUIDAttributeType()));
        }

        public Builder useServerEntryUUIDNaming(String dnAttribute) {
            return this.useServerEntryUUIDNaming(this.at(dnAttribute));
        }

        public Builder useServerNaming(AttributeType dnAttribute, AttributeDescription idAttribute) {
            this.nameStrategy = new AttributeNameStrategy(dnAttribute, idAttribute, true);
            return this;
        }

        public Builder useServerNaming(String dnAttribute, String idAttribute) {
            return this.useServerNaming(this.at(dnAttribute), this.ad(idAttribute));
        }

        public Builder useSubtreeDelete() {
            this.useSubtreeDelete = true;
            return this;
        }

        private AttributeDescription ad(String attribute) {
            return AttributeDescription.valueOf((String)attribute, (Schema)this.schema);
        }

        private AttributeType at(String attribute) {
            return this.schema.getAttributeType(attribute);
        }

        private AttributeMapper configureMapper(JsonValue mapper) {
            if (mapper.isDefined("constant")) {
                return Rest2LDAP.constant(mapper.get("constant").getObject());
            }
            if (mapper.isDefined("simple")) {
                JsonValue config = mapper.get("simple");
                SimpleAttributeMapper s = Rest2LDAP.simple(this.ad(config.get("ldapAttribute").required().asString()));
                if (config.isDefined("defaultJSONValue")) {
                    s.defaultJSONValue(config.get("defaultJSONValue").getObject());
                }
                if (config.get("isBinary").defaultTo((Object)false).asBoolean().booleanValue()) {
                    s.isBinary();
                }
                if (config.get("isRequired").defaultTo((Object)false).asBoolean().booleanValue()) {
                    s.isRequired();
                }
                if (config.get("isSingleValued").defaultTo((Object)false).asBoolean().booleanValue()) {
                    s.isSingleValued();
                }
                s.writability(this.parseWritability(mapper, config));
                return s;
            }
            if (mapper.isDefined("reference")) {
                JsonValue config = mapper.get("reference");
                AttributeDescription ldapAttribute = this.ad(config.get("ldapAttribute").required().asString());
                DN baseDN = DN.valueOf((String)config.get("baseDN").required().asString(), (Schema)this.schema);
                AttributeDescription primaryKey = this.ad(config.get("primaryKey").required().asString());
                AttributeMapper m = this.configureMapper(config.get("mapper").required());
                ReferenceAttributeMapper r = Rest2LDAP.reference(ldapAttribute, baseDN, primaryKey, m);
                if (config.get("isRequired").defaultTo((Object)false).asBoolean().booleanValue()) {
                    r.isRequired();
                }
                if (config.get("isSingleValued").defaultTo((Object)false).asBoolean().booleanValue()) {
                    r.isSingleValued();
                }
                if (config.isDefined("searchFilter")) {
                    r.searchFilter(config.get("searchFilter").asString());
                }
                r.writability(this.parseWritability(mapper, config));
                return r;
            }
            if (mapper.isDefined("object")) {
                return this.configureObjectMapper(mapper.get("object"));
            }
            throw new JsonValueException(mapper, "Illegal mapping: must contain constant, simple, or object");
        }

        private ObjectAttributeMapper configureObjectMapper(JsonValue mapper) {
            ObjectAttributeMapper object = Rest2LDAP.object();
            for (String attribute : mapper.keys()) {
                object.attribute(attribute, this.configureMapper(mapper.get(attribute)));
            }
            return object;
        }

        private WritabilityPolicy parseWritability(JsonValue mapper, JsonValue config) {
            if (config.isDefined("writability")) {
                String writability = config.get("writability").asString();
                if (writability.equalsIgnoreCase("readOnly")) {
                    return WritabilityPolicy.READ_ONLY;
                }
                if (writability.equalsIgnoreCase("readOnlyDiscardWrites")) {
                    return WritabilityPolicy.READ_ONLY_DISCARD_WRITES;
                }
                if (writability.equalsIgnoreCase("createOnly")) {
                    return WritabilityPolicy.CREATE_ONLY;
                }
                if (writability.equalsIgnoreCase("createOnlyDiscardWrites")) {
                    return WritabilityPolicy.CREATE_ONLY_DISCARD_WRITES;
                }
                if (writability.equalsIgnoreCase("readWrite")) {
                    return WritabilityPolicy.READ_WRITE;
                }
                throw new JsonValueException(mapper, "Illegal writability: must be one of readOnly, readOnlyDiscardWrites, createOnly, createOnlyDiscardWrites, or readWrite");
            }
            return WritabilityPolicy.READ_WRITE;
        }
    }

    private static enum TrustManagerType {
        TRUSTALL,
        JVM,
        FILE;

    }

    private static enum ConnectionSecurity {
        NONE,
        SSL,
        STARTTLS;

    }
}

