/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.rest2ldap.AbstractLDAPAttributeMapper;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.Context;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.util.Function;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.NeverThrowsException;

public final class ReferenceAttributeMapper
extends AbstractLDAPAttributeMapper<ReferenceAttributeMapper> {
    private static final int SEARCH_MAX_CANDIDATES = 1000;
    private final DN baseDN;
    private Filter filter;
    private final AttributeMapper mapper;
    private final AttributeDescription primaryKey;
    private SearchScope scope = SearchScope.WHOLE_SUBTREE;

    ReferenceAttributeMapper(AttributeDescription ldapAttributeName, DN baseDN, AttributeDescription primaryKey, AttributeMapper mapper) {
        super(ldapAttributeName);
        this.baseDN = baseDN;
        this.primaryKey = primaryKey;
        this.mapper = mapper;
    }

    public ReferenceAttributeMapper searchFilter(Filter filter) {
        this.filter = Utils.ensureNotNull(filter);
        return this;
    }

    public ReferenceAttributeMapper searchFilter(String filter) {
        return this.searchFilter(Filter.valueOf((String)filter));
    }

    public ReferenceAttributeMapper searchScope(SearchScope scope) {
        this.scope = Utils.ensureNotNull(scope);
        return this;
    }

    public String toString() {
        return "reference(" + this.ldapAttributeName + ")";
    }

    @Override
    void getLDAPFilter(final Context c, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion, final ResultHandler<Filter> h) {
        this.mapper.getLDAPFilter(c, path, subPath, type, operator, valueAssertion, new ResultHandler<Filter>(){

            public void handleError(ResourceException error) {
                h.handleError(error);
            }

            public void handleResult(Filter result) {
                SearchRequest request = ReferenceAttributeMapper.this.createSearchRequest(result);
                final LinkedList subFilters = new LinkedList();
                ExceptionHandler<LdapException> exceptionHandler = new ExceptionHandler<LdapException>(){

                    public void handleException(LdapException exception) {
                        h.handleError(Rest2LDAP.asResourceException(exception));
                    }
                };
                c.getConnection().searchAsync(request, new SearchResultHandler(){

                    public boolean handleEntry(SearchResultEntry entry) {
                        if (subFilters.size() < 1000) {
                            subFilters.add(Filter.equality((String)ReferenceAttributeMapper.this.ldapAttributeName.toString(), (Object)entry.getName()));
                            return true;
                        }
                        return false;
                    }

                    public boolean handleReference(SearchResultReference reference) {
                        return true;
                    }
                }).thenOnResult((org.forgerock.util.promise.ResultHandler)new org.forgerock.util.promise.ResultHandler<Result>((ExceptionHandler)exceptionHandler){
                    final /* synthetic */ ExceptionHandler val$exceptionHandler;
                    {
                        this.val$exceptionHandler = exceptionHandler;
                    }

                    public void handleResult(Result result) {
                        if (subFilters.size() >= 1000) {
                            this.val$exceptionHandler.handleException((Object)LdapException.newLdapException((ResultCode)ResultCode.ADMIN_LIMIT_EXCEEDED));
                        } else if (subFilters.size() == 1) {
                            h.handleResult(subFilters.get(0));
                        } else {
                            h.handleResult((Object)Filter.or((Collection)subFilters));
                        }
                    }
                }).thenOnException((ExceptionHandler)exceptionHandler);
            }
        });
    }

    @Override
    void getNewLDAPAttributes(final Context c, final JsonPointer path, List<Object> newValues, final ResultHandler<Attribute> h) {
        LinkedAttribute newLDAPAttribute = new LinkedAttribute(this.ldapAttributeName);
        AtomicInteger pendingSearches = new AtomicInteger(newValues.size());
        AtomicReference exception = new AtomicReference();
        for (Object value : newValues) {
            this.mapper.create(c, path, new JsonValue(value), new ResultHandler<List<Attribute>>((Attribute)newLDAPAttribute, exception, pendingSearches){
                final /* synthetic */ Attribute val$newLDAPAttribute;
                final /* synthetic */ AtomicReference val$exception;
                final /* synthetic */ AtomicInteger val$pendingSearches;
                {
                    this.val$newLDAPAttribute = attribute;
                    this.val$exception = atomicReference;
                    this.val$pendingSearches = atomicInteger;
                }

                public void handleError(ResourceException error) {
                    h.handleError(error);
                }

                public void handleResult(List<Attribute> result) {
                    Attribute primaryKeyAttribute = null;
                    for (Attribute attribute : result) {
                        if (!attribute.getAttributeDescription().equals((Object)ReferenceAttributeMapper.this.primaryKey)) continue;
                        primaryKeyAttribute = attribute;
                        break;
                    }
                    if (primaryKeyAttribute == null || primaryKeyAttribute.isEmpty()) {
                        h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because the reference field '%s' contains a value which does not contain a primary key", path)));
                        return;
                    }
                    if (primaryKeyAttribute.size() > 1) {
                        h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because the reference field '%s' contains a value which contains multiple primary keys", path)));
                        return;
                    }
                    final ByteString primaryKeyValue = primaryKeyAttribute.firstValue();
                    Filter filter = Filter.equality((String)ReferenceAttributeMapper.this.primaryKey.toString(), (Object)primaryKeyValue);
                    SearchRequest search = ReferenceAttributeMapper.this.createSearchRequest(filter);
                    c.getConnection().searchSingleEntryAsync(search).thenOnResult((org.forgerock.util.promise.ResultHandler)new org.forgerock.util.promise.ResultHandler<SearchResultEntry>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void handleResult(SearchResultEntry result) {
                            Attribute attribute = val$newLDAPAttribute;
                            synchronized (attribute) {
                                val$newLDAPAttribute.add(new Object[]{result.getName()});
                            }
                            this.completeIfNecessary();
                        }
                    }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                        public void handleException(LdapException error) {
                            ResourceException re;
                            try {
                                throw error;
                            }
                            catch (EntryNotFoundException e) {
                                re = new BadRequestException(Utils.i18n("The request cannot be processed because the resource '%s' referenced in field '%s' does not exist", primaryKeyValue.toString(), path));
                            }
                            catch (MultipleEntriesFoundException e) {
                                re = new BadRequestException(Utils.i18n("The request cannot be processed because the resource '%s' referenced in field '%s' is ambiguous", primaryKeyValue.toString(), path));
                            }
                            catch (LdapException e) {
                                re = Rest2LDAP.asResourceException(e);
                            }
                            val$exception.compareAndSet(null, re);
                            this.completeIfNecessary();
                        }
                    });
                }

                private void completeIfNecessary() {
                    if (this.val$pendingSearches.decrementAndGet() == 0) {
                        if (this.val$exception.get() != null) {
                            h.handleError((ResourceException)((Object)this.val$exception.get()));
                        } else {
                            h.handleResult((Object)this.val$newLDAPAttribute);
                        }
                    }
                }
            });
        }
    }

    @Override
    ReferenceAttributeMapper getThis() {
        return this;
    }

    @Override
    void read(Context c, JsonPointer path, Entry e, ResultHandler<JsonValue> h) {
        Attribute attribute = e.getAttribute(this.ldapAttributeName);
        if (attribute == null || attribute.isEmpty()) {
            h.handleResult(null);
        } else if (this.attributeIsSingleValued()) {
            try {
                DN dn = attribute.parse().usingSchema(c.getConfig().schema()).asDN();
                this.readEntry(c, path, dn, h);
            }
            catch (Exception ex) {
                h.handleError(Rest2LDAP.asResourceException(ex));
            }
        } else {
            try {
                Set dns = attribute.parse().usingSchema(c.getConfig().schema()).asSetOfDN();
                ResultHandler<JsonValue> handler = Utils.accumulate(dns.size(), Utils.transform(new Function<List<JsonValue>, JsonValue, NeverThrowsException>(){

                    public JsonValue apply(List<JsonValue> value) {
                        if (value.isEmpty()) {
                            return null;
                        }
                        ArrayList<Object> result = new ArrayList<Object>(value.size());
                        for (JsonValue e : value) {
                            result.add(e.getObject());
                        }
                        return new JsonValue(result);
                    }
                }, h));
                for (DN dn : dns) {
                    this.readEntry(c, path, dn, handler);
                }
            }
            catch (Exception ex) {
                h.handleError(Rest2LDAP.asResourceException(ex));
            }
        }
    }

    private SearchRequest createSearchRequest(Filter result) {
        Filter searchFilter = this.filter != null ? Filter.and((Filter[])new Filter[]{this.filter, result}) : result;
        return Requests.newSearchRequest((DN)this.baseDN, (SearchScope)this.scope, (Filter)searchFilter, (String[])new String[]{"1.1"});
    }

    private void readEntry(final Context c, final JsonPointer path, DN dn, final ResultHandler<JsonValue> handler) {
        LinkedHashSet<String> requestedLDAPAttributes = new LinkedHashSet<String>();
        this.mapper.getLDAPAttributes(c, path, new JsonPointer(), requestedLDAPAttributes);
        c.getConnection().readEntryAsync(dn, requestedLDAPAttributes).thenOnResult((org.forgerock.util.promise.ResultHandler)new org.forgerock.util.promise.ResultHandler<SearchResultEntry>(){

            public void handleResult(SearchResultEntry result) {
                ReferenceAttributeMapper.this.mapper.read(c, path, (Entry)result, (ResultHandler<JsonValue>)handler);
            }
        }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

            public void handleException(LdapException error) {
                if (!(error instanceof EntryNotFoundException)) {
                    handler.handleError(Rest2LDAP.asResourceException((Throwable)error));
                } else {
                    handler.handleResult(null);
                }
            }
        });
    }
}

