/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryFilter;
import org.forgerock.json.resource.QueryFilterVisitor;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResult;
import org.forgerock.json.resource.QueryResultHandler;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Resource;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.json.resource.ServerContext;
import org.forgerock.json.resource.UncategorizedException;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.PermissiveModifyRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadResponseControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadResponseControl;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.Config;
import org.forgerock.opendj.rest2ldap.Context;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.NameStrategy;
import org.forgerock.opendj.rest2ldap.ReadOnUpdatePolicy;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.util.Function;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;

final class LDAPCollectionResourceProvider
implements CollectionResourceProvider {
    private static final ResourceException SUCCESS = new UncategorizedException(0, null, null);
    private static final DecodeOptions DECODE_OPTIONS = new DecodeOptions();
    private final List<Attribute> additionalLDAPAttributes;
    private final AttributeMapper attributeMapper;
    private final DN baseDN;
    private final Config config;
    private final AttributeDescription etagAttribute;
    private final NameStrategy nameStrategy;

    LDAPCollectionResourceProvider(DN baseDN, AttributeMapper mapper, NameStrategy nameStrategy, AttributeDescription etagAttribute, Config config, List<Attribute> additionalLDAPAttributes) {
        this.baseDN = baseDN;
        this.attributeMapper = mapper;
        this.config = config;
        this.nameStrategy = nameStrategy;
        this.etagAttribute = etagAttribute;
        this.additionalLDAPAttributes = additionalLDAPAttributes;
    }

    public void actionCollection(ServerContext context, ActionRequest request, ResultHandler<JsonValue> handler) {
        handler.handleError((ResourceException)new NotSupportedException("Not yet implemented"));
    }

    public void actionInstance(ServerContext context, String resourceId, ActionRequest request, ResultHandler<JsonValue> handler) {
        handler.handleError((ResourceException)new NotSupportedException("Not yet implemented"));
    }

    public void createInstance(ServerContext context, final CreateRequest request, ResultHandler<Resource> handler) {
        final Context c = this.wrap(context);
        final ResultHandler<Resource> h = this.wrap(c, handler);
        c.run(h, new Runnable(){

            @Override
            public void run() {
                LDAPCollectionResourceProvider.this.attributeMapper.create(c, new JsonPointer(), request.getContent(), new ResultHandler<List<Attribute>>(){

                    public void handleError(ResourceException error) {
                        h.handleError(error);
                    }

                    public void handleResult(List<Attribute> result) {
                        AddRequest addRequest = Requests.newAddRequest((DN)DN.rootDN());
                        for (Attribute attribute : LDAPCollectionResourceProvider.this.additionalLDAPAttributes) {
                            addRequest.addAttribute(attribute);
                        }
                        for (Attribute attribute : result) {
                            addRequest.addAttribute(attribute);
                        }
                        try {
                            LDAPCollectionResourceProvider.this.nameStrategy.setResourceId(c, LDAPCollectionResourceProvider.this.getBaseDN(c), request.getNewResourceId(), (Entry)addRequest);
                        }
                        catch (ResourceException e) {
                            h.handleError(e);
                            return;
                        }
                        if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                            String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                            addRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, (String[])attributes));
                        }
                        c.getConnection().applyChangeAsync((ChangeRecord)addRequest).thenOnResult(LDAPCollectionResourceProvider.this.postUpdateResultHandler(c, (ResultHandler<Resource>)h)).thenOnException(LDAPCollectionResourceProvider.this.postUpdateExceptionHandler((ResultHandler<Resource>)h));
                    }
                });
            }
        });
    }

    public void deleteInstance(ServerContext context, String resourceId, final org.forgerock.json.resource.DeleteRequest request, ResultHandler<Resource> handler) {
        final Context c = this.wrap(context);
        final ResultHandler<Resource> h = this.wrap(c, handler);
        c.run(h, this.doUpdate(c, resourceId, request.getRevision(), new ResultHandler<DN>(){

            public void handleError(ResourceException error) {
                h.handleError(error);
            }

            public void handleResult(DN dn) {
                try {
                    DeleteRequest deleteRequest = Requests.newDeleteRequest((DN)dn);
                    if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                        String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                        deleteRequest.addControl((Control)PreReadRequestControl.newControl((boolean)false, (String[])attributes));
                    }
                    if (LDAPCollectionResourceProvider.this.config.useSubtreeDelete()) {
                        deleteRequest.addControl((Control)SubtreeDeleteRequestControl.newControl((boolean)true));
                    }
                    LDAPCollectionResourceProvider.this.addAssertionControl((ChangeRecord)deleteRequest, request.getRevision());
                    c.getConnection().applyChangeAsync((ChangeRecord)deleteRequest).thenOnResult(LDAPCollectionResourceProvider.this.postUpdateResultHandler(c, (ResultHandler<Resource>)h)).thenOnException(LDAPCollectionResourceProvider.this.postUpdateExceptionHandler((ResultHandler<Resource>)h));
                }
                catch (Exception e) {
                    h.handleError(Rest2LDAP.asResourceException(e));
                }
            }
        }));
    }

    public void patchInstance(ServerContext context, final String resourceId, final PatchRequest request, ResultHandler<Resource> handler) {
        final Context c = this.wrap(context);
        final ResultHandler<Resource> h = this.wrap(c, handler);
        if (request.getPatchOperations().isEmpty()) {
            c.run(h, new Runnable(){

                @Override
                public void run() {
                    String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                    SearchRequest searchRequest = LDAPCollectionResourceProvider.this.nameStrategy.createSearchRequest(c, LDAPCollectionResourceProvider.this.getBaseDN(c), resourceId).addAttribute(attributes);
                    c.getConnection().searchSingleEntryAsync(searchRequest).thenOnResult(LDAPCollectionResourceProvider.this.postEmptyPatchResultHandler(c, request, (ResultHandler<Resource>)h)).thenOnException(LDAPCollectionResourceProvider.this.postEmptyPatchExceptionHandler((ResultHandler<Resource>)h));
                }
            });
        } else {
            c.run(h, this.doUpdate(c, resourceId, request.getRevision(), new ResultHandler<DN>(){

                public void handleError(ResourceException error) {
                    h.handleError(error);
                }

                public void handleResult(final DN dn) {
                    ArrayList<PromiseImpl> promises = new ArrayList<PromiseImpl>(request.getPatchOperations().size());
                    for (PatchOperation operation : request.getPatchOperations()) {
                        ResultHandlerFromPromise<List<Modification>> handler = new ResultHandlerFromPromise<List<Modification>>();
                        LDAPCollectionResourceProvider.this.attributeMapper.patch(c, new JsonPointer(), operation, handler);
                        promises.add(((ResultHandlerFromPromise)handler).promise);
                    }
                    Promises.when(promises).thenOnResult((org.forgerock.util.promise.ResultHandler)new org.forgerock.util.promise.ResultHandler<List<List<Modification>>>(){

                        public void handleResult(List<List<Modification>> result) {
                            try {
                                ModifyRequest modifyRequest = Requests.newModifyRequest((DN)dn);
                                for (List<Modification> modifications : result) {
                                    if (modifications == null) continue;
                                    modifyRequest.getModifications().addAll(modifications);
                                }
                                List<String> attributes = Arrays.asList(LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields()));
                                if (modifyRequest.getModifications().isEmpty()) {
                                    c.getConnection().readEntryAsync(dn, attributes).thenOnResult(LDAPCollectionResourceProvider.this.postEmptyPatchResultHandler(c, request, (ResultHandler<Resource>)h)).thenOnException(LDAPCollectionResourceProvider.this.postEmptyPatchExceptionHandler((ResultHandler<Resource>)h));
                                } else {
                                    if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                                        modifyRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, attributes));
                                    }
                                    if (LDAPCollectionResourceProvider.this.config.usePermissiveModify()) {
                                        modifyRequest.addControl((Control)PermissiveModifyRequestControl.newControl((boolean)true));
                                    }
                                    LDAPCollectionResourceProvider.this.addAssertionControl((ChangeRecord)modifyRequest, request.getRevision());
                                    c.getConnection().applyChangeAsync((ChangeRecord)modifyRequest).thenOnResult(LDAPCollectionResourceProvider.this.postUpdateResultHandler(c, (ResultHandler<Resource>)h)).thenOnException(LDAPCollectionResourceProvider.this.postUpdateExceptionHandler((ResultHandler<Resource>)h));
                                }
                            }
                            catch (Exception e) {
                                h.handleError(Rest2LDAP.asResourceException(e));
                            }
                        }
                    }).thenOnException((ExceptionHandler)new ExceptionHandler<ResourceException>(){

                        public void handleException(ResourceException exception) {
                            h.handleError(Rest2LDAP.asResourceException(exception));
                        }
                    });
                }
            }));
        }
    }

    public void queryCollection(ServerContext context, final QueryRequest request, QueryResultHandler handler) {
        final Context c = this.wrap(context);
        final QueryResultHandler h = this.wrap(c, handler);
        c.run((ResultHandler<?>)h, new Runnable(){

            @Override
            public void run() {
                LDAPCollectionResourceProvider.this.getLDAPFilter(c, request.getQueryFilter(), (ResultHandler<Filter>)((ResultHandler)new ResultHandler<Filter>(){
                    private final Object sequenceLock = new Object();
                    private String cookie;
                    private ResourceException pendingResult;
                    private int pendingResourceCount;
                    private boolean resultSent;
                    private int totalResourceCount;

                    public void handleError(ResourceException error) {
                        h.handleError(error);
                    }

                    public void handleResult(Filter ldapFilter) {
                        if (ldapFilter == null || ldapFilter == Filter.alwaysFalse()) {
                            h.handleResult(new QueryResult());
                        } else {
                            int pageResultStartIndex;
                            String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                            Filter searchFilter = ldapFilter == Filter.alwaysTrue() ? Filter.objectClassPresent() : ldapFilter;
                            SearchRequest searchRequest = Requests.newSearchRequest((DN)LDAPCollectionResourceProvider.this.getBaseDN(c), (SearchScope)SearchScope.SINGLE_LEVEL, (Filter)searchFilter, (String[])attributes);
                            int pageSize = request.getPageSize();
                            if (request.getPageSize() > 0) {
                                int pageResultEndIndex;
                                if (request.getPagedResultsOffset() > 0) {
                                    pageResultStartIndex = request.getPagedResultsOffset() * pageSize;
                                    pageResultEndIndex = pageResultStartIndex + pageSize;
                                } else {
                                    pageResultStartIndex = 0;
                                    pageResultEndIndex = pageSize;
                                }
                                ByteString cookie = request.getPagedResultsCookie() != null ? ByteString.valueOfBase64((String)request.getPagedResultsCookie()) : ByteString.empty();
                                SimplePagedResultsControl control = SimplePagedResultsControl.newControl((boolean)true, (int)pageResultEndIndex, (ByteString)cookie);
                                searchRequest.addControl((Control)control);
                            } else {
                                pageResultStartIndex = 0;
                            }
                            c.getConnection().searchAsync(searchRequest, new SearchResultHandler(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public boolean handleEntry(SearchResultEntry entry) {
                                    Object object = sequenceLock;
                                    synchronized (object) {
                                        if (pendingResult != null) {
                                            return false;
                                        }
                                        if (totalResourceCount++ < pageResultStartIndex) {
                                            return true;
                                        }
                                        pendingResourceCount++;
                                    }
                                    final String id = LDAPCollectionResourceProvider.this.nameStrategy.getResourceId(c, (Entry)entry);
                                    final String revision = LDAPCollectionResourceProvider.this.getRevisionFromEntry((Entry)entry);
                                    LDAPCollectionResourceProvider.this.attributeMapper.read(c, new JsonPointer(), (Entry)entry, new ResultHandler<JsonValue>(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void handleError(ResourceException e) {
                                            Object object = sequenceLock;
                                            synchronized (object) {
                                                pendingResourceCount--;
                                                this.completeIfNecessary(e);
                                            }
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void handleResult(JsonValue result) {
                                            Object object = sequenceLock;
                                            synchronized (object) {
                                                pendingResourceCount--;
                                                if (!resultSent) {
                                                    h.handleResource(new Resource(id, revision, result));
                                                }
                                                this.completeIfNecessary();
                                            }
                                        }
                                    });
                                    return true;
                                }

                                public boolean handleReference(SearchResultReference reference) {
                                    return true;
                                }
                            }).thenOnResult((org.forgerock.util.promise.ResultHandler)new org.forgerock.util.promise.ResultHandler<Result>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void handleResult(Result result) {
                                    Object object = sequenceLock;
                                    synchronized (object) {
                                        if (request.getPageSize() > 0) {
                                            try {
                                                SimplePagedResultsControl control = (SimplePagedResultsControl)result.getControl(SimplePagedResultsControl.DECODER, DECODE_OPTIONS);
                                                if (control != null && !control.getCookie().isEmpty()) {
                                                    cookie = control.getCookie().toBase64String();
                                                }
                                            }
                                            catch (DecodeException decodeException) {
                                                // empty catch block
                                            }
                                        }
                                        this.completeIfNecessary(SUCCESS);
                                    }
                                }
                            }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void handleException(LdapException exception) {
                                    Object object = sequenceLock;
                                    synchronized (object) {
                                        this.completeIfNecessary(Rest2LDAP.asResourceException((Throwable)exception));
                                    }
                                }
                            });
                        }
                    }

                    private void completeIfNecessary(ResourceException e) {
                        if (this.pendingResult == null) {
                            this.pendingResult = e;
                        }
                        this.completeIfNecessary();
                    }

                    private void completeIfNecessary() {
                        if (this.pendingResourceCount == 0 && this.pendingResult != null && !this.resultSent) {
                            if (this.pendingResult == SUCCESS) {
                                h.handleResult(new QueryResult(this.cookie, -1));
                            } else {
                                h.handleError(this.pendingResult);
                            }
                            this.resultSent = true;
                        }
                    }
                }));
            }
        });
    }

    public void readInstance(ServerContext context, final String resourceId, final ReadRequest request, ResultHandler<Resource> handler) {
        final Context c = this.wrap(context);
        final ResultHandler<Resource> h = this.wrap(c, handler);
        c.run(h, new Runnable(){

            @Override
            public void run() {
                String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                SearchRequest request2 = LDAPCollectionResourceProvider.this.nameStrategy.createSearchRequest(c, LDAPCollectionResourceProvider.this.getBaseDN(c), resourceId).addAttribute(attributes);
                c.getConnection().searchSingleEntryAsync(request2).thenOnResult((org.forgerock.util.promise.ResultHandler)new org.forgerock.util.promise.ResultHandler<SearchResultEntry>(){

                    public void handleResult(SearchResultEntry entry) {
                        LDAPCollectionResourceProvider.this.adaptEntry(c, (Entry)entry, (ResultHandler<Resource>)h);
                    }
                }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                    public void handleException(LdapException exception) {
                        h.handleError(Rest2LDAP.asResourceException((Throwable)exception));
                    }
                });
            }
        });
    }

    public void updateInstance(ServerContext context, final String resourceId, final UpdateRequest request, ResultHandler<Resource> handler) {
        final Context c = this.wrap(context);
        final ResultHandler<Resource> h = this.wrap(c, handler);
        c.run(h, new Runnable(){

            @Override
            public void run() {
                String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, Collections.emptyList());
                SearchRequest searchRequest = LDAPCollectionResourceProvider.this.nameStrategy.createSearchRequest(c, LDAPCollectionResourceProvider.this.getBaseDN(c), resourceId).addAttribute(attributes);
                c.getConnection().searchSingleEntryAsync(searchRequest).thenOnResult((org.forgerock.util.promise.ResultHandler)new org.forgerock.util.promise.ResultHandler<SearchResultEntry>(){

                    public void handleResult(final SearchResultEntry entry) {
                        try {
                            LDAPCollectionResourceProvider.this.ensureMVCCVersionMatches((Entry)entry, request.getRevision());
                            final ModifyRequest modifyRequest = Requests.newModifyRequest((DN)entry.getName());
                            if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                                String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(c, request.getFields());
                                modifyRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, (String[])attributes));
                            }
                            if (LDAPCollectionResourceProvider.this.config.usePermissiveModify()) {
                                modifyRequest.addControl((Control)PermissiveModifyRequestControl.newControl((boolean)true));
                            }
                            LDAPCollectionResourceProvider.this.addAssertionControl((ChangeRecord)modifyRequest, request.getRevision());
                            LDAPCollectionResourceProvider.this.attributeMapper.update(c, new JsonPointer(), (Entry)entry, request.getNewContent(), new ResultHandler<List<Modification>>(){

                                public void handleError(ResourceException error) {
                                    h.handleError(error);
                                }

                                public void handleResult(List<Modification> result) {
                                    if (result.isEmpty()) {
                                        LDAPCollectionResourceProvider.this.adaptEntry(c, (Entry)entry, (ResultHandler<Resource>)h);
                                    } else {
                                        modifyRequest.getModifications().addAll(result);
                                        c.getConnection().applyChangeAsync((ChangeRecord)modifyRequest).thenOnResult(LDAPCollectionResourceProvider.this.postUpdateResultHandler(c, (ResultHandler<Resource>)h)).thenOnException(LDAPCollectionResourceProvider.this.postUpdateExceptionHandler((ResultHandler<Resource>)h));
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            h.handleError(Rest2LDAP.asResourceException(e));
                        }
                    }
                }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                    public void handleException(LdapException exception) {
                        h.handleError(Rest2LDAP.asResourceException((Throwable)exception));
                    }
                });
            }
        });
    }

    private void adaptEntry(Context c, Entry entry, ResultHandler<Resource> handler) {
        final String actualResourceId = this.nameStrategy.getResourceId(c, entry);
        final String revision = this.getRevisionFromEntry(entry);
        this.attributeMapper.read(c, new JsonPointer(), entry, Utils.transform(new Function<JsonValue, Resource, NeverThrowsException>(){

            public Resource apply(JsonValue value) {
                return new Resource(actualResourceId, revision, new JsonValue((Object)value));
            }
        }, handler));
    }

    private void addAssertionControl(ChangeRecord request, String expectedRevision) throws ResourceException {
        if (expectedRevision != null) {
            this.ensureMVCCSupported();
            request.addControl((Control)AssertionRequestControl.newControl((boolean)true, (Filter)Filter.equality((String)this.etagAttribute.toString(), (Object)expectedRevision)));
        }
    }

    private Runnable doUpdate(final Context c, final String resourceId, final String revision, final ResultHandler<DN> updateHandler) {
        return new Runnable(){

            @Override
            public void run() {
                String ldapAttribute = LDAPCollectionResourceProvider.this.etagAttribute != null && revision != null ? LDAPCollectionResourceProvider.this.etagAttribute.toString() : "1.1";
                SearchRequest searchRequest = LDAPCollectionResourceProvider.this.nameStrategy.createSearchRequest(c, LDAPCollectionResourceProvider.this.getBaseDN(c), resourceId).addAttribute(new String[]{ldapAttribute});
                if (searchRequest.getScope().equals((Object)SearchScope.BASE_OBJECT)) {
                    updateHandler.handleResult((Object)searchRequest.getName());
                } else {
                    c.getConnection().searchSingleEntryAsync(searchRequest).thenOnResult((org.forgerock.util.promise.ResultHandler)new org.forgerock.util.promise.ResultHandler<SearchResultEntry>(){

                        public void handleResult(SearchResultEntry entry) {
                            try {
                                LDAPCollectionResourceProvider.this.ensureMVCCVersionMatches((Entry)entry, revision);
                                updateHandler.handleResult((Object)entry.getName());
                            }
                            catch (Exception e) {
                                updateHandler.handleError(Rest2LDAP.asResourceException(e));
                            }
                        }
                    }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                        public void handleException(LdapException exception) {
                            updateHandler.handleError(Rest2LDAP.asResourceException((Throwable)exception));
                        }
                    });
                }
            }
        };
    }

    private void ensureMVCCSupported() throws NotSupportedException {
        if (this.etagAttribute == null) {
            throw new NotSupportedException(Utils.i18n("Multi-version concurrency control is not supported by this resource", new Object[0]));
        }
    }

    private void ensureMVCCVersionMatches(Entry entry, String expectedRevision) throws ResourceException {
        if (expectedRevision != null) {
            this.ensureMVCCSupported();
            String actualRevision = entry.parseAttribute(this.etagAttribute).asString();
            if (actualRevision == null) {
                throw new PreconditionFailedException(Utils.i18n("The resource could not be accessed because it did not contain any version information, when the version '%s' was expected", expectedRevision));
            }
            if (!expectedRevision.equals(actualRevision)) {
                throw new PreconditionFailedException(Utils.i18n("The resource could not be accessed because the expected version '%s' does not match the current version '%s'", expectedRevision, actualRevision));
            }
        }
    }

    private DN getBaseDN(Context context) {
        return this.baseDN;
    }

    private String[] getLDAPAttributes(Context c, Collection<JsonPointer> requestedAttributes) {
        LinkedHashSet<String> requestedLDAPAttributes;
        if (requestedAttributes.isEmpty()) {
            requestedLDAPAttributes = new LinkedHashSet<String>();
            this.attributeMapper.getLDAPAttributes(c, new JsonPointer(), new JsonPointer(), requestedLDAPAttributes);
        } else {
            requestedLDAPAttributes = new LinkedHashSet(requestedAttributes.size());
            for (JsonPointer requestedAttribute : requestedAttributes) {
                this.attributeMapper.getLDAPAttributes(c, new JsonPointer(), requestedAttribute, requestedLDAPAttributes);
            }
        }
        this.nameStrategy.getLDAPAttributes(c, requestedLDAPAttributes);
        if (this.etagAttribute != null) {
            requestedLDAPAttributes.add(this.etagAttribute.toString());
        }
        return requestedLDAPAttributes.toArray(new String[requestedLDAPAttributes.size()]);
    }

    private void getLDAPFilter(final Context c, QueryFilter queryFilter, ResultHandler<Filter> h) {
        QueryFilterVisitor<Void, ResultHandler<Filter>> visitor = new QueryFilterVisitor<Void, ResultHandler<Filter>>(){

            public Void visitAndFilter(final ResultHandler<Filter> p, List<QueryFilter> subFilters) {
                ArrayList<PromiseImpl> promises = new ArrayList<PromiseImpl>(subFilters.size());
                for (QueryFilter subFilter : subFilters) {
                    ResultHandlerFromPromise handler = new ResultHandlerFromPromise();
                    subFilter.accept((QueryFilterVisitor)this, handler);
                    promises.add(handler.promise);
                }
                Promises.when(promises).then((Function)new Function<List<Filter>, Filter, ResourceException>(){

                    public Filter apply(List<Filter> value) {
                        Iterator<Filter> i = value.iterator();
                        while (i.hasNext()) {
                            Filter f = i.next();
                            if (f == Filter.alwaysFalse()) {
                                return Filter.alwaysFalse();
                            }
                            if (f != Filter.alwaysTrue()) continue;
                            i.remove();
                        }
                        switch (value.size()) {
                            case 0: {
                                return Filter.alwaysTrue();
                            }
                            case 1: {
                                return value.get(0);
                            }
                        }
                        return Filter.and(value);
                    }
                }).thenOnResult((org.forgerock.util.promise.ResultHandler)new org.forgerock.util.promise.ResultHandler<Filter>(){

                    public void handleResult(Filter result) {
                        p.handleResult((Object)result);
                    }
                }).thenOnException((ExceptionHandler)new ExceptionHandler<ResourceException>(){

                    public void handleException(ResourceException exception) {
                        p.handleError(exception);
                    }
                });
                return null;
            }

            public Void visitBooleanLiteralFilter(ResultHandler<Filter> p, boolean value) {
                p.handleResult((Object)Utils.toFilter(value));
                return null;
            }

            public Void visitContainsFilter(ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.CONTAINS, null, valueAssertion, p);
                return null;
            }

            public Void visitEqualsFilter(ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.EQUAL_TO, null, valueAssertion, p);
                return null;
            }

            public Void visitExtendedMatchFilter(ResultHandler<Filter> p, JsonPointer field, String operator, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.EXTENDED, operator, valueAssertion, p);
                return null;
            }

            public Void visitGreaterThanFilter(ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.GREATER_THAN, null, valueAssertion, p);
                return null;
            }

            public Void visitGreaterThanOrEqualToFilter(ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.GREATER_THAN_OR_EQUAL_TO, null, valueAssertion, p);
                return null;
            }

            public Void visitLessThanFilter(ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.LESS_THAN, null, valueAssertion, p);
                return null;
            }

            public Void visitLessThanOrEqualToFilter(ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.LESS_THAN_OR_EQUAL_TO, null, valueAssertion, p);
                return null;
            }

            public Void visitNotFilter(ResultHandler<Filter> p, QueryFilter subFilter) {
                subFilter.accept((QueryFilterVisitor)this, Utils.transform(new Function<Filter, Filter, NeverThrowsException>(){

                    public Filter apply(Filter value) {
                        if (value == null || value == Filter.alwaysFalse()) {
                            return Filter.alwaysTrue();
                        }
                        if (value == Filter.alwaysTrue()) {
                            return Filter.alwaysFalse();
                        }
                        return Filter.not((Filter)value);
                    }
                }, p));
                return null;
            }

            public Void visitOrFilter(final ResultHandler<Filter> p, List<QueryFilter> subFilters) {
                ArrayList<PromiseImpl> promises = new ArrayList<PromiseImpl>(subFilters.size());
                for (QueryFilter subFilter : subFilters) {
                    ResultHandlerFromPromise handler = new ResultHandlerFromPromise();
                    subFilter.accept((QueryFilterVisitor)this, handler);
                    promises.add(handler.promise);
                }
                Promises.when(promises).then((Function)new Function<List<Filter>, Filter, ResourceException>(){

                    public Filter apply(List<Filter> value) {
                        Iterator<Filter> i = value.iterator();
                        while (i.hasNext()) {
                            Filter f = i.next();
                            if (f == Filter.alwaysFalse()) {
                                i.remove();
                                continue;
                            }
                            if (f != Filter.alwaysTrue()) continue;
                            return Filter.alwaysTrue();
                        }
                        switch (value.size()) {
                            case 0: {
                                return Filter.alwaysFalse();
                            }
                            case 1: {
                                return value.get(0);
                            }
                        }
                        return Filter.or(value);
                    }
                }).thenOnResult((org.forgerock.util.promise.ResultHandler)new org.forgerock.util.promise.ResultHandler<Filter>(){

                    public void handleResult(Filter result) {
                        p.handleResult((Object)result);
                    }
                }).thenOnException((ExceptionHandler)new ExceptionHandler<ResourceException>(){

                    public void handleException(ResourceException exception) {
                        p.handleError(exception);
                    }
                });
                return null;
            }

            public Void visitPresentFilter(ResultHandler<Filter> p, JsonPointer field) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.PRESENT, null, null, p);
                return null;
            }

            public Void visitStartsWithFilter(ResultHandler<Filter> p, JsonPointer field, Object valueAssertion) {
                LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(c, new JsonPointer(), field, FilterType.STARTS_WITH, null, valueAssertion, p);
                return null;
            }
        };
        queryFilter.accept((QueryFilterVisitor)visitor, h);
    }

    private String getRevisionFromEntry(Entry entry) {
        return this.etagAttribute != null ? entry.parseAttribute(this.etagAttribute).asString() : null;
    }

    private org.forgerock.util.promise.ResultHandler<SearchResultEntry> postEmptyPatchResultHandler(final Context c, final PatchRequest request, final ResultHandler<Resource> h) {
        return new org.forgerock.util.promise.ResultHandler<SearchResultEntry>(){

            public void handleResult(SearchResultEntry entry) {
                try {
                    LDAPCollectionResourceProvider.this.ensureMVCCVersionMatches((Entry)entry, request.getRevision());
                    LDAPCollectionResourceProvider.this.adaptEntry(c, (Entry)entry, (ResultHandler<Resource>)h);
                }
                catch (Exception e) {
                    h.handleError(Rest2LDAP.asResourceException(e));
                }
            }
        };
    }

    private ExceptionHandler<LdapException> postEmptyPatchExceptionHandler(final ResultHandler<Resource> h) {
        return new ExceptionHandler<LdapException>(){

            public void handleException(LdapException exception) {
                h.handleError(Rest2LDAP.asResourceException((Throwable)exception));
            }
        };
    }

    private org.forgerock.util.promise.ResultHandler<Result> postUpdateResultHandler(final Context c, final ResultHandler<Resource> handler) {
        return new org.forgerock.util.promise.ResultHandler<Result>(){

            public void handleResult(Result result) {
                Object entry;
                try {
                    PreReadResponseControl preReadControl;
                    PostReadResponseControl postReadControl = (PostReadResponseControl)result.getControl(PostReadResponseControl.DECODER, LDAPCollectionResourceProvider.this.config.decodeOptions());
                    entry = postReadControl != null ? postReadControl.getEntry() : ((preReadControl = (PreReadResponseControl)result.getControl(PreReadResponseControl.DECODER, LDAPCollectionResourceProvider.this.config.decodeOptions())) != null ? preReadControl.getEntry() : null);
                }
                catch (DecodeException e) {
                    entry = null;
                }
                if (entry != null) {
                    LDAPCollectionResourceProvider.this.adaptEntry(c, entry, (ResultHandler<Resource>)handler);
                } else {
                    Resource resource = new Resource(null, null, new JsonValue(Collections.emptyMap()));
                    handler.handleResult((Object)resource);
                }
            }
        };
    }

    private ExceptionHandler<LdapException> postUpdateExceptionHandler(final ResultHandler<Resource> handler) {
        return new ExceptionHandler<LdapException>(){

            public void handleException(LdapException exception) {
                handler.handleError(Rest2LDAP.asResourceException((Throwable)exception));
            }
        };
    }

    private QueryResultHandler wrap(final Context c, final QueryResultHandler handler) {
        return new QueryResultHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleError(ResourceException error) {
                try {
                    handler.handleError(error);
                }
                finally {
                    c.close();
                }
            }

            public boolean handleResource(Resource resource) {
                return handler.handleResource(resource);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResult(QueryResult result) {
                try {
                    handler.handleResult(result);
                }
                finally {
                    c.close();
                }
            }
        };
    }

    private <V> ResultHandler<V> wrap(final Context c, final ResultHandler<V> handler) {
        return new ResultHandler<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleError(ResourceException error) {
                try {
                    handler.handleError(error);
                }
                finally {
                    c.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResult(V result) {
                try {
                    handler.handleResult(result);
                }
                finally {
                    c.close();
                }
            }
        };
    }

    private Context wrap(ServerContext context) {
        return new Context(this.config, context);
    }

    private static class ResultHandlerFromPromise<T>
    implements ResultHandler<T> {
        private final PromiseImpl<T, ResourceException> promise = PromiseImpl.create();

        ResultHandlerFromPromise() {
        }

        public void handleError(ResourceException error) {
            this.promise.handleException((Exception)((Object)error));
        }

        public void handleResult(T result) {
            this.promise.handleResult(result);
        }
    }
}

