/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.AuthorizationPolicy;
import org.forgerock.opendj.rest2ldap.AuthzIdTemplate;
import org.forgerock.opendj.rest2ldap.ReadOnUpdatePolicy;

final class Config {
    private final AuthorizationPolicy authzPolicy;
    private final ConnectionFactory factory;
    private final DecodeOptions options;
    private final AuthzIdTemplate proxiedAuthzTemplate;
    private final ReadOnUpdatePolicy readOnUpdatePolicy;
    private final Schema schema;
    private final boolean useSubtreeDelete;
    private final boolean usePermissiveModify;

    Config(ConnectionFactory factory, ReadOnUpdatePolicy readOnUpdatePolicy, AuthorizationPolicy authzPolicy, AuthzIdTemplate proxiedAuthzTemplate, boolean useSubtreeDelete, boolean usePermissiveModify, Schema schema) {
        this.factory = factory;
        this.readOnUpdatePolicy = readOnUpdatePolicy;
        this.authzPolicy = authzPolicy;
        this.proxiedAuthzTemplate = proxiedAuthzTemplate;
        this.useSubtreeDelete = useSubtreeDelete;
        this.usePermissiveModify = usePermissiveModify;
        this.schema = schema;
        this.options = new DecodeOptions().setSchema(schema);
    }

    ConnectionFactory connectionFactory() {
        return this.factory;
    }

    DecodeOptions decodeOptions() {
        return this.options;
    }

    AuthorizationPolicy getAuthorizationPolicy() {
        return this.authzPolicy;
    }

    AuthzIdTemplate getProxiedAuthorizationTemplate() {
        return this.proxiedAuthzTemplate;
    }

    boolean usePermissiveModify() {
        return this.usePermissiveModify;
    }

    boolean useSubtreeDelete() {
        return this.useSubtreeDelete;
    }

    ReadOnUpdatePolicy readOnUpdatePolicy() {
        return this.readOnUpdatePolicy;
    }

    Schema schema() {
        return this.schema;
    }
}

