/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.Context;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.opendj.rest2ldap.WritabilityPolicy;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;

abstract class AbstractLDAPAttributeMapper<T extends AbstractLDAPAttributeMapper<T>>
extends AttributeMapper {
    List<Object> defaultJSONValues = Collections.emptyList();
    final AttributeDescription ldapAttributeName;
    private boolean isRequired;
    private boolean isSingleValued;
    private WritabilityPolicy writabilityPolicy = WritabilityPolicy.READ_WRITE;

    AbstractLDAPAttributeMapper(AttributeDescription ldapAttributeName) {
        this.ldapAttributeName = ldapAttributeName;
    }

    public final T isRequired() {
        this.isRequired = true;
        return this.getThis();
    }

    public final T isSingleValued() {
        this.isSingleValued = true;
        return this.getThis();
    }

    public final T writability(WritabilityPolicy policy) {
        this.writabilityPolicy = policy;
        return this.getThis();
    }

    boolean attributeIsSingleValued() {
        return this.isSingleValued || this.ldapAttributeName.getAttributeType().isSingleValue();
    }

    @Override
    void create(Context c, JsonPointer path, JsonValue v, ResultHandler<List<Attribute>> h) {
        this.getNewLDAPAttributes(c, path, v, this.createAttributeHandler(path, h));
    }

    @Override
    void getLDAPAttributes(Context c, JsonPointer path, JsonPointer subPath, Set<String> ldapAttributes) {
        ldapAttributes.add(this.ldapAttributeName.toString());
    }

    abstract void getNewLDAPAttributes(Context var1, JsonPointer var2, List<Object> var3, ResultHandler<Attribute> var4);

    abstract T getThis();

    @Override
    void patch(Context c, JsonPointer path, PatchOperation operation, ResultHandler<List<Modification>> h) {
        try {
            ModificationType modType;
            JsonPointer field = operation.getField();
            JsonValue v = operation.getValue();
            if (!this.writabilityPolicy.canWrite(this.ldapAttributeName)) {
                throw new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to modify the read-only field '%s'", path));
            }
            switch (field.size()) {
                case 0: {
                    if (this.attributeIsSingleValued()) {
                        if (!v.isList()) break;
                        throw new BadRequestException(Utils.i18n("The request cannot be processed because an array of values was provided for the single valued field '%s'", path));
                    }
                    if (v.isList() || operation.isIncrement() || v.isNull() && (operation.isReplace() || operation.isRemove())) break;
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because an array of values was not provided for the multi-valued field '%s'", path));
                }
                case 1: {
                    String fieldName = field.get(0);
                    if (fieldName.equals("-") && operation.isAdd()) {
                        if (this.attributeIsSingleValued()) {
                            throw new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to append a value to the single valued field '%s'", path));
                        }
                        if (!v.isList()) break;
                        throw new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to perform an indexed append of an array of values to the multi-valued field '%s'", path.child(fieldName)));
                    }
                    if (fieldName.matches("[0-9]+")) {
                        throw new NotSupportedException(Utils.i18n("The request cannot be processed because it included an indexed patch operation '%s' which is not supported by this resource provider", path.child(fieldName)));
                    }
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because it included an unrecognized field '%s'", path.child(fieldName)));
                }
                default: {
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because it included an unrecognized field '%s'", path.child(field.get(0))));
                }
            }
            List<Object> newValues = this.asList(v, Collections.emptyList());
            if (operation.isAdd()) {
                ModificationType modificationType = modType = this.attributeIsSingleValued() ? ModificationType.REPLACE : ModificationType.ADD;
                if (newValues.isEmpty()) {
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because it included an add patch operation but no value(s) for field '%s'", path.child(field.get(0))));
                }
            } else if (operation.isRemove()) {
                modType = ModificationType.DELETE;
            } else if (operation.isReplace()) {
                modType = ModificationType.REPLACE;
            } else if (operation.isIncrement()) {
                modType = ModificationType.INCREMENT;
            } else {
                throw new NotSupportedException(Utils.i18n("The request cannot be processed because it included an unsupported type of patch operation '%s'", operation.getOperation()));
            }
            if (newValues.isEmpty()) {
                if (this.isRequired) {
                    h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to remove the required field '%s'", path)));
                } else {
                    h.handleResult(Collections.singletonList(new Modification(modType, Attributes.emptyAttribute((AttributeDescription)this.ldapAttributeName))));
                }
            } else {
                this.getNewLDAPAttributes(c, path, newValues, Utils.transform(new Function<Attribute, List<Modification>, NeverThrowsException>(){

                    public List<Modification> apply(Attribute value) {
                        return Collections.singletonList(new Modification(modType, value));
                    }
                }, h));
            }
        }
        catch (RuntimeException e) {
            h.handleError(Rest2LDAP.asResourceException(e));
        }
        catch (ResourceException e) {
            h.handleError(e);
        }
    }

    @Override
    void update(Context c, JsonPointer path, Entry e, JsonValue v, ResultHandler<List<Modification>> h) {
        this.getNewLDAPAttributes(c, path, v, this.updateAttributeHandler(path, e, h));
    }

    private List<Object> asList(JsonValue v, List<Object> defaultValues) {
        if (Utils.isNullOrEmpty(v)) {
            return defaultValues;
        }
        if (v.isList()) {
            return v.asList();
        }
        return Collections.singletonList(v.getObject());
    }

    private void checkSchema(JsonPointer path, JsonValue v) throws BadRequestException {
        if (this.attributeIsSingleValued()) {
            if (v != null && v.isList()) {
                throw new BadRequestException(Utils.i18n("The request cannot be processed because an array of values was provided for the single valued field '%s'", path));
            }
        } else if (v != null && !v.isList()) {
            throw new BadRequestException(Utils.i18n("The request cannot be processed because an array of values was not provided for the multi-valued field '%s'", path));
        }
    }

    private ResultHandler<Attribute> createAttributeHandler(final JsonPointer path, final ResultHandler<List<Attribute>> h) {
        return new ResultHandler<Attribute>(){

            public void handleError(ResourceException error) {
                h.handleError(error);
            }

            public void handleResult(Attribute newLDAPAttribute) {
                if (!AbstractLDAPAttributeMapper.this.writabilityPolicy.canCreate(AbstractLDAPAttributeMapper.this.ldapAttributeName)) {
                    if (newLDAPAttribute.isEmpty() || AbstractLDAPAttributeMapper.this.writabilityPolicy.discardWrites()) {
                        h.handleResult(Collections.emptyList());
                    } else {
                        h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to create the read-only field '%s'", path)));
                    }
                } else if (newLDAPAttribute.isEmpty()) {
                    if (AbstractLDAPAttributeMapper.this.isRequired) {
                        h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to remove the required field '%s'", path)));
                        return;
                    }
                    h.handleResult(Collections.emptyList());
                } else {
                    h.handleResult(Collections.singletonList(newLDAPAttribute));
                }
            }
        };
    }

    private void getNewLDAPAttributes(Context c, JsonPointer path, JsonValue v, ResultHandler<Attribute> attributeHandler) {
        try {
            this.checkSchema(path, v);
            List<Object> newValues = this.asList(v, this.defaultJSONValues);
            if (newValues.isEmpty()) {
                attributeHandler.handleResult((Object)Attributes.emptyAttribute((AttributeDescription)this.ldapAttributeName));
            } else {
                this.getNewLDAPAttributes(c, path, newValues, attributeHandler);
            }
        }
        catch (Exception ex) {
            attributeHandler.handleError(Rest2LDAP.asResourceException(ex));
        }
    }

    private ResultHandler<Attribute> updateAttributeHandler(final JsonPointer path, Entry e, final ResultHandler<List<Modification>> h) {
        Attribute tmp = e.getAttribute(this.ldapAttributeName);
        final Attribute oldLDAPAttribute = tmp != null ? tmp : Attributes.emptyAttribute((AttributeDescription)this.ldapAttributeName);
        return new ResultHandler<Attribute>(){

            public void handleError(ResourceException error) {
                h.handleError(error);
            }

            public void handleResult(Attribute newLDAPAttribute) {
                if (!AbstractLDAPAttributeMapper.this.writabilityPolicy.canWrite(AbstractLDAPAttributeMapper.this.ldapAttributeName)) {
                    if (newLDAPAttribute.isEmpty() || newLDAPAttribute.equals((Object)oldLDAPAttribute) || AbstractLDAPAttributeMapper.this.writabilityPolicy.discardWrites()) {
                        h.handleResult(Collections.emptyList());
                    } else {
                        h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to modify the read-only field '%s'", path)));
                    }
                } else {
                    List<Object> modifications;
                    if (oldLDAPAttribute.isEmpty() && newLDAPAttribute.isEmpty()) {
                        modifications = Collections.emptyList();
                    } else if (oldLDAPAttribute.isEmpty()) {
                        modifications = Collections.singletonList(new Modification(ModificationType.REPLACE, newLDAPAttribute));
                    } else if (newLDAPAttribute.isEmpty()) {
                        if (AbstractLDAPAttributeMapper.this.isRequired) {
                            h.handleError((ResourceException)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to remove the required field '%s'", path)));
                            return;
                        }
                        modifications = Collections.singletonList(new Modification(ModificationType.REPLACE, newLDAPAttribute));
                    } else {
                        modifications = new ArrayList(2);
                        LinkedAttribute deletedValues = new LinkedAttribute(oldLDAPAttribute);
                        deletedValues.removeAll((Collection)newLDAPAttribute);
                        if (!deletedValues.isEmpty()) {
                            modifications.add(new Modification(ModificationType.DELETE, (Attribute)deletedValues));
                        }
                        LinkedAttribute addedValues = new LinkedAttribute(newLDAPAttribute);
                        addedValues.removeAll((Collection)oldLDAPAttribute);
                        if (!addedValues.isEmpty()) {
                            modifications.add(new Modification(ModificationType.ADD, (Attribute)addedValues));
                        }
                    }
                    h.handleResult(modifications);
                }
            }
        };
    }
}

