/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.setup.model;

import java.util.ArrayList;
import org.forgerock.opendj.server.setup.model.Certificate;
import org.forgerock.opendj.server.setup.model.ListenerSettings;
import org.forgerock.opendj.server.setup.model.Model;

final class ModelUtils {
    static final String OBFUSCATED_VALUE = "******";

    ModelUtils() {
    }

    ArrayList<String> getSetupEquivalentCommandLine(Model configuration) {
        ArrayList<String> cmdLines = new ArrayList<String>();
        ListenerSettings settings = configuration.getListenerSettings();
        if (configuration.getType() == Model.Type.STANDALONE && !configuration.isStartingServerAfterSetup()) {
            cmdLines.add("--doNotStart");
        }
        if (configuration.isSecure()) {
            if (settings.isTLSEnabled()) {
                cmdLines.add("--enableStartTLS");
            }
            if (settings.isSSLEnabled()) {
                cmdLines.add("--ldapsPort");
                cmdLines.add(String.valueOf(settings.getSSLPortNumber()));
            }
            Certificate certificate = settings.getCertificate();
            switch (certificate.getType()) {
                case SELF_SIGNED: {
                    cmdLines.add("--generateSelfSignedCertificate");
                    cmdLines.add("--hostName");
                    cmdLines.add(settings.getHostName());
                    break;
                }
                case JKS: {
                    this.appendKeystoreCliOptionsWithPath(cmdLines, "--useJavaKeystore", certificate);
                    break;
                }
                case JCEKS: {
                    this.appendKeystoreCliOptionsWithPath(cmdLines, "--useJCEKS", certificate);
                    break;
                }
                case PKCS12: {
                    this.appendKeystoreCliOptionsWithPath(cmdLines, "--usePkcs12keyStore", certificate);
                    break;
                }
                case PKCS11: {
                    cmdLines.add("--usePkcs11Keystore");
                    this.appendKeystoreCliOptions(cmdLines, certificate);
                }
            }
        }
        cmdLines.add("--no-prompt");
        cmdLines.add("--noPropertiesFile");
        return cmdLines;
    }

    private void appendKeystoreCliOptionsWithPath(ArrayList<String> cmdLines, String cliOption, Certificate certificate) {
        cmdLines.add(cliOption);
        cmdLines.add(certificate.getKeyStoreFile().getAbsolutePath());
        this.appendKeystoreCliOptions(cmdLines, certificate);
    }

    private void appendKeystoreCliOptions(ArrayList<String> cmdLines, Certificate certificate) {
        if (certificate.getKeyStorePin() != null) {
            cmdLines.add("--keyStorePassword");
            cmdLines.add(OBFUSCATED_VALUE);
        }
        if (!certificate.getCertNickName().isEmpty()) {
            cmdLines.add("--certNickname");
            cmdLines.add(certificate.getCertNickName());
        }
    }
}

