/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.setup.model;

import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.server.setup.model.DataConfiguration;
import org.forgerock.opendj.server.setup.model.ListenerSettings;
import org.forgerock.opendj.server.setup.model.ReplicationConfiguration;
import org.forgerock.opendj.server.setup.model.RuntimeOptions;
import org.forgerock.util.Reject;

public abstract class Model {
    private Type type;
    private boolean startingServerAfterSetup;
    private boolean isService;
    private String instancePath;
    private String installationPath;
    private String license;
    private ListenerSettings settings;
    private RuntimeOptions serverRuntimeSettings;
    private RuntimeOptions importLdifRuntimeSettings;
    private DataConfiguration dataConfiguration;
    private ReplicationConfiguration replicationConfiguration;

    public ListenerSettings getListenerSettings() {
        return this.settings;
    }

    public void setListenerSettings(ListenerSettings lSettings) {
        this.settings = lSettings;
    }

    public boolean hasLicense() {
        return this.license != null && !this.license.isEmpty();
    }

    boolean isStandAlone() {
        return this.type == Type.STANDALONE;
    }

    boolean isFirstInTopology() {
        return this.type == Type.FIRST_IN_TOPOLOGY;
    }

    boolean isPartOfReplicationTopology() {
        return this.type == Type.IN_EXISTING_TOPOLOGY;
    }

    boolean isSecure() {
        return this.getListenerSettings() != null && this.getListenerSettings().getCertificate() != null;
    }

    void setStandAloneDS() {
        this.setType(Type.STANDALONE);
    }

    void setFirstInTopology() {
        this.setType(Type.FIRST_IN_TOPOLOGY);
    }

    void setInExistingTopology() {
        this.setType(Type.IN_EXISTING_TOPOLOGY);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type mtype) {
        this.type = mtype;
    }

    public boolean isStartingServerAfterSetup() {
        return this.startingServerAfterSetup;
    }

    public void setStartingServerAfterSetup(boolean startServerAfterSetup) {
        this.startingServerAfterSetup = startServerAfterSetup;
    }

    public boolean isService() {
        return this.isService;
    }

    public void setService(boolean isAService) {
        this.isService = isAService;
    }

    public String getInstancePath() {
        return this.instancePath;
    }

    public void setInstancePath(String iPath) {
        this.instancePath = iPath;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String theLicense) {
        this.license = theLicense;
    }

    public RuntimeOptions getServerRuntimeSettings() {
        return this.serverRuntimeSettings;
    }

    public void setServerRuntimeOptions(RuntimeOptions settings) {
        this.serverRuntimeSettings = settings;
    }

    public RuntimeOptions getImportLdifRuntimeOptions() {
        return this.importLdifRuntimeSettings;
    }

    public void setImportLdifRuntimeOptions(RuntimeOptions settings) {
        this.importLdifRuntimeSettings = settings;
    }

    public DataConfiguration getDataConfiguration() {
        return this.dataConfiguration;
    }

    public void setDataConfiguration(DataConfiguration dConfiguration) {
        this.dataConfiguration = dConfiguration;
    }

    public ReplicationConfiguration getReplicationConfiguration() {
        return this.replicationConfiguration;
    }

    public void setReplicationConfiguration(ReplicationConfiguration replicationConfiguration) {
        this.replicationConfiguration = replicationConfiguration;
    }

    public String getInstallationPath() {
        return this.installationPath;
    }

    public void setInstallationPath(String installationPath) {
        this.installationPath = installationPath;
    }

    void validate() throws ConfigException {
        if (this.isFirstInTopology() || this.isPartOfReplicationTopology()) {
            if (this.getReplicationConfiguration() == null) {
                throw new ConfigException(LocalizableMessage.raw((CharSequence)"No replication configuration found", (Object[])new Object[0]));
            }
            if (this.isPartOfReplicationTopology()) {
                Reject.ifNull((Object)this.getReplicationConfiguration().getAdministrator(), (String)"Administrator name should not be null");
                Reject.ifNull((Object)this.getReplicationConfiguration().getPassword(), (String)"Admin password should not be null");
                Reject.ifNull((Object)this.getReplicationConfiguration().getGlobalAdministrator(), (String)"Global administrator should not be null");
                Reject.ifNull((Object)this.getReplicationConfiguration().getGlobalAdministratorPassword(), (String)"Global administrator should not be null");
                if (this.getReplicationConfiguration().getSuffixes() == null || this.getReplicationConfiguration().getSuffixes().size() == 0) {
                    throw new ConfigException(LocalizableMessage.raw((CharSequence)"At least one base DN should be selected to replicate content with", (Object[])new Object[0]));
                }
            }
        }
        ListenerSettings settings = this.getListenerSettings();
        DataConfiguration dataConf = this.getDataConfiguration();
        if (settings == null) {
            throw new ConfigException(LocalizableMessage.raw((CharSequence)"Invalid settings", (Object[])new Object[0]));
        }
        if (dataConf == null) {
            throw new ConfigException(LocalizableMessage.raw((CharSequence)"Invalid data configuration", (Object[])new Object[0]));
        }
        if (dataConf.isImportLDIF() && dataConf.getLdifImportDataPath() == null) {
            throw new ConfigException(LocalizableMessage.raw((CharSequence)"Invalid import ldif file.", (Object[])new Object[0]));
        }
        if (settings.getPasswordFile() == null && settings.getPassword() == null) {
            throw new ConfigException(LocalizableMessage.raw((CharSequence)"A password must be set for the root DN.", (Object[])new Object[0]));
        }
    }

    public static class DataStoreModel
    extends Model {
        public DataStoreModel() {
            this.setStandAloneDS();
            this.setDataConfiguration(new DataConfiguration());
            this.setListenerSettings(new ListenerSettings());
            this.setServerRuntimeOptions(RuntimeOptions.getDefault());
            this.setImportLdifRuntimeOptions(RuntimeOptions.getDefault());
            this.setStartingServerAfterSetup(true);
        }
    }

    public static enum Type {
        STANDALONE,
        FIRST_IN_TOPOLOGY,
        IN_EXISTING_TOPOLOGY;

    }
}

