/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.setup.model;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.forgerock.opendj.server.setup.model.Certificate;

public class ListenerSettings {
    private String hostName = "";
    private int ldapPort = 389;
    private int ldapsPort = 1636;
    private int adminPort = 1444;
    private boolean isJMXConnectionHandlerEnabled = false;
    private int jmxPort = 1689;
    private boolean isHTTPConnectionHandlerEnabled = true;
    private int httpPort = 8080;
    private boolean isSNMPConnectionHandlerEnabled = false;
    private int snmpPort = 161;
    private String rootUserDN = "cn=Directory Manager";
    private char[] password;
    private File passwordFile;
    private boolean isSSLEnabled = false;
    private boolean isTLSEnabled = false;
    private int sslPortNumber = 636;
    private Certificate certificate = null;

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getLdapPort() {
        return this.ldapPort;
    }

    public void setLdapPort(int ldapPort) {
        this.ldapPort = ldapPort;
    }

    public int getLdapsPort() {
        return this.ldapsPort;
    }

    public void setLdapsPort(int ldapsPort) {
        this.ldapsPort = ldapsPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    public int getJMXPort() {
        return this.jmxPort;
    }

    public void setJMXPort(int jmxPort) {
        this.jmxPort = jmxPort;
    }

    public boolean isJMXConnectionHandlerEnabled() {
        return this.isJMXConnectionHandlerEnabled;
    }

    public void setJMXConnectionHandlerEnabled(boolean isJMXConnectionHandlerEnabled) {
        this.isJMXConnectionHandlerEnabled = isJMXConnectionHandlerEnabled;
    }

    public int getHTTPPort() {
        return this.httpPort;
    }

    public void setHTTPPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public boolean isHTTPConnectionHandlerEnabled() {
        return this.isHTTPConnectionHandlerEnabled;
    }

    public void setHTTPConnectionHandlerEnabled(boolean isHTTPConnectionHandlerEnabled) {
        this.isHTTPConnectionHandlerEnabled = isHTTPConnectionHandlerEnabled;
    }

    public int getSNMPPort() {
        return this.snmpPort;
    }

    public void setSNMPPort(int snmpPort) {
        this.snmpPort = snmpPort;
    }

    public boolean isSNMPConnectionHandlerEnabled() {
        return this.isSNMPConnectionHandlerEnabled;
    }

    public void setSNMPConnectionHandlerEnabled(boolean isSNMPConnectionHandlerEnabled) {
        this.isSNMPConnectionHandlerEnabled = isSNMPConnectionHandlerEnabled;
    }

    public String getRootUserDN() {
        return this.rootUserDN;
    }

    public void setRootUserDN(String rootUserDN) {
        this.rootUserDN = rootUserDN;
    }

    public String getPassword() {
        if (this.password != null) {
            return String.valueOf(this.password);
        }
        return null;
    }

    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    public File getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(File pwdFile) {
        this.passwordFile = pwdFile;
    }

    public boolean isSSLEnabled() {
        return this.isSSLEnabled;
    }

    public void setSSLEnabled(boolean isSSLEnabled) {
        this.isSSLEnabled = isSSLEnabled;
    }

    public boolean isTLSEnabled() {
        return this.isTLSEnabled;
    }

    public void setTLSEnabled(boolean isTLSEnabled) {
        this.isTLSEnabled = isTLSEnabled;
    }

    public int getSSLPortNumber() {
        return this.sslPortNumber;
    }

    public void setSSLPortNumber(int sslPortNumber) {
        this.sslPortNumber = sslPortNumber;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    static int getFreeSocketPort(int startPortNumber) {
        return ListenerSettings.getFreeSocketPort(startPortNumber, new TestPortImpl());
    }

    private static int getFreeSocketPort(int startPortNumber, TestPort testPort) {
        for (int port = startPortNumber; port >= 0 && port <= 65535; port += 1000) {
            try {
                testPort.canBindToPort(port);
                return port;
            }
            catch (IOException e) {
                continue;
            }
        }
        throw new IllegalArgumentException("Invalid port.");
    }

    static class TestPortImpl
    implements TestPort {
        TestPortImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void canBindToPort(int portNumber) throws IOException {
            ServerSocket socket = null;
            try {
                socket = new ServerSocket();
                socket.setReuseAddress(true);
                socket.bind(new InetSocketAddress(portNumber));
            }
            finally {
                this.close(socket);
            }
        }

        private void close(ServerSocket socket) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static interface TestPort {
        public void canBindToPort(int var1) throws IOException;
    }
}

