/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.setup.model;

import java.io.File;

class DataConfiguration {
    static final String DEFAULT_DIRECTORY_BASE_DN = "dc=example,dc=com";
    static final int IMPORT_ENTRIES_DEFAULT_VALUE = 2000;
    private String directoryBaseDN = "dc=example,dc=com";
    private Type type = Type.AUTOMATICALLY_GENERATED;
    private File ldifImportDataPath;
    private int numberOfUserEntries = 2000;

    DataConfiguration() {
    }

    public String getDirectoryBaseDN() {
        return this.directoryBaseDN;
    }

    public void setDirectoryBaseDN(String directoryBaseDN) {
        this.directoryBaseDN = directoryBaseDN;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isOnlyBaseEntry() {
        return this.type == Type.BASE_ENTRY_ONLY;
    }

    public boolean isEmptyDatabase() {
        return this.type == Type.EMPTY_DATABASE;
    }

    public boolean isImportLDIF() {
        return this.type == Type.IMPORT_LDIF;
    }

    public boolean isAutomaticallyImportGenerated() {
        return this.type == Type.AUTOMATICALLY_GENERATED;
    }

    public File getLdifImportDataPath() {
        return this.ldifImportDataPath;
    }

    public void setLdifImportDataPath(File ldifImportDataPath) {
        this.ldifImportDataPath = ldifImportDataPath;
    }

    public int getNumberOfUserEntries() {
        return this.numberOfUserEntries;
    }

    public void setNumberOfUserEntries(int numberOfUserEntries) {
        this.numberOfUserEntries = numberOfUserEntries;
    }

    public static enum Type {
        BASE_ENTRY_ONLY,
        EMPTY_DATABASE,
        IMPORT_LDIF,
        AUTOMATICALLY_GENERATED;

    }
}

