/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.setup.model;

import java.io.File;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.server.ConfigException;

class Certificate {
    private CertificateType type = CertificateType.SELF_SIGNED;
    private String certNickName = "";
    private File keyStoreFile;
    private String keyStorePin = "";

    Certificate() {
    }

    public String getCertNickName() {
        return this.certNickName;
    }

    public void setCertNickName(String certNickName) {
        this.certNickName = certNickName;
    }

    public CertificateType getType() {
        return this.type;
    }

    public void setType(CertificateType type) {
        this.type = type;
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(File keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePin() {
        return this.keyStorePin;
    }

    public void setKeyStorePin(String keyStorePin) {
        this.keyStorePin = keyStorePin;
    }

    public void validate() throws ConfigException {
        if (this.type == CertificateType.JKS || this.type == CertificateType.JCEKS || this.type == CertificateType.PKCS12) {
            if (this.keyStoreFile == null || !this.keyStoreFile.exists()) {
                throw new ConfigException(LocalizableMessage.raw((CharSequence)"Invalid keystore file", (Object[])new Object[0]));
            }
            if (this.keyStorePin.isEmpty()) {
                throw new ConfigException(LocalizableMessage.raw((CharSequence)"Invalid key pin", (Object[])new Object[0]));
            }
        } else if (this.type == CertificateType.PKCS11 && this.keyStorePin.isEmpty()) {
            throw new ConfigException(LocalizableMessage.raw((CharSequence)"Invalid key pin", (Object[])new Object[0]));
        }
    }

    public static enum CertificateType {
        SELF_SIGNED,
        JKS,
        JCEKS,
        PKCS12,
        PKCS11;

    }
}

