/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.setup.cli;

import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ReturnCode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.forgerock.opendj.server.setup.cli.SetupCli;

final class SetupLog {
    private static File logFile;
    private static FileHandler fileHandler;
    static final String LOGNAME = "setup.log";

    private SetupLog() {
    }

    static void initLogFileHandler() {
        Logger logger = Logger.getLogger(SetupCli.class.getName());
        String space = " ";
        if (logFile == null) {
            logFile = new File(SetupCli.getInstallationPath() + File.separator + LOGNAME);
        }
        try {
            fileHandler = new FileHandler(logFile.getCanonicalPath(), true);
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        fileHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                StringBuffer sb = new StringBuffer();
                SimpleDateFormat dateFormat = new SimpleDateFormat("[dd/MMM/yyyy:HH:mm:ss Z]");
                sb.append(dateFormat.format(record.getMillis())).append(" ");
                sb.append("category=SETUP").append(" ").append("sq=").append(record.getSequenceNumber()).append(" ").append("severity=").append(record.getLevel().toString().toUpperCase());
                sb.append(" ").append("src=").append(record.getSourceClassName()).append(" ").append(record.getSourceMethodName()).append("\n");
                sb.append(" ").append("msg=").append(record.getMessage()).append("\n");
                return sb.toString();
            }
        });
        logger.setLevel(Level.CONFIG);
        logger.addHandler(fileHandler);
        logger.setUseParentHandlers(false);
        logger.info("**** Setup of OpenDJ3 started ****");
        logger.info(CliMessages.INFO_INSTALLATION_DIRECTORY.get((Object)SetupCli.getInstallationPath()).toString());
        logger.info(CliMessages.INFO_INSTANCE_DIRECTORY.get((Object)SetupCli.getInstancePath()).toString());
    }

    static PrintStream getPrintStream() throws ClientException {
        try {
            return new PrintStream(new FileOutputStream(logFile, true));
        }
        catch (FileNotFoundException e) {
            throw new ClientException(ReturnCode.ERROR_UNEXPECTED, CliMessages.ERR_INVALID_LOG_FILE.get((Object)e.getMessage()));
        }
    }

    public static File getLogFile() {
        return logFile;
    }
}

