/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.setup.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.cli.Utils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;

public final class SetupCli
extends ConsoleApplication {
    private static final LocalizedLogger LOG = LocalizedLogger.getLoggerForThisClass();
    private SubCommandArgumentParser argParser;
    private BooleanArgument cli;
    private BooleanArgument addBaseEntry;
    private BooleanArgument skipPortCheck;
    private BooleanArgument enableWindowsService;
    private BooleanArgument doNotStart;
    private BooleanArgument enableStartTLS;
    private BooleanArgument generateSelfSignedCertificate;
    private StringArgument hostName;
    private BooleanArgument usePkcs11;
    private FileBasedArgument directoryManagerPwdFile;
    private FileBasedArgument keyStorePasswordFile;
    private IntegerArgument ldapPort;
    private IntegerArgument adminConnectorPort;
    private IntegerArgument ldapsPort;
    private IntegerArgument jmxPort;
    private IntegerArgument sampleData;
    private StringArgument baseDN;
    private StringArgument importLDIF;
    private StringArgument rejectedImportFile;
    private StringArgument skippedImportFile;
    private StringArgument directoryManagerDN;
    private StringArgument directoryManagerPwdString;
    private StringArgument useJavaKeyStore;
    private StringArgument useJCEKS;
    private StringArgument usePkcs12;
    private StringArgument keyStorePassword;
    private StringArgument certNickname;
    private IntegerArgument connectTimeout;
    private BooleanArgument acceptLicense;
    private SubCommand createDirectoryServer;
    private SubCommand createProxy;
    private BooleanArgument noPrompt;
    private BooleanArgument quietMode;
    private BooleanArgument verbose;
    private StringArgument propertiesFile;
    private BooleanArgument noPropertiesFile;
    private BooleanArgument showUsage;

    static String getInstallationPath() {
        return "/home/violette/OpenDJ-3.0.0/";
    }

    static String getInstancePath() {
        return "/home/violette/OpenDJ-3.0.0/";
    }

    private SetupCli() {
    }

    SetupCli(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public static void main(String[] args) {
        int retCode = new SetupCli().run(args);
        System.exit(Utils.filterExitCode((int)retCode));
    }

    int run(String[] args) {
        try {
            Utils.checkJavaVersion();
        }
        catch (ClientException e) {
            this.errPrintln(e.getMessageObject());
            return ReturnCode.JAVA_VERSION_INCOMPATIBLE.get();
        }
        try {
            this.argParser = new SubCommandArgumentParser("setup", CliMessages.INFO_SETUP_DESCRIPTION.get(), true);
            this.initializeArguments();
        }
        catch (ArgumentException e) {
            LocalizableMessage message = CliMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)e.getMessage());
            this.errPrintln(message);
            return ReturnCode.CLIENT_SIDE_PARAM_ERROR.get();
        }
        try {
            this.argParser.parseArguments(args);
            if (this.argParser.usageOrVersionDisplayed()) {
                return ReturnCode.SUCCESS.get();
            }
        }
        catch (ArgumentException e) {
            LocalizableMessage message = CliMessages.ERR_ERROR_PARSING_ARGS.get((Object)e.getMessage());
            this.errPrintln(message);
            return ReturnCode.CLIENT_SIDE_PARAM_ERROR.get();
        }
        try {
            LinkedHashSet<LocalizableMessage> errorMessages = new LinkedHashSet<LocalizableMessage>();
            this.checkServerPassword(errorMessages);
            this.checkProvidedPorts(errorMessages);
            this.checkImportDataArguments(errorMessages);
            this.checkSecurityArguments(errorMessages);
            if (errorMessages.size() > 0) {
                throw new ArgumentException(CliMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)SetupCli.getMessageFromCollection(errorMessages, Utils.LINE_SEPARATOR)));
            }
        }
        catch (ArgumentException e) {
            this.errPrintln(e.getMessageObject());
            return ReturnCode.CLIENT_SIDE_PARAM_ERROR.get();
        }
        try {
            this.fillSetupSettings();
            this.runSetupInstallation();
        }
        catch (ClientException ex) {
            return ex.getReturnCode();
        }
        catch (Exception ex) {
            return ReturnCode.ERROR_UNEXPECTED.get();
        }
        return ReturnCode.SUCCESS.get();
    }

    private void initializeArguments() throws ArgumentException {
        this.acceptLicense = this.addGlobal(CommonArguments.getAcceptLicense());
        this.cli = this.addGlobal(CommonArguments.getCLI());
        this.baseDN = this.addGlobal(CommonArguments.getBaseDN());
        this.addBaseEntry = this.addGlobal(CommonArguments.getAddBaseEntry());
        this.importLDIF = this.addGlobal(CommonArguments.getLDIFFile((LocalizableMessage)CliMessages.INFO_DESCRIPTION_IMPORTLDIF.get()));
        this.rejectedImportFile = this.addGlobal(CommonArguments.getRejectedImportLdif());
        this.skippedImportFile = this.addGlobal(CommonArguments.getSkippedImportFile());
        this.sampleData = this.addGlobal(CommonArguments.getSampleData());
        this.ldapPort = this.addGlobal(CommonArguments.getLDAPPort((int)389));
        this.ldapsPort = this.addGlobal(CommonArguments.getLDAPSPort((int)1636));
        this.adminConnectorPort = this.addGlobal(CommonArguments.getAdminLDAPPort((int)1444));
        this.jmxPort = this.addGlobal(CommonArguments.getJMXPort((int)1689));
        this.skipPortCheck = this.addGlobal(CommonArguments.getSkipPortCheck());
        this.directoryManagerDN = this.addGlobal(CommonArguments.getRootDN());
        this.directoryManagerPwdString = this.addGlobal(CommonArguments.getRootDNPwd());
        this.directoryManagerPwdFile = this.addGlobal(CommonArguments.getRootDNPwdFile());
        this.enableWindowsService = this.addGlobal(CommonArguments.getEnableWindowsService());
        this.doNotStart = this.addGlobal(CommonArguments.getDoNotStart());
        this.enableStartTLS = this.addGlobal(CommonArguments.getEnableTLS());
        this.generateSelfSignedCertificate = this.addGlobal(CommonArguments.getGenerateSelfSigned());
        this.hostName = this.addGlobal(CommonArguments.getHostName((String)Utils.getDefaultHostName()));
        this.usePkcs11 = this.addGlobal(CommonArguments.getUsePKCS11Keystore());
        this.useJavaKeyStore = this.addGlobal(CommonArguments.getUseJavaKeyStore());
        this.useJCEKS = this.addGlobal(CommonArguments.getUseJCEKS());
        this.usePkcs12 = this.addGlobal(CommonArguments.getUsePKCS12KeyStore());
        this.keyStorePassword = this.addGlobal(CommonArguments.getKeyStorePassword());
        this.keyStorePasswordFile = this.addGlobal(CommonArguments.getKeyStorePasswordFile());
        this.certNickname = this.addGlobal(CommonArguments.getCertNickName());
        this.connectTimeout = CommonArguments.getConnectTimeOut();
        this.noPrompt = this.addGlobal(CommonArguments.getNoPrompt());
        this.quietMode = this.addGlobal(CommonArguments.getQuiet());
        this.verbose = this.addGlobal(CommonArguments.getVerbose());
        this.propertiesFile = this.addGlobal(CommonArguments.getPropertiesFile());
        this.noPropertiesFile = this.addGlobal(CommonArguments.getNoPropertiesFile());
        this.showUsage = this.addGlobal(CommonArguments.getShowUsage());
        ArrayList<SubCommand> subCommandList = new ArrayList<SubCommand>(2);
        this.createDirectoryServer = new SubCommand(this.argParser, "create-directory-server", CliMessages.INFO_SETUP_SUBCOMMAND_CREATE_DIRECTORY_SERVER.get());
        this.createProxy = new SubCommand(this.argParser, "create-proxy", CliMessages.INFO_SETUP_SUBCOMMAND_CREATE_PROXY.get());
        subCommandList.add(this.createDirectoryServer);
        subCommandList.add(this.createProxy);
        this.argParser.setUsageGroupArgument((Argument)this.showUsage, subCommandList);
        this.argParser.addArgument((Argument)this.showUsage);
        this.argParser.setUsageArgument((Argument)this.showUsage, (OutputStream)this.getOutputStream());
        this.argParser.addArgument((Argument)this.noPropertiesFile);
        this.argParser.setNoPropertiesFileArgument(this.noPropertiesFile);
        this.argParser.addArgument((Argument)this.propertiesFile);
        this.argParser.setFilePropertiesArgument(this.propertiesFile);
        this.argParser.addArgument((Argument)this.quietMode);
        this.argParser.addArgument((Argument)this.verbose);
        this.argParser.addArgument((Argument)this.noPrompt);
        this.argParser.addArgument((Argument)this.acceptLicense);
    }

    private <A extends Argument> A addGlobal(A arg) throws ArgumentException {
        this.argParser.addGlobalArgument(arg);
        return arg;
    }

    public boolean isInteractive() {
        return !this.noPrompt.isPresent();
    }

    public boolean isQuiet() {
        return this.quietMode.isPresent();
    }

    private boolean isAcceptLicense() {
        return this.acceptLicense.isPresent();
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    public boolean isCli() {
        return this.cli.isPresent();
    }

    public boolean isCreateProxy() {
        return this.argParser.getSubCommand("create-proxy") != null;
    }

    private void checkProvidedPorts(Collection<LocalizableMessage> errorMessages) {
        try {
            HashSet<Integer> ports = new HashSet<Integer>();
            ports.add(this.ldapPort.getIntValue());
            this.checkPortArgument(this.adminConnectorPort, ports, errorMessages);
            if (this.jmxPort.isPresent()) {
                this.checkPortArgument(this.jmxPort, ports, errorMessages);
            }
            if (this.ldapsPort.isPresent()) {
                this.checkPortArgument(this.ldapsPort, ports, errorMessages);
            }
        }
        catch (ArgumentException ae) {
            LOG.error(LocalizableMessage.raw((CharSequence)("Unexpected error. Assuming that it is caused by a previous parsing issue: " + (Object)((Object)ae)), (Object[])new Object[]{ae}));
        }
    }

    private void checkPortArgument(IntegerArgument portArg, Set<Integer> ports, Collection<LocalizableMessage> errorMessages) throws ArgumentException {
        if (ports.contains(portArg.getIntValue())) {
            errorMessages.add(CliMessages.ERR_PORT_ALREADY_SPECIFIED.get((Object)portArg.getIntValue()));
        } else {
            ports.add(portArg.getIntValue());
        }
    }

    private void checkImportDataArguments(Collection<LocalizableMessage> errorMessages) {
        if (this.addBaseEntry.isPresent()) {
            if (this.importLDIF.isPresent()) {
                errorMessages.add(CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.addBaseEntry.getLongIdentifier(), (Object)this.importLDIF.getLongIdentifier()));
            } else if (this.sampleData.isPresent()) {
                errorMessages.add(CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.addBaseEntry.getLongIdentifier(), (Object)this.sampleData.getLongIdentifier()));
            }
        } else if (this.importLDIF.isPresent() && this.sampleData.isPresent()) {
            errorMessages.add(CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.importLDIF.getLongIdentifier(), (Object)this.sampleData.getLongIdentifier()));
        }
        if (this.rejectedImportFile.isPresent() && this.addBaseEntry.isPresent()) {
            errorMessages.add(CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.addBaseEntry.getLongIdentifier(), (Object)this.rejectedImportFile.getLongIdentifier()));
        } else if (this.rejectedImportFile.isPresent() && this.sampleData.isPresent()) {
            errorMessages.add(CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.rejectedImportFile.getLongIdentifier(), (Object)this.sampleData.getLongIdentifier()));
        }
        if (this.skippedImportFile.isPresent() && this.addBaseEntry.isPresent()) {
            errorMessages.add(CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.addBaseEntry.getLongIdentifier(), (Object)this.skippedImportFile.getLongIdentifier()));
        } else if (this.skippedImportFile.isPresent() && this.sampleData.isPresent()) {
            errorMessages.add(CliMessages.ERR_TOOL_CONFLICTING_ARGS.get((Object)this.skippedImportFile.getLongIdentifier(), (Object)this.sampleData.getLongIdentifier()));
        }
        if (this.noPrompt.isPresent() && !this.baseDN.isPresent() && this.baseDN.getDefaultValue() == null) {
            Argument[] args;
            for (Argument arg : args = new Argument[]{this.importLDIF, this.addBaseEntry, this.sampleData}) {
                if (!arg.isPresent()) continue;
                errorMessages.add(CliMessages.ERR_ARGUMENT_NO_BASE_DN_SPECIFIED.get((Object)("--" + arg.getLongIdentifier())));
            }
        }
    }

    private void checkSecurityArguments(Collection<LocalizableMessage> errorMessages) {
        boolean certificateRequired = this.ldapsPort.isPresent() || this.enableStartTLS.isPresent();
        int certificateType = 0;
        if (this.generateSelfSignedCertificate.isPresent()) {
            ++certificateType;
        }
        if (this.useJavaKeyStore.isPresent()) {
            ++certificateType;
        }
        if (this.useJCEKS.isPresent()) {
            ++certificateType;
        }
        if (this.usePkcs11.isPresent()) {
            ++certificateType;
        }
        if (this.usePkcs12.isPresent()) {
            ++certificateType;
        }
        if (certificateType > 1) {
            errorMessages.add(CliMessages.ERR_SEVERAL_CERTIFICATE_TYPE_SPECIFIED.get());
        }
        if (certificateRequired && this.noPrompt.isPresent() && certificateType == 0) {
            errorMessages.add(CliMessages.ERR_CERTIFICATE_REQUIRED_FOR_SSL_OR_STARTTLS.get());
        }
        if (certificateType == 1) {
            LocalizableMessage message;
            if (!this.generateSelfSignedCertificate.isPresent()) {
                if (this.keyStorePassword.isPresent() && this.keyStorePasswordFile.isPresent()) {
                    message = CliMessages.ERR_TWO_CONFLICTING_ARGUMENTS.get((Object)this.keyStorePassword.getLongIdentifier(), (Object)this.keyStorePasswordFile.getLongIdentifier());
                    errorMessages.add(message);
                }
                if (this.noPrompt.isPresent() && !this.keyStorePassword.isPresent() && !this.keyStorePasswordFile.isPresent()) {
                    message = CliMessages.ERR_NO_KEYSTORE_PASSWORD.get((Object)this.keyStorePassword.getLongIdentifier(), (Object)this.keyStorePasswordFile.getLongIdentifier());
                    errorMessages.add(message);
                }
            }
            if (this.noPrompt.isPresent() && !this.ldapsPort.isPresent() && !this.enableStartTLS.isPresent()) {
                message = CliMessages.ERR_SSL_OR_STARTTLS_REQUIRED.get((Object)this.ldapsPort.getLongIdentifier(), (Object)this.enableStartTLS.getLongIdentifier());
                errorMessages.add(message);
            }
        }
    }

    private void checkServerPassword(Collection<LocalizableMessage> errorMessages) {
        if (this.directoryManagerPwdString.isPresent() && this.directoryManagerPwdFile.isPresent()) {
            errorMessages.add(CliMessages.ERR_TWO_CONFLICTING_ARGUMENTS.get((Object)this.directoryManagerPwdString.getLongIdentifier(), (Object)this.directoryManagerPwdFile.getLongIdentifier()));
        }
        if (this.noPrompt.isPresent() && !this.directoryManagerPwdString.isPresent() && !this.directoryManagerPwdFile.isPresent()) {
            errorMessages.add(CliMessages.ERR_NO_ROOT_PASSWORD.get((Object)this.directoryManagerPwdString.getLongIdentifier(), (Object)this.directoryManagerPwdFile.getLongIdentifier()));
        }
    }

    private static LocalizableMessage getMessageFromCollection(Collection<LocalizableMessage> col, String separator) {
        if (col == null || col.isEmpty()) {
            return LocalizableMessage.EMPTY;
        }
        LocalizableMessageBuilder mb = null;
        for (LocalizableMessage m : col) {
            if (mb == null) {
                mb = new LocalizableMessageBuilder(m);
                continue;
            }
            mb.append((CharSequence)separator).append(m);
        }
        return mb.toMessage();
    }

    private void fillSetupSettings() throws ArgumentException {
    }

    private void runSetupInstallation() throws ClientException {
    }
}

