/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.grizzly.GrizzlyMessages;
import com.forgerock.opendj.util.ReferenceCountedObject;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.DefaultTCPNIOTransport;
import org.forgerock.opendj.grizzly.GrizzlyLDAPConnection;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LDAPClientFilter;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.TimeoutChecker;
import org.forgerock.opendj.ldap.TimeoutEventListener;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.StartTLSExtendedRequest;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.spi.LDAPConnectionFactoryImpl;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.ResultHandler;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class GrizzlyLDAPConnectionFactory
implements LDAPConnectionFactoryImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final LDAPClientFilter clientFilter;
    private final FilterChain defaultFilterChain;
    private final LDAPOptions options;
    private final String host;
    private final int port;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final ReferenceCountedObject.Reference transport;
    private final ReferenceCountedObject.Reference timeoutChecker = TimeoutChecker.TIMEOUT_CHECKER.acquire();

    public GrizzlyLDAPConnectionFactory(String host, int port, LDAPOptions options) {
        this(host, port, options, null);
    }

    public GrizzlyLDAPConnectionFactory(String host, int port, LDAPOptions options, TCPNIOTransport transport) {
        this.transport = DefaultTCPNIOTransport.DEFAULT_TRANSPORT.acquireIfNull(transport);
        this.host = host;
        this.port = port;
        this.options = new LDAPOptions(options);
        this.clientFilter = new LDAPClientFilter(this.options.getDecodeOptions(), 0);
        this.defaultFilterChain = GrizzlyUtils.buildFilterChain(((TCPNIOTransport)this.transport.get()).getProcessor(), (Filter)this.clientFilter);
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.releaseTransportAndTimeoutChecker();
        }
    }

    public org.forgerock.opendj.ldap.Connection getConnection() throws LdapException {
        try {
            return (org.forgerock.opendj.ldap.Connection)this.getConnectionAsync().getOrThrow();
        }
        catch (InterruptedException e) {
            throw LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_USER_CANCELLED, (Throwable)e);
        }
    }

    public Promise<org.forgerock.opendj.ldap.Connection, LdapException> getConnectionAsync() {
        this.acquireTransportAndTimeoutChecker();
        TCPNIOConnectorHandler connectorHandler = ((TCPNIOConnectorHandler.Builder)TCPNIOConnectorHandler.builder((TCPNIOTransport)((TCPNIOTransport)this.transport.get())).processor((Processor)this.defaultFilterChain)).build();
        PromiseImpl promise = PromiseImpl.create();
        connectorHandler.connect((Object)this.getSocketAddress(), (CompletionHandler)new CompletionHandlerAdapter(promise));
        return promise;
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getHostName() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.host + ':' + this.port + ')';
    }

    TimeoutChecker getTimeoutChecker() {
        return (TimeoutChecker)this.timeoutChecker.get();
    }

    LDAPOptions getLDAPOptions() {
        return this.options;
    }

    void releaseTransportAndTimeoutChecker() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.transport.release();
            this.timeoutChecker.release();
        }
    }

    private void acquireTransportAndTimeoutChecker() {
        this.referenceCount.incrementAndGet();
        if (this.isClosed.get()) {
            this.releaseTransportAndTimeoutChecker();
            throw new IllegalStateException("Attempted to get a connection after factory close");
        }
    }

    private final class CompletionHandlerAdapter
    implements CompletionHandler<Connection>,
    TimeoutEventListener {
        private final PromiseImpl<org.forgerock.opendj.ldap.Connection, LdapException> promise;
        private final long timeoutEndTime;

        private CompletionHandlerAdapter(PromiseImpl<org.forgerock.opendj.ldap.Connection, LdapException> promise) {
            this.promise = promise;
            long timeoutMS = this.getTimeout();
            this.timeoutEndTime = timeoutMS > 0L ? System.currentTimeMillis() + timeoutMS : 0L;
            ((TimeoutChecker)GrizzlyLDAPConnectionFactory.this.timeoutChecker.get()).addListener((TimeoutEventListener)this);
        }

        public void cancelled() {
        }

        public void completed(Connection result) {
            final GrizzlyLDAPConnection connection = this.adaptConnection(result);
            if (GrizzlyLDAPConnectionFactory.this.options.getSSLContext() == null) {
                this.thenOnResult(connection);
                return;
            }
            if (this.promise.isDone()) {
                ((TimeoutChecker)GrizzlyLDAPConnectionFactory.this.timeoutChecker.get()).removeListener((TimeoutEventListener)this);
                connection.close();
                return;
            }
            if (GrizzlyLDAPConnectionFactory.this.options.useStartTLS()) {
                StartTLSExtendedRequest startTLS = Requests.newStartTLSExtendedRequest((SSLContext)GrizzlyLDAPConnectionFactory.this.options.getSSLContext());
                startTLS.addEnabledCipherSuite(GrizzlyLDAPConnectionFactory.this.options.getEnabledCipherSuites().toArray(new String[GrizzlyLDAPConnectionFactory.this.options.getEnabledCipherSuites().size()]));
                startTLS.addEnabledProtocol(GrizzlyLDAPConnectionFactory.this.options.getEnabledProtocols().toArray(new String[GrizzlyLDAPConnectionFactory.this.options.getEnabledProtocols().size()]));
                connection.extendedRequestAsync((ExtendedRequest)startTLS).thenOnResult((ResultHandler)new ResultHandler<ExtendedResult>(){

                    public void handleResult(ExtendedResult result) {
                        CompletionHandlerAdapter.this.thenOnResult(connection);
                    }
                }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                    public void handleException(LdapException error) {
                        CompletionHandlerAdapter.this.onException(connection, error);
                    }
                });
            } else {
                try {
                    connection.startTLS(GrizzlyLDAPConnectionFactory.this.options.getSSLContext(), GrizzlyLDAPConnectionFactory.this.options.getEnabledProtocols(), GrizzlyLDAPConnectionFactory.this.options.getEnabledCipherSuites(), (CompletionHandler<SSLEngine>)new EmptyCompletionHandler<SSLEngine>(){

                        public void completed(SSLEngine result) {
                            CompletionHandlerAdapter.this.thenOnResult(connection);
                        }

                        public void failed(Throwable throwable) {
                            CompletionHandlerAdapter.this.onException(connection, throwable);
                        }
                    });
                }
                catch (IOException e) {
                    this.onException(connection, e);
                }
            }
        }

        public void failed(Throwable throwable) {
            ((TimeoutChecker)GrizzlyLDAPConnectionFactory.this.timeoutChecker.get()).removeListener((TimeoutEventListener)this);
            this.promise.handleException((Exception)((Object)this.adaptConnectionException(throwable)));
            GrizzlyLDAPConnectionFactory.this.releaseTransportAndTimeoutChecker();
        }

        public void updated(Connection result) {
        }

        private GrizzlyLDAPConnection adaptConnection(Connection<?> connection) {
            GrizzlyUtils.configureConnection(connection, GrizzlyLDAPConnectionFactory.this.options.isTCPNoDelay(), GrizzlyLDAPConnectionFactory.this.options.isKeepAlive(), GrizzlyLDAPConnectionFactory.this.options.isReuseAddress(), GrizzlyLDAPConnectionFactory.this.options.getLinger(), logger);
            GrizzlyLDAPConnection ldapConnection = new GrizzlyLDAPConnection(connection, GrizzlyLDAPConnectionFactory.this);
            ((TimeoutChecker)GrizzlyLDAPConnectionFactory.this.timeoutChecker.get()).addListener((TimeoutEventListener)ldapConnection);
            GrizzlyLDAPConnectionFactory.this.clientFilter.registerConnection(connection, ldapConnection);
            return ldapConnection;
        }

        private LdapException adaptConnectionException(Throwable t) {
            if (!(t instanceof LdapException) && t instanceof ExecutionException) {
                Throwable throwable = t = t.getCause() != null ? t.getCause() : t;
            }
            if (t instanceof LdapException) {
                return (LdapException)t;
            }
            return LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_CONNECT_ERROR, (CharSequence)t.getMessage(), (Throwable)t);
        }

        private void onException(GrizzlyLDAPConnection connection, Throwable t) {
            ((TimeoutChecker)GrizzlyLDAPConnectionFactory.this.timeoutChecker.get()).removeListener((TimeoutEventListener)this);
            this.promise.handleException((Exception)((Object)this.adaptConnectionException(t)));
            connection.close();
        }

        private void thenOnResult(GrizzlyLDAPConnection connection) {
            ((TimeoutChecker)GrizzlyLDAPConnectionFactory.this.timeoutChecker.get()).removeListener((TimeoutEventListener)this);
            if (!this.promise.tryHandleResult((Object)connection)) {
                connection.close();
            }
        }

        public long handleTimeout(long currentTime) {
            if (this.timeoutEndTime == 0L) {
                return 0L;
            }
            if (this.timeoutEndTime > currentTime) {
                return this.timeoutEndTime - currentTime;
            }
            this.promise.handleException((Exception)((Object)LdapException.newLdapException((ResultCode)ResultCode.CLIENT_SIDE_CONNECT_ERROR, (CharSequence)GrizzlyMessages.LDAP_CONNECTION_CONNECT_TIMEOUT.get((Object)GrizzlyLDAPConnectionFactory.this.getSocketAddress(), (Object)this.getTimeout()).toString())));
            return 0L;
        }

        public long getTimeout() {
            return GrizzlyLDAPConnectionFactory.this.options.getConnectTimeout(TimeUnit.MILLISECONDS);
        }
    }
}

