/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.forgerock.util.xml.XMLHandler;
import org.xml.sax.SAXException;

public final class XMLUtils {
    private XMLUtils() {
    }

    public static DocumentBuilder getSafeDocumentBuilder(boolean validating) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validating);
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(new XMLHandler());
        return db;
    }

    public static SAXParser getSafeSAXParser(boolean validating) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(validating);
        saxFactory.setNamespaceAware(true);
        saxFactory.setXIncludeAware(false);
        saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXParser sp = saxFactory.newSAXParser();
        sp.getXMLReader().setEntityResolver(new XMLHandler());
        return sp;
    }
}

