/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.promise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.promise.RuntimeExceptionHandler;

public final class Promises {
    private static final AsyncFunction<Exception, Object, Exception> EXCEPTION_IDEM_ASYNC_FUNC = new AsyncFunction<Exception, Object, Exception>(){

        @Override
        public Promise<Object, Exception> apply(Exception exception) throws Exception {
            throw exception;
        }
    };
    private static final Function<Exception, Object, Exception> EXCEPTION_IDEM_FUNC = new Function<Exception, Object, Exception>(){

        @Override
        public Object apply(Exception exception) throws Exception {
            throw exception;
        }
    };
    private static final AsyncFunction<Exception, Object, Exception> RESULT_IDEM_ASYNC_FUNC = new AsyncFunction<Exception, Object, Exception>(){

        @Override
        public Promise<Object, Exception> apply(Exception exception) throws Exception {
            throw exception;
        }
    };
    private static final Function<Object, Object, Exception> RESULT_IDEM_FUNC = new Function<Object, Object, Exception>(){

        @Override
        public Object apply(Object value) throws Exception {
            return value;
        }
    };

    public static <V, E extends Exception> Promise<V, E> newExceptionPromise(E exception) {
        PromiseImpl promise = new PromiseImpl();
        promise.handleException(exception);
        return promise;
    }

    public static <V, E extends Exception> Promise<V, E> newResultPromise(V result) {
        PromiseImpl promise = new PromiseImpl();
        promise.handleResult(result);
        return promise;
    }

    public static <V, E extends Exception> Promise<List<V>, E> when(List<Promise<V, E>> promises) {
        int size = promises.size();
        final AtomicInteger remaining = new AtomicInteger(size);
        final ArrayList results = new ArrayList(size);
        final PromiseImpl composite = PromiseImpl.create();
        for (Promise<V, E> promise : promises) {
            promise.thenOnResult(new ResultHandler<V>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleResult(V value) {
                    List list = results;
                    synchronized (list) {
                        results.add(value);
                    }
                    if (remaining.decrementAndGet() == 0) {
                        composite.handleResult(results);
                    }
                }
            }).thenOnException(new ExceptionHandler<E>(){

                @Override
                public void handleException(E exception) {
                    composite.handleException(exception);
                }
            }).thenOnRuntimeException(new RuntimeExceptionHandler(){

                @Override
                public void handleRuntimeException(RuntimeException exception) {
                    composite.handleRuntimeException(exception);
                }
            });
        }
        if (promises.isEmpty()) {
            composite.handleResult(results);
        }
        return composite;
    }

    @SafeVarargs
    public static <V, E extends Exception> Promise<List<V>, E> when(Promise<V, E> ... promises) {
        return Promises.when(Arrays.asList(promises));
    }

    static <VOUT, E extends Exception> AsyncFunction<E, VOUT, E> exceptionIdempotentAsyncFunction() {
        return EXCEPTION_IDEM_ASYNC_FUNC;
    }

    static <VOUT, E extends Exception> Function<E, VOUT, E> exceptionIdempotentFunction() {
        return EXCEPTION_IDEM_FUNC;
    }

    static <V, E extends Exception> AsyncFunction<V, V, E> resultIdempotentAsyncFunction() {
        return RESULT_IDEM_ASYNC_FUNC;
    }

    static <V, E extends Exception> Function<V, V, E> resultIdempotentFunction() {
        return RESULT_IDEM_FUNC;
    }

    private Promises() {
    }
}

