/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server.changelog.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.Closeable;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.opends.messages.BackendMessages;
import org.opends.messages.ReplicationMessages;
import org.opends.server.replication.common.CSN;
import org.opends.server.replication.server.ChangelogState;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.changelog.api.ChangelogException;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

public class ReplicationDbEnv {
    private Environment dbEnvironment;
    private Database changelogStateDb;
    private final ChangelogState changelogState;
    private final Object stateLock = new Object();
    private final List<Database> allDbs = new CopyOnWriteArrayList<Database>();
    private ReplicationServer replicationServer;
    private final AtomicBoolean isShuttingDown = new AtomicBoolean(false);
    private static final String GENERATION_ID_TAG = "GENID";
    private static final String OFFLINE_TAG = "OFFLINE";
    private static final String FIELD_SEPARATOR = " ";
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();

    public ReplicationDbEnv(String path, ReplicationServer replicationServer) throws ChangelogException {
        this.replicationServer = replicationServer;
        try {
            this.dbEnvironment = this.openJEEnvironment(path);
            this.changelogStateDb = this.openDatabase("changelogstate");
            this.changelogState = this.readOnDiskChangelogState();
        }
        catch (RuntimeException e) {
            throw new ChangelogException((Throwable)e);
        }
    }

    protected Environment openJEEnvironment(String path) {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setConfigParam("je.stats.collect", "false");
        envConfig.setConfigParam("je.cleaner.threads", "2");
        envConfig.setConfigParam("je.checkpointer.highPriority", "true");
        if (Runtime.getRuntime().maxMemory() > 0x10000000L) {
            envConfig.setConfigParam("je.cleaner.lookAheadCacheSize", this.mb(2));
            envConfig.setConfigParam("je.log.iteratorReadSize", this.mb(2));
            envConfig.setConfigParam("je.log.faultReadSize", this.kb(4));
            envConfig.setConfigParam("je.maxMemory", this.mb(16));
        } else {
            envConfig.setConfigParam("je.maxMemory", this.mb(5));
        }
        envConfig.setTxnTimeout(0L, TimeUnit.SECONDS);
        envConfig.setLockTimeout(0L, TimeUnit.SECONDS);
        envConfig.setDurability(Durability.COMMIT_WRITE_NO_SYNC);
        return new Environment(new File(path), envConfig);
    }

    private String kb(int sizeInKb) {
        return String.valueOf(sizeInKb * 1024);
    }

    private String mb(int sizeInMb) {
        return String.valueOf(sizeInMb * 1024 * 1024);
    }

    protected Database openDatabase(String databaseName) throws ChangelogException, RuntimeException {
        if (this.isShuttingDown.get()) {
            throw new ChangelogException(ReplicationMessages.WARN_CANNOT_OPEN_DATABASE_BECAUSE_SHUTDOWN_WAS_REQUESTED.get((Object)databaseName, (Object)this.replicationServer.getServerId()));
        }
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(true);
        Database db = this.dbEnvironment.openDatabase(null, databaseName, dbConfig);
        if (this.isShuttingDown.get()) {
            this.closeDB(db);
            throw new ChangelogException(ReplicationMessages.WARN_CANNOT_OPEN_DATABASE_BECAUSE_SHUTDOWN_WAS_REQUESTED.get((Object)databaseName, (Object)this.replicationServer.getServerId()));
        }
        this.allDbs.add(db);
        return db;
    }

    public ChangelogState getChangelogState() {
        return this.changelogState;
    }

    protected ChangelogState readOnDiskChangelogState() throws ChangelogException {
        return this.decodeChangelogState(this.readWholeState());
    }

    ChangelogState decodeChangelogState(Map<byte[], byte[]> wholeState) throws ChangelogException {
        try {
            ChangelogState result = new ChangelogState();
            for (Map.Entry<byte[], byte[]> entry : wholeState.entrySet()) {
                String[] str;
                String prefix;
                String stringKey = this.toString(entry.getKey());
                String stringData = this.toString(entry.getValue());
                if (logger.isTraceEnabled()) {
                    this.debug("read (key, data)=(" + stringKey + ", " + stringData + ")");
                }
                if ((prefix = stringKey.split(FIELD_SEPARATOR)[0]).equals(GENERATION_ID_TAG)) {
                    str = stringData.split(FIELD_SEPARATOR, 3);
                    long generationId = this.toLong(str[1]);
                    DN baseDN = DN.valueOf((String)str[2]);
                    if (logger.isTraceEnabled()) {
                        this.debug("has read generationId: baseDN=" + baseDN + " generationId=" + generationId);
                    }
                    result.setDomainGenerationId(baseDN, generationId);
                    continue;
                }
                if (prefix.equals(OFFLINE_TAG)) {
                    str = stringData.split(FIELD_SEPARATOR, 3);
                    long timestamp = this.toLong(str[0]);
                    int serverId = this.toInt(str[1]);
                    DN baseDN = DN.valueOf((String)str[2]);
                    if (logger.isTraceEnabled()) {
                        this.debug("has read replica offline: baseDN=" + baseDN + " serverId=" + serverId);
                    }
                    result.addOfflineReplica(baseDN, new CSN(timestamp, 0, serverId));
                    continue;
                }
                str = stringData.split(FIELD_SEPARATOR, 2);
                int serverId = this.toInt(str[0]);
                DN baseDN = DN.valueOf((String)str[1]);
                if (logger.isTraceEnabled()) {
                    this.debug("has read replica: baseDN=" + baseDN + " serverId=" + serverId);
                }
                result.addServerIdToDomain(serverId, baseDN);
            }
            return result;
        }
        catch (DirectoryException e) {
            throw new ChangelogException(e.getMessageObject(), (Throwable)e);
        }
    }

    private Map<byte[], byte[]> readWholeState() throws ChangelogException {
        LinkedHashMap<byte[], byte[]> linkedHashMap;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.changelogStateDb.openCursor(null, null);
        try {
            LinkedHashMap<byte[], byte[]> results = new LinkedHashMap<byte[], byte[]>();
            OperationStatus status = cursor.getFirst(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                results.put(key.getData(), data.getData());
                status = cursor.getNext(key, data, LockMode.DEFAULT);
            }
            linkedHashMap = results;
        }
        catch (RuntimeException e) {
            try {
                throw new ChangelogException(BackendMessages.ERR_DATABASE_EXCEPTION.get((Object)e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                StaticUtils.close((Closeable[])new Closeable[]{cursor});
                throw throwable;
            }
        }
        StaticUtils.close((Closeable[])new Closeable[]{cursor});
        return linkedHashMap;
    }

    private int toInt(String data) throws ChangelogException {
        try {
            return Integer.parseInt(data);
        }
        catch (NumberFormatException e) {
            throw new ChangelogException(LocalizableMessage.raw((CharSequence)("replicationServer state database has a wrong format: " + e.getLocalizedMessage() + "<" + data + ">"), (Object[])new Object[0]));
        }
    }

    private long toLong(String data) throws ChangelogException {
        try {
            return Long.parseLong(data);
        }
        catch (NumberFormatException e) {
            throw new ChangelogException(LocalizableMessage.raw((CharSequence)("replicationServer state database has a wrong format: " + e.getLocalizedMessage() + "<" + data + ">"), (Object[])new Object[0]));
        }
    }

    private String toString(byte[] data) throws ChangelogException {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ChangelogException(LocalizableMessage.raw((CharSequence)"need UTF-8 support", (Object[])new Object[0]));
        }
    }

    static byte[] toBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getOrAddReplicationDB(int serverId, DN baseDN, long generationId) throws ChangelogException {
        if (logger.isTraceEnabled()) {
            this.debug("ReplicationDbEnv.getOrAddDb(" + serverId + ", " + baseDN + ", " + generationId + ")");
        }
        try {
            Map.Entry<String, String> replicaEntry = ReplicationDbEnv.toReplicaEntry(baseDN, serverId);
            Database replicaDB = this.openDatabase(replicaEntry.getKey());
            Object object = this.stateLock;
            synchronized (object) {
                this.putInChangelogStateDBIfNotExist(ReplicationDbEnv.toByteArray(replicaEntry));
                this.changelogState.addServerIdToDomain(serverId, baseDN);
                this.putInChangelogStateDBIfNotExist(ReplicationDbEnv.toGenIdEntry(baseDN, generationId));
                this.changelogState.setDomainGenerationId(baseDN, generationId);
            }
            return replicaDB;
        }
        catch (RuntimeException e) {
            throw new ChangelogException((Throwable)e);
        }
    }

    static Map.Entry<String, String> toReplicaEntry(DN baseDN, int serverId) {
        String key = serverId + FIELD_SEPARATOR + baseDN.toNormalizedUrlSafeString();
        String value = serverId + FIELD_SEPARATOR + baseDN;
        return ReplicationDbEnv.toEntry(key, value);
    }

    static Map.Entry<byte[], byte[]> toGenIdEntry(DN baseDN, long generationId) {
        String key = "GENID " + baseDN.toNormalizedUrlSafeString();
        String data = "GENID " + generationId + FIELD_SEPARATOR + baseDN;
        return ReplicationDbEnv.toEntry(ReplicationDbEnv.toBytes(key), ReplicationDbEnv.toBytes(data));
    }

    static Map.Entry<byte[], byte[]> toByteArray(Map.Entry<String, String> entry) {
        return ReplicationDbEnv.toEntry(ReplicationDbEnv.toBytes(entry.getKey()), ReplicationDbEnv.toBytes(entry.getValue()));
    }

    static Map.Entry<byte[], byte[]> toReplicaOfflineEntry(DN baseDN, CSN offlineCSN) {
        int serverId = offlineCSN.getServerId();
        byte[] key = ReplicationDbEnv.toReplicaOfflineKey(baseDN, serverId);
        byte[] data = ReplicationDbEnv.toBytes(offlineCSN.getTime() + FIELD_SEPARATOR + serverId + FIELD_SEPARATOR + baseDN);
        return ReplicationDbEnv.toEntry(key, data);
    }

    private static byte[] toReplicaOfflineKey(DN baseDN, int serverId) {
        return ReplicationDbEnv.toBytes("OFFLINE " + serverId + FIELD_SEPARATOR + baseDN.toNormalizedUrlSafeString());
    }

    private AbstractMap.SimpleImmutableEntry<byte[], byte[]> toEntryWithNullValue(byte[] key) {
        return ReplicationDbEnv.toEntry(key, null);
    }

    private static <K, V> AbstractMap.SimpleImmutableEntry<K, V> toEntry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    private void putInChangelogStateDBIfNotExist(Map.Entry<byte[], byte[]> entry) throws ChangelogException, RuntimeException {
        DatabaseEntry data;
        DatabaseEntry key = new DatabaseEntry(entry.getKey());
        if (this.changelogStateDb.get(null, key, data = new DatabaseEntry(), LockMode.DEFAULT) == OperationStatus.NOTFOUND) {
            Transaction txn = this.dbEnvironment.beginTransaction(null, null);
            try {
                data.setData(entry.getValue());
                if (logger.isTraceEnabled()) {
                    this.debug("putting record in the changelogstate Db key=[" + this.toString(entry.getKey()) + "] value=[" + this.toString(entry.getValue()) + "]");
                }
                this.changelogStateDb.put(txn, key, data);
                txn.commit(Durability.COMMIT_WRITE_NO_SYNC);
            }
            catch (DatabaseException dbe) {
                txn.abort();
                throw dbe;
            }
        }
    }

    public Transaction beginTransaction() throws ChangelogException {
        try {
            return this.dbEnvironment.beginTransaction(null, null);
        }
        catch (RuntimeException e) {
            throw new ChangelogException((Throwable)e);
        }
    }

    public void shutdown() {
        this.isShuttingDown.set(true);
        Database[] allDbsCopy = this.allDbs.toArray(new Database[0]);
        this.allDbs.clear();
        for (Database db : allDbsCopy) {
            this.closeDB(db);
        }
        try {
            this.dbEnvironment.close();
        }
        catch (DatabaseException e) {
            logger.error(this.closeDBErrorMessage(null, e));
        }
    }

    private void closeDB(Database db) {
        this.allDbs.remove(db);
        try {
            db.close();
        }
        catch (DatabaseException e) {
            logger.error(this.closeDBErrorMessage(db.getDatabaseName(), e));
        }
    }

    private LocalizableMessage closeDBErrorMessage(String dbName, DatabaseException e) {
        if (dbName != null) {
            return ReplicationMessages.NOTE_EXCEPTION_CLOSING_DATABASE.get((Object)dbName, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e));
        }
        return ReplicationMessages.ERR_ERROR_CLOSING_CHANGELOG_ENV.get((Object)StaticUtils.stackTraceToSingleLineString((Throwable)e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGenerationId(DN baseDN) throws ChangelogException {
        Object object = this.stateLock;
        synchronized (object) {
            boolean unusedGenId = false;
            this.deleteFromChangelogStateDB(ReplicationDbEnv.toGenIdEntry(baseDN, 0L), "clearGenerationId(baseDN=" + baseDN + ")");
            this.changelogState.setDomainGenerationId(baseDN, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearServerId(DN baseDN, int serverId) throws ChangelogException {
        Object object = this.stateLock;
        synchronized (object) {
            this.deleteFromChangelogStateDB(ReplicationDbEnv.toByteArray(ReplicationDbEnv.toReplicaEntry(baseDN, serverId)), "clearServerId(baseDN=" + baseDN + " , serverId=" + serverId + ")");
            this.changelogState.setDomainGenerationId(baseDN, -1L);
        }
    }

    private void deleteFromChangelogStateDB(Map.Entry<byte[], ?> entry, String methodInvocation) throws ChangelogException {
        block9: {
            if (logger.isTraceEnabled()) {
                this.debug(methodInvocation + " starting");
            }
            try {
                DatabaseEntry key = new DatabaseEntry(entry.getKey());
                DatabaseEntry data = new DatabaseEntry();
                if (this.changelogStateDb.get(null, key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    Transaction txn = this.dbEnvironment.beginTransaction(null, null);
                    try {
                        this.changelogStateDb.delete(txn, key);
                        txn.commit(Durability.COMMIT_WRITE_NO_SYNC);
                        if (logger.isTraceEnabled()) {
                            this.debug(methodInvocation + " succeeded");
                        }
                        break block9;
                    }
                    catch (RuntimeException dbe) {
                        txn.abort();
                        throw dbe;
                    }
                }
                if (logger.isTraceEnabled()) {
                    this.debug(methodInvocation + " failed: key not found");
                }
            }
            catch (RuntimeException e) {
                if (logger.isTraceEnabled()) {
                    this.debug(methodInvocation + " error: " + StaticUtils.stackTraceToSingleLineString((Throwable)e));
                }
                throw new ChangelogException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReplicaOffline(DN baseDN, CSN offlineCSN) throws ChangelogException {
        Object object = this.stateLock;
        synchronized (object) {
            this.putInChangelogStateDB(ReplicationDbEnv.toReplicaOfflineEntry(baseDN, offlineCSN), "replicaOffline(baseDN=" + baseDN + ", offlineCSN=" + offlineCSN + ")");
            this.changelogState.addOfflineReplica(baseDN, offlineCSN);
        }
    }

    public void notifyReplicaOnline(DN baseDN, int serverId) throws ChangelogException {
        this.deleteFromChangelogStateDB(this.toEntryWithNullValue(ReplicationDbEnv.toReplicaOfflineKey(baseDN, serverId)), "removeOfflineReplica(baseDN=" + baseDN + ", serverId=" + serverId + ")");
    }

    private void putInChangelogStateDB(Map.Entry<byte[], byte[]> entry, String methodInvocation) throws ChangelogException {
        if (logger.isTraceEnabled()) {
            this.debug(methodInvocation + " starting");
        }
        try {
            DatabaseEntry key = new DatabaseEntry(entry.getKey());
            DatabaseEntry data = new DatabaseEntry(entry.getValue());
            this.changelogStateDb.put(null, key, data);
            if (logger.isTraceEnabled()) {
                this.debug(methodInvocation + " succeeded");
            }
        }
        catch (RuntimeException e) {
            if (logger.isTraceEnabled()) {
                this.debug(methodInvocation + " error: " + StaticUtils.stackTraceToSingleLineString((Throwable)e));
            }
            throw new ChangelogException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearDb(Database db) {
        String databaseName = db.getDatabaseName();
        db.close();
        Transaction txn = null;
        try {
            txn = this.dbEnvironment.beginTransaction(null, null);
            this.dbEnvironment.truncateDatabase(txn, databaseName, false);
            txn.commit(Durability.COMMIT_WRITE_NO_SYNC);
            txn = null;
        }
        catch (RuntimeException e) {
            logger.error(ReplicationMessages.ERR_ERROR_CLEARING_DB, (Object)databaseName, (Object)(e.getMessage() + FIELD_SEPARATOR + StaticUtils.stackTraceToSingleLineString((Throwable)e)));
        }
        finally {
            try {
                if (txn != null) {
                    txn.abort();
                }
            }
            catch (Exception e) {}
        }
    }

    public Database getOrCreateCNIndexDB() throws ChangelogException {
        try {
            return this.openDatabase("draftcndb");
        }
        catch (RuntimeException e) {
            throw new ChangelogException((Throwable)e);
        }
    }

    void shutdownOnException(DatabaseException e) {
        logger.error(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e));
        this.replicationServer.shutdown();
    }

    private void debug(String message) {
        logger.trace("In %s, %s", (Object)(this.replicationServer != null ? this.replicationServer.getMonitorInstanceName() : "[test]"), (Object)message);
    }
}

