/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server.changelog.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.opends.messages.ReplicationMessages;
import org.opends.server.replication.common.CSN;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.changelog.api.ChangelogException;
import org.opends.server.replication.server.changelog.api.DBCursor;
import org.opends.server.replication.server.changelog.je.JEUtils;
import org.opends.server.replication.server.changelog.je.ReplicationDbEnv;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

class ReplicationDB {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private Database db;
    private final ReplicationDbEnv dbEnv;
    private final ReplicationServer replicationServer;
    private final int serverId;
    private final DN baseDN;
    private final ReadWriteLock dbCloseLock = new ReentrantReadWriteLock(true);
    private int counterCurrValue = 1;
    private long counterTsLimit;
    private int counterWindowSize = 1000;

    ReplicationDB(int serverId, DN baseDN, ReplicationServer replicationServer, ReplicationDbEnv dbEnv) throws ChangelogException {
        this.serverId = serverId;
        this.baseDN = baseDN;
        this.dbEnv = dbEnv;
        this.replicationServer = replicationServer;
        ReplicationServerDomain domain = replicationServer.getReplicationServerDomain(baseDN, true);
        this.db = dbEnv.getOrAddReplicationDB(serverId, baseDN, domain.getGenerationId());
        this.intializeCounters();
    }

    private void intializeCounters() throws ChangelogException {
        this.counterCurrValue = 1;
        Cursor cursor = null;
        try {
            cursor = this.db.openCursor(null, null);
            int distBackToCounterRecord = 0;
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = cursor.getLast(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                CSN csn = ReplicationDB.toCSN(key.getData());
                if (ReplicationDB.isACounterRecord(csn)) {
                    this.counterCurrValue = ReplicationDB.decodeCounterValue(data.getData()) + 1;
                    this.counterTsLimit = csn.getTime();
                    break;
                }
                status = cursor.getPrev(key, data, LockMode.DEFAULT);
                ++distBackToCounterRecord;
            }
            this.counterCurrValue += distBackToCounterRecord;
        }
        catch (DatabaseException e) {
            try {
                throw new ChangelogException((Throwable)e);
            }
            catch (Throwable throwable) {
                StaticUtils.close((Closeable[])new Closeable[]{cursor});
                throw throwable;
            }
        }
        StaticUtils.close((Closeable[])new Closeable[]{cursor});
    }

    private static CSN toCSN(byte[] data) {
        return new CSN(StaticUtils.decodeUTF8((byte[])data));
    }

    void addEntry(UpdateMsg change) throws ChangelogException {
        this.dbCloseLock.readLock().lock();
        try {
            if (this.isDBClosed()) {
                return;
            }
            DatabaseEntry key = this.createReplicationKey(change.getCSN());
            DatabaseEntry data = new DatabaseEntry(change.getBytes());
            this.insertCounterRecordIfNeeded(change.getCSN());
            this.db.put(null, key, data);
            ++this.counterCurrValue;
        }
        catch (DatabaseException e) {
            throw new ChangelogException(ReplicationMessages.ERR_EXCEPTION_COULD_NOT_ADD_CHANGE_TO_REPLICA_DB.get((Object)change, (Object)this.baseDN, (Object)this.serverId, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
        }
        finally {
            this.dbCloseLock.readLock().unlock();
        }
    }

    private void insertCounterRecordIfNeeded(CSN csn) throws DatabaseException {
        if (this.counterCurrValue != 0 && this.counterCurrValue % this.counterWindowSize == 0) {
            this.counterTsLimit = csn.getTime();
        }
        if (this.counterTsLimit != 0L && csn.getTime() != this.counterTsLimit) {
            CSN counterRecord = ReplicationDB.newCounterRecord(csn);
            DatabaseEntry counterKey = this.createReplicationKey(counterRecord);
            DatabaseEntry counterValue = ReplicationDB.encodeCounterValue(this.counterCurrValue - 1);
            this.db.put(null, counterKey, counterValue);
            this.counterTsLimit = 0L;
        }
    }

    private DatabaseEntry createReplicationKey(CSN csn) {
        DatabaseEntry key = new DatabaseEntry();
        if (csn != null) {
            try {
                key.setData(csn.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.dbCloseLock.writeLock().lock();
        try {
            this.db.close();
            this.db = null;
        }
        catch (DatabaseException e) {
            logger.info(ReplicationMessages.NOTE_EXCEPTION_CLOSING_DATABASE, (Object)this, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e));
        }
        finally {
            this.dbCloseLock.writeLock().unlock();
        }
    }

    ReplServerDBCursor openReadCursor(CSN startCSN, DBCursor.KeyMatchingStrategy matchingStrategy, DBCursor.PositionStrategy positionStrategy) throws ChangelogException {
        return new ReplServerDBCursor(startCSN, matchingStrategy, positionStrategy);
    }

    ReplServerDBCursor openDeleteCursor() throws ChangelogException {
        return new ReplServerDBCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndReleaseReadLock(Cursor cursor) {
        try {
            StaticUtils.close((Closeable[])new Closeable[]{cursor});
        }
        finally {
            this.dbCloseLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CSN readOldestCSN() throws ChangelogException {
        this.dbCloseLock.readLock().lock();
        Cursor cursor = null;
        try {
            DatabaseEntry data;
            DatabaseEntry key;
            if (this.isDBClosed()) {
                CSN cSN = null;
                return cSN;
            }
            cursor = this.db.openCursor(null, null);
            if (cursor.getFirst(key = new DatabaseEntry(), data = new DatabaseEntry(), LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                CSN cSN = null;
                this.closeAndReleaseReadLock(cursor);
                return cSN;
            }
            CSN csn = ReplicationDB.toCSN(key.getData());
            if (!ReplicationDB.isACounterRecord(csn)) {
                CSN cSN = csn;
                this.closeAndReleaseReadLock(cursor);
                return cSN;
            }
            if (cursor.getNext(key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                CSN cSN = null;
                this.closeAndReleaseReadLock(cursor);
                return cSN;
            }
            CSN cSN = ReplicationDB.toCSN(key.getData());
            this.closeAndReleaseReadLock(cursor);
            return cSN;
        }
        catch (DatabaseException e) {
            throw new ChangelogException((Throwable)e);
        }
        finally {
            this.closeAndReleaseReadLock(cursor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CSN readNewestCSN() throws ChangelogException {
        this.dbCloseLock.readLock().lock();
        Cursor cursor = null;
        try {
            DatabaseEntry data;
            DatabaseEntry key;
            if (this.isDBClosed()) {
                CSN cSN = null;
                return cSN;
            }
            cursor = this.db.openCursor(null, null);
            if (cursor.getLast(key = new DatabaseEntry(), data = new DatabaseEntry(), LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                CSN cSN = null;
                this.closeAndReleaseReadLock(cursor);
                return cSN;
            }
            CSN csn = ReplicationDB.toCSN(key.getData());
            if (!ReplicationDB.isACounterRecord(csn)) {
                CSN cSN = csn;
                this.closeAndReleaseReadLock(cursor);
                return cSN;
            }
            if (cursor.getPrev(key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                CSN cSN = null;
                this.closeAndReleaseReadLock(cursor);
                return cSN;
            }
            CSN cSN = ReplicationDB.toCSN(key.getData());
            this.closeAndReleaseReadLock(cursor);
            return cSN;
        }
        catch (DatabaseException e) {
            throw new ChangelogException((Throwable)e);
        }
        finally {
            this.closeAndReleaseReadLock(cursor);
        }
    }

    public String toString() {
        return this.serverId + " " + this.baseDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() throws ChangelogException {
        this.dbCloseLock.writeLock().lock();
        try {
            if (this.isDBClosed()) {
                return;
            }
            this.dbEnv.clearServerId(this.baseDN, this.serverId);
            Database oldDb = this.db;
            this.db = null;
            this.dbEnv.clearDb(oldDb);
            this.db = this.dbEnv.getOrAddReplicationDB(this.serverId, this.baseDN, -1L);
        }
        catch (Exception e) {
            logger.error(ReplicationMessages.ERR_ERROR_CLEARING_DB, (Object)this, (Object)(e.getMessage() + " " + StaticUtils.stackTraceToSingleLineString((Throwable)e)));
        }
        finally {
            this.dbCloseLock.writeLock().unlock();
        }
    }

    private static boolean isACounterRecord(CSN csn) {
        return csn.getServerId() == 0 && csn.getSeqnum() == 0;
    }

    private static CSN newCounterRecord(CSN csn) {
        return new CSN(csn.getTime(), 0, 0);
    }

    private static int decodeCounterValue(byte[] entry) {
        String numAckStr = StaticUtils.decodeUTF8((byte[])entry);
        return Integer.parseInt(numAckStr);
    }

    private static DatabaseEntry encodeCounterValue(int value) {
        DatabaseEntry entry = new DatabaseEntry();
        entry.setData(StaticUtils.getBytes((String)String.valueOf(value)));
        return entry;
    }

    public void setCounterRecordWindowSize(int size) {
        this.counterWindowSize = size;
    }

    private boolean isDBClosed() {
        return this.db == null || !this.db.getEnvironment().isValid();
    }

    long getNumberRecords() {
        return this.db.count();
    }

    class ReplServerDBCursor
    implements DBCursor<UpdateMsg> {
        private Cursor cursor;
        private final DatabaseEntry key;
        private final DatabaseEntry data;
        private final Transaction txn;
        private UpdateMsg currentRecord;
        private boolean isClosed;

        private ReplServerDBCursor(CSN startCSN, DBCursor.KeyMatchingStrategy matchingStrategy, DBCursor.PositionStrategy positionStrategy) throws ChangelogException {
            this.key = ReplicationDB.this.createReplicationKey(startCSN);
            this.data = new DatabaseEntry();
            this.txn = null;
            ReplicationDB.this.dbCloseLock.readLock().lock();
            CursorWithEmptyIndicator maybeEmptyCursor = null;
            try {
                if (ReplicationDB.this.isDBClosed()) {
                    this.isClosed = true;
                    this.cursor = null;
                    return;
                }
                maybeEmptyCursor = this.generateCursor(startCSN, matchingStrategy, positionStrategy);
                if (maybeEmptyCursor.isEmpty) {
                    this.isClosed = true;
                    this.cursor = null;
                    return;
                }
                this.cursor = maybeEmptyCursor.cursor;
                if (this.key.getData() != null) {
                    this.computeCurrentRecord();
                }
            }
            catch (DatabaseException e) {
                throw new ChangelogException((Throwable)e);
            }
            finally {
                if (maybeEmptyCursor != null && maybeEmptyCursor.isEmpty) {
                    ReplicationDB.this.closeAndReleaseReadLock(maybeEmptyCursor.cursor);
                }
            }
        }

        private CursorWithEmptyIndicator generateCursor(CSN startCSN, DBCursor.KeyMatchingStrategy matchingStrategy, DBCursor.PositionStrategy positionStrategy) {
            boolean isCsnFound;
            Cursor cursor = ReplicationDB.this.db.openCursor(this.txn, null);
            boolean bl = isCsnFound = startCSN == null || cursor.getSearchKey(this.key, this.data, LockMode.DEFAULT) == OperationStatus.SUCCESS;
            if (!isCsnFound) {
                boolean isGreaterCsnFound;
                if (matchingStrategy == DBCursor.KeyMatchingStrategy.EQUAL_TO_KEY) {
                    return CursorWithEmptyIndicator.createEmpty(cursor);
                }
                boolean bl2 = isGreaterCsnFound = cursor.getSearchKeyRange(this.key, this.data, LockMode.DEFAULT) == OperationStatus.SUCCESS;
                if (isGreaterCsnFound) {
                    if (matchingStrategy == DBCursor.KeyMatchingStrategy.GREATER_THAN_OR_EQUAL_TO_KEY && positionStrategy == DBCursor.PositionStrategy.AFTER_MATCHING_KEY) {
                        this.key.setData(null);
                        if (cursor.getPrev(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            cursor.close();
                            cursor = ReplicationDB.this.db.openCursor(this.txn, null);
                        }
                    } else if (matchingStrategy == DBCursor.KeyMatchingStrategy.LESS_THAN_OR_EQUAL_TO_KEY) {
                        this.key.setData(null);
                        if (cursor.getPrev(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            return CursorWithEmptyIndicator.createEmpty(cursor);
                        }
                    }
                } else {
                    boolean isLastKeyFound;
                    if (matchingStrategy == DBCursor.KeyMatchingStrategy.GREATER_THAN_OR_EQUAL_TO_KEY) {
                        return CursorWithEmptyIndicator.createEmpty(cursor);
                    }
                    this.key.setData(null);
                    boolean bl3 = isLastKeyFound = cursor.getLast(this.key, this.data, LockMode.DEFAULT) == OperationStatus.SUCCESS;
                    if (!isLastKeyFound) {
                        cursor.close();
                        cursor = ReplicationDB.this.db.openCursor(this.txn, null);
                    }
                }
            }
            return CursorWithEmptyIndicator.createNonEmpty(cursor);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ReplServerDBCursor() throws ChangelogException {
            Cursor localCursor;
            Transaction localTxn;
            boolean cursorHeld;
            block6: {
                this.key = new DatabaseEntry();
                this.data = new DatabaseEntry();
                ReplicationDB.this.dbCloseLock.readLock().lock();
                cursorHeld = false;
                localTxn = null;
                localCursor = null;
                if (!ReplicationDB.this.isDBClosed()) break block6;
                this.isClosed = true;
                this.txn = null;
                this.cursor = null;
                if (cursorHeld) return;
                ReplicationDB.this.closeAndReleaseReadLock(localCursor);
                return;
            }
            try {
                localTxn = ReplicationDB.this.dbEnv.beginTransaction();
                localCursor = ReplicationDB.this.db.openCursor(localTxn, null);
                this.txn = localTxn;
                this.cursor = localCursor;
                cursorHeld = this.cursor != null;
                if (cursorHeld) return;
            }
            catch (ChangelogException e) {
                try {
                    JEUtils.abort(localTxn);
                    throw e;
                    catch (Exception e2) {
                        JEUtils.abort(localTxn);
                        throw new ChangelogException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (cursorHeld) throw throwable;
                    ReplicationDB.this.closeAndReleaseReadLock(localCursor);
                    throw throwable;
                }
            }
            ReplicationDB.this.closeAndReleaseReadLock(localCursor);
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            ReplServerDBCursor replServerDBCursor = this;
            synchronized (replServerDBCursor) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                this.currentRecord = null;
            }
            ReplicationDB.this.closeAndReleaseReadLock(this.cursor);
            if (this.txn != null) {
                try {
                    this.txn.commit(Durability.COMMIT_NO_SYNC);
                }
                catch (DatabaseException e) {
                    ReplicationDB.this.dbEnv.shutdownOnException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void abort() {
            ReplServerDBCursor replServerDBCursor = this;
            synchronized (replServerDBCursor) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            ReplicationDB.this.closeAndReleaseReadLock(this.cursor);
            JEUtils.abort(this.txn);
        }

        CSN nextCSN() throws ChangelogException {
            if (this.isClosed) {
                return null;
            }
            this.currentRecord = null;
            try {
                if (this.cursor.getNext(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                    return null;
                }
                return ReplicationDB.toCSN(this.key.getData());
            }
            catch (DatabaseException e) {
                throw new ChangelogException((Throwable)e);
            }
        }

        public boolean next() throws ChangelogException {
            if (this.isClosed) {
                return false;
            }
            this.currentRecord = null;
            while (this.currentRecord == null) {
                try {
                    if (this.cursor.getNext(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                        return false;
                    }
                }
                catch (DatabaseException e) {
                    throw new ChangelogException((Throwable)e);
                }
                this.computeCurrentRecord();
            }
            return this.currentRecord != null;
        }

        private void computeCurrentRecord() {
            CSN csn = null;
            try {
                csn = ReplicationDB.toCSN(this.key.getData());
                if (ReplicationDB.isACounterRecord(csn)) {
                    return;
                }
                this.currentRecord = this.toRecord(this.data.getData());
            }
            catch (Exception e) {
                logger.error(ReplicationMessages.ERR_REPLICATIONDB_CANNOT_PROCESS_CHANGE_RECORD, (Object)ReplicationDB.this.replicationServer.getServerId(), (Object)csn, (Object)e.getMessage());
            }
        }

        private UpdateMsg toRecord(byte[] data) throws Exception {
            short currentVersion = ProtocolVersion.getCurrentVersion();
            return (UpdateMsg)ReplicationMsg.generateMsg((byte[])data, (short)currentVersion);
        }

        public UpdateMsg getRecord() {
            return this.currentRecord;
        }

        void delete() throws ChangelogException {
            if (this.isClosed) {
                throw new IllegalStateException("ReplServerDBCursor already closed");
            }
            try {
                this.cursor.delete();
            }
            catch (DatabaseException e) {
                throw new ChangelogException((Throwable)e);
            }
        }
    }

    private static class CursorWithEmptyIndicator {
        private Cursor cursor;
        private boolean isEmpty;

        private CursorWithEmptyIndicator(Cursor localCursor, boolean isEmpty) {
            this.cursor = localCursor;
            this.isEmpty = isEmpty;
        }

        static CursorWithEmptyIndicator createEmpty(Cursor cursor) {
            return new CursorWithEmptyIndicator(cursor, true);
        }

        static CursorWithEmptyIndicator createNonEmpty(Cursor cursor) {
            return new CursorWithEmptyIndicator(cursor, false);
        }
    }
}

