/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server.changelog.je;

import org.opends.server.replication.common.CSN;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.changelog.api.ChangelogException;
import org.opends.server.replication.server.changelog.api.DBCursor;
import org.opends.server.replication.server.changelog.je.JEReplicaDB;
import org.opends.server.replication.server.changelog.je.ReplicationDB;

class JEReplicaDBCursor
implements DBCursor<UpdateMsg> {
    private final ReplicationDB db;
    private DBCursor.PositionStrategy positionStrategy;
    private DBCursor.KeyMatchingStrategy matchingStrategy;
    private JEReplicaDB replicaDB;
    private final CSN startCSN;
    private CSN lastNonNullCurrentCSN;
    private ReplicationDB.ReplServerDBCursor cursor;

    public JEReplicaDBCursor(ReplicationDB db, CSN startCSN, DBCursor.KeyMatchingStrategy matchingStrategy, DBCursor.PositionStrategy positionStrategy, JEReplicaDB replicaDB) throws ChangelogException {
        this.db = db;
        this.matchingStrategy = matchingStrategy;
        this.positionStrategy = positionStrategy;
        this.replicaDB = replicaDB;
        this.startCSN = startCSN;
        this.lastNonNullCurrentCSN = startCSN;
    }

    public UpdateMsg getRecord() {
        if (!this.isClosed() && this.cursor != null) {
            return this.cursor.getRecord();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws ChangelogException {
        UpdateMsg currentRecord;
        if (this.isClosed()) {
            return false;
        }
        ReplicationDB.ReplServerDBCursor previousCursor = this.cursor;
        if (this.getRecord() == null) {
            JEReplicaDBCursor jEReplicaDBCursor = this;
            synchronized (jEReplicaDBCursor) {
                this.closeCursor();
                if (this.lastNonNullCurrentCSN != this.startCSN) {
                    this.matchingStrategy = DBCursor.KeyMatchingStrategy.GREATER_THAN_OR_EQUAL_TO_KEY;
                    this.positionStrategy = DBCursor.PositionStrategy.AFTER_MATCHING_KEY;
                }
                this.cursor = this.db.openReadCursor(this.lastNonNullCurrentCSN, this.matchingStrategy, this.positionStrategy);
            }
        }
        if (this.positionStrategy == DBCursor.PositionStrategy.ON_MATCHING_KEY && previousCursor != null || this.positionStrategy == DBCursor.PositionStrategy.AFTER_MATCHING_KEY) {
            this.cursor.next();
        }
        if ((currentRecord = this.cursor.getRecord()) != null) {
            this.lastNonNullCurrentCSN = currentRecord.getCSN();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JEReplicaDBCursor jEReplicaDBCursor = this;
        synchronized (jEReplicaDBCursor) {
            this.closeCursor();
            this.replicaDB = null;
        }
    }

    private boolean isClosed() {
        return this.replicaDB == null;
    }

    private void closeCursor() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " currentChange=" + this.cursor.getRecord() + " positionStrategy=" + this.positionStrategy + " matchingStrategy=" + this.matchingStrategy + " replicaDB=" + this.replicaDB;
    }
}

