/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server.changelog.je;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.forgerock.opendj.config.server.ConfigException;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.replication.common.CSN;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.changelog.api.ChangelogException;
import org.opends.server.replication.server.changelog.api.DBCursor;
import org.opends.server.replication.server.changelog.je.JEReplicaDBCursor;
import org.opends.server.replication.server.changelog.je.ReplicationDB;
import org.opends.server.replication.server.changelog.je.ReplicationDbEnv;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;

class JEReplicaDB {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private volatile CSNLimits csnLimits;
    private final int serverId;
    private final DN baseDN;
    private final DbMonitorProvider dbMonitor = new DbMonitorProvider();
    private final ReplicationServer replicationServer;
    private final ReplicationDB db;

    JEReplicaDB(int serverId, DN baseDN, ReplicationServer replicationServer, ReplicationDbEnv replicationEnv) throws ChangelogException {
        this.serverId = serverId;
        this.baseDN = baseDN;
        this.replicationServer = replicationServer;
        this.db = new ReplicationDB(serverId, baseDN, replicationServer, replicationEnv);
        this.csnLimits = new CSNLimits(this.db.readOldestCSN(), this.db.readNewestCSN());
        DirectoryServer.deregisterMonitorProvider((MonitorProvider)this.dbMonitor);
        DirectoryServer.registerMonitorProvider((MonitorProvider)this.dbMonitor);
    }

    public void add(UpdateMsg updateMsg) throws ChangelogException {
        boolean updateOld;
        if (this.shutdown.get()) {
            throw new ChangelogException(ReplicationMessages.ERR_COULD_NOT_ADD_CHANGE_TO_SHUTTING_DOWN_REPLICA_DB.get((Object)updateMsg, (Object)this.baseDN, (Object)this.serverId));
        }
        this.db.addEntry(updateMsg);
        CSNLimits limits = this.csnLimits;
        boolean updateNew = limits.newestCSN == null || limits.newestCSN.isOlderThan(updateMsg.getCSN());
        boolean bl = updateOld = limits.oldestCSN == null;
        if (updateOld || updateNew) {
            this.csnLimits = new CSNLimits(updateOld ? updateMsg.getCSN() : limits.oldestCSN, updateNew ? updateMsg.getCSN() : limits.newestCSN);
        }
    }

    CSN getOldestCSN() {
        return this.csnLimits.oldestCSN;
    }

    CSN getNewestCSN() {
        return this.csnLimits.newestCSN;
    }

    DBCursor<UpdateMsg> generateCursorFrom(CSN startCSN, DBCursor.KeyMatchingStrategy matchingStrategy, DBCursor.PositionStrategy positionStrategy) throws ChangelogException {
        CSN actualStartCSN = startCSN != null && startCSN.getServerId() == this.serverId ? startCSN : null;
        return new JEReplicaDBCursor(this.db, actualStartCSN, matchingStrategy, positionStrategy, this);
    }

    void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.db.shutdown();
            DirectoryServer.deregisterMonitorProvider((MonitorProvider)this.dbMonitor);
        }
    }

    void purgeUpTo(CSN purgeCSN) throws ChangelogException {
        if (purgeCSN == null) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            try (ReplicationDB.ReplServerDBCursor cursor = this.db.openDeleteCursor();){
                for (int j = 0; j < 50; ++j) {
                    if (this.shutdown.get()) {
                        return;
                    }
                    CSN csn = cursor.nextCSN();
                    if (csn == null) {
                        return;
                    }
                    if (csn.equals((Object)this.csnLimits.newestCSN) || !csn.isOlderThan(purgeCSN)) {
                        this.csnLimits = new CSNLimits(csn, this.csnLimits.newestCSN);
                        return;
                    }
                    cursor.delete();
                }
                continue;
            }
        }
    }

    public String toString() {
        CSNLimits limits = this.csnLimits;
        return this.getClass().getSimpleName() + " " + this.baseDN + " " + this.serverId + " " + limits.oldestCSN + " " + limits.newestCSN;
    }

    void clear() throws ChangelogException {
        this.db.clear();
        this.csnLimits = new CSNLimits(null, null);
    }

    public int getServerId() {
        return this.serverId;
    }

    long getNumberRecords() {
        return this.db.getNumberRecords();
    }

    void setCounterRecordWindowSize(int size) {
        this.db.setCounterRecordWindowSize(size);
    }

    private class DbMonitorProvider
    extends MonitorProvider<MonitorProviderCfg> {
        private DbMonitorProvider() {
        }

        public List<Attribute> getMonitorData() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            this.create(attributes, "replicationServer-database", String.valueOf(JEReplicaDB.this.serverId));
            this.create(attributes, "domain-name", JEReplicaDB.this.baseDN.toString());
            CSNLimits limits = JEReplicaDB.this.csnLimits;
            if (limits.oldestCSN != null) {
                this.create(attributes, "first-change", this.encode(limits.oldestCSN));
            }
            if (limits.newestCSN != null) {
                this.create(attributes, "last-change", this.encode(limits.newestCSN));
            }
            return attributes;
        }

        private void create(List<Attribute> attributes, String name, String value) {
            attributes.add(Attributes.create((String)name, (String)value));
        }

        private String encode(CSN csn) {
            return csn + " " + new Date(csn.getTime());
        }

        public String getMonitorInstanceName() {
            ReplicationServerDomain domain = JEReplicaDB.this.replicationServer.getReplicationServerDomain(JEReplicaDB.this.baseDN);
            return "Changelog for DS(" + JEReplicaDB.this.serverId + "),cn=" + domain.getMonitorInstanceName();
        }

        public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        }
    }

    private static final class CSNLimits {
        private final CSN oldestCSN;
        private final CSN newestCSN;

        public CSNLimits(CSN oldestCSN, CSN newestCSN) {
            this.oldestCSN = oldestCSN;
            this.newestCSN = newestCSN;
        }
    }
}

