/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server.changelog.je;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.util.Pair;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.ReplicationServerCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.ChangelogBackend;
import org.opends.server.replication.common.CSN;
import org.opends.server.replication.common.MultiDomainServerState;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ChangelogState;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.changelog.api.ChangeNumberIndexDB;
import org.opends.server.replication.server.changelog.api.ChangelogDB;
import org.opends.server.replication.server.changelog.api.ChangelogException;
import org.opends.server.replication.server.changelog.api.DBCursor;
import org.opends.server.replication.server.changelog.api.ReplicaId;
import org.opends.server.replication.server.changelog.api.ReplicationDomainDB;
import org.opends.server.replication.server.changelog.file.ChangeNumberIndexer;
import org.opends.server.replication.server.changelog.file.DomainDBCursor;
import org.opends.server.replication.server.changelog.file.MultiDomainDBCursor;
import org.opends.server.replication.server.changelog.file.ReplicaCursor;
import org.opends.server.replication.server.changelog.je.JEChangeNumberIndexDB;
import org.opends.server.replication.server.changelog.je.JEReplicaDB;
import org.opends.server.replication.server.changelog.je.ReplicationDbEnv;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public class JEChangelogDB
implements ChangelogDB,
ReplicationDomainDB {
    protected static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final ConcurrentMap<DN, ConcurrentMap<Integer, JEReplicaDB>> domainToReplicaDBs = new ConcurrentHashMap<DN, ConcurrentMap<Integer, JEReplicaDB>>();
    private final ConcurrentSkipListMap<DN, CopyOnWriteArrayList<DomainDBCursor>> registeredDomainCursors = new ConcurrentSkipListMap();
    private final CopyOnWriteArrayList<MultiDomainDBCursor> registeredMultiDomainCursors = new CopyOnWriteArrayList();
    private final ConcurrentSkipListMap<ReplicaId, CopyOnWriteArrayList<ReplicaCursor>> replicaCursors = new ConcurrentSkipListMap();
    private ReplicationDbEnv replicationEnv;
    private final ReplicationServerCfg config;
    private final File dbDirectory;
    private JEChangeNumberIndexDB cnIndexDB;
    private final AtomicReference<ChangeNumberIndexer> cnIndexer = new AtomicReference();
    private final Object cnIndexDBLock = new Object();
    private volatile long purgeDelayInMillis;
    private final AtomicReference<ChangelogDBPurger> cnPurger = new AtomicReference();
    private final ReplicationServer replicationServer;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private static final DBCursor<UpdateMsg> EMPTY_CURSOR_REPLICA_DB = new DBCursor<UpdateMsg>(){

        public boolean next() {
            return false;
        }

        public UpdateMsg getRecord() {
            return null;
        }

        public void close() {
        }

        public String toString() {
            return "EmptyDBCursor<UpdateMsg>";
        }
    };

    public JEChangelogDB(ReplicationServer replicationServer, ReplicationServerCfg config) throws ConfigException {
        this.config = config;
        this.replicationServer = replicationServer;
        this.dbDirectory = this.makeDir(config.getReplicationDBDirectory());
    }

    private File makeDir(String dbDirName) throws ConfigException {
        File dbDirectory = StaticUtils.getFileForPath((String)dbDirName);
        try {
            if (!dbDirectory.exists()) {
                dbDirectory.mkdir();
            }
            return dbDirectory;
        }
        catch (Exception e) {
            LocalizableMessageBuilder mb = new LocalizableMessageBuilder((Object)e.getLocalizedMessage()).append((CharSequence)" ").append((CharSequence)String.valueOf(dbDirectory));
            throw new ConfigException(ReplicationMessages.ERR_FILE_CHECK_CREATE_FAILED.get((Object)mb.toString()), (Throwable)e);
        }
    }

    private Map<Integer, JEReplicaDB> getDomainMap(DN baseDN) {
        Map domainMap = (Map)this.domainToReplicaDBs.get(baseDN);
        if (domainMap != null) {
            return domainMap;
        }
        return Collections.emptyMap();
    }

    private JEReplicaDB getReplicaDB(DN baseDN, int serverId) {
        return this.getDomainMap(baseDN).get(serverId);
    }

    Pair<JEReplicaDB, Boolean> getOrCreateReplicaDB(DN baseDN, int serverId, ReplicationServer server) throws ChangelogException {
        while (!this.shutdown.get()) {
            List cursors;
            ConcurrentMap<Integer, JEReplicaDB> domainMap = this.getExistingOrNewDomainMap(baseDN);
            Pair<JEReplicaDB, Boolean> result = this.getExistingOrNewReplicaDB(domainMap, serverId, baseDN, server);
            if (result == null) continue;
            Boolean dbWasCreated = (Boolean)result.getSecond();
            if (dbWasCreated.booleanValue() && (cursors = (List)this.registeredDomainCursors.get(baseDN)) != null && !cursors.isEmpty()) {
                for (DomainDBCursor cursor : cursors) {
                    cursor.addReplicaDB(serverId, null);
                }
            }
            return result;
        }
        throw new ChangelogException(ReplicationMessages.ERR_CANNOT_CREATE_REPLICA_DB_BECAUSE_CHANGELOG_DB_SHUTDOWN.get());
    }

    private ConcurrentMap<Integer, JEReplicaDB> getExistingOrNewDomainMap(DN baseDN) {
        ConcurrentMap currentValue = (ConcurrentMap)this.domainToReplicaDBs.get(baseDN);
        if (currentValue != null) {
            return currentValue;
        }
        ConcurrentHashMap<Integer, JEReplicaDB> newValue = new ConcurrentHashMap<Integer, JEReplicaDB>();
        ConcurrentMap previousValue = this.domainToReplicaDBs.putIfAbsent(baseDN, newValue);
        if (previousValue != null) {
            return previousValue;
        }
        for (MultiDomainDBCursor cursor : this.registeredMultiDomainCursors) {
            cursor.addDomain(baseDN, null);
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<JEReplicaDB, Boolean> getExistingOrNewReplicaDB(ConcurrentMap<Integer, JEReplicaDB> domainMap, int serverId, DN baseDN, ReplicationServer server) throws ChangelogException {
        JEReplicaDB currentValue = (JEReplicaDB)domainMap.get(serverId);
        if (currentValue != null) {
            return Pair.of((Object)currentValue, (Object)false);
        }
        ConcurrentMap<Integer, JEReplicaDB> concurrentMap = domainMap;
        synchronized (concurrentMap) {
            currentValue = (JEReplicaDB)domainMap.get(serverId);
            if (currentValue != null) {
                return Pair.of((Object)currentValue, (Object)false);
            }
            if (this.domainToReplicaDBs.get(baseDN) != domainMap) {
                return null;
            }
            JEReplicaDB newDB = new JEReplicaDB(serverId, baseDN, server, this.replicationEnv);
            domainMap.put(serverId, newDB);
            return Pair.of((Object)newDB, (Object)true);
        }
    }

    public void initializeDB() {
        try {
            File dbDir = StaticUtils.getFileForPath((String)this.config.getReplicationDBDirectory());
            this.replicationEnv = new ReplicationDbEnv(dbDir.getAbsolutePath(), this.replicationServer);
            ChangelogState changelogState = this.replicationEnv.getChangelogState();
            this.initializeToChangelogState(changelogState);
            if (this.config.isComputeChangeNumber()) {
                this.startIndexer(changelogState);
            }
            this.setPurgeDelay(this.replicationServer.getPurgeDelay());
        }
        catch (ChangelogException e) {
            logger.traceException((Throwable)e);
            logger.error(ReplicationMessages.ERR_COULD_NOT_READ_DB, (Object)this.dbDirectory.getAbsolutePath(), (Object)e.getLocalizedMessage());
        }
    }

    private void initializeToChangelogState(ChangelogState changelogState) throws ChangelogException {
        for (Map.Entry entry : changelogState.getDomainToGenerationId().entrySet()) {
            this.replicationServer.getReplicationServerDomain((DN)entry.getKey(), true).initGenerationID(((Long)entry.getValue()).longValue());
        }
        for (Map.Entry entry : changelogState.getDomainToServerIds().entrySet()) {
            Iterator i$ = ((Set)entry.getValue()).iterator();
            while (i$.hasNext()) {
                int serverId = (Integer)i$.next();
                this.getOrCreateReplicaDB((DN)entry.getKey(), serverId, this.replicationServer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownChangeNumberIndexDB() throws ChangelogException {
        Object object = this.cnIndexDBLock;
        synchronized (object) {
            if (this.cnIndexDB != null) {
                this.cnIndexDB.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownDB() throws ChangelogException {
        ChangelogDBPurger purger;
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        ChangelogException firstException = null;
        ChangeNumberIndexer indexer = this.cnIndexer.getAndSet(null);
        if (indexer != null) {
            indexer.initiateShutdown();
        }
        if ((purger = (ChangelogDBPurger)this.cnPurger.getAndSet(null)) != null) {
            purger.initiateShutdown();
        }
        try {
            this.shutdownChangeNumberIndexDB();
        }
        catch (ChangelogException e) {
            firstException = e;
        }
        Iterator it = this.domainToReplicaDBs.values().iterator();
        while (it.hasNext()) {
            ConcurrentMap domainMap;
            ConcurrentMap concurrentMap = domainMap = (ConcurrentMap)it.next();
            synchronized (concurrentMap) {
                it.remove();
                for (JEReplicaDB replicaDB : domainMap.values()) {
                    replicaDB.shutdown();
                }
            }
        }
        if (this.replicationEnv != null) {
            try {
                if (indexer != null) {
                    indexer.join();
                }
                if (purger != null) {
                    purger.join();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.replicationEnv.shutdown();
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDB() throws ChangelogException {
        if (!this.dbDirectory.exists()) {
            return;
        }
        ChangelogException firstException = null;
        for (DN baseDN : this.domainToReplicaDBs.keySet()) {
            this.removeDomain(baseDN);
        }
        Object object = this.cnIndexDBLock;
        synchronized (object) {
            if (this.cnIndexDB != null) {
                try {
                    this.cnIndexDB.clear();
                }
                catch (ChangelogException e) {
                    firstException = e;
                }
                try {
                    this.shutdownChangeNumberIndexDB();
                }
                catch (ChangelogException e) {
                    if (firstException == null) {
                        firstException = e;
                    }
                    logger.traceException((Throwable)e);
                }
                this.cnIndexDB = null;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public void removeDB() throws ChangelogException {
        this.shutdownDB();
        StaticUtils.recursiveDelete((File)this.dbDirectory);
    }

    public ServerState getDomainOldestCSNs(DN baseDN) {
        ServerState result = new ServerState();
        for (JEReplicaDB replicaDB : this.getDomainMap(baseDN).values()) {
            result.update(replicaDB.getOldestCSN());
        }
        return result;
    }

    public ServerState getDomainNewestCSNs(DN baseDN) {
        ServerState result = new ServerState();
        for (JEReplicaDB replicaDB : this.getDomainMap(baseDN).values()) {
            result.update(replicaDB.getNewestCSN());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDomain(DN baseDN) throws ChangelogException {
        Object indexer;
        ChangelogException firstException = null;
        Map domainMap = (Map)this.domainToReplicaDBs.get(baseDN);
        if (domainMap != null) {
            indexer = this.cnIndexer.get();
            if (indexer != null) {
                indexer.clear(baseDN);
            }
            Map map = domainMap;
            synchronized (map) {
                domainMap = (Map)this.domainToReplicaDBs.remove(baseDN);
                for (JEReplicaDB replicaDB : domainMap.values()) {
                    try {
                        replicaDB.clear();
                    }
                    catch (ChangelogException e) {
                        firstException = e;
                    }
                    replicaDB.shutdown();
                }
            }
        }
        indexer = this.cnIndexDBLock;
        synchronized (indexer) {
            if (this.cnIndexDB != null) {
                try {
                    this.cnIndexDB.removeDomain(baseDN);
                }
                catch (ChangelogException e) {
                    if (firstException == null) {
                        firstException = e;
                    }
                    logger.traceException((Throwable)e);
                }
            }
        }
        try {
            this.replicationEnv.clearGenerationId(baseDN);
        }
        catch (ChangelogException e) {
            if (firstException == null) {
                firstException = e;
            }
            logger.traceException((Throwable)e);
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPurgeDelay(long purgeDelayInMillis) {
        this.purgeDelayInMillis = purgeDelayInMillis;
        if (purgeDelayInMillis > 0L) {
            ChangelogDBPurger newPurger = new ChangelogDBPurger();
            if (this.cnPurger.compareAndSet(null, newPurger)) {
                newPurger.start();
            } else {
                ChangelogDBPurger currentPurger;
                ChangelogDBPurger changelogDBPurger = currentPurger = this.cnPurger.get();
                synchronized (changelogDBPurger) {
                    ((Object)((Object)currentPurger)).notify();
                }
            }
        } else {
            ChangelogDBPurger purgerToStop = this.cnPurger.getAndSet(null);
            if (purgerToStop != null) {
                purgerToStop.initiateShutdown();
            }
        }
    }

    public void setComputeChangeNumber(boolean computeChangeNumber) throws ChangelogException {
        if (computeChangeNumber) {
            this.startIndexer(this.replicationEnv.getChangelogState());
        } else {
            ChangeNumberIndexer indexer = this.cnIndexer.getAndSet(null);
            if (indexer != null) {
                indexer.initiateShutdown();
            }
        }
    }

    private void startIndexer(ChangelogState changelogState) {
        ChangeNumberIndexer indexer = new ChangeNumberIndexer((ChangelogDB)this, changelogState);
        if (this.cnIndexer.compareAndSet(null, indexer)) {
            indexer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeNumberIndexDB getChangeNumberIndexDB() {
        Object object = this.cnIndexDBLock;
        synchronized (object) {
            if (this.cnIndexDB == null) {
                try {
                    this.cnIndexDB = new JEChangeNumberIndexDB(this.replicationEnv);
                }
                catch (Exception e) {
                    logger.traceException((Throwable)e);
                    logger.error(ReplicationMessages.ERR_CHANGENUMBER_DATABASE, (Object)e.getLocalizedMessage());
                }
            }
            return this.cnIndexDB;
        }
    }

    public ReplicationDomainDB getReplicationDomainDB() {
        return this;
    }

    public MultiDomainDBCursor getCursorFrom(MultiDomainServerState startState, DBCursor.CursorOptions options) throws ChangelogException {
        Set<DN> excludedDomainDns = Collections.emptySet();
        return this.getCursorFrom(startState, options, excludedDomainDns);
    }

    public MultiDomainDBCursor getCursorFrom(MultiDomainServerState startState, DBCursor.CursorOptions options, Set<DN> excludedDomainDns) throws ChangelogException {
        MultiDomainDBCursor cursor = new MultiDomainDBCursor((ReplicationDomainDB)this, options);
        this.registeredMultiDomainCursors.add(cursor);
        for (DN baseDN : this.domainToReplicaDBs.keySet()) {
            if (excludedDomainDns.contains(baseDN)) continue;
            cursor.addDomain(baseDN, startState.getServerState(baseDN));
        }
        return cursor;
    }

    public DBCursor<UpdateMsg> getCursorFrom(DN baseDN, ServerState startState, DBCursor.CursorOptions options) throws ChangelogException {
        DomainDBCursor cursor = this.newDomainDBCursor(baseDN, options);
        for (int serverId : this.getDomainMap(baseDN).keySet()) {
            CSN lastCSN = startState != null ? startState.getCSN(serverId) : null;
            cursor.addReplicaDB(serverId, lastCSN);
        }
        return cursor;
    }

    private DomainDBCursor newDomainDBCursor(DN baseDN, DBCursor.CursorOptions options) {
        DomainDBCursor cursor = new DomainDBCursor(baseDN, (ReplicationDomainDB)this, options);
        this.putCursor(this.registeredDomainCursors, baseDN, cursor);
        return cursor;
    }

    private CSN getOfflineCSN(DN baseDN, int serverId, CSN startAfterCSN) {
        MultiDomainServerState offlineReplicas = this.replicationEnv.getChangelogState().getOfflineReplicas();
        CSN offlineCSN = offlineReplicas.getCSN(baseDN, serverId);
        if (offlineCSN != null && (startAfterCSN == null || startAfterCSN.isOlderThan(offlineCSN))) {
            return offlineCSN;
        }
        return null;
    }

    public DBCursor<UpdateMsg> getCursorFrom(DN baseDN, int serverId, CSN startCSN, DBCursor.CursorOptions options) throws ChangelogException {
        JEReplicaDB replicaDB = this.getReplicaDB(baseDN, serverId);
        if (replicaDB != null) {
            CSN actualStartCSN = startCSN != null ? startCSN : options.getDefaultCSN();
            DBCursor<UpdateMsg> cursor = replicaDB.generateCursorFrom(actualStartCSN, options.getKeyMatchingStrategy(), options.getPositionStrategy());
            CSN offlineCSN = this.getOfflineCSN(baseDN, serverId, actualStartCSN);
            ReplicaId replicaId = ReplicaId.of((DN)baseDN, (int)serverId);
            ReplicaCursor replicaCursor = new ReplicaCursor(cursor, offlineCSN, replicaId, (ReplicationDomainDB)this);
            this.putCursor(this.replicaCursors, replicaId, replicaCursor);
            return replicaCursor;
        }
        return EMPTY_CURSOR_REPLICA_DB;
    }

    private <K, V> void putCursor(ConcurrentSkipListMap<K, CopyOnWriteArrayList<V>> map, K key, V cursor) {
        CopyOnWriteArrayList<V> previousValue;
        CopyOnWriteArrayList<Object> cursors = map.get(key);
        if (cursors == null && (previousValue = map.putIfAbsent(key, cursors = new CopyOnWriteArrayList())) != null) {
            cursors = previousValue;
        }
        cursors.add(cursor);
    }

    public void unregisterCursor(DBCursor<?> cursor) {
        ReplicaCursor replicaCursor;
        List cursors;
        if (cursor instanceof MultiDomainDBCursor) {
            this.registeredMultiDomainCursors.remove(cursor);
        } else if (cursor instanceof DomainDBCursor) {
            DomainDBCursor domainCursor = (DomainDBCursor)cursor;
            List cursors2 = this.registeredDomainCursors.get(domainCursor.getBaseDN());
            if (cursors2 != null) {
                cursors2.remove(cursor);
            }
        } else if (cursor instanceof ReplicaCursor && (cursors = (List)this.replicaCursors.get((replicaCursor = (ReplicaCursor)cursor).getReplicaId())) != null) {
            cursors.remove(cursor);
        }
    }

    public boolean publishUpdateMsg(DN baseDN, UpdateMsg updateMsg) throws ChangelogException {
        CSN csn = updateMsg.getCSN();
        Pair<JEReplicaDB, Boolean> pair = this.getOrCreateReplicaDB(baseDN, csn.getServerId(), this.replicationServer);
        JEReplicaDB replicaDB = (JEReplicaDB)pair.getFirst();
        replicaDB.add(updateMsg);
        ChangelogBackend.getInstance().notifyCookieEntryAdded(baseDN, updateMsg);
        ChangeNumberIndexer indexer = this.cnIndexer.get();
        if (indexer != null) {
            this.notifyReplicaOnline(indexer, baseDN, csn.getServerId());
            indexer.publishUpdateMsg(baseDN, updateMsg);
        }
        return (Boolean)pair.getSecond();
    }

    public void replicaHeartbeat(DN baseDN, CSN heartbeatCSN) throws ChangelogException {
        ChangeNumberIndexer indexer = this.cnIndexer.get();
        if (indexer != null) {
            this.notifyReplicaOnline(indexer, baseDN, heartbeatCSN.getServerId());
            indexer.publishHeartbeat(baseDN, heartbeatCSN);
        }
    }

    private void notifyReplicaOnline(ChangeNumberIndexer indexer, DN baseDN, int serverId) throws ChangelogException {
        if (indexer.isReplicaOffline(baseDN, serverId)) {
            this.replicationEnv.notifyReplicaOnline(baseDN, serverId);
        }
        this.updateCursorsWithOfflineCSN(baseDN, serverId, null);
    }

    public void notifyReplicaOffline(DN baseDN, CSN offlineCSN) throws ChangelogException {
        this.replicationEnv.notifyReplicaOffline(baseDN, offlineCSN);
        ChangeNumberIndexer indexer = this.cnIndexer.get();
        if (indexer != null) {
            indexer.replicaOffline(baseDN, offlineCSN);
        }
        this.updateCursorsWithOfflineCSN(baseDN, offlineCSN.getServerId(), offlineCSN);
    }

    private void updateCursorsWithOfflineCSN(DN baseDN, int serverId, CSN offlineCSN) {
        List cursors = this.replicaCursors.get(ReplicaId.of((DN)baseDN, (int)serverId));
        if (cursors != null) {
            for (ReplicaCursor cursor : cursors) {
                cursor.setOfflineCSN(offlineCSN);
            }
        }
    }

    private final class ChangelogDBPurger
    extends DirectoryThread {
        private static final int DEFAULT_SLEEP = 500;

        protected ChangelogDBPurger() {
            super("changelog DB purger");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            JEChangelogDB.this.getChangeNumberIndexDB();
            while (!this.isShutdownInitiated()) {
                try {
                    CSN oldestNotPurgedCSN;
                    long purgeTimestamp = TimeThread.getTime() - JEChangelogDB.this.purgeDelayInMillis;
                    CSN purgeCSN = new CSN(purgeTimestamp, 0, 0);
                    if (!JEChangelogDB.this.config.isComputeChangeNumber()) {
                        oldestNotPurgedCSN = purgeCSN;
                    } else {
                        JEChangeNumberIndexDB localCNIndexDB = JEChangelogDB.this.cnIndexDB;
                        if (localCNIndexDB == null) {
                            return;
                        }
                        oldestNotPurgedCSN = localCNIndexDB.purgeUpTo(purgeCSN);
                        if (oldestNotPurgedCSN == null) {
                            if (this.isShutdownInitiated()) continue;
                            ChangelogDBPurger changelogDBPurger = this;
                            synchronized (changelogDBPurger) {
                                if (!this.isShutdownInitiated()) {
                                    ((Object)((Object)this)).wait(500L);
                                }
                                continue;
                            }
                        }
                    }
                    for (Map domainMap : JEChangelogDB.this.domainToReplicaDBs.values()) {
                        for (JEReplicaDB replicaDB : domainMap.values()) {
                            replicaDB.purgeUpTo(oldestNotPurgedCSN);
                        }
                    }
                    if (this.isShutdownInitiated()) continue;
                    ChangelogDBPurger changelogDBPurger = this;
                    synchronized (changelogDBPurger) {
                        if (!this.isShutdownInitiated()) {
                            ((Object)((Object)this)).wait(this.computeSleepTimeUntilNextPurge(oldestNotPurgedCSN));
                        }
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    logger.error(ReplicationMessages.ERR_EXCEPTION_CHANGELOG_TRIM_FLUSH, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e));
                    if (JEChangelogDB.this.replicationServer == null) continue;
                    JEChangelogDB.this.replicationServer.shutdown();
                }
            }
        }

        private long computeSleepTimeUntilNextPurge(CSN notPurgedCSN) {
            long nextPurgeTime = notPurgedCSN.getTime();
            long currentPurgeTime = TimeThread.getTime() - JEChangelogDB.this.purgeDelayInMillis;
            if (currentPurgeTime <= nextPurgeTime) {
                return nextPurgeTime - currentPurgeTime;
            }
            return 500L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initiateShutdown() {
            super.initiateShutdown();
            ChangelogDBPurger changelogDBPurger = this;
            synchronized (changelogDBPurger) {
                ((Object)((Object)this)).notify();
            }
        }
    }
}

