/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server.changelog.je;

import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.opends.server.replication.server.changelog.api.ChangeNumberIndexRecord;
import org.opends.server.replication.server.changelog.api.ChangelogException;
import org.opends.server.replication.server.changelog.api.DBCursor;
import org.opends.server.replication.server.changelog.je.DraftCNDB;

public class JEChangeNumberIndexDBCursor
implements DBCursor<ChangeNumberIndexRecord> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private DraftCNDB.DraftCNDBCursor draftCNDbCursor;
    private boolean isInitialized;

    public JEChangeNumberIndexDBCursor(DraftCNDB db, long startChangeNumber) throws ChangelogException {
        this.draftCNDbCursor = db.openReadCursor(startChangeNumber);
    }

    public ChangeNumberIndexRecord getRecord() {
        try {
            return this.isInitialized ? this.draftCNDbCursor.currentRecord() : null;
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
            return null;
        }
    }

    public boolean next() throws ChangelogException {
        if (this.draftCNDbCursor != null) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                return this.draftCNDbCursor.currentRecord() != null;
            }
            return this.draftCNDbCursor.next();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JEChangeNumberIndexDBCursor jEChangeNumberIndexDBCursor = this;
        synchronized (jEChangeNumberIndexDBCursor) {
            if (this.draftCNDbCursor != null) {
                this.draftCNDbCursor.close();
                this.draftCNDbCursor = null;
            }
        }
    }

    protected void finalize() {
        this.close();
    }
}

