/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server.changelog.je;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigException;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.replication.common.CSN;
import org.opends.server.replication.server.changelog.api.ChangeNumberIndexDB;
import org.opends.server.replication.server.changelog.api.ChangeNumberIndexRecord;
import org.opends.server.replication.server.changelog.api.ChangelogException;
import org.opends.server.replication.server.changelog.api.DBCursor;
import org.opends.server.replication.server.changelog.je.DraftCNDB;
import org.opends.server.replication.server.changelog.je.JEChangeNumberIndexDBCursor;
import org.opends.server.replication.server.changelog.je.ReplicationDbEnv;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;

public class JEChangeNumberIndexDB
implements ChangeNumberIndexDB {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final int NO_KEY = 0;
    private DraftCNDB db;
    private volatile long newestChangeNumber = 0L;
    private final AtomicLong lastGeneratedChangeNumber;
    private DbMonitorProvider dbMonitor = new DbMonitorProvider();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public JEChangeNumberIndexDB(ReplicationDbEnv dbEnv) throws ChangelogException {
        this.db = new DraftCNDB(dbEnv);
        ChangeNumberIndexRecord newestRecord = this.db.readLastRecord();
        this.newestChangeNumber = this.getChangeNumber(newestRecord);
        this.lastGeneratedChangeNumber = new AtomicLong(this.newestChangeNumber);
        DirectoryServer.deregisterMonitorProvider((MonitorProvider)this.dbMonitor);
        DirectoryServer.registerMonitorProvider((MonitorProvider)this.dbMonitor);
    }

    private long getChangeNumber(ChangeNumberIndexRecord record) throws ChangelogException {
        if (record != null) {
            return record.getChangeNumber();
        }
        return 0L;
    }

    public long addRecord(ChangeNumberIndexRecord record) throws ChangelogException {
        long changeNumber = this.nextChangeNumber();
        ChangeNumberIndexRecord newRecord = new ChangeNumberIndexRecord(changeNumber, record.getBaseDN(), record.getCSN());
        this.db.addRecord(newRecord);
        this.newestChangeNumber = changeNumber;
        logger.trace("In JEChangeNumberIndexDB.add, added: %s", (Object)newRecord);
        return changeNumber;
    }

    public ChangeNumberIndexRecord getOldestRecord() throws ChangelogException {
        return this.db.readFirstRecord();
    }

    public ChangeNumberIndexRecord getNewestRecord() throws ChangelogException {
        return this.db.readLastRecord();
    }

    private long nextChangeNumber() {
        return this.lastGeneratedChangeNumber.incrementAndGet();
    }

    public long getLastGeneratedChangeNumber() {
        return this.lastGeneratedChangeNumber.get();
    }

    public long count() {
        return this.db.count();
    }

    public boolean isEmpty() throws ChangelogException {
        return this.getNewestRecord() == null;
    }

    public DBCursor<ChangeNumberIndexRecord> getCursorFrom(long startChangeNumber) throws ChangelogException {
        return new JEChangeNumberIndexDBCursor(this.db, startChangeNumber);
    }

    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.db.shutdown();
            DirectoryServer.deregisterMonitorProvider((MonitorProvider)this.dbMonitor);
        }
    }

    public CSN purgeUpTo(CSN purgeCSN) throws ChangelogException {
        if (this.isEmpty() || purgeCSN == null) {
            return null;
        }
        try (DraftCNDB.DraftCNDBCursor cursor = this.db.openDeleteCursor();){
            ChangeNumberIndexRecord record;
            while (!this.mustShutdown(this.shutdown) && cursor.next()) {
                record = cursor.currentRecord();
                if (record.getChangeNumber() == this.newestChangeNumber || !record.getCSN().isOlderThan(purgeCSN)) {
                    CSN cSN = record.getCSN();
                    return cSN;
                }
                cursor.delete();
            }
            record = null;
            return record;
        }
    }

    public void removeDomain(DN baseDNToClear) throws ChangelogException {
        if (this.isEmpty()) {
            return;
        }
        try (DraftCNDB.DraftCNDBCursor cursor = this.db.openDeleteCursor();){
            while (!this.mustShutdown(this.shutdown) && cursor.next()) {
                ChangeNumberIndexRecord record = cursor.currentRecord();
                if (record.getChangeNumber() == this.newestChangeNumber) {
                    return;
                }
                if (baseDNToClear != null && !record.getBaseDN().equals((Object)baseDNToClear)) continue;
                cursor.delete();
            }
        }
    }

    private boolean mustShutdown(AtomicBoolean shutdown) {
        return shutdown != null && shutdown.get();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", newestChangeNumber=" + this.newestChangeNumber;
    }

    public void clear() throws ChangelogException {
        this.db.clear();
        this.newestChangeNumber = 0L;
    }

    private class DbMonitorProvider
    extends MonitorProvider<MonitorProviderCfg> {
        private DbMonitorProvider() {
        }

        public List<Attribute> getMonitorData() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(this.createChangeNumberAttribute(true));
            attributes.add(this.createChangeNumberAttribute(false));
            attributes.add(Attributes.create((String)"count", (String)Long.toString(JEChangeNumberIndexDB.this.count())));
            return attributes;
        }

        private Attribute createChangeNumberAttribute(boolean isFirst) {
            String attributeName = isFirst ? "first-draft-changenumber" : "last-draft-changenumber";
            String changeNumber = String.valueOf(this.readChangeNumber(isFirst));
            return Attributes.create((String)attributeName, (String)changeNumber);
        }

        private long readChangeNumber(boolean isFirst) {
            try {
                return JEChangeNumberIndexDB.this.getChangeNumber(isFirst ? JEChangeNumberIndexDB.this.db.readFirstRecord() : JEChangeNumberIndexDB.this.db.readLastRecord());
            }
            catch (ChangelogException e) {
                logger.traceException((Throwable)e);
                return 0L;
            }
        }

        public String getMonitorInstanceName() {
            return "ChangeNumber Index Database";
        }

        public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        }
    }
}

