/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server.changelog.je;

import com.sleepycat.je.DatabaseEntry;
import java.io.UnsupportedEncodingException;
import org.forgerock.i18n.LocalizableMessage;
import org.opends.server.replication.common.CSN;
import org.opends.server.replication.server.changelog.api.ChangeNumberIndexRecord;
import org.opends.server.replication.server.changelog.api.ChangelogException;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

public class DraftCNData
extends DatabaseEntry {
    private static final String FIELD_SEPARATOR = "!";
    private static final String EMPTY_STRING_PREVIOUS_COOKIE = "";
    private static final long serialVersionUID = 1L;
    private long changeNumber;
    private ChangeNumberIndexRecord record;

    public DraftCNData(long changeNumber, DN baseDN, CSN csn) {
        this.changeNumber = changeNumber;
        String record = FIELD_SEPARATOR + baseDN + FIELD_SEPARATOR + csn;
        this.setData(StaticUtils.getBytes((String)record));
    }

    public DraftCNData(long changeNumber, byte[] data) throws ChangelogException {
        this.changeNumber = changeNumber;
        this.record = this.decodeData(changeNumber, data);
    }

    private ChangeNumberIndexRecord decodeData(long changeNumber, byte[] data) throws ChangelogException {
        try {
            String stringData = new String(data, "UTF-8");
            String[] str = stringData.split(FIELD_SEPARATOR, 3);
            DN baseDN = DN.valueOf((String)str[1]);
            CSN csn = new CSN(str[2]);
            return new ChangeNumberIndexRecord(changeNumber, baseDN, csn);
        }
        catch (UnsupportedEncodingException e) {
            throw new ChangelogException(LocalizableMessage.raw((CharSequence)"need UTF-8 support", (Object[])new Object[0]));
        }
        catch (DirectoryException e) {
            throw new ChangelogException((Throwable)e);
        }
    }

    public ChangeNumberIndexRecord getRecord() throws ChangelogException {
        if (this.record == null) {
            this.record = this.decodeData(this.changeNumber, this.getData());
        }
        return this.record;
    }

    public String toString() {
        return "DraftCNData : [" + this.record + "]";
    }
}

