/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server.changelog.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.Closeable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.opends.messages.ReplicationMessages;
import org.opends.server.replication.server.changelog.api.ChangeNumberIndexRecord;
import org.opends.server.replication.server.changelog.api.ChangelogException;
import org.opends.server.replication.server.changelog.je.DraftCNData;
import org.opends.server.replication.server.changelog.je.JEUtils;
import org.opends.server.replication.server.changelog.je.ReplicationDbEnv;
import org.opends.server.replication.server.changelog.je.ReplicationDraftCNKey;
import org.opends.server.util.StaticUtils;

public class DraftCNDB {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private Database db;
    private ReplicationDbEnv dbenv;
    private final ReadWriteLock dbCloseLock = new ReentrantReadWriteLock(true);

    public DraftCNDB(ReplicationDbEnv dbenv) throws ChangelogException {
        this.dbenv = dbenv;
        this.db = dbenv.getOrCreateCNIndexDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(ChangeNumberIndexRecord record) throws ChangelogException {
        try {
            Transaction txn;
            DraftCNData data;
            ReplicationDraftCNKey key;
            block5: {
                long changeNumber = record.getChangeNumber();
                key = new ReplicationDraftCNKey(changeNumber);
                data = new DraftCNData(changeNumber, record.getBaseDN(), record.getCSN());
                txn = null;
                this.dbCloseLock.readLock().lock();
                try {
                    if (!this.isDBClosed()) break block5;
                }
                catch (Throwable throwable) {
                    JEUtils.abort(txn);
                    this.dbCloseLock.readLock().unlock();
                    throw throwable;
                }
                JEUtils.abort(txn);
                this.dbCloseLock.readLock().unlock();
                return;
            }
            txn = this.dbenv.beginTransaction();
            this.db.put(txn, (DatabaseEntry)key, (DatabaseEntry)data);
            txn.commit(Durability.COMMIT_WRITE_NO_SYNC);
            JEUtils.abort(txn);
            this.dbCloseLock.readLock().unlock();
        }
        catch (DatabaseException e) {
            throw new ChangelogException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.dbCloseLock.writeLock().lock();
        try {
            this.db.close();
            this.db = null;
        }
        catch (DatabaseException e) {
            logger.info(ReplicationMessages.NOTE_EXCEPTION_CLOSING_DATABASE, (Object)this, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e));
        }
        finally {
            this.dbCloseLock.writeLock().unlock();
        }
    }

    public DraftCNDBCursor openReadCursor(long changeNumber) throws ChangelogException {
        return new DraftCNDBCursor(this, changeNumber, null);
    }

    public DraftCNDBCursor openDeleteCursor() throws ChangelogException {
        return new DraftCNDBCursor(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLockedCursor(Cursor cursor) {
        try {
            StaticUtils.close((Closeable[])new Closeable[]{cursor});
        }
        finally {
            this.dbCloseLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangeNumberIndexRecord readFirstRecord() throws ChangelogException {
        try {
            this.dbCloseLock.readLock().lock();
            Cursor cursor = null;
            try {
                DatabaseEntry entry;
                ReplicationDraftCNKey key;
                if (this.isDBClosed()) {
                    ChangeNumberIndexRecord changeNumberIndexRecord = null;
                    this.closeLockedCursor(cursor);
                    return changeNumberIndexRecord;
                }
                cursor = this.db.openCursor(null, null);
                if (cursor.getFirst((DatabaseEntry)(key = new ReplicationDraftCNKey()), entry = new DatabaseEntry(), LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                    ChangeNumberIndexRecord changeNumberIndexRecord = null;
                    this.closeLockedCursor(cursor);
                    return changeNumberIndexRecord;
                }
                ChangeNumberIndexRecord changeNumberIndexRecord = this.newCNIndexRecord(key, entry);
                this.closeLockedCursor(cursor);
                return changeNumberIndexRecord;
            }
            catch (Throwable throwable) {
                this.closeLockedCursor(cursor);
                throw throwable;
            }
        }
        catch (DatabaseException e) {
            throw new ChangelogException((Throwable)e);
        }
    }

    private ChangeNumberIndexRecord newCNIndexRecord(ReplicationDraftCNKey key, DatabaseEntry data) throws ChangelogException {
        return new DraftCNData(key.getChangeNumber(), data.getData()).getRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        this.dbCloseLock.readLock().lock();
        try {
            if (this.isDBClosed()) {
                long l = 0L;
                return l;
            }
            long l = this.db.count();
            return l;
        }
        catch (DatabaseException e) {
            logger.traceException((Throwable)e);
        }
        finally {
            this.dbCloseLock.readLock().unlock();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangeNumberIndexRecord readLastRecord() throws ChangelogException {
        try {
            this.dbCloseLock.readLock().lock();
            Cursor cursor = null;
            try {
                DatabaseEntry entry;
                ReplicationDraftCNKey key;
                if (this.isDBClosed()) {
                    ChangeNumberIndexRecord changeNumberIndexRecord = null;
                    this.closeLockedCursor(cursor);
                    return changeNumberIndexRecord;
                }
                cursor = this.db.openCursor(null, null);
                if (cursor.getLast((DatabaseEntry)(key = new ReplicationDraftCNKey()), entry = new DatabaseEntry(), LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                    ChangeNumberIndexRecord changeNumberIndexRecord = null;
                    this.closeLockedCursor(cursor);
                    return changeNumberIndexRecord;
                }
                ChangeNumberIndexRecord changeNumberIndexRecord = this.newCNIndexRecord(key, entry);
                this.closeLockedCursor(cursor);
                return changeNumberIndexRecord;
            }
            catch (Throwable throwable) {
                this.closeLockedCursor(cursor);
                throw throwable;
            }
        }
        catch (DatabaseException e) {
            throw new ChangelogException((Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws ChangelogException {
        this.dbCloseLock.writeLock().lock();
        try {
            if (this.isDBClosed()) {
                return;
            }
            Database oldDb = this.db;
            this.db = null;
            this.dbenv.clearDb(oldDb);
            this.db = this.dbenv.getOrCreateCNIndexDB();
        }
        catch (Exception e) {
            logger.error(ReplicationMessages.ERR_ERROR_CLEARING_DB, (Object)this, (Object)(e.getMessage() + " " + StaticUtils.stackTraceToSingleLineString((Throwable)e)));
        }
        finally {
            this.dbCloseLock.writeLock().unlock();
        }
    }

    private boolean isDBClosed() {
        return this.db == null || !this.db.getEnvironment().isValid();
    }

    static class 1 {
    }

    /*
     * Exception performing whole class analysis.
     */
    public class DraftCNDBCursor
    implements Closeable {
        private final Cursor cursor;
        private final Transaction txn;
        private final ReplicationDraftCNKey key;
        private final DatabaseEntry entry;
        private ChangeNumberIndexRecord record;
        private boolean isClosed;
        final /* synthetic */ DraftCNDB this$0;

        /*
         * Unable to fully structure code
         */
        private DraftCNDBCursor(DraftCNDB var1_1, long startChangeNumber) throws ChangelogException {
            block12: {
                block13: {
                    block10: {
                        block11: {
                            this.this$0 = var1_1;
                            super();
                            this.entry = new DatabaseEntry();
                            this.key = new ReplicationDraftCNKey(startChangeNumber);
                            DraftCNDB.access$200(var1_1).readLock().lock();
                            cursorHeld = false;
                            localCursor = null;
                            if (!DraftCNDB.access$300(var1_1)) break block10;
                            this.isClosed = true;
                            this.txn = null;
                            this.cursor = null;
                            if (cursorHeld) break block11;
                            DraftCNDB.access$600(var1_1, localCursor);
                        }
                        return;
                    }
                    localCursor = DraftCNDB.access$400(var1_1).openCursor(null, null);
                    if (startChangeNumber < 0L) ** GOTO lbl39
                    if (localCursor.getSearchKey((DatabaseEntry)this.key, this.entry, LockMode.DEFAULT) == OperationStatus.SUCCESS) ** GOTO lbl38
                    if (localCursor.getSearchKeyRange((DatabaseEntry)this.key, this.entry, LockMode.DEFAULT) == OperationStatus.SUCCESS) break block12;
                    this.isClosed = true;
                    this.txn = null;
                    this.cursor = null;
                    if (cursorHeld) break block13;
                    DraftCNDB.access$600(var1_1, localCursor);
                }
                return;
            }
            try {
                block14: {
                    if (localCursor.getPrev((DatabaseEntry)this.key, this.entry, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                        localCursor.close();
                        localCursor = DraftCNDB.access$400(var1_1).openCursor(null, null);
                    } else {
                        this.record = DraftCNDB.access$500(var1_1, this.key, this.entry);
                    }
                    break block14;
lbl38:
                    // 1 sources

                    this.record = DraftCNDB.access$500(var1_1, this.key, this.entry);
                }
                this.txn = null;
                this.cursor = localCursor;
                cursorHeld = true;
                ** if (cursorHeld) goto lbl-1000
            }
            catch (DatabaseException e) {
                try {
                    throw new ChangelogException((Throwable)e);
                }
                catch (Throwable var7_6) {
                    if (!cursorHeld) {
                        DraftCNDB.access$600(var1_1, localCursor);
                    }
                    throw var7_6;
                }
            }
lbl-1000:
            // 1 sources

            {
                DraftCNDB.access$600(var1_1, localCursor);
            }
lbl-1000:
            // 2 sources

            {
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private DraftCNDBCursor(DraftCNDB draftCNDB) throws ChangelogException {
            boolean cursorHeld;
            Cursor localCursor;
            Transaction localTxn;
            block7: {
                block8: {
                    this.this$0 = draftCNDB;
                    this.entry = new DatabaseEntry();
                    localTxn = null;
                    localCursor = null;
                    this.key = new ReplicationDraftCNKey();
                    cursorHeld = false;
                    draftCNDB.dbCloseLock.readLock().lock();
                    if (!draftCNDB.isDBClosed()) break block7;
                    this.isClosed = true;
                    this.txn = null;
                    this.cursor = null;
                    if (cursorHeld) break block8;
                    draftCNDB.closeLockedCursor(localCursor);
                }
                return;
            }
            try {
                localTxn = draftCNDB.dbenv.beginTransaction();
                localCursor = draftCNDB.db.openCursor(localTxn, null);
                this.txn = localTxn;
                this.cursor = localCursor;
                return;
            }
            catch (DatabaseException e) {
                try {
                    logger.traceException((Throwable)e);
                    JEUtils.abort(localTxn);
                    throw new ChangelogException((Throwable)e);
                    catch (ChangelogException e2) {
                        logger.traceException((Throwable)e2);
                        JEUtils.abort(localTxn);
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (!cursorHeld) {
                        draftCNDB.closeLockedCursor(localCursor);
                    }
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            DraftCNDBCursor draftCNDBCursor = this;
            synchronized (draftCNDBCursor) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            this.this$0.closeLockedCursor(this.cursor);
            if (this.txn != null) {
                try {
                    this.txn.commit();
                }
                catch (DatabaseException e) {
                    this.this$0.dbenv.shutdownOnException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            DraftCNDBCursor draftCNDBCursor = this;
            synchronized (draftCNDBCursor) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            this.this$0.closeLockedCursor(this.cursor);
            JEUtils.abort(this.txn);
        }

        public ChangeNumberIndexRecord currentRecord() {
            if (this.isClosed) {
                return null;
            }
            return this.record;
        }

        public boolean next() throws ChangelogException {
            this.record = null;
            if (this.isClosed) {
                return false;
            }
            try {
                OperationStatus status = this.cursor.getNext((DatabaseEntry)this.key, this.entry, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS) {
                    this.record = this.this$0.newCNIndexRecord(this.key, this.entry);
                    return true;
                }
                return false;
            }
            catch (DatabaseException e) {
                throw new ChangelogException((Throwable)e);
            }
        }

        public void delete() throws ChangelogException {
            if (this.isClosed) {
                throw new IllegalStateException("DraftCNDB already closed");
            }
            try {
                this.cursor.delete();
            }
            catch (DatabaseException e) {
                throw new ChangelogException((Throwable)e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " currentRecord=" + this.record;
        }

        /* synthetic */ DraftCNDBCursor(DraftCNDB x0, long x1, 1 x2) throws ChangelogException {
            this(x0, x1);
        }

        /* synthetic */ DraftCNDBCursor(DraftCNDB x0, 1 x1) throws ChangelogException {
            this(x0);
        }
    }
}

