/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DiskOrderedCursor;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.opends.messages.BackendMessages;
import org.opends.server.backends.VerifyConfig;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.backends.jeb.SortValuesSet;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class VerifyJob {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final VerifyConfig verifyConfig;
    private RootContainer rootContainer;
    private final long progressInterval = 10000L;
    private long keyCount;
    private long errorCount;
    private long entryLimitExceededCount;
    private long multiReferenceCount;
    private long entryReferencesCount;
    private long maxEntryPerValue;
    private IdentityHashMap<Index, HashMap<ByteString, Long>> entryLimitMap = new IdentityHashMap();
    private boolean verifyDN2ID;
    private boolean verifyID2Children;
    private boolean verifyID2Subtree;
    private ID2Entry id2entry;
    private DN2ID dn2id;
    private Index id2c;
    private Index id2s;
    private final ArrayList<AttributeIndex> attrIndexList = new ArrayList();
    private final ArrayList<VLVIndex> vlvIndexList = new ArrayList();

    public VerifyJob(VerifyConfig verifyConfig) {
        this.verifyConfig = verifyConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long verifyBackend(RootContainer rootContainer) throws DatabaseException, JebException, DirectoryException {
        this.rootContainer = rootContainer;
        EntryContainer entryContainer = rootContainer.getEntryContainer(this.verifyConfig.getBaseDN());
        entryContainer.sharedLock.lock();
        try {
            List completeList = this.verifyConfig.getCompleteList();
            List cleanList = this.verifyConfig.getCleanList();
            boolean cleanMode = false;
            if (completeList.isEmpty() && cleanList.isEmpty()) {
                this.verifyDN2ID = true;
                if (rootContainer.getConfiguration().isSubordinateIndexesEnabled()) {
                    this.verifyID2Children = true;
                    this.verifyID2Subtree = true;
                }
                for (AttributeIndex index : entryContainer.getAttributeIndexes()) {
                    if (!index.isTrusted()) continue;
                    this.attrIndexList.add(index);
                }
            } else {
                List list;
                if (!completeList.isEmpty()) {
                    list = completeList;
                } else {
                    list = cleanList;
                    cleanMode = true;
                }
                for (String index : list) {
                    LocalizableMessage msg;
                    String lowerName = index.toLowerCase();
                    if ("dn2id".equals(lowerName)) {
                        this.verifyDN2ID = true;
                        continue;
                    }
                    if ("id2children".equals(lowerName)) {
                        if (rootContainer.getConfiguration().isSubordinateIndexesEnabled()) {
                            this.verifyID2Children = true;
                            continue;
                        }
                        msg = BackendMessages.NOTE_JEB_SUBORDINATE_INDEXES_DISABLED.get((Object)rootContainer.getConfiguration().getBackendId());
                        throw new JebException(msg);
                    }
                    if ("id2subtree".equals(lowerName)) {
                        if (rootContainer.getConfiguration().isSubordinateIndexesEnabled()) {
                            this.verifyID2Subtree = true;
                            continue;
                        }
                        msg = BackendMessages.NOTE_JEB_SUBORDINATE_INDEXES_DISABLED.get((Object)rootContainer.getConfiguration().getBackendId());
                        throw new JebException(msg);
                    }
                    if (lowerName.startsWith("vlv.")) {
                        if (lowerName.length() < 5) {
                            throw new JebException(BackendMessages.ERR_VLV_INDEX_NOT_CONFIGURED.get((Object)lowerName));
                        }
                        VLVIndex vlvIndex = entryContainer.getVLVIndex(lowerName.substring(4));
                        if (vlvIndex == null) {
                            throw new JebException(BackendMessages.ERR_VLV_INDEX_NOT_CONFIGURED.get((Object)lowerName.substring(4)));
                        }
                        this.vlvIndexList.add(vlvIndex);
                        continue;
                    }
                    AttributeType attrType = DirectoryServer.getAttributeType((String)lowerName);
                    if (attrType == null) {
                        throw new JebException(BackendMessages.ERR_ATTRIBUTE_INDEX_NOT_CONFIGURED.get((Object)index));
                    }
                    AttributeIndex attrIndex = entryContainer.getAttributeIndex(attrType);
                    if (attrIndex == null) {
                        throw new JebException(BackendMessages.ERR_ATTRIBUTE_INDEX_NOT_CONFIGURED.get((Object)index));
                    }
                    this.attrIndexList.add(attrIndex);
                }
            }
            this.entryLimitMap = new IdentityHashMap(this.attrIndexList.size());
            this.id2entry = entryContainer.getID2Entry();
            this.dn2id = entryContainer.getDN2ID();
            this.id2c = entryContainer.getID2Children();
            this.id2s = entryContainer.getID2Subtree();
            long startTime = System.currentTimeMillis();
            Timer timer = new Timer();
            ProgressTask progressTask = new ProgressTask(cleanMode);
            timer.scheduleAtFixedRate((TimerTask)progressTask, 10000L, 10000L);
            try {
                if (cleanMode) {
                    this.iterateIndex();
                } else {
                    this.iterateID2Entry();
                    for (VLVIndex vlvIndex : this.vlvIndexList) {
                        this.iterateVLVIndex(vlvIndex, false);
                    }
                }
            }
            finally {
                timer.cancel();
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            float rate = 0.0f;
            if (totalTime > 0L) {
                rate = 1000.0f * (float)this.keyCount / (float)totalTime;
            }
            if (cleanMode) {
                logger.info(BackendMessages.NOTE_VERIFY_CLEAN_FINAL_STATUS, (Object)this.keyCount, (Object)this.errorCount, (Object)(totalTime / 1000L), (Object)Float.valueOf(rate));
                if (this.multiReferenceCount > 0L) {
                    float averageEntryReferences = 0.0f;
                    if (this.keyCount > 0L) {
                        averageEntryReferences = this.entryReferencesCount / this.keyCount;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(BackendMessages.INFO_VERIFY_MULTIPLE_REFERENCE_COUNT, (Object)this.multiReferenceCount);
                        logger.debug(BackendMessages.INFO_VERIFY_ENTRY_LIMIT_EXCEEDED_COUNT, (Object)this.entryLimitExceededCount);
                        logger.debug(BackendMessages.INFO_VERIFY_AVERAGE_REFERENCE_COUNT, (Object)Float.valueOf(averageEntryReferences));
                        logger.debug(BackendMessages.INFO_VERIFY_MAX_REFERENCE_COUNT, (Object)this.maxEntryPerValue);
                    }
                }
            } else {
                logger.info(BackendMessages.NOTE_VERIFY_FINAL_STATUS, (Object)this.keyCount, (Object)this.errorCount, (Object)(totalTime / 1000L), (Object)Float.valueOf(rate));
                if (!this.entryLimitMap.isEmpty()) {
                    logger.debug(BackendMessages.INFO_VERIFY_ENTRY_LIMIT_STATS_HEADER);
                    for (Map.Entry<Index, HashMap<ByteString, Long>> mapEntry : this.entryLimitMap.entrySet()) {
                        Index index = mapEntry.getKey();
                        Object[] values = mapEntry.getValue().values().toArray(new Long[0]);
                        Arrays.sort(values);
                        int x = values.length / 2;
                        long medianValue = values.length % 2 == 0 ? ((Long)values[x] + (Long)values[x - 1]) / 2L : (Long)values[x];
                        logger.debug(BackendMessages.INFO_VERIFY_ENTRY_LIMIT_STATS_ROW, (Object)index, (Object)values.length, values[0], values[values.length - 1], (Object)medianValue);
                    }
                }
            }
        }
        finally {
            entryContainer.sharedLock.unlock();
        }
        return this.errorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateID2Entry() throws DatabaseException {
        long storedEntryCount = this.id2entry.getRecordCount();
        try (DiskOrderedCursor cursor = this.id2entry.openCursor(new DiskOrderedCursorConfig());){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                Entry entry;
                EntryID entryID;
                try {
                    entryID = new EntryID(key);
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.traceException((Throwable)e);
                    logger.trace("Malformed id2entry ID %s.%n", (Object)StaticUtils.bytesToHex((byte[])key.getData()));
                    continue;
                }
                ++this.keyCount;
                try {
                    entry = ID2Entry.entryFromDatabase(ByteString.wrap((byte[])data.getData()), this.rootContainer.getCompressedSchema());
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.traceException((Throwable)e);
                    logger.trace("Malformed id2entry record for ID %d:%n%s%n", (Object)entryID.longValue(), (Object)StaticUtils.bytesToHex((byte[])data.getData()));
                    continue;
                }
                this.verifyEntry(entryID, entry);
            }
            if (this.keyCount != storedEntryCount) {
                ++this.errorCount;
                if (logger.isTraceEnabled()) {
                    logger.trace("The stored entry count in id2entry (%d) does not agree with the actual number of entry records found (%d).%n", (Object)storedEntryCount, (Object)this.keyCount);
                }
            }
        }
    }

    private void iterateIndex() throws JebException, DatabaseException, DirectoryException {
        if (this.verifyDN2ID) {
            this.iterateDN2ID();
        } else if (this.verifyID2Children) {
            this.iterateID2Children();
        } else if (this.verifyID2Subtree) {
            this.iterateID2Subtree();
        } else if (!this.attrIndexList.isEmpty()) {
            for (Index index : this.attrIndexList.get(0).getAllIndexes()) {
                this.iterateAttrIndex(index);
            }
        } else if (!this.vlvIndexList.isEmpty()) {
            this.iterateVLVIndex(this.vlvIndexList.get(0), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateDN2ID() throws DatabaseException {
        try (DiskOrderedCursor cursor = this.dn2id.openCursor(new DiskOrderedCursorConfig());){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                Entry entry;
                EntryID entryID;
                ++this.keyCount;
                try {
                    entryID = new EntryID(data);
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.traceException((Throwable)e);
                    logger.trace("File dn2id has malformed ID for DN <%s>:%n%s%n", (Object)new String(key.getData()), (Object)StaticUtils.bytesToHex((byte[])data.getData()));
                    continue;
                }
                try {
                    entry = this.id2entry.get(null, entryID, LockMode.DEFAULT);
                }
                catch (Exception e) {
                    ++this.errorCount;
                    logger.traceException((Throwable)e);
                    continue;
                }
                if (entry == null) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("File dn2id has DN <%s> referencing unknown ID %d%n", (Object)new String(key.getData()), (Object)entryID.longValue());
                    continue;
                }
                if (Arrays.equals(JebFormat.dnToDNKey(entry.getName(), this.verifyConfig.getBaseDN().size()), key.getData())) continue;
                ++this.errorCount;
                if (!logger.isTraceEnabled()) continue;
                logger.trace("File dn2id has DN <%s> referencing entry with wrong DN <%s>%n", (Object)new String(key.getData()), (Object)entry.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateID2Children() throws JebException, DatabaseException {
        try (DiskOrderedCursor cursor = this.id2c.openCursor(new DiskOrderedCursorConfig());){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                Entry entry;
                EntryIDSet entryIDList;
                EntryID entryID;
                ++this.keyCount;
                try {
                    entryID = new EntryID(key);
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.traceException((Throwable)e);
                    logger.trace("File id2children has malformed ID %s%n", (Object)StaticUtils.bytesToHex((byte[])key.getData()));
                    continue;
                }
                try {
                    entryIDList = new EntryIDSet(key.getData(), data.getData());
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.traceException((Throwable)e);
                    logger.trace("File id2children has malformed ID list for ID %s:%n%s%n", (Object)entryID, (Object)StaticUtils.bytesToHex((byte[])data.getData()));
                    continue;
                }
                this.updateIndexStats(entryIDList);
                if (!entryIDList.isDefined()) continue;
                try {
                    entry = this.id2entry.get(null, entryID, LockMode.DEFAULT);
                }
                catch (Exception e) {
                    logger.traceException((Throwable)e);
                    ++this.errorCount;
                    continue;
                }
                if (entry == null) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("File id2children has unknown ID %d%n", (Object)entryID.longValue());
                    continue;
                }
                for (EntryID id : entryIDList) {
                    Entry childEntry;
                    try {
                        childEntry = this.id2entry.get(null, id, LockMode.DEFAULT);
                    }
                    catch (Exception e) {
                        logger.traceException((Throwable)e);
                        ++this.errorCount;
                        continue;
                    }
                    if (childEntry == null) {
                        ++this.errorCount;
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("File id2children has ID %d referencing unknown ID %d%n", (Object)entryID.longValue(), (Object)id.longValue());
                        continue;
                    }
                    if (childEntry.getName().isDescendantOf(entry.getName()) && childEntry.getName().size() == entry.getName().size() + 1) continue;
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("File id2children has ID %d with DN <%s> referencing ID %d with non-child DN <%s>%n", new Object[]{entryID.longValue(), entry.getName(), id.longValue(), childEntry.getName()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateID2Subtree() throws JebException, DatabaseException {
        try (DiskOrderedCursor cursor = this.id2s.openCursor(new DiskOrderedCursorConfig());){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                Entry entry;
                EntryIDSet entryIDList;
                EntryID entryID;
                ++this.keyCount;
                try {
                    entryID = new EntryID(key);
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.traceException((Throwable)e);
                    logger.trace("File id2subtree has malformed ID %s%n", (Object)StaticUtils.bytesToHex((byte[])key.getData()));
                    continue;
                }
                try {
                    entryIDList = new EntryIDSet(key.getData(), data.getData());
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.traceException((Throwable)e);
                    logger.trace("File id2subtree has malformed ID list for ID %s:%n%s%n", (Object)entryID, (Object)StaticUtils.bytesToHex((byte[])data.getData()));
                    continue;
                }
                this.updateIndexStats(entryIDList);
                if (!entryIDList.isDefined()) continue;
                try {
                    entry = this.id2entry.get(null, entryID, LockMode.DEFAULT);
                }
                catch (Exception e) {
                    logger.traceException((Throwable)e);
                    ++this.errorCount;
                    continue;
                }
                if (entry == null) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("File id2subtree has unknown ID %d%n", (Object)entryID.longValue());
                    continue;
                }
                for (EntryID id : entryIDList) {
                    Entry subordEntry;
                    try {
                        subordEntry = this.id2entry.get(null, id, LockMode.DEFAULT);
                    }
                    catch (Exception e) {
                        logger.traceException((Throwable)e);
                        ++this.errorCount;
                        continue;
                    }
                    if (subordEntry == null) {
                        ++this.errorCount;
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("File id2subtree has ID %d referencing unknown ID %d%n", (Object)entryID.longValue(), (Object)id.longValue());
                        continue;
                    }
                    if (subordEntry.getName().isDescendantOf(entry.getName())) continue;
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("File id2subtree has ID %d with DN <%s> referencing ID %d with non-subordinate DN <%s>%n", new Object[]{entryID.longValue(), entry.getName(), id.longValue(), subordEntry.getName()});
                }
            }
        }
    }

    private void incrEntryLimitStats(Index index, byte[] key) {
        ByteString octetString;
        Long counter;
        HashMap<Object, Long> hashMap = this.entryLimitMap.get(index);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.entryLimitMap.put(index, hashMap);
        }
        if ((counter = hashMap.get(octetString = ByteString.wrap((byte[])key))) != null) {
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        } else {
            counter = 1L;
        }
        hashMap.put(octetString, counter);
    }

    private void updateIndexStats(EntryIDSet entryIDSet) {
        if (!entryIDSet.isDefined()) {
            ++this.entryLimitExceededCount;
            ++this.multiReferenceCount;
        } else {
            if (entryIDSet.size() > 1L) {
                ++this.multiReferenceCount;
            }
            this.entryReferencesCount += entryIDSet.size();
            this.maxEntryPerValue = Math.max(this.maxEntryPerValue, entryIDSet.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateVLVIndex(VLVIndex vlvIndex, boolean verifyID) throws JebException, DatabaseException, DirectoryException {
        if (vlvIndex == null) {
            return;
        }
        try (DiskOrderedCursor cursor = vlvIndex.openCursor(new DiskOrderedCursorConfig());){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            SortValues lastValues = null;
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                SortValuesSet sortValuesSet = new SortValuesSet(key.getData(), data.getData(), vlvIndex);
                for (int i = 0; i < sortValuesSet.getEntryIDs().length; ++i) {
                    Entry entry;
                    ++this.keyCount;
                    SortValues values = sortValuesSet.getSortValues(i);
                    if (lastValues != null && lastValues.compareTo(values) >= 1) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Values %s and %s are incorrectly ordered", (Object)lastValues, (Object)values, (Object)this.keyDump(vlvIndex, sortValuesSet.getKeySortValues()));
                        }
                        ++this.errorCount;
                    }
                    if (i == sortValuesSet.getEntryIDs().length - 1 && key.getData().length != 0) {
                        byte[] encodedKey = vlvIndex.encodeKey(values.getEntryID(), values.getValues(), values.getTypes());
                        if (!Arrays.equals(key.getData(), encodedKey)) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("Incorrect key for SortValuesSet in VLV index %s. Last values bytes %s, Key bytes %s", (Object)vlvIndex.getName(), (Object)encodedKey, (Object)key);
                            }
                            ++this.errorCount;
                        }
                    }
                    lastValues = values;
                    if (!verifyID) continue;
                    EntryID id = new EntryID(values.getEntryID());
                    try {
                        entry = this.id2entry.get(null, id, LockMode.DEFAULT);
                    }
                    catch (Exception e) {
                        logger.traceException((Throwable)e);
                        ++this.errorCount;
                        continue;
                    }
                    if (entry == null) {
                        ++this.errorCount;
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Reference to unknown ID %d%n%s", (Object)id.longValue(), (Object)this.keyDump(vlvIndex, sortValuesSet.getKeySortValues()));
                        continue;
                    }
                    SortValues entryValues = new SortValues(id, entry, vlvIndex.sortOrder);
                    if (entryValues.compareTo(values) == 0) continue;
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Reference to entry ID %d which does not match the values%n%s", (Object)id.longValue(), (Object)this.keyDump(vlvIndex, sortValuesSet.getKeySortValues()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateAttrIndex(Index index) throws JebException, DatabaseException {
        if (index == null) {
            return;
        }
        try (DiskOrderedCursor cursor = index.openCursor(new DiskOrderedCursorConfig());){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                EntryIDSet entryIDList;
                ++this.keyCount;
                try {
                    entryIDList = new EntryIDSet(key.getData(), data.getData());
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.traceException((Throwable)e);
                    logger.trace("Malformed ID list: %s%n%s", (Object)StaticUtils.bytesToHex((byte[])data.getData()), (Object)this.keyDump(index, key.getData()));
                    continue;
                }
                this.updateIndexStats(entryIDList);
                if (!entryIDList.isDefined()) continue;
                final ByteString value = ByteString.wrap((byte[])key.getData());
                EntryID prevID = null;
                for (EntryID id : entryIDList) {
                    Entry entry;
                    if (prevID != null && id.equals(prevID) && logger.isTraceEnabled()) {
                        logger.trace("Duplicate reference to ID %d%n%s", (Object)id.longValue(), (Object)this.keyDump(index, key.getData()));
                    }
                    prevID = id;
                    try {
                        entry = this.id2entry.get(null, id, LockMode.DEFAULT);
                    }
                    catch (Exception e) {
                        logger.traceException((Throwable)e);
                        ++this.errorCount;
                        continue;
                    }
                    if (entry == null) {
                        ++this.errorCount;
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Reference to unknown ID %d%n%s", (Object)id.longValue(), (Object)this.keyDump(index, key.getData()));
                        continue;
                    }
                    final AtomicBoolean foundMatchingKey = new AtomicBoolean(false);
                    AbstractSet<ByteString> dummySet = new AbstractSet<ByteString>(){

                        @Override
                        public Iterator<ByteString> iterator() {
                            return Collections.emptySet().iterator();
                        }

                        @Override
                        public int size() {
                            return 0;
                        }

                        @Override
                        public boolean add(ByteString e) {
                            if (value.equals((Object)e)) {
                                foundMatchingKey.set(true);
                            }
                            return true;
                        }
                    };
                    index.indexEntry(entry, (Set<ByteString>)dummySet);
                    if (foundMatchingKey.get()) continue;
                    ++this.errorCount;
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Reference to entry <%s> which does not match the value%n%s", (Object)entry.getName(), (Object)this.keyDump(index, value.toByteArray()));
                }
            }
        }
    }

    private void verifyEntry(EntryID entryID, Entry entry) {
        if (this.verifyDN2ID) {
            this.verifyDN2ID(entryID, entry);
        }
        if (this.verifyID2Children) {
            this.verifyID2Children(entryID, entry);
        }
        if (this.verifyID2Subtree) {
            this.verifyID2Subtree(entryID, entry);
        }
        this.verifyIndex(entryID, entry);
    }

    private void verifyDN2ID(EntryID entryID, Entry entry) {
        DN dn = entry.getName();
        try {
            EntryID id = this.dn2id.get(null, dn, LockMode.DEFAULT);
            if (id == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("File dn2id is missing key %s.%n", (Object)dn);
                }
                ++this.errorCount;
            } else if (!id.equals(entryID)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("File dn2id has ID %d instead of %d for key %s.%n", (Object)id.longValue(), (Object)entryID.longValue(), (Object)dn);
                }
                ++this.errorCount;
            }
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.traceException((Throwable)e);
                logger.trace("File dn2id has error reading key %s: %s.%n", (Object)dn, (Object)e.getMessage());
            }
            ++this.errorCount;
        }
        DN parentDN = this.getParent(dn);
        if (parentDN != null) {
            try {
                EntryID id = this.dn2id.get(null, parentDN, LockMode.DEFAULT);
                if (id == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("File dn2id is missing key %s.%n", (Object)parentDN);
                    }
                    ++this.errorCount;
                }
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.traceException((Throwable)e);
                    logger.trace("File dn2id has error reading key %s: %s.%n", (Object)parentDN, (Object)e.getMessage());
                }
                ++this.errorCount;
            }
        }
    }

    private void verifyID2Children(EntryID entryID, Entry entry) {
        DN dn = entry.getName();
        DN parentDN = this.getParent(dn);
        if (parentDN != null) {
            EntryID parentID = null;
            try {
                parentID = this.dn2id.get(null, parentDN, LockMode.DEFAULT);
                if (parentID == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("File dn2id is missing key %s.%n", (Object)parentDN);
                    }
                    ++this.errorCount;
                }
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.traceException((Throwable)e);
                    logger.trace("File dn2id has error reading key %s: %s.", (Object)parentDN, (Object)e.getMessage());
                }
                ++this.errorCount;
            }
            if (parentID != null) {
                try {
                    ConditionResult cr = this.id2c.containsID(null, parentID.getDatabaseEntry(), entryID);
                    if (cr == ConditionResult.FALSE) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("File id2children is missing ID %d for key %d.%n", (Object)entryID.longValue(), (Object)parentID.longValue());
                        }
                        ++this.errorCount;
                    } else if (cr == ConditionResult.UNDEFINED) {
                        this.incrEntryLimitStats(this.id2c, parentID.getDatabaseEntry().getData());
                    }
                }
                catch (DatabaseException e) {
                    if (logger.isTraceEnabled()) {
                        logger.traceException((Throwable)e);
                        logger.trace("File id2children has error reading key %d: %s.", (Object)parentID.longValue(), (Object)e.getMessage());
                    }
                    ++this.errorCount;
                }
            }
        }
    }

    private void verifyID2Subtree(EntryID entryID, Entry entry) {
        DN dn = this.getParent(entry.getName());
        while (dn != null) {
            EntryID id = null;
            try {
                id = this.dn2id.get(null, dn, LockMode.DEFAULT);
                if (id == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("File dn2id is missing key %s.%n", (Object)dn);
                    }
                    ++this.errorCount;
                }
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.traceException((Throwable)e);
                    logger.trace("File dn2id has error reading key %s: %s.%n", (Object)dn, (Object)e.getMessage());
                }
                ++this.errorCount;
            }
            if (id != null) {
                try {
                    ConditionResult cr = this.id2s.containsID(null, id.getDatabaseEntry(), entryID);
                    if (cr == ConditionResult.FALSE) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("File id2subtree is missing ID %d for key %d.%n", (Object)entryID.longValue(), (Object)id.longValue());
                        }
                        ++this.errorCount;
                    } else if (cr == ConditionResult.UNDEFINED) {
                        this.incrEntryLimitStats(this.id2s, id.getDatabaseEntry().getData());
                    }
                }
                catch (DatabaseException e) {
                    if (logger.isTraceEnabled()) {
                        logger.traceException((Throwable)e);
                        logger.trace("File id2subtree has error reading key %d: %s.%n", (Object)id.longValue(), (Object)e.getMessage());
                    }
                    ++this.errorCount;
                }
            }
            dn = this.getParent(dn);
        }
    }

    private String keyDump(Index index, byte[] keyBytes) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("File: ");
        buffer.append(index);
        buffer.append(ServerConstants.EOL);
        buffer.append("Key:");
        buffer.append(ServerConstants.EOL);
        StaticUtils.byteArrayToHexPlusAscii((StringBuilder)buffer, (byte[])keyBytes, (int)6);
        return buffer.toString();
    }

    private String keyDump(VLVIndex vlvIndex, SortValues keySortValues) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("File: ");
        buffer.append(vlvIndex);
        buffer.append(ServerConstants.EOL);
        buffer.append("Key (last sort values):");
        if (keySortValues != null) {
            buffer.append(keySortValues);
        } else {
            buffer.append("UNBOUNDED (0x00)");
        }
        return buffer.toString();
    }

    private void verifyIndex(EntryID entryID, Entry entry) {
        for (AttributeIndex attrIndex : this.attrIndexList) {
            try {
                this.verifyAttribute(attrIndex, entryID, entry);
            }
            catch (DirectoryException e) {
                if (!logger.isTraceEnabled()) continue;
                logger.traceException((Throwable)e);
                logger.trace("Error normalizing values of attribute %s in entry <%s>: %s.%n", (Object)attrIndex.getAttributeType(), (Object)entry.getName(), (Object)e.getMessageObject());
            }
        }
        for (VLVIndex vlvIndex : this.vlvIndexList) {
            try {
                if (!vlvIndex.shouldInclude(entry) || vlvIndex.containsValues(null, entryID.longValue(), vlvIndex.getSortValues(entry), vlvIndex.getSortTypes())) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("Missing entry %s in VLV index %s", (Object)entry.getName(), (Object)vlvIndex.getName());
                }
                ++this.errorCount;
            }
            catch (DirectoryException e) {
                if (logger.isTraceEnabled()) {
                    logger.traceException((Throwable)e);
                    logger.trace("Error checking entry %s against filter or base DN for VLV index %s: %s", (Object)entry.getName(), (Object)vlvIndex.getName(), (Object)e.getMessageObject());
                }
                ++this.errorCount;
            }
            catch (DatabaseException | JebException e) {
                if (logger.isTraceEnabled()) {
                    logger.traceException((Throwable)e);
                    logger.trace("Error reading VLV index %s for entry %s: %s", (Object)vlvIndex.getName(), (Object)entry.getName(), (Object)StaticUtils.getBacktrace((Throwable)e));
                }
                ++this.errorCount;
            }
        }
    }

    private void verifyAttribute(AttributeIndex attrIndex, EntryID entryID, Entry entry) throws DirectoryException {
        for (Index index : attrIndex.getAllIndexes()) {
            HashSet<ByteString> keys = new HashSet<ByteString>();
            index.indexEntry(entry, keys);
            for (ByteString key : keys) {
                this.verifyAttributeInIndex(index, null, key, entryID);
            }
        }
    }

    private void verifyAttributeInIndex(Index index, Transaction txn, ByteString key, EntryID entryID) {
        try {
            ConditionResult cr = index.containsID(txn, new DatabaseEntry(key.toByteArray()), entryID);
            if (cr == ConditionResult.FALSE) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Missing ID %d%n%s", (Object)entryID.longValue(), (Object)this.keyDump(index, key.toByteArray()));
                }
                ++this.errorCount;
            } else if (cr == ConditionResult.UNDEFINED) {
                this.incrEntryLimitStats(index, key.toByteArray());
            }
        }
        catch (DatabaseException e) {
            if (logger.isTraceEnabled()) {
                logger.traceException((Throwable)e);
                logger.trace("Error reading database: %s%n%s", (Object)e.getMessage(), (Object)this.keyDump(index, key.toByteArray()));
            }
            ++this.errorCount;
        }
    }

    private byte[] normalize(MatchingRule matchingRule, ByteString value) throws DirectoryException {
        try {
            return matchingRule.normalizeAttributeValue((ByteSequence)value).toByteArray();
        }
        catch (DecodeException e) {
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, e.getMessageObject(), (Throwable)e);
        }
    }

    private DN getParent(DN dn) {
        if (dn.equals((Object)this.verifyConfig.getBaseDN())) {
            return null;
        }
        return dn.getParentDNInSuffix();
    }

    private final class ProgressTask
    extends TimerTask {
        private long totalCount;
        private long previousCount;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats prevEnvStats;
        private static final int bytesPerMegabyte = 0x100000;

        private ProgressTask(boolean indexIterator) throws DatabaseException {
            this.prevEnvStats = VerifyJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
            if (indexIterator) {
                if (VerifyJob.this.verifyDN2ID) {
                    this.totalCount = VerifyJob.this.dn2id.getRecordCount();
                } else if (VerifyJob.this.verifyID2Children) {
                    this.totalCount = VerifyJob.this.id2c.getRecordCount();
                } else if (VerifyJob.this.verifyID2Subtree) {
                    this.totalCount = VerifyJob.this.id2s.getRecordCount();
                } else if (!VerifyJob.this.attrIndexList.isEmpty()) {
                    AttributeIndex attrIndex = (AttributeIndex)VerifyJob.this.attrIndexList.get(0);
                    this.totalCount = 0L;
                    for (Index index : attrIndex.getAllIndexes()) {
                        this.totalCount += this.getRecordCount(index);
                    }
                } else if (!VerifyJob.this.vlvIndexList.isEmpty()) {
                    this.totalCount = ((VLVIndex)VerifyJob.this.vlvIndexList.get(0)).getRecordCount();
                }
            } else {
                this.totalCount = VerifyJob.this.rootContainer.getEntryContainer(VerifyJob.this.verifyConfig.getBaseDN()).getEntryCount();
            }
        }

        private long getRecordCount(Index index) {
            return index != null ? index.getRecordCount() : 0L;
        }

        @Override
        public void run() {
            long latestCount = VerifyJob.this.keyCount;
            long deltaCount = latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            logger.info(BackendMessages.NOTE_VERIFY_PROGRESS_REPORT, (Object)latestCount, (Object)this.totalCount, (Object)VerifyJob.this.errorCount, (Object)Float.valueOf(rate));
            try {
                Runtime runtime = Runtime.getRuntime();
                long freeMemory = runtime.freeMemory() / 0x100000L;
                EnvironmentStats envStats = VerifyJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = envStats.getNCacheMiss() - this.prevEnvStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                logger.debug(BackendMessages.INFO_CACHE_AND_MEMORY_REPORT, (Object)freeMemory, (Object)Float.valueOf(cacheMissRate));
                this.prevEnvStats = envStats;
            }
            catch (DatabaseException e) {
                logger.traceException((Throwable)e);
            }
            this.previousCount = latestCount;
            this.previousTime = latestTime;
        }
    }
}

