/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseComparator;
import com.sleepycat.je.DatabaseException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.SortValuesSet;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DirectoryException;

public class VLVKeyComparator
implements DatabaseComparator {
    static final long serialVersionUID = 1585167927344130604L;
    private transient MatchingRule[] orderingRules;
    private String[] orderingRuleOids;
    private boolean[] ascending;

    public VLVKeyComparator(MatchingRule[] orderingRules, boolean[] ascending) {
        this.orderingRules = orderingRules;
        this.orderingRuleOids = new String[orderingRules.length];
        for (int i = 0; i < orderingRules.length; ++i) {
            this.orderingRuleOids[i] = orderingRules[i].getOID();
        }
        this.ascending = ascending;
    }

    public int compare(byte[] b1, byte[] b2) {
        if (b1.length == 0) {
            if (b2.length == 0) {
                return 0;
            }
            return 1;
        }
        if (b2.length == 0) {
            return -1;
        }
        int b1Pos = 0;
        int b2Pos = 0;
        for (int j = 0; j < this.orderingRules.length && b1Pos < b1.length && b2Pos < b2.length; ++j) {
            int result;
            byte[] b2Bytes;
            byte[] b1Bytes;
            int b2Length;
            int b1Length;
            if (b1[b1Pos++] != (b1Length = b1[b1Pos] & 0x7F)) {
                int b1NumLengthBytes = b1Length;
                b1Length = 0;
                int k = 0;
                while (k < b1NumLengthBytes) {
                    b1Length = b1Length << 8 | b1[b1Pos] & 0xFF;
                    ++k;
                    ++b1Pos;
                }
            }
            if (b2[b2Pos++] != (b2Length = b2[b2Pos] & 0x7F)) {
                int b2NumLengthBytes = b2Length;
                b2Length = 0;
                int k = 0;
                while (k < b2NumLengthBytes) {
                    b2Length = b2Length << 8 | b2[b2Pos] & 0xFF;
                    ++k;
                    ++b2Pos;
                }
            }
            if (b1Length > 0) {
                b1Bytes = new byte[b1Length];
                System.arraycopy(b1, b1Pos, b1Bytes, 0, b1Length);
                b1Pos += b1Length;
            } else {
                b1Bytes = null;
            }
            if (b2Length > 0) {
                b2Bytes = new byte[b2Length];
                System.arraycopy(b2, b2Pos, b2Bytes, 0, b2Length);
                b2Pos += b2Length;
            } else {
                b2Bytes = null;
            }
            if (b1Bytes == null) {
                if (b2Bytes == null) continue;
                return 1;
            }
            if (b2Bytes == null) {
                return -1;
            }
            ByteString val1 = ByteString.valueOf((byte[])b1Bytes);
            ByteString val2 = ByteString.valueOf((byte[])b2Bytes);
            int n = result = this.ascending[j] ? val1.compareTo((ByteSequence)val2) : val2.compareTo((ByteSequence)val1);
            if (result == 0) continue;
            return result;
        }
        if (b1Pos + 8 <= b1.length && b2Pos + 8 <= b2.length) {
            long b1ID = JebFormat.toLong(b1, b1Pos, b1Pos + 8);
            long b2ID = JebFormat.toLong(b2, b2Pos, b2Pos + 8);
            return this.compare(b1ID, b2ID);
        }
        return 0;
    }

    public int compare(SortValuesSet set, int index, long entryID, ByteString[] values) throws DatabaseException, DirectoryException {
        for (int j = 0; j < this.orderingRules.length && j < values.length; ++j) {
            int result;
            ByteString b1Bytes = set.getValue(index * this.orderingRules.length + j);
            ByteString b2Bytes = null;
            if (values[j] != null) {
                try {
                    b2Bytes = this.orderingRules[j].normalizeAttributeValue((ByteSequence)values[j]);
                }
                catch (DecodeException e) {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, e.getMessageObject(), (Throwable)e);
                }
            }
            if (b1Bytes == null) {
                if (b2Bytes == null) continue;
                return 1;
            }
            if (b2Bytes == null) {
                return -1;
            }
            int n = result = this.ascending[j] ? b1Bytes.compareTo((ByteSequence)b2Bytes) : b2Bytes.compareTo((ByteSequence)b1Bytes);
            if (result == 0) continue;
            return result;
        }
        if (entryID != -1L) {
            return this.compare(set.getEntryIDs()[index], entryID);
        }
        return 0;
    }

    private int compare(long l1, long l2) {
        long difference = l1 - l2;
        if (difference < 0L) {
            return -1;
        }
        if (difference > 0L) {
            return 1;
        }
        return 0;
    }

    public void initialize(ClassLoader loader) {
        if (this.orderingRules == null) {
            this.orderingRules = new MatchingRule[this.orderingRuleOids.length];
            for (int i = 0; i < this.orderingRuleOids.length; ++i) {
                this.orderingRules[i] = DirectoryServer.getSchema().getMatchingRule(this.orderingRuleOids[i]);
            }
        }
    }
}

