/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.opends.messages.BackendMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.LocalDBVLVIndexCfgDefn;
import org.opends.server.admin.std.server.LocalDBVLVIndexCfg;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.IndexBuffer;
import org.opends.server.backends.jeb.JEBUtils;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.backends.jeb.SortValuesSet;
import org.opends.server.backends.jeb.State;
import org.opends.server.backends.jeb.VLVKeyComparator;
import org.opends.server.controls.ServerSideSortRequestControl;
import org.opends.server.controls.VLVRequestControl;
import org.opends.server.controls.VLVResponseControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SortKey;
import org.opends.server.types.SortOrder;
import org.opends.server.util.StaticUtils;

public class VLVIndex
extends DatabaseContainer
implements ConfigurationChangeListener<LocalDBVLVIndexCfg> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public VLVKeyComparator comparator;
    private int sortedSetCapacity = 4000;
    public SortOrder sortOrder;
    private final AtomicInteger count;
    private final State state;
    private boolean trusted;
    private LocalDBVLVIndexCfg config;
    private DN baseDN;
    private SearchFilter filter;
    private SearchScope scope;

    VLVIndex(LocalDBVLVIndexCfg config, State state, Environment env, EntryContainer entryContainer) throws DatabaseException, ConfigException {
        super(entryContainer.getDatabasePrefix() + "_vlv." + config.getName(), env, entryContainer);
        this.config = config;
        this.baseDN = config.getBaseDN();
        this.scope = this.convertScope(config.getScope());
        this.sortedSetCapacity = config.getMaxBlockSize();
        try {
            this.filter = SearchFilter.createFilterFromString((String)config.getFilter());
        }
        catch (Exception e) {
            throw new ConfigException(BackendMessages.ERR_CONFIG_VLV_INDEX_BAD_FILTER.get((Object)config.getFilter(), (Object)this.name, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
        }
        String[] sortAttrs = config.getSortOrder().split(" ");
        SortKey[] sortKeys = new SortKey[sortAttrs.length];
        MatchingRule[] orderingRules = new MatchingRule[sortAttrs.length];
        boolean[] ascending = new boolean[sortAttrs.length];
        for (int i = 0; i < sortAttrs.length; ++i) {
            try {
                if (sortAttrs[i].startsWith("-")) {
                    ascending[i] = false;
                    sortAttrs[i] = sortAttrs[i].substring(1);
                } else {
                    ascending[i] = true;
                    if (sortAttrs[i].startsWith("+")) {
                        sortAttrs[i] = sortAttrs[i].substring(1);
                    }
                }
            }
            catch (Exception e) {
                throw new ConfigException(BackendMessages.ERR_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get((Object)sortKeys[i], (Object)this.name));
            }
            AttributeType attrType = DirectoryServer.getAttributeType((String)sortAttrs[i].toLowerCase());
            if (attrType == null) {
                throw new ConfigException(BackendMessages.ERR_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get((Object)sortAttrs[i], (Object)this.name));
            }
            sortKeys[i] = new SortKey(attrType, ascending[i]);
            orderingRules[i] = attrType.getOrderingMatchingRule();
        }
        this.sortOrder = new SortOrder(sortKeys);
        this.comparator = new VLVKeyComparator(orderingRules, ascending);
        this.dbConfig = JEBUtils.toDatabaseConfigNoDuplicates(env);
        this.dbConfig.setOverrideBtreeComparator(true);
        this.dbConfig.setBtreeComparator((Comparator)((Object)this.comparator));
        this.state = state;
        this.trusted = state.getIndexTrustState(null, this);
        if (!this.trusted && entryContainer.getHighestEntryID().longValue() == 0L) {
            this.setTrusted(null, true);
        }
        this.count = new AtomicInteger(0);
        this.config.addChangeListener((ConfigurationChangeListener)this);
    }

    private SearchScope convertScope(LocalDBVLVIndexCfgDefn.Scope cfgScope) {
        switch (cfgScope) {
            case BASE_OBJECT: {
                return SearchScope.BASE_OBJECT;
            }
            case SINGLE_LEVEL: {
                return SearchScope.SINGLE_LEVEL;
            }
            case SUBORDINATE_SUBTREE: {
                return SearchScope.SUBORDINATES;
            }
        }
        return SearchScope.WHOLE_SUBTREE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws DatabaseException {
        super.open();
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        LockMode lockMode = LockMode.RMW;
        try (Cursor cursor = this.openCursor(null, CursorConfig.READ_COMMITTED);){
            OperationStatus status = cursor.getFirst(key, data, lockMode);
            while (status == OperationStatus.SUCCESS) {
                this.count.getAndAdd(SortValuesSet.getEncodedSize(data.getData(), 0));
                status = cursor.getNext(key, data, lockMode);
            }
        }
    }

    @Override
    public void close() throws DatabaseException {
        super.close();
        this.config.removeChangeListener((ConfigurationChangeListener)this);
    }

    public boolean addEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException, JebException {
        return this.shouldInclude(entry) && this.insertValues(txn, entryID.longValue(), entry);
    }

    boolean addEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DirectoryException {
        if (this.shouldInclude(entry)) {
            SortValues sortValues = new SortValues(entryID, entry, this.sortOrder);
            buffer.getVLVIndex(this).addValues(sortValues);
            return true;
        }
        return false;
    }

    boolean removeEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DirectoryException {
        if (this.shouldInclude(entry)) {
            SortValues sortValues = new SortValues(entryID, entry, this.sortOrder);
            buffer.getVLVIndex(this).deleteValues(sortValues);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean modifyEntry(IndexBuffer buffer, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException, DirectoryException {
        if (this.shouldInclude(oldEntry)) {
            if (!this.shouldInclude(newEntry)) return this.removeEntry(buffer, entryID, oldEntry);
            if (!this.isSortAttributeModified(mods)) return true;
            boolean success = this.removeEntry(buffer, entryID, oldEntry);
            return success &= this.addEntry(buffer, entryID, newEntry);
        }
        if (!this.shouldInclude(newEntry)) return true;
        return this.addEntry(buffer, entryID, newEntry);
    }

    private boolean isSortAttributeModified(List<Modification> mods) {
        for (SortKey sortKey : this.sortOrder.getSortKeys()) {
            AttributeType attributeType = sortKey.getAttributeType();
            Iterable subTypes = DirectoryServer.getSchema().getSubTypes(attributeType);
            for (Modification mod : mods) {
                AttributeType modAttrType = mod.getAttribute().getAttributeType();
                if (modAttrType.equals((Object)attributeType)) {
                    return true;
                }
                for (AttributeType subType : subTypes) {
                    if (!modAttrType.equals((Object)subType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    SortValuesSet getSortValuesSet(Transaction txn, long entryID, ByteString[] values, AttributeType[] types) throws DatabaseException, DirectoryException {
        DatabaseEntry key = new DatabaseEntry(this.encodeKey(entryID, values, types));
        DatabaseEntry data = new DatabaseEntry();
        return this.getSortValuesSet(txn, key, data, LockMode.DEFAULT);
    }

    private SortValuesSet getSortValuesSet(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationStatus status = this.getSearchKeyRange(txn, key, data, lockMode);
        if (status != OperationStatus.SUCCESS) {
            if (logger.isTraceEnabled()) {
                logger.trace("No sort values set exist in VLV vlvIndex %s. Creating unbound set.", (Object)this.config.getName());
            }
            key.setData(new byte[0]);
            return new SortValuesSet(this);
        }
        if (logger.isTraceEnabled()) {
            this.logSearchKeyResult(key);
        }
        return new SortValuesSet(key.getData(), data.getData(), this);
    }

    private void logSearchKeyResult(DatabaseEntry key) {
        StringBuilder searchKeyHex = new StringBuilder();
        StaticUtils.byteArrayToHexPlusAscii((StringBuilder)searchKeyHex, (byte[])key.getData(), (int)4);
        StringBuilder foundKeyHex = new StringBuilder();
        StaticUtils.byteArrayToHexPlusAscii((StringBuilder)foundKeyHex, (byte[])key.getData(), (int)4);
        logger.trace("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", (Object)this.config.getName(), (Object)searchKeyHex, (Object)foundKeyHex);
    }

    boolean containsValues(Transaction txn, long entryID, ByteString[] values, AttributeType[] types) throws JebException, DatabaseException, DirectoryException {
        SortValuesSet valuesSet = this.getSortValuesSet(txn, entryID, values, types);
        int pos = valuesSet.binarySearch(entryID, values);
        return pos >= 0;
    }

    private boolean insertValues(Transaction txn, long entryID, Entry entry) throws JebException, DatabaseException, DirectoryException {
        ByteString[] values = this.getSortValues(entry);
        AttributeType[] types = this.getSortTypes();
        DatabaseEntry key = new DatabaseEntry(this.encodeKey(entryID, values, types));
        DatabaseEntry data = new DatabaseEntry();
        SortValuesSet sortValuesSet = this.getSortValuesSet(txn, key, data, LockMode.RMW);
        boolean success = sortValuesSet.add(entryID, values, types);
        int newSize = sortValuesSet.size();
        if (newSize >= this.sortedSetCapacity) {
            SortValuesSet splitSortValuesSet = sortValuesSet.split(newSize / 2);
            this.put(txn, key, data, splitSortValuesSet);
            this.put(txn, key, data, sortValuesSet);
            if (logger.isTraceEnabled()) {
                logger.trace("SortValuesSet with key %s has reached the entry size of %d. Spliting into two sets with  keys %s and %s.", new Object[]{splitSortValuesSet.getKeySortValues(), newSize, sortValuesSet.getKeySortValues(), splitSortValuesSet.getKeySortValues()});
            }
        } else {
            data.setData(sortValuesSet.toDatabase());
            this.put(txn, key, data);
        }
        if (success) {
            this.count.getAndIncrement();
        }
        return success;
    }

    private void put(Transaction txn, DatabaseEntry key, DatabaseEntry data, SortValuesSet set) throws DirectoryException {
        key.setData(set.getKeyBytes());
        data.setData(set.toDatabase());
        this.put(txn, key, data);
    }

    AttributeType[] getSortTypes() {
        SortKey[] sortKeys = this.sortOrder.getSortKeys();
        AttributeType[] types = new AttributeType[sortKeys.length];
        for (int i = 0; i < sortKeys.length; ++i) {
            types[i] = sortKeys[i].getAttributeType();
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus getSearchKeyRange(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        try (Cursor cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);){
            OperationStatus operationStatus = cursor.getSearchKeyRange(key, data, lockMode);
            return operationStatus;
        }
    }

    void updateIndex(Transaction txn, TreeSet<SortValues> addedValues, TreeSet<SortValues> deletedValues) throws DirectoryException, DatabaseException {
        if ((addedValues == null || addedValues.isEmpty()) && (deletedValues == null || deletedValues.isEmpty())) {
            return;
        }
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Iterator<SortValues> aValues = null;
        Iterator<SortValues> dValues = null;
        SortValues av = null;
        SortValues dv = null;
        if (addedValues != null) {
            aValues = addedValues.iterator();
            av = aValues.next();
        }
        if (deletedValues != null) {
            dValues = deletedValues.iterator();
            dv = dValues.next();
        }
        while (true) {
            int newSize;
            if (av != null) {
                if (dv != null) {
                    if (av.compareTo(dv) < 0) {
                        key.setData(this.encodeKey(av));
                    } else {
                        key.setData(this.encodeKey(dv));
                    }
                } else {
                    key.setData(this.encodeKey(av));
                }
            } else {
                if (dv == null) break;
                key.setData(this.encodeKey(dv));
            }
            SortValuesSet sortValuesSet = this.getSortValuesSet(txn, key, data, LockMode.RMW);
            int oldSize = sortValuesSet.size();
            if (key.getData().length == 0) {
                while (av != null) {
                    sortValuesSet.add(av);
                    av = this.moveToNextSortValues(aValues);
                }
                while (dv != null) {
                    sortValuesSet.remove(dv);
                    dv = this.moveToNextSortValues(dValues);
                }
            } else {
                SortValues maxValues = this.decodeKey(sortValuesSet.getKeyBytes());
                while (av != null && av.compareTo(maxValues) <= 0) {
                    sortValuesSet.add(av);
                    av = this.moveToNextSortValues(aValues);
                }
                while (dv != null && dv.compareTo(maxValues) <= 0) {
                    sortValuesSet.remove(dv);
                    dv = this.moveToNextSortValues(dValues);
                }
            }
            if ((newSize = sortValuesSet.size()) >= this.sortedSetCapacity) {
                SortValuesSet splitSortValuesSet = sortValuesSet.split(newSize / 2);
                this.put(txn, key, data, splitSortValuesSet);
                this.put(txn, key, data, sortValuesSet);
                if (logger.isTraceEnabled()) {
                    logger.trace("SortValuesSet with key %s has reached the entry size of %d. Spliting into two sets with  keys %s and %s.", new Object[]{splitSortValuesSet.getKeySortValues(), newSize, sortValuesSet.getKeySortValues(), splitSortValuesSet.getKeySortValues()});
                }
            } else if (newSize == 0) {
                this.delete(txn, key);
            } else {
                byte[] after = sortValuesSet.toDatabase();
                data.setData(after);
                this.put(txn, key, data);
            }
            this.count.getAndAdd(newSize - oldSize);
        }
    }

    private SortValues moveToNextSortValues(Iterator<SortValues> sortValues) {
        sortValues.remove();
        if (sortValues.hasNext()) {
            return sortValues.next();
        }
        return null;
    }

    private byte[] encodeKey(SortValues sv) throws DirectoryException {
        return this.encodeKey(sv.getEntryID(), sv.getValues(), sv.getTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    EntryIDSet evaluate(Transaction txn, SearchOperation searchOperation, ServerSideSortRequestControl sortControl, VLVRequestControl vlvRequest, StringBuilder debugBuilder) throws DirectoryException, DatabaseException {
        if (!(this.trusted && searchOperation.getBaseDN().equals((Object)this.baseDN) && searchOperation.getScope().equals((Object)this.scope) && searchOperation.getFilter().equals((Object)this.filter) && sortControl.getSortOrder().equals((Object)this.sortOrder))) {
            return null;
        }
        if (debugBuilder != null) {
            debugBuilder.append("vlv=");
            debugBuilder.append("[INDEX:");
            debugBuilder.append(this.name.replace(this.entryContainer.getDatabasePrefix() + "_", ""));
            debugBuilder.append("]");
        }
        selectedIDs = new long[]{};
        if (vlvRequest != null) {
            currentCount = this.count.get();
            beforeCount = vlvRequest.getBeforeCount();
            afterCount = vlvRequest.getAfterCount();
            if (vlvRequest.getTargetType() == -96) {
                targetOffset = vlvRequest.getOffset();
                if (targetOffset < 0) {
                    searchOperation.addResponseControl((Control)new VLVResponseControl(targetOffset, currentCount, 61));
                    message = BackendMessages.ERR_ENTRYIDSORTER_NEGATIVE_START_POS.get();
                    throw new DirectoryException(ResultCode.VIRTUAL_LIST_VIEW_ERROR, message);
                }
                if (targetOffset == 0) {
                    targetOffset = 1;
                }
                if ((startPos = (listOffset = targetOffset - 1) - beforeCount) < 0) {
                    startPos = 0;
                    beforeCount = listOffset;
                } else if (startPos >= currentCount) {
                    targetOffset = currentCount + 1;
                    listOffset = currentCount;
                    startPos = listOffset - beforeCount;
                    afterCount = 0;
                }
                count = 1 + beforeCount + afterCount;
                selectedIDs = new long[count];
                cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
                try {
                    key = new DatabaseEntry();
                    data = new DatabaseEntry();
                    lockMode = LockMode.DEFAULT;
                    cursorCount = 0;
                    selectedPos = 0;
                    status = cursor.getFirst(key, data, lockMode);
                    while (status == OperationStatus.SUCCESS) {
                        if (VLVIndex.logger.isTraceEnabled()) {
                            this.logSearchKeyResult(key);
                        }
                        IDs = SortValuesSet.getEncodedIDs(data.getData(), 0);
                        for (i = startPos + selectedPos - cursorCount; i < IDs.length && selectedPos < count; ++i, ++selectedPos) {
                            selectedIDs[selectedPos] = IDs[i];
                        }
                        cursorCount += IDs.length;
                        status = cursor.getNext(key, data, lockMode);
                    }
                    if (selectedPos < count) {
                        newIDArray = new long[selectedPos];
                        System.arraycopy(selectedIDs, 0, newIDArray, 0, selectedPos);
                        selectedIDs = newIDArray;
                    }
                    searchOperation.addResponseControl((Control)new VLVResponseControl(targetOffset, currentCount, 0));
                    if (debugBuilder == null) ** GOTO lbl175
                    debugBuilder.append("[COUNT:");
                    debugBuilder.append(cursorCount);
                    debugBuilder.append("]");
                }
                finally {
                    cursor.close();
                }
            } else {
                targetOffset = 0;
                includedBeforeCount = 0;
                includedAfterCount = 0;
                idList = new LinkedList<EntryID>();
                key = new DatabaseEntry();
                data = new DatabaseEntry();
                cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
                try {
                    lockMode = LockMode.DEFAULT;
                    vBytes = vlvRequest.getGreaterThanOrEqualAssertion();
                    keyBytes = new ByteStringBuilder(vBytes.length() + 4);
                    keyBytes.appendBERLength(vBytes.length());
                    vBytes.copyTo(keyBytes);
                    key.setData(keyBytes.getBackingArray(), 0, keyBytes.length());
                    status = cursor.getSearchKeyRange(key, data, lockMode);
                    if (status != OperationStatus.SUCCESS) ** GOTO lbl175
                    if (VLVIndex.logger.isTraceEnabled()) {
                        this.logSearchKeyResult(key);
                    }
                    if ((adjustedTargetOffset = (sortValuesSet = new SortValuesSet(key.getData(), data.getData(), this)).binarySearch(-1L, new ByteString[]{vlvRequest.getGreaterThanOrEqualAssertion()})) < 0) {
                        adjustedTargetOffset = -(adjustedTargetOffset + 1);
                    }
                    targetOffset = adjustedTargetOffset;
                    lastOffset = adjustedTargetOffset - 1;
                    lastIDs = sortValuesSet.getEntryIDs();
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        for (i = lastOffset; i >= 0 && includedBeforeCount < beforeCount; ++includedBeforeCount, --i) {
                            idList.addFirst(new EntryID(lastIDs[i]));
                        }
                        status = cursor.getPrev(key, data, lockMode);
                        if (status != OperationStatus.SUCCESS) break;
                        if (includedBeforeCount < beforeCount) {
                            lastIDs = SortValuesSet.getEncodedIDs(data.getData(), 0);
                            lastOffset = lastIDs.length - 1;
                            targetOffset += lastIDs.length;
                            ** continue;
                        }
                        targetOffset += SortValuesSet.getEncodedSize(data.getData(), 0);
                    }
                    key.setData(sortValuesSet.getKeyBytes());
                    cursor.getSearchKey(key, data, lockMode);
                    lastOffset = adjustedTargetOffset;
                    lastIDs = sortValuesSet.getEntryIDs();
                    afterIDCount = 0;
                    while (true) {
                        for (i = lastOffset; i < lastIDs.length && includedAfterCount < afterCount + 1; ++includedAfterCount, ++i) {
                            idList.addLast(new EntryID(lastIDs[i]));
                        }
                        if (includedAfterCount >= afterCount + 1 || (status = cursor.getNext(key, data, lockMode)) != OperationStatus.SUCCESS) break;
                        lastIDs = SortValuesSet.getEncodedIDs(data.getData(), 0);
                        lastOffset = 0;
                        afterIDCount += lastIDs.length;
                    }
                    selectedIDs = new long[idList.size()];
                    idIterator = idList.iterator();
                    for (i = 0; i < selectedIDs.length; ++i) {
                        selectedIDs[i] = ((EntryID)idIterator.next()).longValue();
                    }
                    searchOperation.addResponseControl((Control)new VLVResponseControl(targetOffset + 1, currentCount, 0));
                    if (debugBuilder == null) ** GOTO lbl175
                    debugBuilder.append("[COUNT:");
                    debugBuilder.append(targetOffset + afterIDCount + 1);
                    debugBuilder.append("]");
                }
                finally {
                    cursor.close();
                }
            }
        } else {
            idSets = new LinkedList<long[]>();
            currentCount = 0;
            key = new DatabaseEntry();
            data = new DatabaseEntry();
            cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
            try {
                lockMode = LockMode.RMW;
                status = cursor.getFirst(key, data, lockMode);
                while (status == OperationStatus.SUCCESS) {
                    if (VLVIndex.logger.isTraceEnabled()) {
                        this.logSearchKeyResult(key);
                    }
                    ids = SortValuesSet.getEncodedIDs(data.getData(), 0);
                    idSets.add(ids);
                    currentCount += ids.length;
                    status = cursor.getNext(key, data, lockMode);
                }
            }
            finally {
                cursor.close();
            }
            selectedIDs = new long[currentCount];
            pos = 0;
            for (long[] id : idSets) {
                System.arraycopy(id, 0, selectedIDs, pos, id.length);
                pos += id.length;
            }
            if (debugBuilder != null) {
                debugBuilder.append("[COUNT:");
                debugBuilder.append(currentCount);
                debugBuilder.append("]");
            }
        }
lbl175:
        // 8 sources

        return new EntryIDSet(selectedIDs, 0, selectedIDs.length);
    }

    public synchronized void setTrusted(Transaction txn, boolean trusted) throws DatabaseException {
        this.trusted = trusted;
        this.state.putIndexTrustState(txn, this, trusted);
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    ByteString[] getSortValues(Entry entry) {
        SortKey[] sortKeys = this.sortOrder.getSortKeys();
        ByteString[] values = new ByteString[sortKeys.length];
        for (int i = 0; i < sortKeys.length; ++i) {
            SortKey sortKey = sortKeys[i];
            List attrList = entry.getAttribute(sortKey.getAttributeType());
            if (attrList == null) continue;
            ByteString sortValue = null;
            for (Attribute a : attrList) {
                for (ByteString v : a) {
                    if (sortValue != null && sortKey.compareValues(v, sortValue) >= 0) continue;
                    sortValue = v;
                }
            }
            values[i] = sortValue;
        }
        return values;
    }

    byte[] encodeKey(long entryID, ByteString[] values, AttributeType[] types) throws DirectoryException {
        try {
            ByteStringBuilder builder = new ByteStringBuilder();
            for (int i = 0; i < values.length; ++i) {
                ByteString v = values[i];
                if (v == null) {
                    builder.appendBERLength(0);
                    continue;
                }
                MatchingRule eqRule = types[i].getEqualityMatchingRule();
                ByteString nv = eqRule.normalizeAttributeValue((ByteSequence)v);
                builder.appendBERLength(nv.length());
                builder.append((ByteSequence)nv);
            }
            builder.append(entryID);
            builder.trimToSize();
            return builder.getBackingArray();
        }
        catch (DecodeException e) {
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, e.getMessageObject(), (Throwable)e);
        }
    }

    private SortValues decodeKey(byte[] keyBytes) throws DirectoryException {
        if (keyBytes == null || keyBytes.length == 0) {
            return null;
        }
        ByteString[] attributeValues = new ByteString[this.sortOrder.getSortKeys().length];
        int vBytesPos = 0;
        for (int i = 0; i < attributeValues.length; ++i) {
            int valueLength = keyBytes[vBytesPos] & 0x7F;
            if (valueLength != keyBytes[vBytesPos++]) {
                int valueLengthBytes = valueLength;
                valueLength = 0;
                int j = 0;
                while (j < valueLengthBytes) {
                    valueLength = valueLength << 8 | keyBytes[vBytesPos] & 0xFF;
                    ++j;
                    ++vBytesPos;
                }
            }
            if (valueLength == 0) {
                attributeValues[i] = null;
            } else {
                byte[] valueBytes = new byte[valueLength];
                System.arraycopy(keyBytes, vBytesPos, valueBytes, 0, valueLength);
                attributeValues[i] = ByteString.wrap((byte[])valueBytes);
            }
            vBytesPos += valueLength;
        }
        long id = JebFormat.toLong(keyBytes, vBytesPos, keyBytes.length);
        return new SortValues(new EntryID(id), attributeValues, this.sortOrder);
    }

    public int getSortedSetCapacity() {
        return this.sortedSetCapacity;
    }

    boolean shouldInclude(Entry entry) throws DirectoryException {
        DN entryDN = entry.getName();
        return entryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(entry);
    }

    public synchronized boolean isConfigurationChangeAcceptable(LocalDBVLVIndexCfg cfg, List<LocalizableMessage> unacceptableReasons) {
        try {
            this.filter = SearchFilter.createFilterFromString((String)cfg.getFilter());
        }
        catch (Exception e) {
            unacceptableReasons.add(BackendMessages.ERR_CONFIG_VLV_INDEX_BAD_FILTER.get((Object)cfg.getFilter(), (Object)this.name, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
            return false;
        }
        String[] sortAttrs = cfg.getSortOrder().split(" ");
        SortKey[] sortKeys = new SortKey[sortAttrs.length];
        MatchingRule[] orderingRules = new MatchingRule[sortAttrs.length];
        boolean[] ascending = new boolean[sortAttrs.length];
        for (int i = 0; i < sortAttrs.length; ++i) {
            try {
                if (sortAttrs[i].startsWith("-")) {
                    ascending[i] = false;
                    sortAttrs[i] = sortAttrs[i].substring(1);
                } else {
                    ascending[i] = true;
                    if (sortAttrs[i].startsWith("+")) {
                        sortAttrs[i] = sortAttrs[i].substring(1);
                    }
                }
            }
            catch (Exception e) {
                unacceptableReasons.add(BackendMessages.ERR_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get((Object)sortKeys[i], (Object)this.name));
                return false;
            }
            AttributeType attrType = DirectoryServer.getAttributeType((String)sortAttrs[i].toLowerCase());
            if (attrType == null) {
                unacceptableReasons.add(BackendMessages.ERR_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get((Object)sortAttrs[i], (Object)this.name));
                return false;
            }
            sortKeys[i] = new SortKey(attrType, ascending[i]);
            orderingRules[i] = attrType.getOrderingMatchingRule();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConfigChangeResult applyConfigurationChange(LocalDBVLVIndexCfg cfg) {
        ConfigChangeResult ccr = new ConfigChangeResult();
        if (!this.config.getBaseDN().equals((Object)cfg.getBaseDN())) {
            this.baseDN = cfg.getBaseDN();
            ccr.setAdminActionRequired(true);
        }
        if (!this.config.getScope().equals((Object)cfg.getScope())) {
            this.scope = this.convertScope(cfg.getScope());
            ccr.setAdminActionRequired(true);
        }
        if (this.config.getMaxBlockSize() != cfg.getMaxBlockSize()) {
            this.sortedSetCapacity = cfg.getMaxBlockSize();
            if (this.config.getMaxBlockSize() < cfg.getMaxBlockSize()) {
                ccr.setAdminActionRequired(true);
            }
        }
        if (!this.config.getFilter().equals(cfg.getFilter())) {
            try {
                this.filter = SearchFilter.createFilterFromString((String)cfg.getFilter());
                ccr.setAdminActionRequired(true);
            }
            catch (Exception e) {
                ccr.addMessage(BackendMessages.ERR_CONFIG_VLV_INDEX_BAD_FILTER.get((Object)this.config.getFilter(), (Object)this.name, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
                ccr.setResultCodeIfSuccess(ResultCode.INVALID_ATTRIBUTE_SYNTAX);
            }
        }
        if (!this.config.getSortOrder().equals(cfg.getSortOrder())) {
            String[] sortAttrs = cfg.getSortOrder().split(" ");
            SortKey[] sortKeys = new SortKey[sortAttrs.length];
            MatchingRule[] orderingRules = new MatchingRule[sortAttrs.length];
            boolean[] ascending = new boolean[sortAttrs.length];
            for (int i = 0; i < sortAttrs.length; ++i) {
                try {
                    if (sortAttrs[i].startsWith("-")) {
                        ascending[i] = false;
                        sortAttrs[i] = sortAttrs[i].substring(1);
                    } else {
                        ascending[i] = true;
                        if (sortAttrs[i].startsWith("+")) {
                            sortAttrs[i] = sortAttrs[i].substring(1);
                        }
                    }
                }
                catch (Exception e) {
                    ccr.addMessage(BackendMessages.ERR_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get((Object)sortKeys[i], (Object)this.name));
                    ccr.setResultCodeIfSuccess(ResultCode.INVALID_ATTRIBUTE_SYNTAX);
                }
                AttributeType attrType = DirectoryServer.getAttributeType((String)sortAttrs[i].toLowerCase());
                if (attrType == null) {
                    ccr.addMessage(BackendMessages.ERR_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get((Object)sortKeys[i], (Object)this.name));
                    ccr.setResultCodeIfSuccess(ResultCode.INVALID_ATTRIBUTE_SYNTAX);
                    continue;
                }
                sortKeys[i] = new SortKey(attrType, ascending[i]);
                orderingRules[i] = attrType.getOrderingMatchingRule();
            }
            this.sortOrder = new SortOrder(sortKeys);
            this.comparator = new VLVKeyComparator(orderingRules, ascending);
            this.entryContainer.exclusiveLock.lock();
            try {
                this.close();
                this.dbConfig.setBtreeComparator((Comparator)((Object)this.comparator));
                this.open();
            }
            catch (DatabaseException de) {
                ccr.addMessage(LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)de), (Object[])new Object[0]));
                ccr.setResultCodeIfSuccess(DirectoryServer.getServerErrorResultCode());
            }
            finally {
                this.entryContainer.exclusiveLock.unlock();
            }
            ccr.setAdminActionRequired(true);
        }
        if (ccr.adminActionRequired()) {
            this.trusted = false;
            ccr.addMessage(BackendMessages.NOTE_INDEX_ADD_REQUIRES_REBUILD.get((Object)this.name));
            try {
                this.state.putIndexTrustState(null, this, false);
            }
            catch (DatabaseException de) {
                ccr.addMessage(LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)de), (Object[])new Object[0]));
                ccr.setResultCodeIfSuccess(DirectoryServer.getServerErrorResultCode());
            }
        }
        this.config = cfg;
        return ccr;
    }
}

