/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.opends.messages.BackendMessages;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Importer;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.types.DN;

class Suffix {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final List<DN> includeBranches;
    private final List<DN> excludeBranches;
    private final DN baseDN;
    private final EntryContainer srcEntryContainer;
    private final EntryContainer entryContainer;
    private final Object synchObject = new Object();
    private static final int PARENT_ID_SET_SIZE = 16384;
    private final ConcurrentHashMap<DN, CountDownLatch> pendingMap = new ConcurrentHashMap();
    private final Set<DN> parentSet = new HashSet<DN>(16384);
    private final List<AttributeIndex> attributeIndexes = new ArrayList<AttributeIndex>();
    private final List<VLVIndex> vlvIndexes = new ArrayList<VLVIndex>();
    private boolean processID2Children;
    private boolean processID2Subtree;

    Suffix(EntryContainer entryContainer, EntryContainer srcEntryContainer, List<DN> includeBranches, List<DN> excludeBranches) {
        this.entryContainer = entryContainer;
        this.srcEntryContainer = srcEntryContainer;
        this.baseDN = entryContainer.getBaseDN();
        this.includeBranches = includeBranches != null ? includeBranches : new ArrayList<DN>(0);
        this.excludeBranches = excludeBranches != null ? excludeBranches : new ArrayList<DN>(0);
    }

    public DN2ID getDN2ID() {
        return this.entryContainer.getDN2ID();
    }

    public ID2Entry getID2Entry() {
        return this.entryContainer.getID2Entry();
    }

    public DN2URI getDN2URI() {
        return this.entryContainer.getDN2URI();
    }

    public EntryContainer getEntryContainer() {
        return this.entryContainer;
    }

    public List<AttributeIndex> getAttributeIndexes() {
        return this.attributeIndexes;
    }

    public List<VLVIndex> getVLVIndexes() {
        return this.vlvIndexes;
    }

    private void assureNotPending(DN parentDN) throws InterruptedException {
        CountDownLatch l = this.pendingMap.get(parentDN);
        if (l != null) {
            l.await();
        }
    }

    public void addPending(DN dn) {
        this.pendingMap.putIfAbsent(dn, new CountDownLatch(1));
    }

    public void removePending(DN dn) {
        CountDownLatch l = this.pendingMap.remove(dn);
        if (l != null) {
            l.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParentProcessed(DN dn, Importer.DNCache dnCache, boolean clearedBackend) throws DatabaseException, InterruptedException {
        boolean parentThere;
        Object object = this.synchObject;
        synchronized (object) {
            if (this.parentSet.contains(dn)) {
                return true;
            }
        }
        try {
            this.assureNotPending(dn);
        }
        catch (InterruptedException e) {
            logger.error(BackendMessages.ERR_IMPORT_LDIF_PENDING_ERR, (Object)e.getMessage());
            throw e;
        }
        boolean bl = parentThere = dnCache.contains(dn) || !clearedBackend && this.getDN2ID().get(null, dn, LockMode.DEFAULT) != null;
        if (parentThere) {
            Object object2 = this.synchObject;
            synchronized (object2) {
                if (this.parentSet.size() >= 16384) {
                    Iterator<DN> iterator = this.parentSet.iterator();
                    iterator.next();
                    iterator.remove();
                }
                this.parentSet.add(dn);
            }
        }
        return parentThere;
    }

    final boolean isProcessID2Children() {
        return this.processID2Children;
    }

    final boolean isProcessID2Subtree() {
        return this.processID2Subtree;
    }

    public void setIndexesTrusted() throws DatabaseException {
        if (this.processID2Children) {
            this.entryContainer.getID2Children().setTrusted(null, true);
        }
        if (this.processID2Subtree) {
            this.entryContainer.getID2Subtree().setTrusted(null, true);
        }
        for (AttributeIndex attrIndex : this.attributeIndexes) {
            this.setTrusted(attrIndex, true);
        }
        for (VLVIndex vlvIdx : this.vlvIndexes) {
            vlvIdx.setTrusted(null, true);
        }
    }

    public void setIndexesNotTrusted(boolean onlyDegraded) throws DatabaseException {
        this.setNotTrustedDN2IDRelatedIndexes(onlyDegraded);
        for (AttributeIndex attributeIndex : this.entryContainer.getAttributeIndexes()) {
            if (onlyDegraded && !attributeIndex.isTrusted()) continue;
            this.attributeIndexes.add(attributeIndex);
            this.setTrusted(attributeIndex, false);
        }
        for (VLVIndex vlvIndex : this.entryContainer.getVLVIndexes()) {
            if (onlyDegraded && !vlvIndex.isTrusted()) continue;
            vlvIndex.setTrusted(null, false);
            this.vlvIndexes.add(vlvIndex);
        }
    }

    private void setNotTrustedDN2IDRelatedIndexes(boolean onlyDegraded) {
        if (this.setNotTrustedDN2IDRelated(this.entryContainer.getID2Children(), onlyDegraded)) {
            this.processID2Children = true;
        }
        if (this.setNotTrustedDN2IDRelated(this.entryContainer.getID2Subtree(), onlyDegraded)) {
            this.processID2Subtree = true;
        }
    }

    private boolean setNotTrustedDN2IDRelated(Index auxIndex, boolean onlyDegraded) {
        if (!onlyDegraded || auxIndex.isTrusted()) {
            auxIndex.setTrusted(null, false);
            return true;
        }
        return false;
    }

    private void setTrusted(AttributeIndex attrIndex, boolean trusted) {
        for (Index index : attrIndex.getAllIndexes()) {
            if (index == null) continue;
            index.setTrusted(null, trusted);
        }
    }

    void forceTrustedDN2IDRelated(boolean trusted) {
        this.entryContainer.getID2Children().setTrusted(null, trusted);
        this.entryContainer.getID2Subtree().setTrusted(null, trusted);
        if (!trusted) {
            this.processID2Subtree = true;
            this.processID2Children = true;
        }
    }

    public EntryContainer getSrcEntryContainer() {
        return this.srcEntryContainer;
    }

    public List<DN> getIncludeBranches() {
        return this.includeBranches;
    }

    public List<DN> getExcludeBranches() {
        return this.excludeBranches;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }
}

