/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.Arrays;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.JEBUtils;
import org.opends.server.util.StaticUtils;

public class State
extends DatabaseContainer {
    private static final byte[] falseBytes = new byte[]{0};
    private static final byte[] trueBytes = new byte[]{1};

    State(String name, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.dbConfig = JEBUtils.toDatabaseConfigNoDuplicates(env);
    }

    private DatabaseEntry keyForIndex(DatabaseContainer index) throws DatabaseException {
        String shortName = index.getName().replace(this.entryContainer.getDatabasePrefix(), "");
        return new DatabaseEntry(StaticUtils.getBytes((String)shortName));
    }

    boolean removeIndexTrustState(Transaction txn, DatabaseContainer index) throws DatabaseException {
        DatabaseEntry key = this.keyForIndex(index);
        return this.delete(txn, key) == OperationStatus.SUCCESS;
    }

    public boolean getIndexTrustState(Transaction txn, DatabaseContainer index) throws DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = this.keyForIndex(index);
        if (this.read(txn, key, data = new DatabaseEntry(), LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            byte[] bytes = data.getData();
            return Arrays.equals(bytes, trueBytes);
        }
        return false;
    }

    void putIndexTrustState(Transaction txn, DatabaseContainer index, boolean trusted) throws DatabaseException {
        DatabaseEntry key = this.keyForIndex(index);
        DatabaseEntry data = new DatabaseEntry();
        data.setData(trusted ? trueBytes : falseBytes);
        this.put(txn, key, data);
    }
}

