/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.List;
import org.forgerock.opendj.ldap.ByteString;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Entry;
import org.opends.server.types.SortKey;
import org.opends.server.types.SortOrder;

public class SortValues
implements Comparable<SortValues> {
    private ByteString[] values;
    private AttributeType[] types;
    private EntryID entryID;
    private SortOrder sortOrder;

    public SortValues(EntryID entryID, ByteString[] values, SortOrder sortOrder) {
        this.entryID = entryID;
        this.sortOrder = sortOrder;
        this.values = values;
        SortKey[] sortKeys = sortOrder.getSortKeys();
        this.types = new AttributeType[sortKeys.length];
        for (int i = 0; i < sortKeys.length; ++i) {
            this.types[i] = sortKeys[i].getAttributeType();
        }
    }

    public SortValues(EntryID entryID, Entry entry, SortOrder sortOrder) {
        this.entryID = entryID;
        this.sortOrder = sortOrder;
        SortKey[] sortKeys = sortOrder.getSortKeys();
        this.values = new ByteString[sortKeys.length];
        this.types = new AttributeType[sortKeys.length];
        for (int i = 0; i < sortKeys.length; ++i) {
            SortKey sortKey = sortKeys[i];
            this.types[i] = sortKey.getAttributeType();
            List attrList = entry.getAttribute(this.types[i]);
            if (attrList == null) continue;
            this.values[i] = this.findBestMatchingValue(sortKey, attrList);
        }
    }

    private ByteString findBestMatchingValue(SortKey sortKey, List<Attribute> attrList) {
        ByteString sortValue = null;
        for (Attribute a : attrList) {
            for (ByteString v : a) {
                if (sortValue != null && sortKey.compareValues(v, sortValue) >= 0) continue;
                sortValue = v;
            }
        }
        return sortValue;
    }

    @Override
    public int compareTo(SortValues sortValues) {
        SortKey[] sortKeys = this.sortOrder.getSortKeys();
        for (int i = 0; i < this.values.length; ++i) {
            int compareValue = sortKeys[i].compareValues(this.values[i], sortValues.values[i]);
            if (compareValue == 0) continue;
            return compareValue;
        }
        return this.entryID.compareTo(sortValues.entryID);
    }

    @Override
    public int compareTo(ByteString assertionValue) {
        SortKey sortKey = this.sortOrder.getSortKeys()[0];
        return sortKey.compareValues(this.values[0], assertionValue);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SortValues(");
        SortKey[] sortKeys = this.sortOrder.getSortKeys();
        for (int i = 0; i < sortKeys.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(sortKeys[i].ascending() ? "+" : "-");
            buffer.append(sortKeys[i].getAttributeType().getNameOrOID());
            buffer.append("=");
            buffer.append(this.values[i]);
        }
        buffer.append(", id=");
        buffer.append(this.entryID);
        buffer.append(")");
    }

    public ByteString[] getValues() {
        return this.values;
    }

    public AttributeType[] getTypes() {
        return this.types;
    }

    public long getEntryID() {
        return this.entryID.longValue();
    }
}

