/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.opends.messages.BackendMessages;
import org.opends.messages.ConfigMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.DatabaseEnvironmentMonitor;
import org.opends.server.backends.jeb.DbPreloadComparator;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JECompressedSchema;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DN;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class RootContainer
implements ConfigurationChangeListener<LocalDBBackendCfg> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private Environment env;
    private final CheckpointConfig importForceCheckPoint = new CheckpointConfig();
    private LocalDBBackendCfg config;
    private final Backend<?> backend;
    private DatabaseEnvironmentMonitor monitor;
    private final ConcurrentHashMap<DN, EntryContainer> entryContainers = new ConcurrentHashMap();
    private AtomicLong nextid = new AtomicLong(1L);
    private JECompressedSchema compressedSchema;

    RootContainer(Backend<?> backend, LocalDBBackendCfg config) {
        this.backend = backend;
        this.config = config;
        this.getMonitorProvider().enableFilterUseStats(config.isIndexFilterAnalyzerEnabled());
        this.getMonitorProvider().setMaxEntries(config.getIndexFilterAnalyzerMaxFilters());
        config.addLocalDBChangeListener((ConfigurationChangeListener)this);
        this.importForceCheckPoint.setForce(true);
    }

    public void open(EnvironmentConfig envConfig) throws DatabaseException, InitializationException, ConfigException {
        FilePermission backendPermission;
        File parentDirectory = StaticUtils.getFileForPath((String)this.config.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.config.getBackendId());
        if (!backendDirectory.exists()) {
            if (!backendDirectory.mkdirs()) {
                throw new ConfigException(BackendMessages.ERR_CREATE_FAIL.get((Object)backendDirectory.getPath()));
            }
        } else if (!backendDirectory.isDirectory()) {
            throw new ConfigException(BackendMessages.ERR_DIRECTORY_INVALID.get((Object)backendDirectory.getPath()));
        }
        try {
            backendPermission = FilePermission.decodeUNIXMode((String)this.config.getDBDirectoryPermissions());
        }
        catch (Exception e) {
            throw new ConfigException(ConfigMessages.ERR_CONFIG_BACKEND_MODE_INVALID.get((Object)this.config.dn()));
        }
        if (!(backendPermission.isOwnerWritable() && backendPermission.isOwnerReadable() && backendPermission.isOwnerExecutable())) {
            LocalizableMessage message = ConfigMessages.ERR_CONFIG_BACKEND_INSANE_MODE.get((Object)this.config.getDBDirectoryPermissions());
            throw new ConfigException(message);
        }
        try {
            if (!FilePermission.setPermissions((File)backendDirectory, (FilePermission)backendPermission)) {
                logger.warn(BackendMessages.WARN_UNABLE_SET_PERMISSIONS, (Object)backendPermission, (Object)backendDirectory);
            }
        }
        catch (Exception e) {
            logger.warn(BackendMessages.WARN_SET_PERMISSIONS_FAILED, (Object)backendDirectory, (Object)e);
        }
        this.env = new Environment(backendDirectory, envConfig);
        if (logger.isTraceEnabled()) {
            logger.trace("JE (%s) environment opened with the following config: %n%s", (Object)JEVersion.CURRENT_VERSION, (Object)this.env.getConfig());
            long heapSize = Runtime.getRuntime().totalMemory();
            long heapMaxSize = Runtime.getRuntime().maxMemory();
            long heapFreeSize = Runtime.getRuntime().freeMemory();
            logger.trace("Current size of heap: %d bytes", (Object)heapSize);
            logger.trace("Max size of heap: %d bytes", (Object)heapMaxSize);
            logger.trace("Free memory in heap: %d bytes", (Object)heapFreeSize);
        }
        this.compressedSchema = new JECompressedSchema(this.env);
        this.openAndRegisterEntryContainers(this.config.getBaseDN());
    }

    EntryContainer openEntryContainer(DN baseDN, String name) throws DatabaseException, ConfigException {
        String databasePrefix = name == null || name.equals("") ? baseDN.toNormalizedUrlSafeString() : name;
        EntryContainer ec = new EntryContainer(baseDN, databasePrefix, this.backend.getBackendID(), this.config, this.env, this);
        ec.open();
        return ec;
    }

    void registerEntryContainer(DN baseDN, EntryContainer entryContainer) throws InitializationException {
        EntryContainer ec1 = this.entryContainers.get(baseDN);
        if (ec1 != null) {
            throw new InitializationException(BackendMessages.ERR_ENTRY_CONTAINER_ALREADY_REGISTERED.get((Object)ec1.getDatabasePrefix(), (Object)baseDN));
        }
        this.entryContainers.put(baseDN, entryContainer);
    }

    private void openAndRegisterEntryContainers(Set<DN> baseDNs) throws DatabaseException, InitializationException, ConfigException {
        EntryID highestID = null;
        for (DN baseDN : baseDNs) {
            EntryContainer ec = this.openEntryContainer(baseDN, null);
            EntryID id = ec.getHighestEntryID();
            this.registerEntryContainer(baseDN, ec);
            if (highestID != null && id.compareTo(highestID) <= 0) continue;
            highestID = id;
        }
        this.nextid = new AtomicLong(highestID.longValue() + 1L);
    }

    EntryContainer unregisterEntryContainer(DN baseDN) {
        return this.entryContainers.remove(baseDN);
    }

    public JECompressedSchema getCompressedSchema() {
        return this.compressedSchema;
    }

    public DatabaseEnvironmentMonitor getMonitorProvider() {
        if (this.monitor == null) {
            String monitorName = this.backend.getBackendID() + " Database Environment";
            this.monitor = new DatabaseEnvironmentMonitor(monitorName, this);
        }
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preload(long timeLimit) {
        if (timeLimit > 0L) {
            ArrayList<DatabaseContainer> dbList = new ArrayList<DatabaseContainer>();
            for (EntryContainer ec : this.entryContainers.values()) {
                ec.sharedLock.lock();
                try {
                    ec.listDatabases(dbList);
                }
                finally {
                    ec.sharedLock.unlock();
                }
            }
            Collections.sort(dbList, new DbPreloadComparator());
            try {
                PreloadConfig preloadConfig = new PreloadConfig();
                preloadConfig.setLoadLNs(true);
                logger.info(BackendMessages.NOTE_CACHE_PRELOAD_STARTED, (Object)this.backend.getBackendID());
                boolean isInterrupted = false;
                long timeEnd = System.currentTimeMillis() + timeLimit;
                for (DatabaseContainer db : dbList) {
                    PreloadStatus preloadStatus;
                    long timeRemaining = timeEnd - System.currentTimeMillis();
                    if (timeRemaining <= 0L) break;
                    preloadConfig.setMaxMillisecs(timeRemaining);
                    PreloadStats preloadStats = db.preload(preloadConfig);
                    if (logger.isTraceEnabled()) {
                        logger.trace("file=" + db.getName() + " LNs=" + preloadStats.getNLNsLoaded());
                    }
                    if ((preloadStatus = preloadStats.getStatus()) != PreloadStatus.SUCCESS) {
                        if (preloadStatus == PreloadStatus.EXCEEDED_TIME) {
                            logger.info(BackendMessages.NOTE_CACHE_PRELOAD_INTERRUPTED_BY_TIME, (Object)this.backend.getBackendID(), (Object)db.getName());
                        } else if (preloadStatus == PreloadStatus.FILLED_CACHE) {
                            logger.info(BackendMessages.NOTE_CACHE_PRELOAD_INTERRUPTED_BY_SIZE, (Object)this.backend.getBackendID(), (Object)db.getName());
                        } else {
                            logger.info(BackendMessages.NOTE_CACHE_PRELOAD_INTERRUPTED_UNKNOWN, (Object)this.backend.getBackendID(), (Object)db.getName());
                        }
                        isInterrupted = true;
                        break;
                    }
                    logger.info(BackendMessages.NOTE_CACHE_DB_PRELOADED, (Object)db.getName());
                }
                if (!isInterrupted) {
                    logger.info(BackendMessages.NOTE_CACHE_PRELOAD_DONE, (Object)this.backend.getBackendID());
                }
                EnvironmentStats stats = this.env.getStats(new StatsConfig());
                long total = stats.getCacheTotalBytes();
                logger.info(BackendMessages.NOTE_CACHE_SIZE_AFTER_PRELOAD, (Object)(total / 0x100000L));
            }
            catch (DatabaseException e) {
                logger.traceException((Throwable)e);
                logger.error(BackendMessages.ERR_CACHE_PRELOAD, (Object)this.backend.getBackendID(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)(e.getCause() != null ? e.getCause() : e)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DatabaseException {
        for (DN baseDN : this.entryContainers.keySet()) {
            EntryContainer ec = this.unregisterEntryContainer(baseDN);
            ec.exclusiveLock.lock();
            try {
                ec.close();
            }
            finally {
                ec.exclusiveLock.unlock();
            }
        }
        this.compressedSchema.close();
        this.config.removeLocalDBChangeListener((ConfigurationChangeListener)this);
        if (this.env != null) {
            this.env.close();
            this.env = null;
        }
    }

    public Collection<EntryContainer> getEntryContainers() {
        return this.entryContainers.values();
    }

    public Set<DN> getBaseDNs() {
        return this.entryContainers.keySet();
    }

    public EntryContainer getEntryContainer(DN baseDN) {
        EntryContainer ec = null;
        DN nodeDN = baseDN;
        while (ec == null && nodeDN != null) {
            ec = this.entryContainers.get(nodeDN);
            if (ec != null) continue;
            nodeDN = nodeDN.getParentDNInSuffix();
        }
        return ec;
    }

    public EnvironmentStats getEnvironmentStats(StatsConfig statsConfig) throws DatabaseException {
        return this.env.getStats(statsConfig);
    }

    public TransactionStats getEnvironmentTransactionStats(StatsConfig statsConfig) throws DatabaseException {
        return this.env.getTransactionStats(statsConfig);
    }

    public EnvironmentConfig getEnvironmentConfig() throws DatabaseException {
        return this.env.getConfig();
    }

    public LocalDBBackendCfg getConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntryCount() throws DatabaseException {
        long entryCount = 0L;
        for (EntryContainer ec : this.entryContainers.values()) {
            ec.sharedLock.lock();
            try {
                entryCount += ec.getEntryCount();
            }
            finally {
                ec.sharedLock.unlock();
            }
        }
        return entryCount;
    }

    public EntryID getNextEntryID() {
        return new EntryID(this.nextid.getAndIncrement());
    }

    public Long getLowestEntryID() {
        return 1L;
    }

    public void resetNextEntryID() {
        this.nextid.set(1L);
    }

    public boolean isConfigurationChangeAcceptable(LocalDBBackendCfg cfg, List<LocalizableMessage> unacceptableReasons) {
        boolean acceptable = true;
        File parentDirectory = StaticUtils.getFileForPath((String)this.config.getDBDirectory());
        File backendDirectory = new File(parentDirectory, this.config.getBackendId());
        if (!backendDirectory.exists()) {
            if (!backendDirectory.mkdirs()) {
                unacceptableReasons.add(BackendMessages.ERR_CREATE_FAIL.get((Object)backendDirectory.getPath()));
                acceptable = false;
            } else {
                backendDirectory.delete();
            }
        } else if (!backendDirectory.isDirectory()) {
            unacceptableReasons.add(BackendMessages.ERR_DIRECTORY_INVALID.get((Object)backendDirectory.getPath()));
            acceptable = false;
        }
        try {
            FilePermission newBackendPermission = FilePermission.decodeUNIXMode((String)cfg.getDBDirectoryPermissions());
            if (!(newBackendPermission.isOwnerWritable() && newBackendPermission.isOwnerReadable() && newBackendPermission.isOwnerExecutable())) {
                LocalizableMessage message = ConfigMessages.ERR_CONFIG_BACKEND_INSANE_MODE.get((Object)cfg.getDBDirectoryPermissions());
                unacceptableReasons.add(message);
                acceptable = false;
            }
        }
        catch (Exception e) {
            unacceptableReasons.add(ConfigMessages.ERR_CONFIG_BACKEND_MODE_INVALID.get((Object)cfg.dn()));
            acceptable = false;
        }
        try {
            ConfigurableEnvironment.parseConfigEntry(cfg);
        }
        catch (Exception e) {
            unacceptableReasons.add(LocalizableMessage.raw((CharSequence)e.getLocalizedMessage(), (Object[])new Object[0]));
            acceptable = false;
        }
        return acceptable;
    }

    public ConfigChangeResult applyConfigurationChange(LocalDBBackendCfg cfg) {
        ConfigChangeResult ccr = new ConfigChangeResult();
        try {
            if (this.env != null) {
                EnvironmentConfig oldEnvConfig = this.env.getConfig();
                EnvironmentConfig newEnvConfig = ConfigurableEnvironment.parseConfigEntry(cfg);
                Map paramsMap = EnvironmentParams.SUPPORTED_PARAMS;
                SortedSet jeProperties = cfg.getJEProperty();
                for (String jeEntry : jeProperties) {
                    String oldValue;
                    StringTokenizer st = new StringTokenizer(jeEntry, "=");
                    if (st.countTokens() != 2) continue;
                    String jePropertyName = st.nextToken();
                    String jePropertyValue = st.nextToken();
                    ConfigParam param = (ConfigParam)paramsMap.get(jePropertyName);
                    if (param.isMutable() || (oldValue = oldEnvConfig.getConfigParam(param.getName())).equalsIgnoreCase(jePropertyValue)) continue;
                    ccr.setAdminActionRequired(true);
                    ccr.addMessage(ConfigMessages.INFO_CONFIG_JE_PROPERTY_REQUIRES_RESTART.get((Object)jePropertyName));
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("The change to the following property will take effect when the component is restarted: " + jePropertyName);
                }
                for (Object o : paramsMap.values()) {
                    String newValue;
                    String oldValue;
                    ConfigParam param = (ConfigParam)o;
                    if (param.isMutable() || (oldValue = oldEnvConfig.getConfigParam(param.getName())).equalsIgnoreCase(newValue = newEnvConfig.getConfigParam(param.getName()))) continue;
                    ccr.setAdminActionRequired(true);
                    String configAttr = ConfigurableEnvironment.getAttributeForProperty(param.getName());
                    if (configAttr != null) {
                        ccr.addMessage(BackendMessages.NOTE_JEB_CONFIG_ATTR_REQUIRES_RESTART.get((Object)configAttr));
                    } else {
                        ccr.addMessage(BackendMessages.NOTE_JEB_CONFIG_ATTR_REQUIRES_RESTART.get((Object)param.getName()));
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("The change to the following property will take effect when the backend is restarted: " + param.getName());
                }
                this.env.setMutableConfig((EnvironmentMutableConfig)newEnvConfig);
                logger.trace("JE database configuration: %s", (Object)this.env.getConfig());
            }
            if (!cfg.getDBDirectory().equals(this.config.getDBDirectory())) {
                File parentDirectory = StaticUtils.getFileForPath((String)cfg.getDBDirectory());
                File backendDirectory = new File(parentDirectory, cfg.getBackendId());
                if (!backendDirectory.exists()) {
                    if (!backendDirectory.mkdirs()) {
                        ccr.addMessage(BackendMessages.ERR_CREATE_FAIL.get((Object)backendDirectory.getPath()));
                        ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
                        return ccr;
                    }
                } else if (!backendDirectory.isDirectory()) {
                    ccr.addMessage(BackendMessages.ERR_DIRECTORY_INVALID.get((Object)backendDirectory.getPath()));
                    ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
                    return ccr;
                }
                ccr.setAdminActionRequired(true);
                ccr.addMessage(BackendMessages.NOTE_CONFIG_DB_DIR_REQUIRES_RESTART.get((Object)this.config.getDBDirectory(), (Object)cfg.getDBDirectory()));
            }
            if (!cfg.getDBDirectoryPermissions().equalsIgnoreCase(this.config.getDBDirectoryPermissions()) || !cfg.getDBDirectory().equals(this.config.getDBDirectory())) {
                FilePermission backendPermission;
                try {
                    backendPermission = FilePermission.decodeUNIXMode((String)cfg.getDBDirectoryPermissions());
                }
                catch (Exception e) {
                    ccr.addMessage(ConfigMessages.ERR_CONFIG_BACKEND_MODE_INVALID.get((Object)this.config.dn()));
                    ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
                    return ccr;
                }
                if (!(backendPermission.isOwnerWritable() && backendPermission.isOwnerReadable() && backendPermission.isOwnerExecutable())) {
                    ccr.addMessage(ConfigMessages.ERR_CONFIG_BACKEND_INSANE_MODE.get((Object)cfg.getDBDirectoryPermissions()));
                    ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
                    return ccr;
                }
                File parentDirectory = StaticUtils.getFileForPath((String)this.config.getDBDirectory());
                File backendDirectory = new File(parentDirectory, this.config.getBackendId());
                try {
                    if (!FilePermission.setPermissions((File)backendDirectory, (FilePermission)backendPermission)) {
                        logger.warn(BackendMessages.WARN_UNABLE_SET_PERMISSIONS, (Object)backendPermission, (Object)backendDirectory);
                    }
                }
                catch (Exception e) {
                    logger.warn(BackendMessages.WARN_SET_PERMISSIONS_FAILED, (Object)backendDirectory, (Object)e);
                }
            }
            this.getMonitorProvider().enableFilterUseStats(cfg.isIndexFilterAnalyzerEnabled());
            this.getMonitorProvider().setMaxEntries(cfg.getIndexFilterAnalyzerMaxFilters());
            this.config = cfg;
        }
        catch (Exception e) {
            ccr.addMessage(LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)e), (Object[])new Object[0]));
            ccr.setResultCode(DirectoryServer.getServerErrorResultCode());
            return ccr;
        }
        return ccr;
    }

    public boolean isValid() {
        return this.env.isValid();
    }
}

