/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.opendj.ldap.ByteString;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

public class PresenceIndexer
extends Indexer {
    static final byte[] presenceKeyBytes = "+".getBytes();
    static final ByteString presenceKey = ByteString.wrap((byte[])presenceKeyBytes);
    private AttributeType attributeType;

    public PresenceIndexer(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    @Override
    public String toString() {
        return this.attributeType.getNameOrOID() + ".presence";
    }

    @Override
    public void indexEntry(Entry entry, Set<ByteString> keys) {
        List attrList = entry.getAttribute(this.attributeType);
        if (attrList != null && !attrList.isEmpty()) {
            keys.add(presenceKey);
        }
    }

    @Override
    public void modifyEntry(Entry oldEntry, Entry newEntry, List<Modification> mods, Map<ByteString, Boolean> modifiedKeys) {
        List newAttributes = newEntry.getAttribute(this.attributeType, true);
        List oldAttributes = oldEntry.getAttribute(this.attributeType, true);
        if (oldAttributes == null) {
            if (newAttributes != null) {
                modifiedKeys.put(presenceKey, true);
            }
        } else if (newAttributes == null) {
            modifiedKeys.put(presenceKey, false);
        }
    }
}

