/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.opends.server.types.DN;

public class JebFormat {
    public static final byte FORMAT_VERSION = 1;
    public static final byte TAG_DATABASE_ENTRY = 96;
    public static final byte TAG_DIRECTORY_SERVER_ENTRY = 97;

    public static long entryIDFromDatabase(byte[] bytes) {
        return JebFormat.toLong(bytes, 0, 8);
    }

    public static long toLong(byte[] bytes, int start, int end) throws ArrayIndexOutOfBoundsException {
        long v = 0L;
        for (int i = start; i < end; ++i) {
            v <<= 8;
            v |= (long)(bytes[i] & 0xFF);
        }
        return v;
    }

    public static long entryIDUndefinedSizeFromDatabase(byte[] bytes) {
        if (bytes == null) {
            return 0L;
        }
        if (bytes.length == 8) {
            long v = 0L;
            v |= (long)(bytes[0] & 0x7F);
            for (int i = 1; i < 8; ++i) {
                v <<= 8;
                v |= (long)(bytes[i] & 0xFF);
            }
            return v;
        }
        return Long.MAX_VALUE;
    }

    public static long[] entryIDListFromDatabase(byte[] bytes) {
        byte[] decodedBytes = bytes;
        int count = decodedBytes.length / 8;
        long[] entryIDList = new long[count];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            long v = 0L;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 56;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 48;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 40;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 32;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 24;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 16;
            v |= ((long)decodedBytes[pos++] & 0xFFL) << 8;
            entryIDList[i] = v |= (long)decodedBytes[pos++] & 0xFFL;
        }
        return entryIDList;
    }

    public static int[] intArrayFromDatabaseBytes(byte[] bytes) {
        byte[] decodedBytes = bytes;
        int count = decodedBytes.length / 8;
        int[] entryIDList = new int[count];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            int v = 0;
            pos += 4;
            v = (int)((long)v | ((long)decodedBytes[pos++] & 0xFFL) << 24);
            v = (int)((long)v | ((long)decodedBytes[pos++] & 0xFFL) << 16);
            v = (int)((long)v | ((long)decodedBytes[pos++] & 0xFFL) << 8);
            entryIDList[i] = v = (int)((long)v | (long)decodedBytes[pos++] & 0xFFL);
        }
        return entryIDList;
    }

    public static byte[] entryIDToDatabase(long id) {
        byte[] bytes = new byte[8];
        long v = id;
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)(v & 0xFFL);
            v >>>= 8;
        }
        return bytes;
    }

    public static byte[] entryIDUndefinedSizeToDatabase(long count) {
        byte[] bytes = new byte[8];
        long v = count;
        for (int i = 7; i >= 1; --i) {
            bytes[i] = (byte)(v & 0xFFL);
            v >>>= 8;
        }
        bytes[0] = (byte)((v | 0x80L) & 0xFFL);
        return bytes;
    }

    public static byte[] entryIDListToDatabase(long[] entryIDArray) {
        if (entryIDArray.length == 0) {
            return null;
        }
        byte[] bytes = new byte[8 * entryIDArray.length];
        int pos = 0;
        for (int i = 0; i < entryIDArray.length; ++i) {
            long v = entryIDArray[i];
            bytes[pos++] = (byte)(v >>> 56 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 48 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 40 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 32 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 24 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 16 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 8 & 0xFFL);
            bytes[pos++] = (byte)(v & 0xFFL);
        }
        return bytes;
    }

    public static int findDNKeyParent(byte[] dnKey) {
        return JebFormat.findDNKeyParent(dnKey, 0, dnKey.length);
    }

    public static int findDNKeyParent(byte[] dnKey, int offset, int length) {
        if (length == 0) {
            return -1;
        }
        for (int i = offset + length - 1; i >= offset; --i) {
            if (dnKey[i] != 0 || i - 1 < offset || dnKey[i - 1] == 2) continue;
            return i;
        }
        return offset;
    }

    public static byte[] dnToDNKey(DN dn, int prefixRDNs) {
        int startSize;
        ByteStringBuilder builder = new ByteStringBuilder();
        for (int i = startSize = dn.size() - prefixRDNs - 1; i >= 0; --i) {
            builder.append((byte)0);
            dn.getRDN(i).toNormalizedByteString(builder);
        }
        return builder.toByteArray();
    }
}

