/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.opends.messages.BackendMessages;
import org.opends.server.api.CompressedSchema;
import org.opends.server.backends.jeb.JEBUtils;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public final class JECompressedSchema
extends CompressedSchema {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final String DB_NAME_AD = "compressed_attributes";
    private static final String DB_NAME_OC = "compressed_object_classes";
    private Database adDatabase;
    private Environment environment;
    private Database ocDatabase;
    private final ByteStringBuilder storeAttributeWriterBuffer = new ByteStringBuilder();
    private final ASN1Writer storeAttributeWriter = ASN1.getWriter((ByteStringBuilder)this.storeAttributeWriterBuffer);
    private final ByteStringBuilder storeObjectClassesWriterBuffer = new ByteStringBuilder();
    private final ASN1Writer storeObjectClassesWriter = ASN1.getWriter((ByteStringBuilder)this.storeObjectClassesWriterBuffer);

    public JECompressedSchema(Environment environment) throws DatabaseException, InitializationException {
        this.environment = environment;
        this.load();
    }

    public void close() {
        this.close0(this.adDatabase);
        this.close0(this.ocDatabase);
        this.adDatabase = null;
        this.ocDatabase = null;
        this.environment = null;
    }

    private void close0(Database database) {
        try {
            database.sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        StaticUtils.close((Closeable[])new Closeable[]{database});
    }

    protected void storeAttribute(byte[] encodedAttribute, String attributeName, Collection<String> attributeOptions) throws DirectoryException {
        try {
            this.storeAttributeWriterBuffer.clear();
            this.storeAttributeWriter.writeStartSequence();
            this.storeAttributeWriter.writeOctetString(attributeName);
            for (String option : attributeOptions) {
                this.storeAttributeWriter.writeOctetString(option);
            }
            this.storeAttributeWriter.writeEndSequence();
            this.store(this.adDatabase, encodedAttribute, this.storeAttributeWriterBuffer);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected void storeObjectClasses(byte[] encodedObjectClasses, Collection<String> objectClassNames) throws DirectoryException {
        try {
            this.storeObjectClassesWriterBuffer.clear();
            this.storeObjectClassesWriter.writeStartSequence();
            for (String ocName : objectClassNames) {
                this.storeObjectClassesWriter.writeOctetString(ocName);
            }
            this.storeObjectClassesWriter.writeEndSequence();
            this.store(this.ocDatabase, encodedObjectClasses, this.storeObjectClassesWriterBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void load() throws DatabaseException, InitializationException {
        DatabaseConfig dbConfig = JEBUtils.toDatabaseConfigNoDuplicates(this.environment);
        this.adDatabase = this.environment.openDatabase(null, DB_NAME_AD, dbConfig);
        this.ocDatabase = this.environment.openDatabase(null, DB_NAME_OC, dbConfig);
        try (Cursor ocCursor = this.ocDatabase.openCursor(null, null);){
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            OperationStatus status = ocCursor.getFirst(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            while (status == OperationStatus.SUCCESS) {
                byte[] encodedObjectClasses = keyEntry.getData();
                ASN1Reader reader = ASN1.getReader((byte[])valueEntry.getData());
                reader.readStartSequence();
                LinkedList<String> objectClassNames = new LinkedList<String>();
                while (reader.hasNextElement()) {
                    objectClassNames.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
                this.loadObjectClasses(encodedObjectClasses, objectClassNames);
                status = ocCursor.getNext(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            }
        }
        try (Cursor adCursor = this.adDatabase.openCursor(null, null);){
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            OperationStatus status = adCursor.getFirst(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            while (status == OperationStatus.SUCCESS) {
                byte[] encodedAttribute = keyEntry.getData();
                ASN1Reader reader = ASN1.getReader((byte[])valueEntry.getData());
                reader.readStartSequence();
                String attributeName = reader.readOctetStringAsString();
                LinkedList<String> attributeOptions = new LinkedList<String>();
                while (reader.hasNextElement()) {
                    attributeOptions.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
                this.loadAttribute(encodedAttribute, attributeName, attributeOptions);
                status = adCursor.getNext(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            }
        }
    }

    private void store(Database database, byte[] key, ByteStringBuilder value) throws DirectoryException {
        if (!this.putNoOverwrite(database, key, value)) {
            LocalizableMessage m = BackendMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_MULTIPLE_FAILURES.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m);
        }
    }

    private boolean putNoOverwrite(Database database, byte[] key, ByteStringBuilder value) throws DirectoryException {
        DatabaseEntry keyEntry = new DatabaseEntry(key);
        DatabaseEntry valueEntry = new DatabaseEntry(value.getBackingArray(), 0, value.length());
        for (int i = 0; i < 3; ++i) {
            try {
                OperationStatus status = database.putNoOverwrite(null, keyEntry, valueEntry);
                if (status != OperationStatus.SUCCESS) {
                    LocalizableMessage m = BackendMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_STATUS.get((Object)status);
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m);
                }
                return true;
            }
            catch (LockConflictException ce) {
                continue;
            }
            catch (DatabaseException de) {
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), BackendMessages.ERR_COMPSCHEMA_CANNOT_STORE_EX.get((Object)de.getMessage()), (Throwable)de);
            }
        }
        return false;
    }
}

