/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import java.util.Collection;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.IndexingOptions;
import org.opends.messages.BackendMessages;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexQuery;
import org.opends.server.backends.jeb.JEBUtils;
import org.opends.server.types.AttributeType;

public final class IndexQueryFactoryImpl
implements IndexQueryFactory<IndexQuery> {
    private static final String PRESENCE_INDEX_KEY = "presence";
    private final Map<String, Index> indexMap;
    private final IndexingOptions indexingOptions;
    private final AttributeType attribute;

    public IndexQueryFactoryImpl(Map<String, Index> indexMap, IndexingOptions indexingOptions, AttributeType attribute) {
        this.indexMap = indexMap;
        this.indexingOptions = indexingOptions;
        this.attribute = attribute;
    }

    public IndexQuery createExactMatchQuery(final String indexID, final ByteSequence value) {
        return new IndexQuery(){

            @Override
            public EntryIDSet evaluate(LocalizableMessageBuilder debugMessage) {
                DatabaseEntry key = new DatabaseEntry(value.toByteArray());
                Index index = (Index)IndexQueryFactoryImpl.this.indexMap.get(indexID);
                if (index == null) {
                    if (debugMessage != null) {
                        debugMessage.append(BackendMessages.INFO_INDEX_FILTER_INDEX_TYPE_DISABLED.get((Object)indexID, (Object)IndexQueryFactoryImpl.this.attribute.getNameOrOID()));
                    }
                    return IndexQueryFactoryImpl.this.createMatchAllQuery().evaluate(debugMessage);
                }
                EntryIDSet entrySet = index.readKey(key, null, LockMode.DEFAULT);
                if (debugMessage != null && !entrySet.isDefined()) {
                    IndexQueryFactoryImpl.updateStatsUndefinedResults(debugMessage, index);
                }
                return entrySet;
            }
        };
    }

    public IndexQuery createRangeMatchQuery(final String indexID, final ByteSequence lowerBound, final ByteSequence upperBound, final boolean includeLowerBound, final boolean includeUpperBound) {
        return new IndexQuery(){

            @Override
            public EntryIDSet evaluate(LocalizableMessageBuilder debugMessage) {
                Index index = (Index)IndexQueryFactoryImpl.this.indexMap.get(indexID);
                if (index == null) {
                    if (debugMessage != null) {
                        debugMessage.append(BackendMessages.INFO_INDEX_FILTER_INDEX_TYPE_DISABLED.get((Object)indexID, (Object)IndexQueryFactoryImpl.this.attribute.getNameOrOID()));
                    }
                    return IndexQueryFactoryImpl.this.createMatchAllQuery().evaluate(debugMessage);
                }
                EntryIDSet entrySet = index.readRange(lowerBound.toByteArray(), upperBound.toByteArray(), includeLowerBound, includeUpperBound);
                if (debugMessage != null && !entrySet.isDefined()) {
                    IndexQueryFactoryImpl.updateStatsUndefinedResults(debugMessage, index);
                }
                return entrySet;
            }
        };
    }

    public IndexQuery createIntersectionQuery(Collection<IndexQuery> subqueries) {
        return IndexQuery.createIntersectionIndexQuery(subqueries);
    }

    public IndexQuery createUnionQuery(Collection<IndexQuery> subqueries) {
        return IndexQuery.createUnionIndexQuery(subqueries);
    }

    public IndexQuery createMatchAllQuery() {
        return new IndexQuery(){

            @Override
            public EntryIDSet evaluate(LocalizableMessageBuilder debugMessage) {
                String indexID = IndexQueryFactoryImpl.PRESENCE_INDEX_KEY;
                Index index = (Index)IndexQueryFactoryImpl.this.indexMap.get(IndexQueryFactoryImpl.PRESENCE_INDEX_KEY);
                if (index == null) {
                    if (debugMessage != null) {
                        debugMessage.append(BackendMessages.INFO_INDEX_FILTER_INDEX_TYPE_DISABLED.get((Object)IndexQueryFactoryImpl.PRESENCE_INDEX_KEY, (Object)IndexQueryFactoryImpl.this.attribute.getNameOrOID()));
                    }
                    return new EntryIDSet();
                }
                EntryIDSet entrySet = index.readKey(JEBUtils.presenceKey, null, LockMode.DEFAULT);
                if (debugMessage != null && !entrySet.isDefined()) {
                    IndexQueryFactoryImpl.updateStatsUndefinedResults(debugMessage, index);
                }
                return entrySet;
            }
        };
    }

    private static void updateStatsUndefinedResults(LocalizableMessageBuilder debugMessage, Index index) {
        if (!index.isTrusted()) {
            debugMessage.append(BackendMessages.INFO_INDEX_FILTER_INDEX_NOT_TRUSTED.get((Object)index.getName()));
        } else if (index.isRebuildRunning()) {
            debugMessage.append(BackendMessages.INFO_INDEX_FILTER_INDEX_REBUILD_IN_PROGRESS.get((Object)index.getName()));
        } else {
            debugMessage.append(BackendMessages.INFO_INDEX_FILTER_INDEX_LIMIT_EXCEEDED.get((Object)index.getName()));
        }
    }

    public IndexingOptions getIndexingOptions() {
        return this.indexingOptions;
    }
}

